/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.LinkedNodeList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class DOMNamedNodeMap<T extends AbstractDOMNode>
implements NamedNodeMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    private final short nodeType;
    private final HashMap<String, T> attributeMap;
    private final AbstractDOMNode.RawNodeList attributes;

    DOMNamedNodeMap(short s) {
        this.nodeType = s;
        this.attributeMap = new HashMap();
        this.attributes = new MyLinkedNodeList();
    }

    AbstractDOMNode.RawNodeList getNodeList() {
        return this.attributes;
    }

    public T getNamedItem(String string) {
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)this.attributeMap.get(string);
        if (abstractDOMNode == null && string != null && string.indexOf(58) == -1 && this.isCaseInsensitive()) {
            string = string.toLowerCase(Locale.ROOT);
            abstractDOMNode = (AbstractDOMNode)this.attributeMap.get(string);
        }
        return (T)abstractDOMNode;
    }

    private boolean isCaseInsensitive() {
        String string;
        DOMDocument dOMDocument = (DOMDocument)this.getOwnerNode().getOwnerDocument();
        return dOMDocument.isHTML() || (string = dOMDocument.getNamespaceURI()) == "http://www.w3.org/1999/xhtml" || string == SVG_NAMESPACE_URI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T setNamedItem(Node node) throws DOMException {
        this.verifyNewNode(node);
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node;
        String string = this.getMapKeyName(abstractDOMNode);
        AbstractDOMNode abstractDOMNode2 = (AbstractDOMNode)this.attributeMap.get(string);
        if (abstractDOMNode2 != null) {
            if (abstractDOMNode2 == node) {
                return null;
            }
            if (!this.isSameNamespace(abstractDOMNode.getNamespaceURI(), abstractDOMNode2) && abstractDOMNode.getNamespaceURI() != null) throw new DOMException(14, "Bad prefix in " + node.getNodeName());
            this.attributes.replace(abstractDOMNode, abstractDOMNode2);
        } else {
            this.attributes.add(abstractDOMNode);
        }
        AbstractDOMNode abstractDOMNode3 = this.attributeMap.put(string, abstractDOMNode);
        this.registerNode(abstractDOMNode);
        return (T)abstractDOMNode3;
    }

    void setNamedItemUnchecked(Node node) {
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)node;
        String string = this.getMapKeyName(abstractDOMNode);
        this.attributes.add(abstractDOMNode);
        this.attributeMap.put(string, abstractDOMNode);
        this.registerNode(abstractDOMNode);
    }

    private String getMapKeyName(Node node) {
        return node.getNodeName();
    }

    void registerNode(T t) {
    }

    void verifyNewNode(Node node) throws DOMException {
        if (this.getOwnerNode().getOwnerDocument() != node.getOwnerDocument()) {
            throw new DOMException(4, "Node was created by different document.");
        }
    }

    public T removeNamedItem(String string) throws DOMException {
        if (!this.attributeMap.containsKey(string)) {
            if (string != null && string.indexOf(58) == -1 && this.isCaseInsensitive()) {
                string = string.toLowerCase(Locale.ROOT);
            }
            if (!this.attributeMap.containsKey(string)) {
                throw new DOMException(8, "No attribute with that name: " + string);
            }
        }
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)this.attributeMap.remove(string);
        this.unregisterNode(abstractDOMNode);
        this.attributes.remove(abstractDOMNode);
        return (T)abstractDOMNode;
    }

    T removeItem(Node node) {
        String string = this.getMapKeyName(node);
        AbstractDOMNode abstractDOMNode = (AbstractDOMNode)this.attributeMap.remove(string);
        if (abstractDOMNode == null) {
            throw new DOMException(8, "Not an attribute from this collection.");
        }
        this.unregisterNode(abstractDOMNode);
        this.attributes.remove((AbstractDOMNode)node);
        return (T)abstractDOMNode;
    }

    void replaceItem(T t, T t2) {
        this.verifyNewNode((Node)t);
        this.unregisterNode(t2);
        this.attributes.replace((AbstractDOMNode)t, (AbstractDOMNode)t2);
        String string = this.getMapKeyName((Node)t2);
        this.attributeMap.remove(string);
        string = this.getMapKeyName((Node)t);
        this.attributeMap.put(string, t);
        this.registerNode(t);
    }

    void unregisterNode(T t) {
    }

    boolean hasAttribute(String string) {
        return this.attributeMap.containsKey(string);
    }

    public T item(int n) {
        return (T)((AbstractDOMNode)this.attributes.item(n));
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public int getLength() {
        return this.attributeMap.size();
    }

    void updatePrefix(Node node, String string, String string2) {
        String string3 = node.getLocalName();
        if (string2 != null && string2.length() != 0) {
            string3 = string2 + ':' + string3;
        }
        for (DOMNode dOMNode : this.attributes) {
            if (dOMNode != node) continue;
            this.attributeMap.remove(string3);
            this.attributeMap.put(node.getNodeName(), (AbstractDOMNode)node);
        }
    }

    public T getNamedItemNS(String string, String string2) throws DOMException {
        if ("http://www.w3.org/1999/xhtml".equals(string) || string == null && this.isCaseInsensitive()) {
            return this.getCINamedItem(string, string2);
        }
        return this.getCSNamedItem(string, string2);
    }

    private T getCINamedItem(String string, String string2) {
        for (DOMNode dOMNode : this.attributes) {
            if (!dOMNode.getLocalName().equalsIgnoreCase(string2) || !this.isSameNamespace(string, dOMNode)) continue;
            AbstractDOMNode abstractDOMNode = (AbstractDOMNode)dOMNode;
            return (T)abstractDOMNode;
        }
        return null;
    }

    private T getCSNamedItem(String string, String string2) {
        for (DOMNode dOMNode : this.attributes) {
            if (!dOMNode.getLocalName().equals(string2) || !this.isSameNamespace(string, dOMNode)) continue;
            AbstractDOMNode abstractDOMNode = (AbstractDOMNode)dOMNode;
            return (T)abstractDOMNode;
        }
        return null;
    }

    public T setNamedItemNS(Node node) throws DOMException {
        return (T)this.setNamedItem(node);
    }

    public T removeNamedItemNS(String string, String string2) throws DOMException {
        if ("http://www.w3.org/1999/xhtml".equals(string) || string == null && this.isCaseInsensitive()) {
            return this.removeCINamedItem(string, string2);
        }
        return this.removeCSNamedItem(string, string2);
    }

    private T removeCINamedItem(String string, String string2) {
        for (DOMNode dOMNode : this.attributes) {
            if (!dOMNode.getLocalName().equalsIgnoreCase(string2) || !this.isSameNamespace(string, dOMNode)) continue;
            this.attributes.remove((AbstractDOMNode)dOMNode);
            AbstractDOMNode abstractDOMNode = (AbstractDOMNode)this.attributeMap.remove(dOMNode.getNodeName());
            this.unregisterNode(abstractDOMNode);
            return (T)abstractDOMNode;
        }
        return null;
    }

    private T removeCSNamedItem(String string, String string2) {
        for (DOMNode dOMNode : this.attributes) {
            if (!dOMNode.getLocalName().equals(string2) || !this.isSameNamespace(string, dOMNode)) continue;
            this.attributes.remove((AbstractDOMNode)dOMNode);
            AbstractDOMNode abstractDOMNode = (AbstractDOMNode)this.attributeMap.remove(dOMNode.getNodeName());
            this.unregisterNode(abstractDOMNode);
            return (T)abstractDOMNode;
        }
        return null;
    }

    void insertAfter(T t, AbstractDOMNode abstractDOMNode) {
        AbstractDOMNode abstractDOMNode2 = abstractDOMNode.nextSibling;
        if (abstractDOMNode2 != null) {
            this.attributes.insertBefore((AbstractDOMNode)t, abstractDOMNode2);
        } else {
            this.attributes.add((AbstractDOMNode)t);
        }
        String string = this.getMapKeyName((Node)t);
        this.attributeMap.put(string, t);
        this.registerNode(t);
    }

    private boolean isSameNamespace(String string, Node node) {
        return Objects.equals(string, node.getNamespaceURI());
    }

    public int hashCode() {
        int n = 31;
        int n2 = this.nodeType;
        TreeSet<String> treeSet = new TreeSet<String>(this.attributeMap.keySet());
        for (String string : treeSet) {
            n2 = 31 * n2 + string.hashCode();
            n2 = 31 * n2 + ((AbstractDOMNode)this.attributeMap.get(string)).hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DOMNamedNodeMap dOMNamedNodeMap = (DOMNamedNodeMap)object;
        if (this.nodeType != dOMNamedNodeMap.nodeType) {
            return false;
        }
        if (this.attributeMap == null) {
            return dOMNamedNodeMap.attributeMap == null;
        }
        return this.sameNodes(dOMNamedNodeMap.attributeMap);
    }

    private boolean sameNodes(HashMap<String, ?> hashMap) {
        if (this.attributeMap.size() != hashMap.size()) {
            return false;
        }
        for (Map.Entry<String, T> entry : this.attributeMap.entrySet()) {
            Node node;
            String string = entry.getKey();
            Node node2 = (Node)entry.getValue();
            if (node2.isEqualNode(node = (Node)hashMap.get(string))) continue;
            return false;
        }
        return true;
    }

    public void appendTo(StringBuilder stringBuilder) {
        Iterator iterator = this.attributes.iterator();
        if (iterator.hasNext()) {
            DOMNode dOMNode = (DOMNode)iterator.next();
            stringBuilder.append(dOMNode.toString());
            while (iterator.hasNext()) {
                dOMNode = (DOMNode)iterator.next();
                stringBuilder.append(' ').append(dOMNode.toString());
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.attributeMap.size() * 24 + 12);
        this.appendTo(stringBuilder);
        return stringBuilder.toString();
    }

    abstract Node getOwnerNode();

    private static class MyLinkedNodeList
    extends LinkedNodeList {
        private static final long serialVersionUID = 1L;

        private MyLinkedNodeList() {
        }

        @Override
        void preAddChild(Node node) {
        }

        @Override
        void postAddChild(AbstractDOMNode abstractDOMNode) {
        }

        @Override
        void replaceChild(Node node, Node node2) {
        }

        @Override
        void postRemoveChild(AbstractDOMNode abstractDOMNode) {
        }
    }
}

