﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker-edge/SagemakerEdgeManagerRequest.h>
#include <aws/sagemaker-edge/SagemakerEdgeManager_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SagemakerEdgeManager {
namespace Model {

/**
 */
class GetDeviceRegistrationRequest : public SagemakerEdgeManagerRequest {
 public:
  AWS_SAGEMAKEREDGEMANAGER_API GetDeviceRegistrationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetDeviceRegistration"; }

  AWS_SAGEMAKEREDGEMANAGER_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique name of the device you want to get the registration status
   * from.</p>
   */
  inline const Aws::String& GetDeviceName() const { return m_deviceName; }
  inline bool DeviceNameHasBeenSet() const { return m_deviceNameHasBeenSet; }
  template <typename DeviceNameT = Aws::String>
  void SetDeviceName(DeviceNameT&& value) {
    m_deviceNameHasBeenSet = true;
    m_deviceName = std::forward<DeviceNameT>(value);
  }
  template <typename DeviceNameT = Aws::String>
  GetDeviceRegistrationRequest& WithDeviceName(DeviceNameT&& value) {
    SetDeviceName(std::forward<DeviceNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the fleet that the device belongs to.</p>
   */
  inline const Aws::String& GetDeviceFleetName() const { return m_deviceFleetName; }
  inline bool DeviceFleetNameHasBeenSet() const { return m_deviceFleetNameHasBeenSet; }
  template <typename DeviceFleetNameT = Aws::String>
  void SetDeviceFleetName(DeviceFleetNameT&& value) {
    m_deviceFleetNameHasBeenSet = true;
    m_deviceFleetName = std::forward<DeviceFleetNameT>(value);
  }
  template <typename DeviceFleetNameT = Aws::String>
  GetDeviceRegistrationRequest& WithDeviceFleetName(DeviceFleetNameT&& value) {
    SetDeviceFleetName(std::forward<DeviceFleetNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_deviceName;

  Aws::String m_deviceFleetName;
  bool m_deviceNameHasBeenSet = false;
  bool m_deviceFleetNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace SagemakerEdgeManager
}  // namespace Aws
