/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.ip;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.schema.Function;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.data.model.ExprIpValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.PPLBuiltinOperators;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class CompareIpFunction
extends ImplementorUDF {
    private final SqlKind kind;

    private CompareIpFunction(SqlKind kind) {
        super(new CompareImplementor(kind), NullPolicy.ANY);
        this.kind = kind;
    }

    public static CompareIpFunction less() {
        return new CompareIpFunction(SqlKind.LESS_THAN);
    }

    public static CompareIpFunction greater() {
        return new CompareIpFunction(SqlKind.GREATER_THAN);
    }

    public static CompareIpFunction lessOrEquals() {
        return new CompareIpFunction(SqlKind.LESS_THAN_OR_EQUAL);
    }

    public static CompareIpFunction greaterOrEquals() {
        return new CompareIpFunction(SqlKind.GREATER_THAN_OR_EQUAL);
    }

    public static CompareIpFunction equals() {
        return new CompareIpFunction(SqlKind.EQUALS);
    }

    public static CompareIpFunction notEquals() {
        return new CompareIpFunction(SqlKind.NOT_EQUALS);
    }

    @Override
    public SqlUserDefinedFunction toUDF(String functionName, final boolean isDeterministic) {
        SqlIdentifier udfIdentifier = new SqlIdentifier(Collections.singletonList(functionName), null, SqlParserPos.ZERO, null);
        return new SqlUserDefinedFunction(this, udfIdentifier, this.kind, this.getReturnTypeInference(), InferTypes.ANY_NULLABLE, this.getOperandMetadata(), (Function)this.getFunction()){

            public boolean isDeterministic() {
                return isDeterministic;
            }

            public @Nullable SqlOperator reverse() {
                return switch (this.kind) {
                    case SqlKind.LESS_THAN -> PPLBuiltinOperators.GREATER_IP;
                    case SqlKind.GREATER_THAN -> PPLBuiltinOperators.LESS_IP;
                    case SqlKind.LESS_THAN_OR_EQUAL -> PPLBuiltinOperators.GTE_IP;
                    case SqlKind.GREATER_THAN_OR_EQUAL -> PPLBuiltinOperators.LTE_IP;
                    case SqlKind.EQUALS -> PPLBuiltinOperators.EQUALS_IP;
                    case SqlKind.NOT_EQUALS -> PPLBuiltinOperators.NOT_EQUALS_IP;
                    default -> throw new IllegalArgumentException(String.format(Locale.ROOT, "CompareIpFunction is not supposed to be of kind: %s", this.kind));
                };
            }

            public SqlSyntax getSyntax() {
                return SqlSyntax.BINARY;
            }
        };
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.BOOLEAN_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrapUDT(List.of(List.of(ExprCoreType.IP, ExprCoreType.IP)));
    }

    public static class CompareImplementor
    implements NotNullImplementor {
        private final SqlKind compareType;

        public CompareImplementor(SqlKind compareType) {
            this.compareType = compareType;
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            MethodCallExpression compareResult = Expressions.call(CompareImplementor.class, (String)"compareTo", (Expression[])new Expression[]{translatedOperands.get(0), translatedOperands.get(1)});
            return CompareImplementor.evalCompareResult((Expression)compareResult, this.compareType);
        }

        private static Expression evalCompareResult(Expression compareResult, SqlKind compareType) {
            ConstantExpression zero = Expressions.constant((Object)0);
            return switch (compareType) {
                case SqlKind.EQUALS -> Expressions.equal((Expression)compareResult, (Expression)zero);
                case SqlKind.NOT_EQUALS -> Expressions.notEqual((Expression)compareResult, (Expression)zero);
                case SqlKind.LESS_THAN -> Expressions.lessThan((Expression)compareResult, (Expression)zero);
                case SqlKind.LESS_THAN_OR_EQUAL -> Expressions.lessThanOrEqual((Expression)compareResult, (Expression)zero);
                case SqlKind.GREATER_THAN -> Expressions.greaterThan((Expression)compareResult, (Expression)zero);
                case SqlKind.GREATER_THAN_OR_EQUAL -> Expressions.greaterThanOrEqual((Expression)compareResult, (Expression)zero);
                default -> throw new UnsupportedOperationException(String.format(Locale.ROOT, "Unsupported compare type: %s", compareType));
            };
        }

        public static int compareTo(Object obj1, Object obj2) {
            ExprIpValue v1 = CompareImplementor.toExprIpValue(obj1);
            ExprIpValue v2 = CompareImplementor.toExprIpValue(obj2);
            return v1.compare(v2);
        }

        private static ExprIpValue toExprIpValue(Object obj) {
            if (obj instanceof ExprIpValue) {
                return (ExprIpValue)obj;
            }
            if (obj instanceof String) {
                return new ExprIpValue((String)obj);
            }
            throw new IllegalArgumentException("Invalid IP type: " + String.valueOf(obj));
        }
    }
}

