/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.internal.resolve.result.BuildableTypedResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;
import org.jspecify.annotations.Nullable;

public class DefaultBuildableTypedResolveResult<T, E extends Throwable>
extends DefaultResourceAwareResolveResult
implements BuildableTypedResolveResult<T, E> {
    private T result;
    private E failure;

    @Override
    public void failed(E failure) {
        this.result = null;
        this.failure = failure;
    }

    @Override
    public void resolved(T result) {
        this.result = result;
        this.failure = null;
    }

    @Override
    public T getResult() throws E {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
        return this.result;
    }

    @Override
    public @Nullable E getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    public boolean isSuccessful() {
        return this.result != null;
    }

    @Override
    public boolean hasResult() {
        return this.failure != null || this.result != null;
    }

    protected void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }
}

