/*
 * ApplyXslServerTemplate.java
 *
 * Copyright (c) 2002 Sun Microsystems, Inc.
 */

package sunlabs.brazil.contrib;

import sunlabs.brazil.handler.ResourceHandler;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;
import sunlabs.brazil.template.RewriteContext;
import sunlabs.brazil.template.Template;
import sunlabs.brazil.util.Format;

// Imported TraX classes

import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;

import java.io.StringReader;
import java.io.ByteArrayOutputStream;
import java.util.Properties;

/**
 * Undocumented Class Declaration. (Rinaldo will fix this)
 * 
 * 
 * 
 * @author	Rinaldo Digiorgio
 * @version 	2.1, 10/01/02
 */
public class ApplyXslServerTemplate extends Template {
    TransformerFactory tFactory = null;

    /**
     * Undocumented Method Declaration.
     * 
     * 
     * @param hr
     * @return
     */

    public boolean init(RewriteContext hr) {
        Properties props = hr.request.props;

        // Use the static TransformerFactory.newInstance() method to instantiate
        // a TransformerFactory. The javax.xml.transform.TransformerFactory
        // system property setting determines the actual class to instantiate --
        // org.apache.xalan.transformer.TransformerImpl.


        hr.lex.getClosingTags().addElement("applyxsl");
        try {
	    tFactory = TransformerFactory.newInstance();
            hr.request.log(Server.LOG_DIAGNOSTIC, hr.prefix, 
                           "Setting request");
        } catch (Exception e) {
            hr.request.log(Server.LOG_WARNING, hr.prefix, 
                           "setting up Apply XSL to XML request: " 
                           + e.toString());
            done(hr);
            return false;
        }
        return super.init(hr);
    }

    /**
     * Processes the <code>&lt;applyxsl&gt;</code> tag.  Substitutes
     * the result of evaluating the following Apply XSL to XML script into
     * the resultant HTML document.
     * 
     * @param   hr
     * The request and associated HTML document that will be
     * processed.
     * 
     */
    public void tag_applyxsl(RewriteContext hr) {
	boolean eval = hr.isTrue("eval");
	String xslName = hr.get("xsl", hr.prefix + "xsl");

	hr.accumulate(false);
	hr.nextToken();
	String script = hr.getBody().trim();
	if (eval) {
	    script = Format.subst(hr.request.props, script);
	}

        try {

            // hr.request.log(Server.LOG_DIAGNOSTIC, hr.prefix, script);
            // Use the TransformerFactory to instantiate a Transformer
            // that will work with the stylesheet you specify. This method
            // call also processes the stylesheet into a compiled
            // Templates object.

	    String xsl = ResourceHandler.getResourceString(hr.request.props, 
		    hr.prefix, xslName);

            StringReader si = new StringReader(xsl);
            Transformer transformer = 
                tFactory.newTransformer(new StreamSource(si));

            // Use the Transformer to apply the associated Templates object
            // to an XML document and make the out available

	    StringReader xmlStream = new StringReader(script);
	    ByteArrayOutputStream output = new ByteArrayOutputStream();
	    transformer.transform(new StreamSource(xmlStream), 
			      new StreamResult(output));
	    hr.append(output.toString());
        } catch (Exception e) {
            hr.append("\n<!-- server-side Apply XSL to XML: error code " 
                      + e.toString() + " -->\n");
            hr.request.log(Server.LOG_DIAGNOSTIC, hr.prefix, e.toString());
            // e.printStackTrace();
        }
	hr.nextToken();  // skip over the </applyxslt>
	hr.accumulate(true);
    }
}
