/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.XOPEncoded;
import org.apache.axiom.om.util.jaxb.AttachmentUnmarshallerImpl;
import org.apache.axiom.om.util.jaxb.UnmarshallerConfigurator;

public final class JAXBUtils {
    private JAXBUtils() {
    }

    public static Object unmarshal(JAXBContext context, OMElement element, boolean cache) throws JAXBException {
        return JAXBUtils.unmarshal(element, context, null, cache);
    }

    public static Object unmarshal(OMContainer container, JAXBContext context, UnmarshallerConfigurator configurator, boolean preserve) throws JAXBException {
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (configurator != null) {
            configurator.configure(unmarshaller);
        }
        XOPEncoded<XMLStreamReader> xopEncodedStream = container.getXOPEncodedStreamReader(preserve);
        unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new AttachmentUnmarshallerImpl(xopEncodedStream.getAttachmentAccessor()));
        return unmarshaller.unmarshal(xopEncodedStream.getRootPart());
    }

    public static <T> JAXBElement<T> unmarshal(OMContainer container, JAXBContext context, UnmarshallerConfigurator configurator, Class<T> declaredType, boolean preserve) throws JAXBException {
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (configurator != null) {
            configurator.configure(unmarshaller);
        }
        XOPEncoded<XMLStreamReader> xopEncodedStream = container.getXOPEncodedStreamReader(preserve);
        unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new AttachmentUnmarshallerImpl(xopEncodedStream.getAttachmentAccessor()));
        return unmarshaller.unmarshal(xopEncodedStream.getRootPart(), declaredType);
    }
}

