/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.openejb.util.CachedSupplier;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class CachedSupplier<T>
implements Supplier<T> {
    private final Logger logger;
    private final Duration initialRetryDelay;
    private final Duration maxRetryDelay;
    private final Duration accessTimeout;
    private final Duration refreshInterval;
    private final Supplier<T> supplier;
    private final AtomicReference<T> value = new AtomicReference();
    private final AtomicReference<Accessor<T>> accessor = new AtomicReference();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());

    private CachedSupplier(Supplier<T> supplier, Duration initialRetryDelay, Duration maxRetryDelay, Duration accessTimeout, Duration refreshInterval, Logger logger) {
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(initialRetryDelay, "initialRetryDelay");
        Objects.requireNonNull(maxRetryDelay, "maxRetryDelay");
        Objects.requireNonNull(accessTimeout, "accessTimeout");
        Objects.requireNonNull(refreshInterval, "refreshInterval");
        this.supplier = supplier;
        this.initialRetryDelay = initialRetryDelay;
        this.maxRetryDelay = maxRetryDelay;
        this.accessTimeout = accessTimeout;
        this.refreshInterval = refreshInterval;
        this.logger = logger != null ? logger : this.createLogger(supplier);
        this.accessor.set(new BlockTillInitialized());
    }

    private Logger createLogger(Supplier<T> supplier) {
        String simpleName = supplier.getClass().getSimpleName();
        LogCategory child = LogCategory.OPENEJB.createChild("cache").createChild(simpleName);
        return Logger.getInstance(LogCategory.ACTIVEMQ, CachedSupplier.class);
    }

    @Override
    public T get() {
        Accessor<T> accessor = this.accessor.get();
        return accessor.get();
    }

    public static <T> CachedSupplier<T> of(Supplier<T> supplier) {
        return new Builder<T>().supplier(supplier).build();
    }

    public static <T> Builder<T> builder(Supplier<T> supplier) {
        return new Builder<T>().supplier(supplier);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName(CachedSupplier.class.getSimpleName() + " Supplier");
            thread.setDaemon(true);
            return thread;
        }
    }

    class BlockTillInitialized
    implements Accessor<T> {
        final CountDownLatch initialized = new CountDownLatch(1);

        public BlockTillInitialized() {
            CachedSupplier.this.executor.execute(new Initialize(1, CachedSupplier.this.initialRetryDelay));
        }

        @Override
        public T get() {
            try {
                if (this.initialized.await(CachedSupplier.this.accessTimeout.getTime(), CachedSupplier.this.accessTimeout.getUnit())) {
                    return CachedSupplier.this.value.get();
                }
                CachedSupplier.this.logger.debug(String.format("Timeout of %s reached waiting for initial value from supplier: %s", CachedSupplier.this.accessTimeout, CachedSupplier.this.supplier));
                throw new AccessTimeoutException(CachedSupplier.this.accessTimeout, CachedSupplier.this.supplier);
            }
            catch (InterruptedException e) {
                CachedSupplier.this.logger.debug(String.format("InterruptedException encountered while waiting for initial value from supplier: %s", CachedSupplier.this.supplier), e);
                throw new AccessInterruptedException(CachedSupplier.this.supplier);
            }
        }

        class Initialize
        implements Runnable {
            final int attempts;
            final Duration delay;

            public Initialize(int attempts, Duration delay) {
                this.attempts = attempts;
                this.delay = delay;
            }

            public org.apache.openejb.util.CachedSupplier$BlockTillInitialized.Initialize retry() {
                if (this.delay.greaterOrEqualTo(CachedSupplier.this.maxRetryDelay)) {
                    return new Initialize(this.attempts + 1, CachedSupplier.this.maxRetryDelay);
                }
                return new Initialize(this.attempts + 1, Duration.min(CachedSupplier.this.maxRetryDelay, this.delay.multiply(2L)));
            }

            @Override
            public void run() {
                try {
                    Object t = CachedSupplier.this.supplier.get();
                    if (t != null) {
                        CachedSupplier.this.value.set(t);
                        CachedSupplier.this.accessor.set(new Initialized());
                        BlockTillInitialized.this.initialized.countDown();
                        CachedSupplier.this.logger.debug(String.format("Initialization attempt %s succeeded. Supplier %s returned valid result.", this.attempts, CachedSupplier.this.supplier));
                        return;
                    }
                    CachedSupplier.this.logger.error(String.format("Initialization attempt %s failed. Supplier %s returned null. Next retry will be in %s", this.attempts, CachedSupplier.this.supplier, this.retry().delay));
                }
                catch (Throwable e) {
                    CachedSupplier.this.logger.error(String.format("Initialization attempt %s failed. Supplier %s threw an exception. Next retry will be in %s", this.attempts, CachedSupplier.this.supplier, this.retry().delay), e);
                }
                Initialize retry = this.retry();
                CachedSupplier.this.executor.schedule(retry, retry.delay.getTime(), retry.delay.getUnit());
            }
        }
    }

    public static interface Accessor<T> {
        public T get();
    }

    public static class Builder<T> {
        private Duration initialRetryDelay = new Duration(2L, TimeUnit.SECONDS);
        private Duration maxRetryDelay = new Duration(1L, TimeUnit.HOURS);
        private Duration accessTimeout = new Duration(30L, TimeUnit.SECONDS);
        private Duration refreshInterval = new Duration(1L, TimeUnit.DAYS);
        private Supplier<T> supplier;
        private Logger logger;

        public Builder<T> initialRetryDelay(Duration initialRetryDelay) {
            this.initialRetryDelay = initialRetryDelay;
            return this;
        }

        public Builder<T> initialRetryDelay(int time, TimeUnit unit) {
            return this.initialRetryDelay(new Duration(time, unit));
        }

        public Builder<T> maxRetryDelay(Duration maxRetryDelay) {
            this.maxRetryDelay = maxRetryDelay;
            return this;
        }

        public Builder<T> maxRetryDelay(int time, TimeUnit unit) {
            return this.maxRetryDelay(new Duration(time, unit));
        }

        public Builder<T> accessTimeout(Duration accessTimeout) {
            this.accessTimeout = accessTimeout;
            return this;
        }

        public Builder<T> accessTimeout(int time, TimeUnit unit) {
            return this.accessTimeout(new Duration(time, unit));
        }

        public Builder<T> refreshInterval(Duration refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        public Builder<T> refreshInterval(int time, TimeUnit unit) {
            return this.refreshInterval(new Duration(time, unit));
        }

        public Builder<T> supplier(Supplier<T> supplier) {
            this.supplier = supplier;
            return this;
        }

        public Builder<T> logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public CachedSupplier<T> build() {
            return new CachedSupplier<T>(this.supplier, this.initialRetryDelay, this.maxRetryDelay, this.accessTimeout, this.refreshInterval, this.logger);
        }
    }

    public static class AccessInterruptedException
    extends RuntimeException {
        private final Supplier<?> supplier;

        public AccessInterruptedException(Supplier<?> supplier) {
            super(String.format("Interrupted while waiting for initial value from supplier: %s", supplier));
            this.supplier = supplier;
        }

        public Supplier<?> getSupplier() {
            return this.supplier;
        }
    }

    public static class AccessTimeoutException
    extends RuntimeException {
        private final Duration timeout;
        private final Supplier<?> supplier;

        public AccessTimeoutException(Duration timeout, Supplier<?> supplier) {
            super(String.format("Timeout of %s reached waiting for initial value from supplier: %s", timeout, supplier));
            this.timeout = timeout;
            this.supplier = supplier;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public Supplier<?> getSupplier() {
            return this.supplier;
        }
    }

    class Initialized
    implements Accessor<T> {
        public Initialized() {
            CachedSupplier.this.executor.scheduleAtFixedRate(new Refresh(), CachedSupplier.this.refreshInterval.getTime(), CachedSupplier.this.refreshInterval.getTime(), CachedSupplier.this.refreshInterval.getUnit());
        }

        @Override
        public T get() {
            return CachedSupplier.this.value.get();
        }

        class Refresh
        implements Runnable {
            Refresh() {
            }

            @Override
            public void run() {
                try {
                    Object t = CachedSupplier.this.supplier.get();
                    if (t != null) {
                        CachedSupplier.this.value.set(t);
                        CachedSupplier.this.logger.debug(String.format("Refresh succeeded. Supplier %s returned valid value.  Next refresh will be in %s", CachedSupplier.this.supplier, CachedSupplier.this.refreshInterval));
                    } else {
                        CachedSupplier.this.logger.error(String.format("Refresh failed. Supplier %s returned null.  Next refresh will be in %s", CachedSupplier.this.supplier, CachedSupplier.this.refreshInterval));
                    }
                }
                catch (Throwable e) {
                    CachedSupplier.this.logger.error(String.format("Refresh failed. Supplier %s threw an exception.  Next refresh will be in %s", CachedSupplier.this.supplier, CachedSupplier.this.refreshInterval), e);
                }
            }
        }
    }
}

