/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.util.Join;

public class DaemonThreadFactory
implements ThreadFactory {
    private final String name;
    private final ThreadGroup group;
    private final AtomicInteger ids = new AtomicInteger(0);

    public DaemonThreadFactory(Object ... name) {
        this.name = Join.join(" ", name).trim();
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    public DaemonThreadFactory(Class ... clazz) {
        this(DaemonThreadFactory.asStrings(clazz));
    }

    private static Object[] asStrings(Class[] clazz) {
        Object[] strings = new String[clazz.length];
        int i = 0;
        for (Class c : clazz) {
            strings[i++] = c.getSimpleName();
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable runnable) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ParentClassLoaderFinder.Helper.get());
        try {
            Thread thread = new Thread(this.group, runnable, this.name + " - " + this.ids.incrementAndGet());
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            Thread thread2 = thread;
            return thread2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }
}

