/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.util.InternationalString;

public final class Legacy {
    private static final CartesianCS LEGACY = new DefaultCartesianCS((Map<String, ?>)Map.of("name", "Legacy geocentric"), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", "X"), "X", AxisDirection.OTHER, Units.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", "Y"), "Y", AxisDirection.EAST, Units.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Map.of("name", "Z"), "Z", AxisDirection.NORTH, Units.METRE));

    private Legacy() {
    }

    public static CartesianCS standard(Unit<?> unit) {
        return Legacy.replaceUnit((CartesianCS)CommonCRS.WGS84.geocentric().getCoordinateSystem(), unit);
    }

    public static CartesianCS forGeocentricCRS(CartesianCS cs, boolean toLegacy) {
        CartesianCS check = toLegacy ? Legacy.standard(null) : LEGACY;
        int dimension = check.getDimension();
        if (cs.getDimension() != dimension) {
            return cs;
        }
        for (int i = 0; i < dimension; ++i) {
            if (cs.getAxis(i).getDirection().equals(check.getAxis(i).getDirection())) continue;
            return cs;
        }
        Unit<?> unit = ReferencingUtilities.getUnit(cs);
        return toLegacy ? Legacy.replaceUnit(LEGACY, unit) : Legacy.standard(unit);
    }

    public static CartesianCS replaceUnit(CartesianCS cs, Unit<?> unit) {
        if (unit != null && !unit.equals(Units.METRE)) {
            cs = (CartesianCS)CoordinateSystems.replaceLinearUnit(cs, unit.asType(Length.class));
        }
        return cs;
    }

    public static Collection<DefaultObjectDomain> getDomains(IdentifiedObject object) {
        Extent domainOfValidity;
        InternationalString scope;
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).getDomains();
        }
        if (object instanceof ReferenceSystem) {
            ReferenceSystem c = (ReferenceSystem)object;
            scope = c.getScope();
            domainOfValidity = c.getDomainOfValidity();
        } else if (object instanceof Datum) {
            Datum c = (Datum)object;
            scope = c.getScope();
            domainOfValidity = c.getDomainOfValidity();
        } else if (object instanceof CoordinateOperation) {
            CoordinateOperation c = (CoordinateOperation)object;
            scope = c.getScope();
            domainOfValidity = c.getDomainOfValidity();
        } else {
            return null;
        }
        if (scope == null && domainOfValidity == null) {
            return null;
        }
        return List.of(new DefaultObjectDomain(scope, domainOfValidity));
    }

    public static InternationalString getScope(Collection<DefaultObjectDomain> domains) {
        return domains.stream().map(DefaultObjectDomain::getScope).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Extent getDomainOfValidity(Collection<DefaultObjectDomain> domains) {
        return domains.stream().map(DefaultObjectDomain::getDomainOfValidity).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

