/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.Identifiers;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.metadata.internal.NameToIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultImageDatum;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.datum.SubTypes;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.util.NilReferencingObject;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDatumType", propOrder={"anchorPoint", "realizationEpoch"})
@XmlRootElement(name="AbstractDatum")
@XmlSeeAlso(value={DefaultGeodeticDatum.class, DefaultVerticalDatum.class, DefaultTemporalDatum.class, DefaultParametricDatum.class, DefaultEngineeringDatum.class, DefaultImageDatum.class})
public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -729506171131910731L;
    private InternationalString anchorDefinition;
    private long realizationEpoch;

    public AbstractDatum(Map<String, ?> properties) {
        super(properties);
        this.realizationEpoch = ImplementationHelper.toMilliseconds(Containers.property(properties, "realizationEpoch", Date.class));
        this.anchorDefinition = Types.toInternationalString(properties, "anchorPoint");
    }

    protected AbstractDatum(Datum datum) {
        super(datum);
        this.realizationEpoch = ImplementationHelper.toMilliseconds(datum.getRealizationEpoch());
        this.anchorDefinition = datum.getAnchorPoint();
    }

    public static AbstractDatum castOrCopy(Datum object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends Datum> getInterface() {
        return Datum.class;
    }

    @Override
    @XmlElement(name="anchorDefinition")
    public InternationalString getAnchorPoint() {
        return this.anchorDefinition;
    }

    @Override
    @XmlSchemaType(name="date")
    @XmlElement(name="realizationEpoch")
    public Date getRealizationEpoch() {
        return ImplementationHelper.toDate(this.realizationEpoch);
    }

    @Override
    @Deprecated(since="1.4")
    public Extent getDomainOfValidity() {
        return Legacy.getDomainOfValidity(this.getDomains());
    }

    @Override
    @Deprecated(since="1.4")
    public InternationalString getScope() {
        return Legacy.getScope(this.getDomains());
    }

    @Override
    public boolean isHeuristicMatchForName(String name) {
        return NameToIdentifier.isHeuristicMatchForName(super.getName(), super.getAlias(), name, Simplifier.INSTANCE);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                AbstractDatum that = (AbstractDatum)object;
                return this.realizationEpoch == that.realizationEpoch && Objects.equals(this.anchorDefinition, that.anchorDefinition);
            }
            case BY_CONTRACT: {
                Datum that = (Datum)object;
                return Utilities.deepEquals(this.getRealizationEpoch(), that.getRealizationEpoch(), mode) && Utilities.deepEquals(this.getAnchorPoint(), that.getAnchorPoint(), mode);
            }
        }
        Datum that = (Datum)object;
        Boolean match = Identifiers.hasCommonIdentifier(this.getIdentifiers(), that.getIdentifiers());
        if (match != null) {
            return match;
        }
        return this.isHeuristicMatchForName(that.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName(that, this.getName().getCode());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.anchorDefinition, this.realizationEpoch);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Citation authority = formatter.getNameAuthority();
        Object name = IdentifiedObjects.getName(this, authority);
        if (name == null) {
            name = IdentifiedObjects.getName(this, null);
            if (name == null) {
                return super.formatTo(formatter);
            }
            if ("ESRI".equalsIgnoreCase(Citations.toCodeSpace(authority)) && !((String)name).startsWith("D_")) {
                name = "D_" + (String)name;
            }
        }
        formatter.append((String)name, ElementKind.DATUM);
        return null;
    }

    AbstractDatum() {
        super(NilReferencingObject.INSTANCE);
        this.realizationEpoch = Long.MIN_VALUE;
    }

    private void setAnchorPoint(InternationalString value) {
        if (this.anchorDefinition == null) {
            this.anchorDefinition = value;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractDatum.class, "setAnchorPoint", "anchorDefinition");
        }
    }

    private void setRealizationEpoch(Date value) {
        if (this.realizationEpoch == Long.MIN_VALUE) {
            this.realizationEpoch = value.getTime();
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractDatum.class, "setRealizationEpoch", "realizationEpoch");
        }
    }

    static class Simplifier
    extends NameToIdentifier.Simplifier {
        static final Simplifier INSTANCE = new Simplifier();

        Simplifier() {
        }

        @Override
        protected CharSequence apply(CharSequence name) {
            if (CharSequences.startsWith(name = super.apply(name), "D_", false)) {
                name = name.subSequence("D_".length(), name.length());
            }
            return name;
        }
    }
}

