/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.XLink;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.IdentifierMapAdapter;
import org.apache.sis.xml.bind.IdentifierMapEntry;
import org.apache.sis.xml.bind.SpecializedIdentifier;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class ModifiableIdentifierMap
extends IdentifierMapAdapter {
    private static final long serialVersionUID = -80325787192055778L;

    public ModifiableIdentifierMap(Collection<Identifier> identifiers) {
        super(identifiers);
    }

    private URI setHRef(URI href) {
        Object link;
        URI old = this.store(IdentifierSpace.HREF, null);
        Identifier identifier = this.getIdentifier(IdentifierSpace.XLINK);
        if (identifier instanceof SpecializedIdentifier && (link = ((SpecializedIdentifier)identifier).value) instanceof XLink) {
            if (old == null) {
                old = ((XLink)link).getHRef();
            }
            ((XLink)link).setHRef(href);
            return old;
        }
        if (href != null) {
            link = new XLink();
            ((XLink)link).setHRef(href);
            this.store(IdentifierSpace.XLINK, link);
        }
        return old;
    }

    @Override
    final boolean isModifiable() {
        return true;
    }

    @Override
    public void clear() {
        this.identifiers.clear();
    }

    @Override
    public String remove(Object authority) {
        return authority instanceof Citation ? this.put((Citation)authority, null) : null;
    }

    @Override
    public String put(Citation authority, String code) {
        Identifier identifier;
        ArgumentChecks.ensureNonNull("authority", authority);
        String previous = null;
        Object discarded = null;
        switch (ModifiableIdentifierMap.specialCase(authority)) {
            case 2: {
                URI uri = null;
                if (code != null) {
                    Context context = Context.current();
                    ValueConverter converter = Context.converter(context);
                    try {
                        uri = converter.toURI((MarshalContext)context, code);
                    }
                    catch (URISyntaxException e) {
                        SpecializedIdentifier.parseFailure(context, code, URI.class, e);
                        discarded = this.setHRef(null);
                        break;
                    }
                }
                identifier = this.getIdentifier(authority);
                if ((uri = this.setHRef(uri)) != null) {
                    previous = uri.toString();
                } else if (identifier != null) {
                    previous = identifier.getCode();
                }
                return previous;
            }
        }
        Iterator it = this.identifiers.iterator();
        while (it.hasNext()) {
            identifier = (Identifier)it.next();
            if (identifier == null) {
                it.remove();
                continue;
            }
            if (!Objects.equals(authority, identifier.getAuthority())) continue;
            if (code != null && identifier instanceof IdentifierMapEntry) {
                return ((IdentifierMapEntry)identifier).setValue(code);
            }
            if (previous == null) {
                previous = identifier.getCode();
            }
            it.remove();
        }
        if (code != null) {
            this.identifiers.add(SpecializedIdentifier.parse(authority, code));
        }
        if (previous == null && discarded != null) {
            previous = discarded.toString();
        }
        return previous;
    }

    @Override
    public <T> T putSpecialized(IdentifierSpace<T> authority, T value) {
        switch (ModifiableIdentifierMap.specialCase(authority)) {
            default: {
                return this.store(authority, value);
            }
            case 2: 
        }
        return (T)this.setHRef((URI)value);
    }

    private <T> T store(IdentifierSpace<T> authority, T value) {
        ArgumentChecks.ensureNonNull("authority", authority);
        T old = null;
        Iterator it = this.identifiers.iterator();
        while (it.hasNext()) {
            Identifier identifier = (Identifier)it.next();
            if (identifier == null) {
                it.remove();
                continue;
            }
            if (!Objects.equals(authority, identifier.getAuthority())) continue;
            if (identifier instanceof SpecializedIdentifier) {
                SpecializedIdentifier id = (SpecializedIdentifier)identifier;
                if (old == null) {
                    old = id.value;
                }
                if (value != null) {
                    id.value = value;
                    return old;
                }
            }
            it.remove();
        }
        if (value != null) {
            this.identifiers.add(new SpecializedIdentifier<T>(authority, value));
        }
        return old;
    }
}

