/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.data;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysml.runtime.instructions.spark.data.LineageObject;

public class RDDObject
extends LineageObject {
    private JavaPairRDD<?, ?> _rddHandle = null;
    private boolean _checkpointed = false;
    private boolean _hdfsfile = false;
    private String _hdfsFname = null;
    private boolean _parRDD = false;
    private boolean _pending = true;

    public RDDObject(JavaPairRDD<?, ?> rddvar) {
        this._rddHandle = rddvar;
    }

    public JavaPairRDD<?, ?> getRDD() {
        return this._rddHandle;
    }

    public void setCheckpointRDD(boolean flag) {
        this._checkpointed = flag;
    }

    public boolean isCheckpointRDD() {
        return this._checkpointed;
    }

    public void setHDFSFile(boolean flag) {
        this._hdfsfile = flag;
    }

    public void setHDFSFilename(String fname) {
        this._hdfsFname = fname;
    }

    public boolean isHDFSFile() {
        return this._hdfsfile;
    }

    public String getHDFSFilename() {
        return this._hdfsFname;
    }

    public void setParallelizedRDD(boolean flag) {
        this._parRDD = flag;
    }

    public boolean isParallelizedRDD() {
        return this._parRDD;
    }

    public void setPending(boolean flag) {
        this._pending = flag;
    }

    public boolean isPending() {
        return this._pending;
    }

    public boolean allowsShortCircuitRead() {
        boolean ret = this.isHDFSFile();
        if (this.isCheckpointRDD() && this.getLineageChilds().size() == 1) {
            LineageObject lo = this.getLineageChilds().get(0);
            ret = lo instanceof RDDObject && ((RDDObject)lo).isHDFSFile();
        }
        return ret;
    }

    public boolean allowsShortCircuitCollect() {
        return this.isCheckpointRDD() && this.getLineageChilds().size() == 1 && this.getLineageChilds().get(0) instanceof RDDObject;
    }

    public boolean rHasCheckpointRDDChilds() {
        if (this._checkpointed) {
            return true;
        }
        boolean ret = false;
        for (LineageObject lo : this.getLineageChilds()) {
            if (!(lo instanceof RDDObject)) continue;
            ret |= ((RDDObject)lo).rHasCheckpointRDDChilds();
        }
        return ret;
    }
}

