/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;

public class RewriteHoistLoopInvariantOperations
extends StatementBlockRewriteRule {
    private final boolean _sideEffectFreeFuns;

    public RewriteHoistLoopInvariantOperations() {
        this(false);
    }

    public RewriteHoistLoopInvariantOperations(boolean noSideEffects) {
        this._sideEffectFreeFuns = noSideEffects;
    }

    @Override
    public boolean createsSplitDag() {
        return true;
    }

    @Override
    public List<StatementBlock> rewriteStatementBlock(StatementBlock sb, ProgramRewriteStatus state) {
        if (sb == null || !HopRewriteUtils.isLoopStatementBlock(sb)) {
            return Arrays.asList(sb);
        }
        Set<String> candInputs = sb.variablesRead().getVariableNames().stream().filter(v -> !sb.variablesUpdated().containsVariable((String)v)).collect(Collectors.toSet());
        HashMap<String, Hop> invariantOps = new HashMap<String, Hop>();
        this.collectOperations(sb, candInputs, invariantOps);
        return invariantOps.isEmpty() ? Arrays.asList(sb) : Arrays.asList(this.createStatementBlock(sb, invariantOps), sb);
    }

    @Override
    public List<StatementBlock> rewriteStatementBlocks(List<StatementBlock> sbs, ProgramRewriteStatus state) {
        return sbs;
    }

    private void collectOperations(StatementBlock sb, Set<String> candInputs, Map<String, Hop> invariantOps) {
        if (sb instanceof WhileStatementBlock) {
            WhileStatement wstmt = (WhileStatement)sb.getStatement(0);
            for (StatementBlock csb : wstmt.getBody()) {
                this.collectOperations(csb, candInputs, invariantOps);
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatement fstmt = (ForStatement)sb.getStatement(0);
            for (StatementBlock csb : fstmt.getBody()) {
                this.collectOperations(csb, candInputs, invariantOps);
            }
        } else if (!(sb instanceof IfStatementBlock) && sb.getHops() != null) {
            Hop.resetVisitStatus(sb.getHops());
            HashSet<Long> memo = new HashSet<Long>();
            for (Hop hop : sb.getHops()) {
                this.rTagLoopInvariantOperations(hop, candInputs, memo);
            }
            Hop.resetVisitStatus(sb.getHops());
            for (Hop hop : sb.getHops()) {
                this.rCollectAndReplaceOperations(hop, candInputs, memo, invariantOps);
            }
            if (!memo.isEmpty()) {
                LOG.debug("Applied hoistLoopInvariantOperations (lines " + sb.getBeginLine() + "-" + sb.getEndLine() + "): " + memo.size() + ".");
            }
        }
    }

    private void rTagLoopInvariantOperations(Hop hop, Set<String> candInputs, Set<Long> memo) {
        if (hop.isVisited()) {
            return;
        }
        for (Hop c : hop.getInput()) {
            this.rTagLoopInvariantOperations(c, candInputs, memo);
        }
        boolean invariant = !HopRewriteUtils.isDataGenOp(hop, Hop.DataGenMethod.RAND) && (!(hop instanceof FunctionOp) || this._sideEffectFreeFuns) && !HopRewriteUtils.isData(hop, Hop.DataOpTypes.TRANSIENTREAD) && !HopRewriteUtils.isData(hop, Hop.DataOpTypes.TRANSIENTWRITE);
        for (Hop c : hop.getInput()) {
            invariant &= candInputs.contains(c.getName()) || memo.contains(c.getHopID()) || c instanceof LiteralOp;
        }
        if (invariant) {
            memo.add(hop.getHopID());
        }
        hop.setVisited();
    }

    private void rCollectAndReplaceOperations(Hop hop, Set<String> candInputs, Set<Long> memo, Map<String, Hop> invariantOps) {
        if (hop.isVisited()) {
            return;
        }
        for (int i = 0; i < hop.getInput().size(); ++i) {
            Hop c = hop.getInput().get(i);
            if (memo.contains(c.getHopID())) {
                String tmpName = RewriteHoistLoopInvariantOperations.createCutVarName(false);
                Hop tmp = Recompiler.deepCopyHopsDag(c);
                tmp.getParent().clear();
                invariantOps.put(tmpName, tmp);
                DataOp tread = HopRewriteUtils.createTransientRead(tmpName, c);
                ArrayList<Hop> parents = new ArrayList<Hop>(c.getParent());
                for (Hop p : parents) {
                    HopRewriteUtils.replaceChildReference(p, c, tread);
                }
                continue;
            }
            this.rCollectAndReplaceOperations(c, candInputs, memo, invariantOps);
        }
        hop.setVisited();
    }

    private StatementBlock createStatementBlock(StatementBlock sb, Map<String, Hop> invariantOps) {
        StatementBlock ret = new StatementBlock();
        ret.setDMLProg(sb.getDMLProg());
        ret.setParseInfo(sb);
        ret.setLiveIn(new VariableSet(sb.liveIn()));
        ret.setLiveOut(new VariableSet(sb.liveIn()));
        ArrayList<Hop> hops = new ArrayList<Hop>();
        for (Map.Entry<String, Hop> e : invariantOps.entrySet()) {
            Hop h = e.getValue();
            DataOp twrite = HopRewriteUtils.createTransientWrite(e.getKey(), h);
            hops.add(twrite);
            DataIdentifier diVar = new DataIdentifier(e.getKey());
            diVar.setDimensions(h.getDim1(), h.getDim2());
            diVar.setBlockDimensions(h.getRowsInBlock(), h.getColsInBlock());
            diVar.setDataType(h.getDataType());
            diVar.setValueType(h.getValueType());
            ret.liveOut().addVariable(e.getKey(), diVar);
            sb.liveIn().addVariable(e.getKey(), diVar);
        }
        ret.setHops(hops);
        return ret;
    }
}

