/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.ipa;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.ipa.FunctionCallGraph;
import org.apache.sysml.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysml.hops.ipa.IPAPass;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.LanguageException;

public class IPAPassRemoveUnusedFunctions
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        return !fgraph.containsSecondOrderCall();
    }

    @Override
    public void rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) {
        try {
            Set<String> fnamespaces = prog.getNamespaces().keySet();
            for (String fnspace : fnamespaces) {
                HashMap<String, FunctionStatementBlock> fsbs = prog.getFunctionStatementBlocks(fnspace);
                Iterator<Map.Entry<String, FunctionStatementBlock>> iter = fsbs.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, FunctionStatementBlock> e = iter.next();
                    if (fgraph.isReachableFunction(fnspace, e.getKey())) continue;
                    iter.remove();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("IPA: Removed unused function: " + DMLProgram.constructFunctionKey(fnspace, e.getKey()));
                }
            }
        }
        catch (LanguageException ex) {
            throw new HopsException(ex);
        }
    }
}

