/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public abstract class Metadata {
    protected Long numColumns = null;
    protected Integer numColumnsPerBlock = null;
    protected Long numNonZeros = null;
    protected Long numRows = null;
    protected Integer numRowsPerBlock = null;

    public MatrixCharacteristics asMatrixCharacteristics() {
        if (this.numRows == null && this.numColumns == null && this.numRowsPerBlock == null && this.numColumnsPerBlock == null && this.numNonZeros == null) {
            return null;
        }
        long nr = this.numRows == null ? -1L : this.numRows;
        long nc = this.numColumns == null ? -1L : this.numColumns;
        int nrpb = this.numRowsPerBlock == null ? ConfigurationManager.getBlocksize() : this.numRowsPerBlock;
        int ncpb = this.numColumnsPerBlock == null ? ConfigurationManager.getBlocksize() : this.numColumnsPerBlock;
        long nnz = this.numNonZeros == null ? -1L : this.numNonZeros;
        return new MatrixCharacteristics(nr, nc, nrpb, ncpb, nnz);
    }

    protected String fieldDisplay(Object field) {
        if (field == null) {
            return "None";
        }
        return field.toString();
    }

    public Long getNumColumns() {
        return this.numColumns;
    }

    public Integer getNumColumnsPerBlock() {
        return this.numColumnsPerBlock;
    }

    public Long getNumNonZeros() {
        return this.numNonZeros;
    }

    public Long getNumRows() {
        return this.numRows;
    }

    public Integer getNumRowsPerBlock() {
        return this.numRowsPerBlock;
    }

    public void setMatrixCharacteristics(MatrixCharacteristics matrixCharacteristics) {
        this.numRows = matrixCharacteristics.getRows();
        this.numColumns = matrixCharacteristics.getCols();
        this.numNonZeros = matrixCharacteristics.getNonZeros();
        this.numRowsPerBlock = matrixCharacteristics.getRowsPerBlock();
        this.numColumnsPerBlock = matrixCharacteristics.getColsPerBlock();
    }

    public void setNumColumns(Long numColumns) {
        this.numColumns = numColumns;
    }

    public void setNumColumnsPerBlock(Integer numColumnsPerBlock) {
        this.numColumnsPerBlock = numColumnsPerBlock;
    }

    public void setNumNonZeros(Long numNonZeros) {
        this.numNonZeros = numNonZeros;
    }

    public void setNumRows(Long numRows) {
        this.numRows = numRows;
    }

    public void setNumRowsPerBlock(Integer numRowsPerBlock) {
        this.numRowsPerBlock = numRowsPerBlock;
    }

    public String toString() {
        return "rows: " + this.fieldDisplay(this.numRows) + ", columns: " + this.fieldDisplay(this.numColumns) + ", non-zeros: " + this.fieldDisplay(this.numNonZeros) + ", rows per block: " + this.fieldDisplay(this.numRowsPerBlock) + ", columns per block: " + this.fieldDisplay(this.numColumnsPerBlock);
    }
}

