/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class AggregateInstruction
extends UnaryMRInstructionBase {
    public AggregateInstruction(Operator op, byte in, byte out, String istr) {
        super(MRInstruction.MRType.Aggregate, op, in, out);
        this.instString = istr;
    }

    public static AggregateInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        AggregateOperator agg = null;
        if (opcode.equalsIgnoreCase("ak+") || opcode.equalsIgnoreCase("asqk+") || opcode.equalsIgnoreCase("amean") || opcode.equalsIgnoreCase("avar")) {
            InstructionUtils.checkNumFields(str, 4);
            agg = InstructionUtils.parseAggregateOperator(opcode, parts[3], parts[4]);
        } else {
            InstructionUtils.checkNumFields(str, 2);
            agg = InstructionUtils.parseAggregateOperator(opcode, null, null);
        }
        return new AggregateInstruction(agg, in, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) {
        throw new DMLRuntimeException("no processInstruction for AggregateInstruction!");
    }
}

