/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import java.util.HashMap;
import org.apache.sysml.lops.BinaryM;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AppendInstruction;
import org.apache.sysml.runtime.instructions.mr.BinUaggChainInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.BinaryMInstruction;
import org.apache.sysml.runtime.instructions.mr.CM_N_COVInstruction;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.CSVWriteInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineTernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CombineUnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.CtableInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeOffsetInstruction;
import org.apache.sysml.runtime.instructions.mr.CumulativeSplitInstruction;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.DataPartitionMRInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateInstruction;
import org.apache.sysml.runtime.instructions.mr.GroupedAggregateMInstruction;
import org.apache.sysml.runtime.instructions.mr.MMTSJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.MapMultChainInstruction;
import org.apache.sysml.runtime.instructions.mr.MatrixReshapeMRInstruction;
import org.apache.sysml.runtime.instructions.mr.PMMJMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ParameterizedBuiltinMRInstruction;
import org.apache.sysml.runtime.instructions.mr.PickByCountInstruction;
import org.apache.sysml.runtime.instructions.mr.QuaternaryInstruction;
import org.apache.sysml.runtime.instructions.mr.RandInstruction;
import org.apache.sysml.runtime.instructions.mr.RangeBasedReIndexInstruction;
import org.apache.sysml.runtime.instructions.mr.ReblockInstruction;
import org.apache.sysml.runtime.instructions.mr.RemoveEmptyMRInstruction;
import org.apache.sysml.runtime.instructions.mr.ReorgInstruction;
import org.apache.sysml.runtime.instructions.mr.ReplicateInstruction;
import org.apache.sysml.runtime.instructions.mr.ScalarInstruction;
import org.apache.sysml.runtime.instructions.mr.SeqInstruction;
import org.apache.sysml.runtime.instructions.mr.TernaryInstruction;
import org.apache.sysml.runtime.instructions.mr.UaggOuterChainInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.instructions.mr.ZeroOutInstruction;
import org.apache.sysml.runtime.matrix.SortMR;

public class MRInstructionParser
extends InstructionParser {
    public static HashMap<String, MRInstruction.MRType> String2MRInstructionType = new HashMap();

    public static MRInstruction parseSingleInstruction(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        MRInstruction.MRType mrtype = InstructionUtils.getMRType(str);
        return MRInstructionParser.parseSingleInstruction(mrtype, str);
    }

    public static MRInstruction parseSingleInstruction(MRInstruction.MRType mrtype, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (mrtype) {
            case Aggregate: {
                return AggregateInstruction.parseInstruction(str);
            }
            case Binary: {
                String opcode = InstructionUtils.getOpCode(str);
                String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
                String dt1 = parts[1].split("\u00b7")[1].split("\u00b7")[0];
                String dt2 = parts[2].split("\u00b7")[1].split("\u00b7")[0];
                if (dt1.equalsIgnoreCase("SCALAR") || dt2.equalsIgnoreCase("SCALAR")) {
                    return ScalarInstruction.parseInstruction(str);
                }
                if (BinaryM.isOpcode(opcode)) {
                    return BinaryMInstruction.parseInstruction(str);
                }
                return BinaryInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernaryInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryInstruction.parseInstruction(str);
            }
            case AggregateUnary: {
                return AggregateUnaryInstruction.parseInstruction(str);
            }
            case Ctable: {
                return CtableInstruction.parseInstruction(str);
            }
            case Quaternary: {
                return QuaternaryInstruction.parseInstruction(str);
            }
            case Rand: {
                return RandInstruction.parseInstruction(str);
            }
            case Seq: {
                return SeqInstruction.parseInstruction(str);
            }
            case Reblock: {
                return ReblockInstruction.parseInstruction(str);
            }
            case Append: {
                return AppendInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgInstruction.parseInstruction(str);
            }
            case Replicate: {
                return ReplicateInstruction.parseInstruction(str);
            }
            case Unary: {
                String opcode = InstructionUtils.getOpCode(str);
                String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
                if (parts.length == 4 && (opcode.equalsIgnoreCase("log") || opcode.equalsIgnoreCase("log_nz"))) {
                    return ScalarInstruction.parseInstruction(str);
                }
                return UnaryInstruction.parseInstruction(str);
            }
            case MMTSJ: {
                return MMTSJMRInstruction.parseInstruction(str);
            }
            case PMMJ: {
                return PMMJMRInstruction.parseInstruction(str);
            }
            case MapMultChain: {
                return MapMultChainInstruction.parseInstruction(str);
            }
            case BinUaggChain: {
                return BinUaggChainInstruction.parseInstruction(str);
            }
            case UaggOuterChain: {
                return UaggOuterChainInstruction.parseInstruction(str);
            }
            case CombineTernary: {
                return CombineTernaryInstruction.parseInstruction(str);
            }
            case CombineBinary: {
                return CombineBinaryInstruction.parseInstruction(str);
            }
            case CombineUnary: {
                return CombineUnaryInstruction.parseInstruction(str);
            }
            case PickByCount: {
                return PickByCountInstruction.parseInstruction(str);
            }
            case CM_N_COV: {
                return CM_N_COVInstruction.parseInstruction(str);
            }
            case GroupedAggregate: {
                return GroupedAggregateInstruction.parseInstruction(str);
            }
            case MapGroupedAggregate: {
                return GroupedAggregateMInstruction.parseInstruction(str);
            }
            case RightIndex: {
                return RangeBasedReIndexInstruction.parseInstruction(str);
            }
            case ZeroOut: {
                return ZeroOutInstruction.parseInstruction(str);
            }
            case MatrixReshape: {
                return MatrixReshapeMRInstruction.parseInstruction(str);
            }
            case Sort: {
                return SortMR.parseSortInstruction(str);
            }
            case CSVReblock: {
                return CSVReblockInstruction.parseInstruction(str);
            }
            case CSVWrite: {
                return CSVWriteInstruction.parseInstruction(str);
            }
            case ParameterizedBuiltin: {
                return ParameterizedBuiltinMRInstruction.parseInstruction(str);
            }
            case RemoveEmpty: {
                return RemoveEmptyMRInstruction.parseInstruction(str);
            }
            case Partition: {
                return DataPartitionMRInstruction.parseInstruction(str);
            }
            case CumsumAggregate: {
                return CumulativeAggregateInstruction.parseInstruction(str);
            }
            case CumsumSplit: {
                return CumulativeSplitInstruction.parseInstruction(str);
            }
            case CumsumOffset: {
                return CumulativeOffsetInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid MR Instruction Type: " + (Object)((Object)mrtype));
    }

    public static MRInstruction[] parseMixedInstructions(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        Instruction[] inst = InstructionParser.parseMixedInstructions(str);
        MRInstruction[] mrinst = new MRInstruction[inst.length];
        for (int i = 0; i < inst.length; ++i) {
            mrinst[i] = (MRInstruction)inst[i];
        }
        return mrinst;
    }

    public static AggregateInstruction[] parseAggregateInstructions(String str) {
        AggregateInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new AggregateInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = AggregateInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static ReblockInstruction[] parseReblockInstructions(String str) {
        ReblockInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new ReblockInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = ReblockInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static CSVReblockInstruction[] parseCSVReblockInstructions(String str) {
        CSVReblockInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new CSVReblockInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = CSVReblockInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static CSVWriteInstruction[] parseCSVWriteInstructions(String str) {
        CSVWriteInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new CSVWriteInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = CSVWriteInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static AggregateBinaryInstruction[] parseAggregateBinaryInstructions(String str) {
        AggregateBinaryInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new AggregateBinaryInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = AggregateBinaryInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static DataGenMRInstruction[] parseDataGenInstructions(String str) {
        DataGenMRInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new DataGenMRInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = (DataGenMRInstruction)InstructionParser.parseSingleInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static MRInstruction[] parseCombineInstructions(String str) {
        MRInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new MRInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                MRInstruction.MRType type = InstructionUtils.getMRType(strlist[i]);
                if (type == MRInstruction.MRType.CombineBinary) {
                    inst[i] = CombineBinaryInstruction.parseInstruction(strlist[i]);
                    continue;
                }
                if (type == MRInstruction.MRType.CombineTernary) {
                    inst[i] = CombineTernaryInstruction.parseInstruction(strlist[i]);
                    continue;
                }
                throw new DMLRuntimeException("unknown combine instruction: " + strlist[i]);
            }
        }
        return inst;
    }

    public static CM_N_COVInstruction[] parseCM_N_COVInstructions(String str) {
        CM_N_COVInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new CM_N_COVInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = CM_N_COVInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    public static GroupedAggregateInstruction[] parseGroupedAggInstructions(String str) {
        GroupedAggregateInstruction[] inst = null;
        if (str != null && !str.isEmpty()) {
            String[] strlist = str.split("\u2021");
            inst = new GroupedAggregateInstruction[strlist.length];
            for (int i = 0; i < strlist.length; ++i) {
                inst[i] = GroupedAggregateInstruction.parseInstruction(strlist[i]);
            }
        }
        return inst;
    }

    static {
        String2MRInstructionType.put("a+", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("ak+", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("asqk+", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("a*", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("amax", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("amin", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("amean", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("avar", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("arimax", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("arimin", MRInstruction.MRType.Aggregate);
        String2MRInstructionType.put("cpmm", MRInstruction.MRType.AggregateBinary);
        String2MRInstructionType.put("rmm", MRInstruction.MRType.AggregateBinary);
        String2MRInstructionType.put("mapmm", MRInstruction.MRType.AggregateBinary);
        String2MRInstructionType.put("ua+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uar+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uac+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uak+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uark+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uack+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uasqk+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uarsqk+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uacsqk+", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uamean", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uarmean", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uacmean", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uavar", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uarvar", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uacvar", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("ua*", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uar*", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uac*", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uamax", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uamin", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uatrace", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uaktrace", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uarmax", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uarimax", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uacmax", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uarmin", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uarimin", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("uacmin", MRInstruction.MRType.AggregateUnary);
        String2MRInstructionType.put("abs", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("sin", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("cos", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("tan", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("asin", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("acos", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("atan", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("sign", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("sqrt", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("exp", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("log", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("log_nz", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("slog", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("pow", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("round", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("ceil", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("floor", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("sprop", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("sigmoid", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("!", MRInstruction.MRType.Unary);
        String2MRInstructionType.put("tsmm", MRInstruction.MRType.MMTSJ);
        String2MRInstructionType.put("pmm", MRInstruction.MRType.PMMJ);
        String2MRInstructionType.put("mapmmchain", MRInstruction.MRType.MapMultChain);
        String2MRInstructionType.put("binuaggchain", MRInstruction.MRType.BinUaggChain);
        String2MRInstructionType.put("+", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("-", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("s-r", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("*", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("/", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("%%", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("%/%", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("1-*", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("so", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("^", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("max", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("min", MRInstruction.MRType.Binary);
        String2MRInstructionType.put(">", MRInstruction.MRType.Binary);
        String2MRInstructionType.put(">=", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("<", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("<=", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("==", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("!=", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("^", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("^2", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("*2", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("-nz", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("&&", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("||", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("xor", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("bitwAnd", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("bitwOr", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("bitwXor", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("bitwShiftL", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("bitwShiftR", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map+", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map-", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map*", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map/", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map%%", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map%/%", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map1-*", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map^", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("mapmax", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("mapmin", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map>", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map>=", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map<", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map<=", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map==", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map!=", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map&&", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("map||", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("mapxor", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("mapbitwAnd", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("mapbitwOr", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("mapbitwXor", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("mapbitwShiftL", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("mapbitwShiftR", MRInstruction.MRType.Binary);
        String2MRInstructionType.put("+*", MRInstruction.MRType.Ternary);
        String2MRInstructionType.put("-*", MRInstruction.MRType.Ternary);
        String2MRInstructionType.put("ifelse", MRInstruction.MRType.Ternary);
        String2MRInstructionType.put("uaggouterchain", MRInstruction.MRType.UaggOuterChain);
        String2MRInstructionType.put("r'", MRInstruction.MRType.Reorg);
        String2MRInstructionType.put("rev", MRInstruction.MRType.Reorg);
        String2MRInstructionType.put("rdiag", MRInstruction.MRType.Reorg);
        String2MRInstructionType.put("rep", MRInstruction.MRType.Replicate);
        String2MRInstructionType.put("rand", MRInstruction.MRType.Rand);
        String2MRInstructionType.put("seq", MRInstruction.MRType.Seq);
        String2MRInstructionType.put("rblk", MRInstruction.MRType.Reblock);
        String2MRInstructionType.put("csvrblk", MRInstruction.MRType.CSVReblock);
        String2MRInstructionType.put("ctabletransform", MRInstruction.MRType.Ctable);
        String2MRInstructionType.put("ctabletransformscalarweight", MRInstruction.MRType.Ctable);
        String2MRInstructionType.put("ctableexpandscalarweight", MRInstruction.MRType.Ctable);
        String2MRInstructionType.put("ctabletransformhistogram", MRInstruction.MRType.Ctable);
        String2MRInstructionType.put("ctabletransformweightedhistogram", MRInstruction.MRType.Ctable);
        String2MRInstructionType.put("mapwsloss", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("redwsloss", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("mapwsigmoid", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("redwsigmoid", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("mapwdivmm", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("redwdivmm", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("mapwcemm", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("redwcemm", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("mapwumm", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("redwumm", MRInstruction.MRType.Quaternary);
        String2MRInstructionType.put("combinebinary", MRInstruction.MRType.CombineBinary);
        String2MRInstructionType.put("combineunary", MRInstruction.MRType.CombineUnary);
        String2MRInstructionType.put("combineternary", MRInstruction.MRType.CombineTernary);
        String2MRInstructionType.put("valuepick", MRInstruction.MRType.PickByCount);
        String2MRInstructionType.put("rangepick", MRInstruction.MRType.PickByCount);
        String2MRInstructionType.put("cm", MRInstruction.MRType.CM_N_COV);
        String2MRInstructionType.put("cov", MRInstruction.MRType.CM_N_COV);
        String2MRInstructionType.put("mean", MRInstruction.MRType.CM_N_COV);
        String2MRInstructionType.put("groupedagg", MRInstruction.MRType.GroupedAggregate);
        String2MRInstructionType.put("mapgroupedagg", MRInstruction.MRType.MapGroupedAggregate);
        String2MRInstructionType.put("rightIndex", MRInstruction.MRType.RightIndex);
        String2MRInstructionType.put("rightIndexForLeft", MRInstruction.MRType.RightIndex);
        String2MRInstructionType.put("zeroOut", MRInstruction.MRType.ZeroOut);
        String2MRInstructionType.put("mappend", MRInstruction.MRType.Append);
        String2MRInstructionType.put("rappend", MRInstruction.MRType.Append);
        String2MRInstructionType.put("gappend", MRInstruction.MRType.Append);
        String2MRInstructionType.put("rshape", MRInstruction.MRType.MatrixReshape);
        String2MRInstructionType.put("partition", MRInstruction.MRType.Partition);
        String2MRInstructionType.put("ucumack+", MRInstruction.MRType.CumsumAggregate);
        String2MRInstructionType.put("ucumac*", MRInstruction.MRType.CumsumAggregate);
        String2MRInstructionType.put("ucumacmin", MRInstruction.MRType.CumsumAggregate);
        String2MRInstructionType.put("ucumacmax", MRInstruction.MRType.CumsumAggregate);
        String2MRInstructionType.put("ucumsplit", MRInstruction.MRType.CumsumSplit);
        String2MRInstructionType.put("bcumoffk+", MRInstruction.MRType.CumsumOffset);
        String2MRInstructionType.put("bcumoff*", MRInstruction.MRType.CumsumOffset);
        String2MRInstructionType.put("bcumoffmin", MRInstruction.MRType.CumsumOffset);
        String2MRInstructionType.put("bcumoffmax", MRInstruction.MRType.CumsumOffset);
        String2MRInstructionType.put("sort", MRInstruction.MRType.Sort);
        String2MRInstructionType.put("csvwrite", MRInstruction.MRType.CSVWrite);
        String2MRInstructionType.put("replace", MRInstruction.MRType.ParameterizedBuiltin);
        String2MRInstructionType.put("rexpand", MRInstruction.MRType.ParameterizedBuiltin);
        String2MRInstructionType.put("rmempty", MRInstruction.MRType.RemoveEmpty);
    }
}

