/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.jmlc;

import java.util.HashMap;
import java.util.Set;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.DataConverter;

public class ResultVariables {
    private HashMap<String, Data> _out = new HashMap();

    public Set<String> getVariableNames() {
        return this._out.keySet();
    }

    public int size() {
        return this._out.size();
    }

    public double[][] getMatrix(String varname) {
        return DataConverter.convertToDoubleMatrix(this.getMatrixBlock(varname));
    }

    public MatrixBlock getMatrixBlock(String varname) {
        Data dat = this._out.get(varname);
        if (dat == null) {
            throw new DMLException("Non-existent output variable: " + varname);
        }
        if (!(dat instanceof MatrixObject)) {
            throw new DMLException("Expected matrix result '" + varname + "' not a matrix.");
        }
        MatrixObject mo = (MatrixObject)dat;
        MatrixBlock mb = (MatrixBlock)mo.acquireRead();
        mo.release();
        return mb;
    }

    public String[][] getFrame(String varname) {
        return DataConverter.convertToStringFrame(this.getFrameBlock(varname));
    }

    public FrameBlock getFrameBlock(String varname) {
        Data dat = this._out.get(varname);
        if (dat == null) {
            throw new DMLException("Non-existent output variable: " + varname);
        }
        if (!(dat instanceof FrameObject)) {
            throw new DMLException("Expected frame result '" + varname + "' not a frame.");
        }
        FrameObject fo = (FrameObject)dat;
        FrameBlock fb = (FrameBlock)fo.acquireRead();
        fo.release();
        return fb;
    }

    public double getDouble(String varname) {
        return this.getScalarObject(varname).getDoubleValue();
    }

    public boolean getBoolean(String varname) {
        return this.getScalarObject(varname).getBooleanValue();
    }

    public long getLong(String varname) {
        return this.getScalarObject(varname).getLongValue();
    }

    public String getString(String varname) {
        return this.getScalarObject(varname).getStringValue();
    }

    public ScalarObject getScalarObject(String varname) {
        Data dat = this._out.get(varname);
        if (dat == null) {
            throw new DMLException("Non-existent output variable: " + varname);
        }
        if (!(dat instanceof ScalarObject)) {
            throw new DMLException("Expected scalar result '" + varname + "' not a scalar.");
        }
        return (ScalarObject)dat;
    }

    protected void addResult(String ovar, Data data) {
        this._out.put(ovar, data);
    }
}

