/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.test.grad_check.Two_layer_affine_l2_net_backward_output;
import org.apache.sysml.scripts.nn.test.grad_check.Two_layer_affine_l2_net_forward_output;
import org.apache.sysml.scripts.nn.test.grad_check.Two_layer_affine_l2_net_run_output;

public class Grad_check
extends Script {
    public Grad_check() {
        String string = "scripts/nn/test/grad_check.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public void fm() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::fm();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String fm__docs() {
        String string = "fm = function() {\n  /*\n   * Gradient check for the factorization machines.\n   */\n";
        return string;
    }

    public String fm__source() {
        String string = "fm = function() {\n  /*\n   * Gradient check for the factorization machines.\n   */\n  print(\"Grad checking the factorization machines with L2 loss.\")\n\n  # Generate data\n  n = 5# num examples\n  d = 100 # num features\n  k = 2 # factorization dimensionality\n  X = rand(rows=n, cols=d)\n  y = rand(rows=n, cols=1)\n  [w0, W, V] = fm::init(d, k)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = fm::forward(X, w0, W, V)\n  dout = l2_loss::backward(out, y)\n  [dw0, dW, dV] = fm::backward(dout, X, w0, W, V)\n\n  # Grad check\n  h = 1e-5\n\n  print(\" - Grad checking w0.\")\n  for (i in 1:nrow(w0)) {\n    for (j in 1:ncol(w0)) {\n      # Compute numerical derivative\n      old = as.scalar(w0[i,j])\n      w0[i,j] = old - h  # h = 1e-5\n      outmh = fm::forward(X, w0, W, V)\n      lossmh = l2_loss::forward(outmh, y)\n      w0[i,j] = old + h  # h = 1e-5\n      outph = fm::forward(X, w0, W, V)\n      lossph = l2_loss::forward(outph, y)\n      w0[i,j] = old  # reset\n      dw0_num = (lossph-lossmh) / (2*h) # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dw0[i,j]), dw0_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W.\")\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h  # h = 1e-5\n      outmh = fm::forward(X, w0, W, V)\n      lossmh = l2_loss::forward(outmh, y)\n      W[i,j] = old + h  # h = 1e-5\n      outph = fm::forward(X, w0, W, V)\n      lossph = l2_loss::forward(outph, y)\n      W[i,j] = old  # reset\n      dW_num = (lossph-lossmh) / (2*h) # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking V.\")\n  for (i in 1:nrow(V)) {\n    for(i in 1:ncol(V)) {\n      # Compute numerical derivative\n      old = as.scalar(V[i,j])\n      V[i,j] = old - h  # h = 1e-5\n      outmh = fm::forward(X, w0, W, V)\n      lossmh = l2_loss::forward(outmh, y)\n      V[i,j] = old + h  # h= 1e-5\n      outph = fm::forward(X, w0, W, V)\n      lossph = l2_loss::forward(outph, y)\n      V[i,j] = old  # reset\n      dV_num = (lossph-lossmh) / (2*h) # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dV[i,j]), dV_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public Two_layer_affine_l2_net_run_output two_layer_affine_l2_net_run(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;[pred, loss, dX, dW1, db1, dW2, db2] = mlcontextns::two_layer_affine_l2_net_run(X, y, W1, b1, W2, b2);";
        Script script = new Script(string);
        script.in("X", object).in("y", object2).in("W1", object3).in("b1", object4).in("W2", object5).in("b2", object6).out("pred").out("loss").out("dX").out("dW1").out("db1").out("dW2").out("db2");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("pred");
        double d = mLResults.getDouble("loss");
        Matrix matrix2 = mLResults.getMatrix("dX");
        Matrix matrix3 = mLResults.getMatrix("dW1");
        Matrix matrix4 = mLResults.getMatrix("db1");
        Matrix matrix5 = mLResults.getMatrix("dW2");
        Matrix matrix6 = mLResults.getMatrix("db2");
        Two_layer_affine_l2_net_run_output two_layer_affine_l2_net_run_output = new Two_layer_affine_l2_net_run_output(matrix, d, matrix2, matrix3, matrix4, matrix5, matrix6);
        return two_layer_affine_l2_net_run_output;
    }

    public String two_layer_affine_l2_net_run__docs() {
        String string = "two_layer_affine_l2_net_run = function(matrix[double] X, matrix[double] y,\n                                       matrix[double] W1, matrix[double] b1,\n                                       matrix[double] W2, matrix[double] b2)\n    return (matrix[double] pred, double loss,\n            matrix[double] dX,\n            matrix[double] dW1, matrix[double] db1,\n            matrix[double] dW2, matrix[double] db2) {\n  # Compute forward pass\n  [loss, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n\n  # Compute backward pass\n  [dX, dpred, daout, dhout, dW1, db1, dW2, db2] =\n      two_layer_affine_l2_net_backward(X, y, pred, aout, hout, W1, b1, W2, b2)\n}\n";
        return string;
    }

    public String two_layer_affine_l2_net_run__source() {
        String string = "two_layer_affine_l2_net_run = function(matrix[double] X, matrix[double] y,\n                                       matrix[double] W1, matrix[double] b1,\n                                       matrix[double] W2, matrix[double] b2)\n    return (matrix[double] pred, double loss,\n            matrix[double] dX,\n            matrix[double] dW1, matrix[double] db1,\n            matrix[double] dW2, matrix[double] db2) {\n  # Compute forward pass\n  [loss, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n\n  # Compute backward pass\n  [dX, dpred, daout, dhout, dW1, db1, dW2, db2] =\n      two_layer_affine_l2_net_backward(X, y, pred, aout, hout, W1, b1, W2, b2)\n}\n";
        return string;
    }

    public void relu() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::relu();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String relu__docs() {
        String string = "relu = function() {\n  /*\n   * Gradient check for the ReLU nonlinearity layer.\n   *\n   * NOTE: This could result in a false-negative in which the test\n   * fails due to a kink being crossed in the nonlinearity.  This\n   * occurs when the tests, f(x-h) and f(x+h), end up on opposite\n   * sides of the zero threshold of max(0, fx).  For now, just run\n   * the tests again.  In the future, we can explicitly check for\n   * this and rerun the test automatically.\n   */\n";
        return string;
    }

    public String relu__source() {
        String string = "relu = function() {\n  /*\n   * Gradient check for the ReLU nonlinearity layer.\n   *\n   * NOTE: This could result in a false-negative in which the test\n   * fails due to a kink being crossed in the nonlinearity.  This\n   * occurs when the tests, f(x-h) and f(x+h), end up on opposite\n   * sides of the zero threshold of max(0, fx).  For now, just run\n   * the tests again.  In the future, we can explicitly check for\n   * this and rerun the test automatically.\n   */\n  print(\"Grad checking the ReLU nonlinearity layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  M = 10 # num neurons\n  X = rand(rows=N, cols=M, min=-5, max=5)\n  y = rand(rows=N, cols=M)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = relu::forward(X)\n  dout = l2_loss::backward(out, y)\n  dX = relu::backward(dout, X)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = relu::forward(X)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = relu::forward(X)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void batch_norm2d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::batch_norm2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String batch_norm2d__docs() {
        String string = "batch_norm2d = function() {\n  /*\n   * Gradient check for the 2D (spatial) batch normalization layer.\n   */\n";
        return string;
    }

    public String batch_norm2d__source() {
        String string = "batch_norm2d = function() {\n  /*\n   * Gradient check for the 2D (spatial) batch normalization layer.\n   */\n  print(\"Grad checking the 2D (spatial) batch normalization layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  C = 2  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  mu = 0.9  # momentum\n  eps = 1e-5  # epsilon\n  X = rand(rows=N, cols=C*Hin*Win)\n  y = rand(rows=N, cols=C*Hin*Win)\n  gamma = rand(rows=C, cols=1)\n  beta = rand(rows=C, cols=1)\n  ema_mean = rand(rows=C, cols=1)\n  ema_var = rand(rows=C, cols=1)\n  #[dummy, dummy, ema_mean, ema_var] = batch_norm2d::init(C)\n\n  # Check training & testing modes\n  # for (i in 1:1) {\n    mode = 'train'\n    print(\" - Grad checking the '\"+mode+\"' mode.\")\n\n    # Compute analytical gradients of loss wrt parameters\n    [out, ema_mean_upd, ema_var_upd, cache_mean, cache_var] =\n        batch_norm2d::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, eps)\n    dout = l2_loss::backward(out, y)\n    [dX, dgamma, dbeta] = batch_norm2d::backward(dout, cache_mean, cache_var, \n                                                 X, gamma, C, Hin, Win, eps)\n\n    # Grad check\n    h = 1e-5\n    print(\"   - Grad checking X.\")\n    for (i in 1:nrow(X)) {\n      for (j in 1:ncol(X)) {\n        # Compute numerical derivative\n        old = as.scalar(X[i,j])\n        X[i,j] = old - h\n        [outmh, ema_mean_upd, ema_var_upd, cache_mean, cache_var] =\n            batch_norm2d::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, eps)\n        lossmh = l2_loss::forward(outmh, y)\n        X[i,j] = old + h\n        [outph, ema_mean_upd, ema_var_upd, cache_mean, cache_var] =\n            batch_norm2d::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, eps)\n        lossph = l2_loss::forward(outph, y)\n        X[i,j] = old  # reset\n        dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking gamma.\")\n    for (i in 1:nrow(gamma)) {\n      for (j in 1:ncol(gamma)) {\n        # Compute numerical derivative\n        old = as.scalar(gamma[i,j])\n        gamma[i,j] = old - h\n        [outmh, ema_mean_upd, ema_var_upd, cache_mean, cache_var] =\n            batch_norm2d::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, eps)\n        lossmh = l2_loss::forward(outmh, y)\n        gamma[i,j] = old + h\n        [outph, ema_mean_upd, ema_var_upd, cache_mean, cache_var] =\n            batch_norm2d::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, eps)\n        lossph = l2_loss::forward(outph, y)\n        gamma[i,j] = old  # reset\n        dgamma_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dgamma[i,j]), dgamma_num,\n                                                    lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking beta.\")\n    for (i in 1:nrow(beta)) {\n      for (j in 1:ncol(beta)) {\n        # Compute numerical derivative\n        old = as.scalar(beta[i,j])\n        beta[i,j] = old - h\n        [outmh, ema_mean_upd, ema_var_upd, cache_mean, cache_var] =\n            batch_norm2d::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, eps)\n        lossmh = l2_loss::forward(outmh, y)\n        beta[i,j] = old + h\n        [outph, ema_mean_upd, ema_var_upd, cache_mean, cache_var] =\n            batch_norm2d::forward(X, gamma, beta, C, Hin, Win, mode, ema_mean, ema_var, mu, eps)\n        lossph = l2_loss::forward(outph, y)\n        beta[i,j] = old  # reset\n        dbeta_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dbeta[i,j]), dbeta_num,\n                                                    lossph, lossmh)\n      }\n    }\n  # }\n}\n";
        return string;
    }

    public void affine() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::affine();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String affine__docs() {
        String string = "affine = function() {\n  /*\n   * Gradient check for the affine layer.\n   */\n";
        return string;
    }

    public String affine__source() {
        String string = "affine = function() {\n  /*\n   * Gradient check for the affine layer.\n   */\n  print(\"Grad checking the affine layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  D = 100 # num features\n  M = 10 # num neurons\n  X = rand(rows=N, cols=D)\n  y = rand(rows=N, cols=M)\n  [W, b] = affine::init(D, M)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = affine::forward(X, W, b)\n  dout = l2_loss::backward(out, y)\n  [dX, dW, db] = affine::backward(dout, X, W, b)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = affine::forward(X, W, b)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = affine::forward(X, W, b)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W.\")\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      outmh = affine::forward(X, W, b)\n      lossmh = l2_loss::forward(outmh, y)\n      W[i,j] = old + h\n      outph = affine::forward(X, W, b)\n      lossph = l2_loss::forward(outph, y)\n      W[i,j] = old  # reset\n      dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b.\")\n  for (i in 1:nrow(b)) {\n    for (j in 1:ncol(b)) {\n      # Compute numerical derivative\n      old = as.scalar(b[i,j])\n      b[i,j] = old - h\n      outmh = affine::forward(X, W, b)\n      lossmh = l2_loss::forward(outmh, y)\n      b[i,j] = old + h\n      outph = affine::forward(X, W, b)\n      lossph = l2_loss::forward(outph, y)\n      b[i,j] = old  # reset\n      db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void avg_pool2d_builtin() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::avg_pool2d_builtin();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String avg_pool2d_builtin__docs() {
        String string = "avg_pool2d_builtin = function() {\n  /*\n   * Gradient check for the 2D avg pooling layer.\n   */\n";
        return string;
    }

    public String avg_pool2d_builtin__source() {
        String string = "avg_pool2d_builtin = function() {\n  /*\n   * Gradient check for the 2D avg pooling layer.\n   */\n  print(\"Grad checking the built-in 2D avg pooling layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 2  # num channels\n  Hin = 4  # input height\n  Win = 4  # input width\n  Hf = 2  # pool filter height\n  Wf = 2  # pool filter width\n  stride = 2\n  X = rand(rows=N, cols=C*Hin*Win)\n\n  for (pad in 0:1) {\n    print(\" - Grad checking w/ pad=\"+pad+\".\")\n    Hout = as.integer(floor((Hin + 2 * pad - Hf) / stride + 1))\n    Wout = as.integer(floor((Win + 2 * pad - Wf) / stride + 1))\n    y = rand(rows=N, cols=C*Hout*Wout)\n\n    # Compute analytical gradients of loss wrt parameters\n    [out, Hout, Wout] = avg_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf, stride, stride,\n                                                    pad, pad)\n    dout = l2_loss::backward(out, y)\n    dX = avg_pool2d_builtin::backward(dout, Hout, Wout, X, C, Hin, Win, Hf, Wf, stride, stride,\n                                      pad, pad)\n\n    # Grad check\n    h = 1e-5\n    for (i in 1:nrow(X)) {\n      for (j in 1:ncol(X)) {\n        # Compute numerical derivative\n        old = as.scalar(X[i,j])\n        X[i,j] = old - h\n        [outmh, Hout, Wout] = avg_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf, stride, stride,\n                                                          pad, pad)\n        lossmh = l2_loss::forward(outmh, y)\n        X[i,j] = old + h\n        [outph, Hout, Wout] = avg_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf, stride, stride,\n                                                          pad, pad)\n        lossph = l2_loss::forward(outph, y)\n        X[i,j] = old  # reset\n        dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n      }\n    }\n  }\n}\n";
        return string;
    }

    public void conv2d_transpose_depthwise() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::conv2d_transpose_depthwise();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d_transpose_depthwise__docs() {
        String string = "conv2d_transpose_depthwise = function() {\n  /*\n   * Gradient check for the 2D depthwise transpose convolutional layer.\n   */\n";
        return string;
    }

    public String conv2d_transpose_depthwise__source() {
        String string = "conv2d_transpose_depthwise = function() {\n  /*\n   * Gradient check for the 2D depthwise transpose convolutional layer.\n   */\n  print(\"Grad checking the 2D depthwise transpose convolutional layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 8  # num channels\n  Hin = 3  # input height\n  Win = 3  # input width\n  M = 4  # depth of filters\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 2\n  pad = 1\n  out_pad = 1\n  X = rand(rows=N, cols=C*Hin*Win)\n\n  # Create layers\n  [W, b] = conv2d_transpose_depthwise::init(C, M, Hf, Wf)\n\n  # Compute analytical gradients of loss wrt parameters\n  [out, Hout, Wout] = conv2d_transpose_depthwise::forward(X, W, b, C, Hin, Win, M, Hf, Wf,\n                                                          stride, stride, pad, pad,\n                                                          out_pad, out_pad)\n  y = rand(rows=N, cols=C/M*Hout*Wout)\n  dout = l2_loss::backward(out,y)\n  [dX, dW, db] = conv2d_transpose_depthwise::backward(dout, Hout, Wout, X, W, b, C, Hin, Win, M,\n                                                      Hf, Wf, stride, stride, pad, pad)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_transpose_depthwise::forward(X, W, b, C, Hin, Win, M, Hf, Wf,\n                                                                stride, stride, pad, pad,\n                                                                out_pad, out_pad)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_transpose_depthwise::forward(X, W, b, C, Hin, Win, M, Hf, Wf,\n                                                                stride, stride, pad, pad,\n                                                                out_pad, out_pad)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W.\")\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_transpose_depthwise::forward(X, W, b, C, Hin, Win, M, Hf, Wf,\n                                                                stride, stride, pad, pad,\n                                                                out_pad, out_pad)\n      lossmh = l2_loss::forward(outmh, y)\n      W[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_transpose_depthwise::forward(X, W, b, C, Hin, Win, M, Hf, Wf,\n                                                                stride, stride, pad, pad,\n                                                                out_pad, out_pad)\n      lossph = l2_loss::forward(outph, y)\n      W[i,j] = old  # reset\n      dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b.\")\n  for (i in 1:nrow(b)) {\n    for (j in 1:ncol(b)) {\n      # Compute numerical derivative\n      old = as.scalar(b[i,j])\n      b[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_transpose_depthwise::forward(X, W, b, C, Hin, Win, M, Hf, Wf,\n                                                                stride, stride, pad, pad,\n                                                                out_pad, out_pad)\n      lossmh = l2_loss::forward(outmh, y)\n      b[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_transpose_depthwise::forward(X, W, b, C, Hin, Win, M, Hf, Wf,\n                                                                stride, stride, pad, pad,\n                                                                out_pad, out_pad)\n      lossph = l2_loss::forward(outph, y)\n      b[i,j] = old  # reset\n      db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void cross_entropy_loss() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::cross_entropy_loss();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String cross_entropy_loss__docs() {
        String string = "cross_entropy_loss = function() {\n  /*\n   * Gradient check for the cross-entropy loss function.\n   */\n";
        return string;
    }

    public String cross_entropy_loss__source() {
        String string = "cross_entropy_loss = function() {\n  /*\n   * Gradient check for the cross-entropy loss function.\n   */\n  print(\"Grad checking the cross-entropy loss function.\")\n\n  # Generate data\n  N = 3  # num examples\n  K = 10  # num targets\n  pred = rand(rows=N, cols=K, min=0, max=1, pdf=\"uniform\")\n  pred = softmax::forward(pred)  # normalized probs\n  y = rand(rows=N, cols=K, min=0, max=1, pdf=\"uniform\")\n  y = softmax::forward(y)  # normalized probs\n\n  # Compute analytical gradient\n  dpred = cross_entropy_loss::backward(pred, y)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(pred)) {\n    for (j in 1:ncol(pred)) {\n      # Compute numerical derivative\n      old = as.scalar(pred[i,j])\n      pred[i,j] = old - h\n      lossmh = cross_entropy_loss::forward(pred, y)\n      pred[i,j] = old + h\n      lossph = cross_entropy_loss::forward(pred, y)\n      pred[i,j] = old  # reset W[i,j]\n      dpred_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dpred[i,j]), dpred_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void softmax() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::softmax();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String softmax__docs() {
        String string = "softmax = function() {\n  /*\n   * Gradient check for the softmax layer.\n   */\n";
        return string;
    }

    public String softmax__source() {
        String string = "softmax = function() {\n  /*\n   * Gradient check for the softmax layer.\n   */\n  print(\"Grad checking the softmax layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  D = 10 # num classes\n  X = rand(rows=N, cols=D)\n  y = rand(rows=N, cols=D, min=0, max=1, pdf=\"uniform\")\n  y = y / rowSums(y)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = softmax::forward(X)\n  dout = l2_loss::backward(out, y)\n  dX = softmax::backward(dout, X)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = softmax::forward(X)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = softmax::forward(X)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void tanh() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::tanh();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String tanh__docs() {
        String string = "tanh = function() {\n  /*\n   * Gradient check for the hyperbolic tangent (tanh) nonlinearity\n   * layer.\n   */\n";
        return string;
    }

    public String tanh__source() {
        String string = "tanh = function() {\n  /*\n   * Gradient check for the hyperbolic tangent (tanh) nonlinearity\n   * layer.\n   */\n  print(\"Grad checking the tanh nonlinearity layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  M = 10 # num neurons\n  X = rand(rows=N, cols=M)\n  y = rand(rows=N, cols=M)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = tanh::forward(X)\n  dout = l2_loss::backward(out, y)\n  dX = tanh::backward(dout, X)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = tanh::forward(X)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = tanh::forward(X)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void max_pool2d_simple() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::max_pool2d_simple();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String max_pool2d_simple__docs() {
        String string = "max_pool2d_simple = function() {\n  /*\n   * Gradient check for the simple reference 2D max pooling layer.\n   */\n";
        return string;
    }

    public String max_pool2d_simple__source() {
        String string = "max_pool2d_simple = function() {\n  /*\n   * Gradient check for the simple reference 2D max pooling layer.\n   */\n  print(\"Grad checking the simple reference 2D max pooling layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 2  # num channels\n  Hin = 4  # input height\n  Win = 4  # input width\n  Hf = 2  # pool filter height\n  Wf = 2  # pool filter width\n  stride = 2\n  X = rand(rows=N, cols=C*Hin*Win)\n\n  for (pad in 0:1) {\n    print(\" - Grad checking w/ pad=\"+pad+\".\")\n    Hout = as.integer(floor((Hin + 2*pad - Hf)/stride + 1))\n    Wout = as.integer(floor((Win + 2*pad - Wf)/stride + 1))\n    y = rand(rows=N, cols=C*Hout*Wout)\n\n    # Compute analytical gradients of loss wrt parameters\n    [out, Hout, Wout] = max_pool2d_simple::forward(X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n    dout = l2_loss::backward(out, y)\n    dX = max_pool2d_simple::backward(dout, Hout, Wout, X, C, Hin, Win, Hf, Wf, stride, stride,\n                                     pad, pad)\n\n    # Grad check\n    h = 1e-5\n    for (i in 1:nrow(X)) {\n      for (j in 1:ncol(X)) {\n        # Compute numerical derivative\n        old = as.scalar(X[i,j])\n        X[i,j] = old - h\n        [outmh, Hout, Wout] = max_pool2d_simple::forward(X, C, Hin, Win, Hf, Wf, stride, stride,\n                                                         pad, pad)\n        lossmh = l2_loss::forward(outmh, y)\n        X[i,j] = old + h\n        [outph, Hout, Wout] = max_pool2d_simple::forward(X, C, Hin, Win, Hf, Wf, stride, stride,\n                                                         pad, pad)\n        lossph = l2_loss::forward(outph, y)\n        X[i,j] = old  # reset\n        dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n      }\n    }\n  }\n}\n";
        return string;
    }

    public void max_pool2d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::max_pool2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String max_pool2d__docs() {
        String string = "max_pool2d = function() {\n  /*\n   * Gradient check for the 2D max pooling layer.\n   */\n";
        return string;
    }

    public String max_pool2d__source() {
        String string = "max_pool2d = function() {\n  /*\n   * Gradient check for the 2D max pooling layer.\n   */\n  print(\"Grad checking the 2D max pooling layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 2  # num channels\n  Hin = 4  # input height\n  Win = 4  # input width\n  Hf = 2  # pool filter height\n  Wf = 2  # pool filter width\n  stride = 2\n  X = rand(rows=N, cols=C*Hin*Win)\n\n  for (pad in 0:1) {\n    print(\" - Grad checking w/ pad=\"+pad+\".\")\n    Hout = as.integer(floor((Hin + 2*pad - Hf)/stride + 1))\n    Wout = as.integer(floor((Win + 2*pad - Wf)/stride + 1))\n    y = rand(rows=N, cols=C*Hout*Wout)\n\n    # Compute analytical gradients of loss wrt parameters\n    [out, Hout, Wout] = max_pool2d::forward(X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n    dout = l2_loss::backward(out, y)\n    dX = max_pool2d::backward(dout, Hout, Wout, X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n\n    # Grad check\n    h = 1e-5\n    for (i in 1:nrow(X)) {\n      for (j in 1:ncol(X)) {\n        # Compute numerical derivative\n        old = as.scalar(X[i,j])\n        X[i,j] = old - h\n        [outmh, Hout, Wout] = max_pool2d::forward(X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n        lossmh = l2_loss::forward(outmh, y)\n        X[i,j] = old + h\n        [outph, Hout, Wout] = max_pool2d::forward(X, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n        lossph = l2_loss::forward(outph, y)\n        X[i,j] = old  # reset\n        dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n      }\n    }\n  }\n}\n";
        return string;
    }

    public void softmax2d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::softmax2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String softmax2d__docs() {
        String string = "softmax2d = function() {\n  /*\n   * Gradient check for the 2D softmax layer.\n   */\n";
        return string;
    }

    public String softmax2d__source() {
        String string = "softmax2d = function() {\n  /*\n   * Gradient check for the 2D softmax layer.\n   */\n  print(\"Grad checking the 2D softmax layer with L2 loss.\")\n\n  # Generate data\n  N = 3  # num examples\n  C = 10  # num classes\n  Hin = 5  # example height\n  Win = 5  # example width\n\n  X = rand(rows=N, cols=C*Hin*Win)\n  y = rand(rows=N, cols=C*Hin*Win, min=0, max=1, pdf=\"uniform\")\n  y_C_NHW = util::transpose_NCHW_to_CNHW(y, C)\n  y_NHW_C = t(y_C_NHW)\n  y_NHW_C = y_NHW_C / rowSums(y_NHW_C)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = softmax2d::forward(X, C)\n  out_C_NHW = util::transpose_NCHW_to_CNHW(out, C)\n  out_NHW_C = t(out_C_NHW)\n\n  dout_NHW_C = l2_loss::backward(out_NHW_C, y_NHW_C)\n  dout_C_NHW = t(dout_NHW_C)\n  dout = util::transpose_NCHW_to_CNHW(dout_C_NHW, N)\n  dX = softmax2d::backward(dout, X, C)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = softmax2d::forward(X, C)\n      outmh_C_NHW = util::transpose_NCHW_to_CNHW(outmh, C)\n      outmh_NHW_C = t(outmh_C_NHW)\n      lossmh = l2_loss::forward(outmh_NHW_C, y_NHW_C)\n\n      X[i,j] = old + h\n      outph = softmax2d::forward(X, C)\n      outph_C_NHW = util::transpose_NCHW_to_CNHW(outph, C)\n      outph_NHW_C = t(outph_C_NHW)\n      lossph = l2_loss::forward(outph_NHW_C, y_NHW_C)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void conv2d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::conv2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d__docs() {
        String string = "conv2d = function() {\n  /*\n   * Gradient check for the 2D convolutional layer using `im2col`.\n   */\n";
        return string;
    }

    public String conv2d__source() {
        String string = "conv2d = function() {\n  /*\n   * Gradient check for the 2D convolutional layer using `im2col`.\n   */\n  print(\"Grad checking the `im2col` 2D convolutional layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  F = 4  # num filters\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 1\n  pad = 1\n  X = rand(rows=N, cols=C*Hin*Win)\n  y = rand(rows=N, cols=F*Hin*Win)\n\n  # Create layers\n  [W, b] = conv2d::init(F, C, Hf, Wf)\n\n  # Compute analytical gradients of loss wrt parameters\n  [out, Hout, Wout] = conv2d::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n  dout = l2_loss::backward(out, y)\n  [dX, dW, db] = conv2d::backward(dout, Hout, Wout, X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                  pad, pad)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      [outph, Hout, Wout] = conv2d::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W.\")\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      W[i,j] = old + h\n      [outph, Hout, Wout] = conv2d::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      W[i,j] = old  # reset\n      dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b.\")\n  for (i in 1:nrow(b)) {\n    for (j in 1:ncol(b)) {\n      # Compute numerical derivative\n      old = as.scalar(b[i,j])\n      b[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      b[i,j] = old + h\n      [outph, Hout, Wout] = conv2d::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      b[i,j] = old  # reset\n      db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public Two_layer_affine_l2_net_backward_output two_layer_affine_l2_net_backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;[dX, dpred, daout, dhout, dW1, db1, dW2, db2] = mlcontextns::two_layer_affine_l2_net_backward(X, y, pred, aout, hout, W1, b1, W2, b2);";
        Script script = new Script(string);
        script.in("X", object).in("y", object2).in("pred", object3).in("aout", object4).in("hout", object5).in("W1", object6).in("b1", object7).in("W2", object8).in("b2", object9).out("dX").out("dpred").out("daout").out("dhout").out("dW1").out("db1").out("dW2").out("db2");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dpred");
        Matrix matrix3 = mLResults.getMatrix("daout");
        Matrix matrix4 = mLResults.getMatrix("dhout");
        Matrix matrix5 = mLResults.getMatrix("dW1");
        Matrix matrix6 = mLResults.getMatrix("db1");
        Matrix matrix7 = mLResults.getMatrix("dW2");
        Matrix matrix8 = mLResults.getMatrix("db2");
        Two_layer_affine_l2_net_backward_output two_layer_affine_l2_net_backward_output = new Two_layer_affine_l2_net_backward_output(matrix, matrix2, matrix3, matrix4, matrix5, matrix6, matrix7, matrix8);
        return two_layer_affine_l2_net_backward_output;
    }

    public String two_layer_affine_l2_net_backward__docs() {
        String string = "two_layer_affine_l2_net_backward = function(matrix[double] X, matrix[double] y, matrix[double] pred,\n                                            matrix[double] aout, matrix[double] hout,\n                                            matrix[double] W1, matrix[double] b1,\n                                            matrix[double] W2, matrix[double] b2)\n    return (matrix[double] dX, matrix[double] dpred,\n            matrix[double] daout, matrix[double] dhout,\n            matrix[double] dW1, matrix[double] db1, matrix[double] dW2, matrix[double] db2) {\n  # Compute backward pass\n  dpred = l2_loss::backward(pred, y)\n  [daout, dW2, db2] = affine::backward(dpred, aout, W2, b2)\n  dhout = relu::backward(daout, hout)\n  [dX, dW1, db1] = affine::backward(dhout, X, W1, b1)\n}\n";
        return string;
    }

    public String two_layer_affine_l2_net_backward__source() {
        String string = "two_layer_affine_l2_net_backward = function(matrix[double] X, matrix[double] y, matrix[double] pred,\n                                            matrix[double] aout, matrix[double] hout,\n                                            matrix[double] W1, matrix[double] b1,\n                                            matrix[double] W2, matrix[double] b2)\n    return (matrix[double] dX, matrix[double] dpred,\n            matrix[double] daout, matrix[double] dhout,\n            matrix[double] dW1, matrix[double] db1, matrix[double] dW2, matrix[double] db2) {\n  # Compute backward pass\n  dpred = l2_loss::backward(pred, y)\n  [daout, dW2, db2] = affine::backward(dpred, aout, W2, b2)\n  dhout = relu::backward(daout, hout)\n  [dX, dW1, db1] = affine::backward(dhout, X, W1, b1)\n}\n";
        return string;
    }

    public void l2_loss() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::l2_loss();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String l2_loss__docs() {
        String string = "l2_loss = function() {\n  /*\n   * Gradient check for the L2 loss function.\n   */\n";
        return string;
    }

    public String l2_loss__source() {
        String string = "l2_loss = function() {\n  /*\n   * Gradient check for the L2 loss function.\n   */\n  print(\"Grad checking the L2 loss function.\")\n\n  # Generate data\n  N = 3 # num examples\n  D = 2 # num targets\n  pred = rand(rows=N, cols=D)\n  y = rand(rows=N, cols=D)\n\n  # Compute analytical gradient\n  dpred = l2_loss::backward(pred, y)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(pred)) {\n    for (j in 1:ncol(pred)) {\n      # Compute numerical derivative\n      old = as.scalar(pred[i,j])\n      pred[i,j] = old - h\n      lossmh = l2_loss::forward(pred, y)\n      pred[i,j] = old + h\n      lossph = l2_loss::forward(pred, y)\n      pred[i,j] = old  # reset W[i,j]\n      dpred_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dpred[i,j]), dpred_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void scale_shift2d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::scale_shift2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String scale_shift2d__docs() {
        String string = "scale_shift2d = function() {\n  /*\n   * Gradient check for the 2D scale & shift layer.\n   */\n";
        return string;
    }

    public String scale_shift2d__source() {
        String string = "scale_shift2d = function() {\n  /*\n   * Gradient check for the 2D scale & shift layer.\n   */\n  print(\"Grad checking the 2D scale & shift layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  C = 2  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  X = rand(rows=N, cols=C*Hin*Win)\n  y = rand(rows=N, cols=C*Hin*Win)\n  [gamma, beta] = scale_shift2d::init(C)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = scale_shift2d::forward(X, gamma, beta, C, Hin, Win)\n  dout = l2_loss::backward(out, y)\n  [dX, dgamma, dbeta] = scale_shift2d::backward(dout, out, X, gamma, beta, C, Hin, Win)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = scale_shift2d::forward(X, gamma, beta, C, Hin, Win)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = scale_shift2d::forward(X, gamma, beta, C, Hin, Win)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking gamma.\")\n  for (i in 1:nrow(gamma)) {\n    for (j in 1:ncol(gamma)) {\n      # Compute numerical derivative\n      old = as.scalar(gamma[i,j])\n      gamma[i,j] = old - h\n      outmh = scale_shift2d::forward(X, gamma, beta, C, Hin, Win)\n      lossmh = l2_loss::forward(outmh, y)\n      gamma[i,j] = old + h\n      outph = scale_shift2d::forward(X, gamma, beta, C, Hin, Win)\n      lossph = l2_loss::forward(outph, y)\n      gamma[i,j] = old  # reset\n      dgamma_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dgamma[i,j]), dgamma_num,\n                                                  lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking beta.\")\n  for (i in 1:nrow(beta)) {\n    for (j in 1:ncol(beta)) {\n      # Compute numerical derivative\n      old = as.scalar(beta[i,j])\n      beta[i,j] = old - h\n      outmh = scale_shift2d::forward(X, gamma, beta, C, Hin, Win)\n      lossmh = l2_loss::forward(outmh, y)\n      beta[i,j] = old + h\n      outph = scale_shift2d::forward(X, gamma, beta, C, Hin, Win)\n      lossph = l2_loss::forward(outph, y)\n      beta[i,j] = old  # reset\n      dbeta_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dbeta[i,j]), dbeta_num,\n                                                  lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void cross_entropy_loss2d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::cross_entropy_loss2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String cross_entropy_loss2d__docs() {
        String string = "cross_entropy_loss2d = function() {\n  /*\n   * Gradient check for the 2D cross-entropy loss function.\n   */\n";
        return string;
    }

    public String cross_entropy_loss2d__source() {
        String string = "cross_entropy_loss2d = function() {\n  /*\n   * Gradient check for the 2D cross-entropy loss function.\n   */\n  print(\"Grad checking the 2D cross-entropy loss function.\")\n\n  # Generate data\n  N = 3  # num examples\n  C = 10  # num targets\n  Hin = 5  # example height\n  Win = 5  # example width\n  pred = rand(rows=N, cols=C*Hin*Win, min=0, max=1, pdf=\"uniform\")\n  pred = softmax2d::forward(pred, C)  # normalized probs\n\n  y = rand(rows=N, cols=C*Hin*Win, min=0, max=1, pdf=\"uniform\")\n  y = softmax2d::forward(y, C)  # normalized probs\n\n  # Compute analytical gradient\n  dpred = cross_entropy_loss2d::backward(pred, y, C)\n\n  # Grad check\n  h = 1e-6\n  for (i in 1:nrow(pred)) {\n    for (j in 1:ncol(pred)) {\n      # Compute numerical derivative\n      old = as.scalar(pred[i,j])\n      pred[i,j] = old - h\n      lossmh = cross_entropy_loss2d::forward(pred, y, C)\n      pred[i,j] = old + h\n      lossph = cross_entropy_loss2d::forward(pred, y, C)\n      pred[i,j] = old  # reset W[i,j]\n      dpred_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dpred[i,j]), dpred_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void l2_reg() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::l2_reg();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String l2_reg__docs() {
        String string = "l2_reg = function() {\n  /*\n   * Gradient check for the L2 regularization function.\n   */\n";
        return string;
    }

    public String l2_reg__source() {
        String string = "l2_reg = function() {\n  /*\n   * Gradient check for the L2 regularization function.\n   */\n  print(\"Grad checking the L2 regularization function.\")\n\n  # Generate data\n  D = 5 # num features\n  M = 3 # num neurons\n  lambda = 0.01\n  W = rand(rows=D, cols=M)\n\n  # Compute analytical gradient\n  dW = l2_reg::backward(W, lambda)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      reg_lossmh = l2_reg::forward(W, lambda)\n      W[i,j] = old + h\n      reg_lossph = l2_reg::forward(W, lambda)\n      W[i,j] = old  # reset W[i,j]\n      dW_num = (reg_lossph-reg_lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num,\n                                                  reg_lossph, reg_lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void low_rank_affine() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::low_rank_affine();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String low_rank_affine__docs() {
        String string = "low_rank_affine = function() {\n  /*\n   * Gradient check for the low rank affine layer.\n   */\n";
        return string;
    }

    public String low_rank_affine__source() {
        String string = "low_rank_affine = function() {\n  /*\n   * Gradient check for the low rank affine layer.\n   */\n  print(\"Grad checking the low rank affine layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  D = 100 # num features\n  M = 10 # num neurons\n  R = 2 # rank\n  X = rand(rows=N, cols=D)\n  y = rand(rows=N, cols=M)\n  [U, V, b] = low_rank_affine::init(D, M, R)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = low_rank_affine::forward(X, U, V, b)\n  dout = l2_loss::backward(out, y)\n  [dX, dU, dV, db] = low_rank_affine::backward(dout, X, U, V, b)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = low_rank_affine::forward(X, U, V, b)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = low_rank_affine::forward(X, U, V, b)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking U.\")\n  for (i in 1:nrow(U)) {\n    for (j in 1:ncol(U)) {\n      # Compute numerical derivative\n      old = as.scalar(U[i,j])\n      U[i,j] = old - h\n      outmh = low_rank_affine::forward(X, U, V, b)\n      lossmh = l2_loss::forward(outmh, y)\n      U[i,j] = old + h\n      outph = low_rank_affine::forward(X, U, V, b)\n      lossph = l2_loss::forward(outph, y)\n      U[i,j] = old  # reset\n      dU_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dU[i,j]), dU_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking V.\")\n  for (i in 1:nrow(V)) {\n    for (j in 1:ncol(V)) {\n      # Compute numerical derivative\n      old = as.scalar(V[i,j])\n      V[i,j] = old - h\n      outmh = low_rank_affine::forward(X, U, V, b)\n      lossmh = l2_loss::forward(outmh, y)\n      V[i,j] = old + h\n      outph = low_rank_affine::forward(X, U, V, b)\n      lossph = l2_loss::forward(outph, y)\n      V[i,j] = old  # reset\n      dV_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dV[i,j]), dV_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b.\")\n  for (i in 1:nrow(b)) {\n    for (j in 1:ncol(b)) {\n      # Compute numerical derivative\n      old = as.scalar(b[i,j])\n      b[i,j] = old - h\n      outmh = low_rank_affine::forward(X, U, V, b)\n      lossmh = l2_loss::forward(outmh, y)\n      b[i,j] = old + h\n      outph = low_rank_affine::forward(X, U, V, b)\n      lossph = l2_loss::forward(outph, y)\n      b[i,j] = old  # reset\n      db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void max_pool2d_builtin() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::max_pool2d_builtin();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String max_pool2d_builtin__docs() {
        String string = "max_pool2d_builtin = function() {\n  /*\n   * Gradient check for the 2D max pooling layer.\n   */\n";
        return string;
    }

    public String max_pool2d_builtin__source() {
        String string = "max_pool2d_builtin = function() {\n  /*\n   * Gradient check for the 2D max pooling layer.\n   */\n  print(\"Grad checking the built-in 2D max pooling layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 2  # num channels\n  Hin = 4  # input height\n  Win = 4  # input width\n  Hf = 2  # pool filter height\n  Wf = 2  # pool filter width\n  stride = 2\n  X = rand(rows=N, cols=C*Hin*Win)\n\n  for (pad in 0:1) {\n    print(\" - Grad checking w/ pad=\"+pad+\".\")\n    Hout = as.integer(floor((Hin + 2 * pad - Hf) / stride + 1))\n    Wout = as.integer(floor((Win + 2 * pad - Wf) / stride + 1))\n    y = rand(rows=N, cols=C*Hout*Wout)\n\n    # Compute analytical gradients of loss wrt parameters\n    [out, Hout, Wout] = max_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf, stride, stride,\n                                                    pad, pad)\n    dout = l2_loss::backward(out, y)\n    dX = max_pool2d_builtin::backward(dout, Hout, Wout, X, C, Hin, Win, Hf, Wf, stride, stride,\n                                      pad, pad)\n\n    # Grad check\n    h = 1e-5\n    for (i in 1:nrow(X)) {\n      for (j in 1:ncol(X)) {\n        # Compute numerical derivative\n        old = as.scalar(X[i,j])\n        X[i,j] = old - h\n        [outmh, Hout, Wout] = max_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf, stride, stride,\n                                                          pad, pad)\n        lossmh = l2_loss::forward(outmh, y)\n        X[i,j] = old + h\n        [outph, Hout, Wout] = max_pool2d_builtin::forward(X, C, Hin, Win, Hf, Wf, stride, stride,\n                                                          pad, pad)\n        lossph = l2_loss::forward(outph, y)\n        X[i,j] = old  # reset\n        dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n      }\n    }\n  }\n}\n";
        return string;
    }

    public void conv2d_simple() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::conv2d_simple();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d_simple__docs() {
        String string = "conv2d_simple = function() {\n  /*\n   * Gradient check for the simple reference 2D convolutional layer.\n   */\n";
        return string;
    }

    public String conv2d_simple__source() {
        String string = "conv2d_simple = function() {\n  /*\n   * Gradient check for the simple reference 2D convolutional layer.\n   */\n  print(\"Grad checking the simple reference 2D convolutional layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  F = 4  # num filters\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 1\n  pad = 1\n  X = rand(rows=N, cols=C*Hin*Win)\n  y = rand(rows=N, cols=F*Hin*Win)\n\n  # Create layers\n  [W, b] = conv2d_simple::init(F, C, Hf, Wf)\n\n  # Compute analytical gradients of loss wrt parameters\n  [out, Hout, Wout] = conv2d_simple::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride, pad, pad)\n  dout = l2_loss::backward(out, y)\n  [dX, dW, db] = conv2d_simple::backward(dout, Hout, Wout, X, W, b, C, Hin, Win, Hf, Wf,\n                                         stride, stride, pad, pad)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_simple::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                   pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_simple::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                   pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W.\")\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_simple::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                   pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      W[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_simple::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                   pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      W[i,j] = old  # reset\n      dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b.\")\n  for (i in 1:nrow(b)) {\n    for (j in 1:ncol(b)) {\n      # Compute numerical derivative\n      old = as.scalar(b[i,j])\n      b[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_simple::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                   pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      b[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_simple::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                   pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      b[i,j] = old  # reset\n      db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void conv2d_transpose() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::conv2d_transpose();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d_transpose__docs() {
        String string = "conv2d_transpose = function() {\n  /*\n   * Gradient check for the 2D transpose convolutional layer.\n   */\n";
        return string;
    }

    public String conv2d_transpose__source() {
        String string = "conv2d_transpose = function() {\n  /*\n   * Gradient check for the 2D transpose convolutional layer.\n   */\n  print(\"Grad checking the 2D transpose convolutional layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 2  # num channels\n  Hin = 3  # input height\n  Win = 3  # input width\n  F = 2  # num filters\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 2\n  pad = 1\n  out_pad = 1\n  X = rand(rows=N, cols=C*Hin*Win)\n\n  # Create layers\n  [W, b] = conv2d_transpose::init(F, C, Hf, Wf)\n\n  # Compute analytical gradients of loss wrt parameters\n  [out, Hout, Wout] = conv2d_transpose::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                pad, pad, out_pad, out_pad)\n  y = rand(rows=N, cols=F*Hout*Wout)\n  dout = l2_loss::backward(out,y)\n  [dX, dW, db] = conv2d_transpose::backward(dout, Hout, Wout, X, W, b, C, Hin, Win, Hf, Wf,\n                                            stride, stride, pad, pad)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_transpose::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                      pad, pad, out_pad, out_pad)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_transpose::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                      pad, pad, out_pad, out_pad)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W.\")\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_transpose::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                      pad, pad, out_pad, out_pad)\n      lossmh = l2_loss::forward(outmh, y)\n      W[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_transpose::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                      pad, pad, out_pad, out_pad)\n      lossph = l2_loss::forward(outph, y)\n      W[i,j] = old  # reset\n      dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b.\")\n  for (i in 1:nrow(b)) {\n    for (j in 1:ncol(b)) {\n      # Compute numerical derivative\n      old = as.scalar(b[i,j])\n      b[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_transpose::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                      pad, pad, out_pad, out_pad)\n      lossmh = l2_loss::forward(outmh, y)\n      b[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_transpose::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                      pad, pad, out_pad, out_pad)\n      lossph = l2_loss::forward(outph, y)\n      b[i,j] = old  # reset\n      db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void batch_norm1d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::batch_norm1d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String batch_norm1d__docs() {
        String string = "batch_norm1d = function() {\n  /*\n   * Gradient check for the 1D batch normalization layer.\n   */\n";
        return string;
    }

    public String batch_norm1d__source() {
        String string = "batch_norm1d = function() {\n  /*\n   * Gradient check for the 1D batch normalization layer.\n   */\n  print(\"Grad checking the 1D batch normalization layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  D = 100 # num features\n  mu = 0.9  # momentum\n  eps = 1e-5  # epsilon\n  X = rand(rows=N, cols=D)\n  y = rand(rows=N, cols=D)\n  gamma = rand(rows=1, cols=D)\n  beta = rand(rows=1, cols=D)\n  ema_mean = rand(rows=1, cols=D)\n  ema_var = rand(rows=1, cols=D)\n  #[dummy, dummy, ema_mean, ema_var] = batch_norm1d::init(D)\n\n  # Check training & testing modes\n  for (i in 1:2) {\n    if (i == 1)\n      mode = 'train'\n    else\n      mode = 'test'\n    print(\" - Grad checking the '\"+mode+\"' mode.\")\n\n    # Compute analytical gradients of loss wrt parameters\n    [out, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] =\n        batch_norm1d::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n    dout = l2_loss::backward(out, y)\n    [dX, dgamma, dbeta] = batch_norm1d::backward(dout, out, ema_mean_upd, ema_var_upd,\n                                                 cache_mean, cache_var, cache_norm,\n                                                 X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n\n    # Grad check\n    h = 1e-5\n    print(\"   - Grad checking X.\")\n    for (i in 1:nrow(X)) {\n      for (j in 1:ncol(X)) {\n        # Compute numerical derivative\n        old = as.scalar(X[i,j])\n        X[i,j] = old - h\n        [outmh, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] =\n            batch_norm1d::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n        lossmh = l2_loss::forward(outmh, y)\n        X[i,j] = old + h\n        [outph, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] =\n            batch_norm1d::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n        lossph = l2_loss::forward(outph, y)\n        X[i,j] = old  # reset\n        dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking gamma.\")\n    for (i in 1:nrow(gamma)) {\n      for (j in 1:ncol(gamma)) {\n        # Compute numerical derivative\n        old = as.scalar(gamma[i,j])\n        gamma[i,j] = old - h\n        [outmh, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] =\n            batch_norm1d::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n        lossmh = l2_loss::forward(outmh, y)\n        gamma[i,j] = old + h\n        [outph, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] =\n            batch_norm1d::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n        lossph = l2_loss::forward(outph, y)\n        gamma[i,j] = old  # reset\n        dgamma_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dgamma[i,j]), dgamma_num,\n                                                    lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking beta.\")\n    for (i in 1:nrow(beta)) {\n      for (j in 1:ncol(beta)) {\n        # Compute numerical derivative\n        old = as.scalar(beta[i,j])\n        beta[i,j] = old - h\n        [outmh, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] =\n            batch_norm1d::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n        lossmh = l2_loss::forward(outmh, y)\n        beta[i,j] = old + h\n        [outph, ema_mean_upd, ema_var_upd, cache_mean, cache_var, cache_norm] =\n            batch_norm1d::forward(X, gamma, beta, mode, ema_mean, ema_var, mu, eps)\n        lossph = l2_loss::forward(outph, y)\n        beta[i,j] = old  # reset\n        dbeta_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dbeta[i,j]), dbeta_num,\n                                                    lossph, lossmh)\n      }\n    }\n  }\n}\n";
        return string;
    }

    public void elu() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::elu();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String elu__docs() {
        String string = "elu = function() {\n  /*\n   * Gradient check for ELU nonlinearity\n   * layer.\n   */\n";
        return string;
    }

    public String elu__source() {
        String string = "elu = function() {\n  /*\n   * Gradient check for ELU nonlinearity\n   * layer.\n   */\n   print(\"Grad checking ELU nonlinearity layer with L2 loss.\")\n   # Generate data\n   N = 3 # num examples\n   M = 10 # num neurons\n\n   X = rand(rows=N, cols=M, min=-5, max=5)\n   y = rand(rows=N, cols=M)\n\n   out = elu::forward(X, 1)\n   dout = l2_loss::backward(out, y)\n   dX = elu::backward(dout, X, 1)\n\n   # Grad check\n   h = 1e-5\n   print(\" - Grad checking X.\")\n   for (i in 1:nrow(X)) {\n     for (j in 1:ncol(X)) {\n       # Compute numerical derivative\n       old = as.scalar(X[i,j])\n       X[i,j] = old - h\n       outmh = elu::forward(X, 1)\n       lossmh = l2_loss::forward(outmh, y)\n       X[i,j] = old + h\n       outph = elu::forward(X, 1)\n       lossph = l2_loss::forward(outph, y)\n       X[i,j] = old  # reset\n       dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n       # Check error\n       rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n     }\n   }\n}\n";
        return string;
    }

    public void l1_reg() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::l1_reg();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String l1_reg__docs() {
        String string = "l1_reg = function() {\n  /*\n   * Gradient check for the L1 regularization function.\n   */\n";
        return string;
    }

    public String l1_reg__source() {
        String string = "l1_reg = function() {\n  /*\n   * Gradient check for the L1 regularization function.\n   */\n  print(\"Grad checking the L1 regularization function.\")\n\n  # Generate data\n  D = 5 # num features\n  M = 3 # num neurons\n  lambda = 0.01\n  W = rand(rows=D, cols=M)\n\n  # Compute analytical gradient\n  dW = l1_reg::backward(W, lambda)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      reg_lossmh = l1_reg::forward(W, lambda)\n      W[i,j] = old + h\n      reg_lossph = l1_reg::forward(W, lambda)\n      W[i,j] = old  # reset W[i,j]\n      dW_num = (reg_lossph-reg_lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num,\n                                                  reg_lossph, reg_lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void conv2d_builtin() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::conv2d_builtin();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d_builtin__docs() {
        String string = "conv2d_builtin = function() {\n  /*\n   * Gradient check for the 2D convolutional layer using built-in\n   * functions.\n   */\n";
        return string;
    }

    public String conv2d_builtin__source() {
        String string = "conv2d_builtin = function() {\n  /*\n   * Gradient check for the 2D convolutional layer using built-in\n   * functions.\n   */\n  print(\"Grad checking the built-in 2D convolutional layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  F = 4  # num filters\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 1\n  pad = 1\n  X = rand(rows=N, cols=C*Hin*Win)\n  y = rand(rows=N, cols=F*Hin*Win)\n\n  # Create layers\n  [W, b] = conv2d_builtin::init(F, C, Hf, Wf)\n\n  # Compute analytical gradients of loss wrt parameters\n  [out, Hout, Wout] = conv2d_builtin::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                              pad, pad)\n  dout = l2_loss::backward(out, y)\n  [dX, dW, db] = conv2d_builtin::backward(dout, Hout, Wout, X, W, b, C, Hin, Win, Hf, Wf,\n                                          stride, stride, pad, pad)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_builtin::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                    pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_builtin::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                    pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W.\")\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_builtin::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                    pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      W[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_builtin::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                    pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      W[i,j] = old  # reset\n      dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b.\")\n  for (i in 1:nrow(b)) {\n    for (j in 1:ncol(b)) {\n      # Compute numerical derivative\n      old = as.scalar(b[i,j])\n      b[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_builtin::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                    pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      b[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_builtin::forward(X, W, b, C, Hin, Win, Hf, Wf, stride, stride,\n                                                    pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      b[i,j] = old  # reset\n      db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void lstm() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::lstm();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String lstm__docs() {
        String string = "lstm = function() {\n  /*\n   * Gradient check for the LSTM layer.\n   */\n";
        return string;
    }

    public String lstm__source() {
        String string = "lstm = function() {\n  /*\n   * Gradient check for the LSTM layer.\n   */\n  print(\"Grad checking the LSTM layer with L2 loss.\")\n\n  # Generate data\n  N = 3  # num examples\n  D = 5  # num features\n  T = 15 # num timesteps (sequence length)\n  M = 10 # num neurons\n  X = rand(rows=N, cols=T*D)\n  yc = rand(rows=N, cols=M)\n  out0 = rand(rows=N, cols=M)\n  c0 = rand(rows=N, cols=M)\n  [W, b, dummy, dummy2] = lstm::init(N, D, M)\n\n  # test with (1) outputs from all timesteps, and (2) output from the final timestep\n  for (i in 1:2) {\n    if (i == 1) {\n      return_seq = TRUE\n      y = rand(rows=N, cols=T*M)\n    }\n    else {\n      return_seq = FALSE\n      y = rand(rows=N, cols=M)\n    }\n\n    print(\" - Grad checking with return_seq = \" + return_seq)\n\n    # Compute analytical gradients of loss wrt parameters\n    [out, c, cache_out, cache_c, cache_ifog] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n    dout = l2_loss::backward(out, y)\n    dc = l2_loss::backward(c, yc)\n    [dX, dW, db, dout0, dc0] = lstm::backward(dout, dc, X, W, b, T, D, return_seq, out0, c0,\n                                              cache_out, cache_c, cache_ifog)\n\n    # Grad check\n    h = 1e-5\n    print(\"   - Grad checking X.\")\n    for (i in 1:nrow(X)) {\n      for (j in 1:ncol(X)) {\n        # Compute numerical derivative\n        old = as.scalar(X[i,j])\n        X[i,j] = old - h\n        [outmh, cmh, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outmh = l2_loss::forward(outmh, y)\n        loss_cmh = l2_loss::forward(cmh, yc)\n        lossmh = loss_outmh + loss_cmh\n        X[i,j] = old + h\n        [outph, cph, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outph = l2_loss::forward(outph, y)\n        loss_cph = l2_loss::forward(cph, yc)\n        lossph = loss_outph + loss_cph\n        X[i,j] = old  # reset\n        dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking W.\")\n    for (i in 1:nrow(W)) {\n      for (j in 1:ncol(W)) {\n        # Compute numerical derivative\n        old = as.scalar(W[i,j])\n        W[i,j] = old - h\n        [outmh, cmh, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outmh = l2_loss::forward(outmh, y)\n        loss_cmh = l2_loss::forward(cmh, yc)\n        lossmh = loss_outmh + loss_cmh\n        W[i,j] = old + h\n        [outph, cph, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outph = l2_loss::forward(outph, y)\n        loss_cph = l2_loss::forward(cph, yc)\n        lossph = loss_outph + loss_cph\n        W[i,j] = old  # reset\n        dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking b.\")\n    for (i in 1:nrow(b)) {\n      for (j in 1:ncol(b)) {\n        # Compute numerical derivative\n        old = as.scalar(b[i,j])\n        b[i,j] = old - h\n        [outmh, cmh, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outmh = l2_loss::forward(outmh, y)\n        loss_cmh = l2_loss::forward(cmh, yc)\n        lossmh = loss_outmh + loss_cmh\n        b[i,j] = old + h\n        [outph, cph, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outph = l2_loss::forward(outph, y)\n        loss_cph = l2_loss::forward(cph, yc)\n        lossph = loss_outph + loss_cph\n        b[i,j] = old  # reset\n        db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking out0.\")\n    for (i in 1:nrow(out0)) {\n      for (j in 1:ncol(out0)) {\n        # Compute numerical derivative\n        old = as.scalar(out0[i,j])\n        out0[i,j] = old - h\n        [outmh, cmh, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outmh = l2_loss::forward(outmh, y)\n        loss_cmh = l2_loss::forward(cmh, yc)\n        lossmh = loss_outmh + loss_cmh\n        out0[i,j] = old + h\n        [outph, cph, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outph = l2_loss::forward(outph, y)\n        loss_cph = l2_loss::forward(cph, yc)\n        lossph = loss_outph + loss_cph\n        out0[i,j] = old  # reset\n        dout0_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dout0[i,j]), dout0_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking c0.\")\n    for (i in 1:nrow(c0)) {\n      for (j in 1:ncol(c0)) {\n        # Compute numerical derivative\n        old = as.scalar(c0[i,j])\n        c0[i,j] = old - h\n        [outmh, cmh, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outmh = l2_loss::forward(outmh, y)\n        loss_cmh = l2_loss::forward(cmh, yc)\n        lossmh = loss_outmh + loss_cmh\n        c0[i,j] = old + h\n        [outph, cph, cache, cache, cache] = lstm::forward(X, W, b, T, D, return_seq, out0, c0)\n        loss_outph = l2_loss::forward(outph, y)\n        loss_cph = l2_loss::forward(cph, yc)\n        lossph = loss_outph + loss_cph\n        c0[i,j] = old  # reset\n        dc0_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dc0[i,j]), dc0_num, lossph, lossmh)\n      }\n    }\n  }\n}\n";
        return string;
    }

    public void rnn() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::rnn();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String rnn__docs() {
        String string = "rnn = function() {\n  /*\n   * Gradient check for the simple RNN layer.\n   */\n";
        return string;
    }

    public String rnn__source() {
        String string = "rnn = function() {\n  /*\n   * Gradient check for the simple RNN layer.\n   */\n  print(\"Grad checking the simple RNN layer with L2 loss.\")\n\n  # Generate data\n  N = 3  # num examples\n  D = 5  # num features\n  T = 15 # num timesteps (sequence length)\n  M = 10 # num neurons\n  X = rand(rows=N, cols=T*D)\n  out0 = rand(rows=N, cols=M)\n  [W, b, dummy] = rnn::init(N, D, M)\n\n  # test with (1) outputs from all timesteps, and (2) output from the final timestep\n  for (i in 1:2) {\n    if (i == 1) {\n      return_seq = TRUE\n      y = rand(rows=N, cols=T*M)\n    }\n    else {\n      return_seq = FALSE\n      y = rand(rows=N, cols=M)\n    }\n\n    print(\" - Grad checking with return_seq = \" + return_seq)\n\n    # Compute analytical gradients of loss wrt parameters\n    [out, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n    dout = l2_loss::backward(out, y)\n    [dX, dW, db, dout0] = rnn::backward(dout, X, W, b, T, D, return_seq, out0, cache_out)\n\n    # Grad check\n    h = 1e-5\n    print(\"   - Grad checking X.\")\n    for (i in 1:nrow(X)) {\n      for (j in 1:ncol(X)) {\n        # Compute numerical derivative\n        old = as.scalar(X[i,j])\n        X[i,j] = old - h\n        [outmh, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n        lossmh = l2_loss::forward(outmh, y)\n        X[i,j] = old + h\n        [outph, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n        lossph = l2_loss::forward(outph, y)\n        X[i,j] = old  # reset\n        dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking W.\")\n    for (i in 1:nrow(W)) {\n      for (j in 1:ncol(W)) {\n        # Compute numerical derivative\n        old = as.scalar(W[i,j])\n        W[i,j] = old - h\n        [outmh, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n        lossmh = l2_loss::forward(outmh, y)\n        W[i,j] = old + h\n        [outph, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n        lossph = l2_loss::forward(outph, y)\n        W[i,j] = old  # reset\n        dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking b.\")\n    for (i in 1:nrow(b)) {\n      for (j in 1:ncol(b)) {\n        # Compute numerical derivative\n        old = as.scalar(b[i,j])\n        b[i,j] = old - h\n        [outmh, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n        lossmh = l2_loss::forward(outmh, y)\n        b[i,j] = old + h\n        [outph, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n        lossph = l2_loss::forward(outph, y)\n        b[i,j] = old  # reset\n        db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n      }\n    }\n\n    print(\"   - Grad checking out0.\")\n    for (i in 1:nrow(out0)) {\n      for (j in 1:ncol(out0)) {\n        # Compute numerical derivative\n        old = as.scalar(out0[i,j])\n        out0[i,j] = old - h\n        [outmh, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n        lossmh = l2_loss::forward(outmh, y)\n        out0[i,j] = old + h\n        [outph, cache_out] = rnn::forward(X, W, b, T, D, return_seq, out0)\n        lossph = l2_loss::forward(outph, y)\n        out0[i,j] = old  # reset\n        dout0_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n        # Check error\n        rel_error = test_util::check_rel_grad_error(as.scalar(dout0[i,j]), dout0_num, lossph, lossmh)\n      }\n    }\n  }\n}\n";
        return string;
    }

    public void l1_loss() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::l1_loss();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String l1_loss__docs() {
        String string = "l1_loss = function() {\n  /*\n   * Gradient check for the L1 loss function.\n   */\n";
        return string;
    }

    public String l1_loss__source() {
        String string = "l1_loss = function() {\n  /*\n   * Gradient check for the L1 loss function.\n   */\n  print(\"Grad checking the L1 loss function.\")\n\n  # Generate data\n  N = 3 # num examples\n  D = 2 # num targets\n  pred = rand(rows=N, cols=D)\n  y = rand(rows=N, cols=D)\n\n  # Compute analytical gradient\n  dpred = l1_loss::backward(pred, y)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(pred)) {\n    for (j in 1:ncol(pred)) {\n      # Compute numerical derivative\n      old = as.scalar(pred[i,j])\n      pred[i,j] = old - h\n      lossmh = l1_loss::forward(pred, y)\n      pred[i,j] = old + h\n      lossph = l1_loss::forward(pred, y)\n      pred[i,j] = old  # reset W[i,j]\n      dpred_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dpred[i,j]), dpred_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void upsample2d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::upsample2d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String upsample2d__docs() {
        String string = "upsample2d = function() {\n  print(\"Grad checking the upsample2d layer with L2 loss.\")\n\n  C=2; Hin=3; Win=3; size_h=2; size_w=2\n  # Generate data\n  N = 3 # num examples\n  M = C*Hin*Win # num neurons\n  X = rand(rows=N, cols=M, min=-5, max=5)\n  y = rand(rows=N, cols=M*size_h*size_w)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = upsample2d::forward(X, C, Hin, Win, size_h, size_w)\n  dout = l2_loss::backward(out, y)\n  dX = upsample2d::backward(dout, C, Hin, Win, size_h, size_w)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = upsample2d::forward(X, C, Hin, Win, size_h, size_w)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = upsample2d::forward(X, C, Hin, Win, size_h, size_w)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public String upsample2d__source() {
        String string = "upsample2d = function() {\n  print(\"Grad checking the upsample2d layer with L2 loss.\")\n\n  C=2; Hin=3; Win=3; size_h=2; size_w=2\n  # Generate data\n  N = 3 # num examples\n  M = C*Hin*Win # num neurons\n  X = rand(rows=N, cols=M, min=-5, max=5)\n  y = rand(rows=N, cols=M*size_h*size_w)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = upsample2d::forward(X, C, Hin, Win, size_h, size_w)\n  dout = l2_loss::backward(out, y)\n  dX = upsample2d::backward(dout, C, Hin, Win, size_h, size_w)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = upsample2d::forward(X, C, Hin, Win, size_h, size_w)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = upsample2d::forward(X, C, Hin, Win, size_h, size_w)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void sigmoid() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::sigmoid();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String sigmoid__docs() {
        String string = "sigmoid = function() {\n  /*\n   * Gradient check for the sigmoid nonlinearity layer.\n   */\n";
        return string;
    }

    public String sigmoid__source() {
        String string = "sigmoid = function() {\n  /*\n   * Gradient check for the sigmoid nonlinearity layer.\n   */\n  print(\"Grad checking the sigmoid nonlinearity layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  M = 10 # num neurons\n  X = rand(rows=N, cols=M)\n  y = rand(rows=N, cols=M)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = sigmoid::forward(X)\n  dout = l2_loss::backward(out, y)\n  dX = sigmoid::backward(dout, X)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = sigmoid::forward(X)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = sigmoid::forward(X)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void dropout() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::dropout();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String dropout__docs() {
        String string = "dropout = function() {\n  /*\n   * Gradient check for the (inverted) dropout layer.\n   */\n";
        return string;
    }

    public String dropout__source() {
        String string = "dropout = function() {\n  /*\n   * Gradient check for the (inverted) dropout layer.\n   */\n  print(\"Grad checking the (inverted) dropout layer with L2 loss.\")\n\n  # Generate data\n  N = 3  # num examples\n  M = 100  # num neurons\n  p = 0.5  # probability of dropping neuron output\n  seed = as.integer(floor(as.scalar(rand(rows=1, cols=1, min=1, max=100000))))  # random seed\n  X = rand(rows=N, cols=M)\n  y = rand(rows=N, cols=M)\n\n  # Compute analytical gradients of loss wrt parameters\n  [out, mask] = dropout::forward(X, p, seed)\n  dout = l2_loss::backward(out, y)\n  dX = dropout::backward(dout, X, p, mask)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      [outmh, mask] = dropout::forward(X, p, seed)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      [outph, mask] = dropout::forward(X, p, seed)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public Two_layer_affine_l2_net_forward_output two_layer_affine_l2_net_forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;[loss, pred, aout, hout] = mlcontextns::two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2);";
        Script script = new Script(string);
        script.in("X", object).in("y", object2).in("W1", object3).in("b1", object4).in("W2", object5).in("b2", object6).out("loss").out("pred").out("aout").out("hout");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("loss");
        Matrix matrix = mLResults.getMatrix("pred");
        Matrix matrix2 = mLResults.getMatrix("aout");
        Matrix matrix3 = mLResults.getMatrix("hout");
        Two_layer_affine_l2_net_forward_output two_layer_affine_l2_net_forward_output = new Two_layer_affine_l2_net_forward_output(d, matrix, matrix2, matrix3);
        return two_layer_affine_l2_net_forward_output;
    }

    public String two_layer_affine_l2_net_forward__docs() {
        String string = "two_layer_affine_l2_net_forward = function(matrix[double] X, matrix[double] y,\n                                           matrix[double] W1, matrix[double] b1,\n                                           matrix[double] W2, matrix[double] b2)\n    return (double loss, matrix[double] pred, matrix[double] aout, matrix[double] hout) {\n  # Compute forward pass\n  hout = affine::forward(X, W1, b1)\n  aout = relu::forward(hout)\n  pred = affine::forward(aout, W2, b2)\n\n  # Compute loss\n  loss = l2_loss::forward(pred, y)\n}\n";
        return string;
    }

    public String two_layer_affine_l2_net_forward__source() {
        String string = "two_layer_affine_l2_net_forward = function(matrix[double] X, matrix[double] y,\n                                           matrix[double] W1, matrix[double] b1,\n                                           matrix[double] W2, matrix[double] b2)\n    return (double loss, matrix[double] pred, matrix[double] aout, matrix[double] hout) {\n  # Compute forward pass\n  hout = affine::forward(X, W1, b1)\n  aout = relu::forward(hout)\n  pred = affine::forward(aout, W2, b2)\n\n  # Compute loss\n  loss = l2_loss::forward(pred, y)\n}\n";
        return string;
    }

    public void conv2d_depthwise() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::conv2d_depthwise();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String conv2d_depthwise__docs() {
        String string = "conv2d_depthwise = function() {\n  /*\n   * Gradient check for the 2D depthwise convolutional layer.\n   */\n";
        return string;
    }

    public String conv2d_depthwise__source() {
        String string = "conv2d_depthwise = function() {\n  /*\n   * Gradient check for the 2D depthwise convolutional layer.\n   */\n  print(\"Grad checking the 2D depthwise convolutional layer with L2 loss.\")\n\n  # Generate data\n  N = 2  # num examples\n  C = 3  # num channels\n  Hin = 5  # input height\n  Win = 5  # input width\n  M = 4  # depth multiplier\n  Hf = 3  # filter height\n  Wf = 3  # filter width\n  stride = 1\n  pad = 1\n  X = rand(rows=N, cols=C*Hin*Win)\n  y = rand(rows=N, cols=C*M*Hin*Win)\n\n  # Create layers\n  [W, b] = conv2d_depthwise::init(C, M, Hf, Wf)\n\n  # Compute analytical gradients of loss wrt parameters\n  [out, Hout, Wout] = conv2d_depthwise::forward(X, W, b, Hin, Win, M, Hf, Wf, stride, stride,\n                                                pad, pad)\n  dout = l2_loss::backward(out, y)\n  [dX, dW, db] = conv2d_depthwise::backward(dout, Hout, Wout, X, W, b, Hin, Win, M, Hf, Wf,\n                                            stride, stride, pad, pad)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_depthwise::forward(X, W, b, Hin, Win, M, Hf, Wf, stride, stride,\n                                                      pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_depthwise::forward(X, W, b, Hin, Win, M, Hf, Wf, stride, stride,\n                                                      pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W.\")\n  for (i in 1:nrow(W)) {\n    for (j in 1:ncol(W)) {\n      # Compute numerical derivative\n      old = as.scalar(W[i,j])\n      W[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_depthwise::forward(X, W, b, Hin, Win, M, Hf, Wf, stride, stride,\n                                                      pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      W[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_depthwise::forward(X, W, b, Hin, Win, M, Hf, Wf, stride, stride,\n                                                      pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      W[i,j] = old  # reset\n      dW_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW[i,j]), dW_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b.\")\n  for (i in 1:nrow(b)) {\n    for (j in 1:ncol(b)) {\n      # Compute numerical derivative\n      old = as.scalar(b[i,j])\n      b[i,j] = old - h\n      [outmh, Hout, Wout] = conv2d_depthwise::forward(X, W, b, Hin, Win, M, Hf, Wf, stride, stride,\n                                                      pad, pad)\n      lossmh = l2_loss::forward(outmh, y)\n      b[i,j] = old + h\n      [outph, Hout, Wout] = conv2d_depthwise::forward(X, W, b, Hin, Win, M, Hf, Wf, stride, stride,\n                                                      pad, pad)\n      lossph = l2_loss::forward(outph, y)\n      b[i,j] = old  # reset\n      db_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db[i,j]), db_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void two_layer_affine_l2_net() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::two_layer_affine_l2_net();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String two_layer_affine_l2_net__docs() {
        String string = "two_layer_affine_l2_net = function() {\n  /*\n   * Gradient check for a two-layer, fully-connected, feed-forward\n   * network with ReLU nonlinearity and L2 loss.\n   *\n   * NOTE: This could result in a false-negative in which the test\n   * fails due to a kink being crossed in the ReLU nonlinearity.  This\n   * occurs when the tests, f(x-h) and f(x+h), end up on opposite\n   * sides of the zero threshold of max(0, fx).  For now, just run\n   * the tests again.  In the future, we can explicitly check for\n   * this and rerun the test automatically.\n   */\n";
        return string;
    }

    public String two_layer_affine_l2_net__source() {
        String string = "two_layer_affine_l2_net = function() {\n  /*\n   * Gradient check for a two-layer, fully-connected, feed-forward\n   * network with ReLU nonlinearity and L2 loss.\n   *\n   * NOTE: This could result in a false-negative in which the test\n   * fails due to a kink being crossed in the ReLU nonlinearity.  This\n   * occurs when the tests, f(x-h) and f(x+h), end up on opposite\n   * sides of the zero threshold of max(0, fx).  For now, just run\n   * the tests again.  In the future, we can explicitly check for\n   * this and rerun the test automatically.\n   */\n  print(\"Grad checking a two-layer, fully-connected, feed-forward network with a ReLU \" +\n        \"nonlinearity, and an L2 loss function.\")\n\n  # Generate input data\n  N = 1000 # num examples\n  D = 100 # num features\n  yD = 5 # num targets\n  X = rand(rows=N, cols=D, pdf=\"normal\")\n  y = rand(rows=N, cols=yD)\n\n  # Create 2-layer, fully-connected network\n  M = 10 # number of hidden neurons\n  [W1, b1] = affine::init(D, M)\n  [W2, b2] = affine::init(M, yD)\n  W2 = W2 / sqrt(2)  # different initialization, since being fed into l2 loss, instead of relu\n\n  # Optimize for short \"burn-in\" time to move to characteristic\n  # mode of operation and unmask any real issues.\n  print(\" - Burn-in:\")\n  lr = 0.01\n  decay = 0.99\n  for(i in 1:5) {\n    # Compute forward and backward passes of net\n    [pred, loss, dX, dW1, db1, dW2, db2] = two_layer_affine_l2_net_run(X, y, W1, b1, W2, b2)\n    print(\"   - L2 loss: \" + loss)\n\n    # Optimize with basic SGD\n    W1 = W1 - lr * dW1\n    b1 = b1 - lr * db1\n    W2 = W2 - lr * dW2\n    b2 = b2 - lr * db2\n    lr = lr * decay\n  }\n\n  # Compute analytical gradients\n  [pred, loss, dX, dW1, db1, dW2, db2] = two_layer_affine_l2_net_run(X, y, W1, b1, W2, b2)\n\n  # Grad check\n  h = 1e-6\n  print(\" - Grad checking X.\")\n  for (i in 1:2) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old_x = as.scalar(X[i,j])\n      X[i,j] = old_x - h\n      [lossmh, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      X[i,j] = old_x + h\n      [lossph, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      X[i,j] = old_x  # reset X[i,j]\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W1.\")\n  for (i in 1:nrow(W1)) {\n    for (j in 1:ncol(W1)) {\n      # Compute numerical derivative\n      old_w = as.scalar(W1[i,j])\n      W1[i,j] = old_w - h\n      [lossmh, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      W1[i,j] = old_w + h\n      [lossph, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      W1[i,j] = old_w  # reset W[i,j]\n      dWij_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW1[i,j]), dWij_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking W2.\")\n  for (i in 1:nrow(W2)) {\n    for (j in 1:ncol(W2)) {\n      # Compute numerical derivative\n      old_w = as.scalar(W2[i,j])\n      W2[i,j] = old_w - h\n      [lossmh, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      W2[i,j] = old_w + h\n      [lossph, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      W2[i,j] = old_w  # reset W[i,j]\n      dWij_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dW2[i,j]), dWij_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b1.\")\n  for (i in 1:nrow(b1)) {\n    for (j in 1:ncol(b1)) {\n      # Compute numerical derivative\n      old_b = as.scalar(b1[i,j])\n      b1[i,j] = old_b - h\n      [lossmh, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      b1[i,j] = old_b + h\n      [lossph, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      b1[i,j] = old_b  # reset b[1,j]\n      dbij_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db1[i,j]), dbij_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking b2.\")\n  for (i in 1:nrow(b2)) {\n    for (j in 1:ncol(b2)) {\n      # Compute numerical derivative\n      old_b = as.scalar(b2[i,j])\n      b2[i,j] = old_b - h\n      [lossmh, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      b2[i,j] = old_b + h\n      [lossph, pred, aout, hout] = two_layer_affine_l2_net_forward(X, y, W1, b1, W2, b2)\n      b2[i,j] = old_b  # reset b[1,j]\n      dbij_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(db2[i,j]), dbij_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void log_loss() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::log_loss();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String log_loss__docs() {
        String string = "log_loss = function() {\n  /*\n   * Gradient check for the log loss function.\n   */\n";
        return string;
    }

    public String log_loss__source() {
        String string = "log_loss = function() {\n  /*\n   * Gradient check for the log loss function.\n   */\n  print(\"Grad checking the log loss function.\")\n\n  # Generate data\n  N = 20 # num examples\n  D = 1 # num targets\n  pred = rand(rows=N, cols=D, min=0, max=1, pdf=\"uniform\")\n  y = round(rand(rows=N, cols=D, min=0, max=1, pdf=\"uniform\"))\n\n  # Compute analytical gradient\n  dpred = log_loss::backward(pred, y)\n\n  # Grad check\n  h = 1e-5\n  for (i in 1:nrow(pred)) {\n    for (j in 1:ncol(pred)) {\n      # Compute numerical derivative\n      old = as.scalar(pred[i,j])\n      pred[i,j] = old - h\n      lossmh = log_loss::forward(pred, y)\n      pred[i,j] = old + h\n      lossph = log_loss::forward(pred, y)\n      pred[i,j] = old  # reset W[i,j]\n      dpred_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dpred[i,j]), dpred_num, lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }

    public void scale_shift1d() {
        String string = "source('scripts/nn/test/grad_check.dml') as mlcontextns;mlcontextns::scale_shift1d();";
        Script script = new Script(string);
        MLResults mLResults = script.execute();
    }

    public String scale_shift1d__docs() {
        String string = "scale_shift1d = function() {\n  /*\n   * Gradient check for the 1D scale & shift layer.\n   */\n";
        return string;
    }

    public String scale_shift1d__source() {
        String string = "scale_shift1d = function() {\n  /*\n   * Gradient check for the 1D scale & shift layer.\n   */\n  print(\"Grad checking the 1D scale & shift layer with L2 loss.\")\n\n  # Generate data\n  N = 3 # num examples\n  D = 100 # num features\n  X = rand(rows=N, cols=D)\n  y = rand(rows=N, cols=D)\n  [gamma, beta] = scale_shift1d::init(D)\n\n  # Compute analytical gradients of loss wrt parameters\n  out = scale_shift1d::forward(X, gamma, beta)\n  dout = l2_loss::backward(out, y)\n  [dX, dgamma, dbeta] = scale_shift1d::backward(dout, out, X, gamma, beta)\n\n  # Grad check\n  h = 1e-5\n  print(\" - Grad checking X.\")\n  for (i in 1:nrow(X)) {\n    for (j in 1:ncol(X)) {\n      # Compute numerical derivative\n      old = as.scalar(X[i,j])\n      X[i,j] = old - h\n      outmh = scale_shift1d::forward(X, gamma, beta)\n      lossmh = l2_loss::forward(outmh, y)\n      X[i,j] = old + h\n      outph = scale_shift1d::forward(X, gamma, beta)\n      lossph = l2_loss::forward(outph, y)\n      X[i,j] = old  # reset\n      dX_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dX[i,j]), dX_num, lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking gamma.\")\n  for (i in 1:nrow(gamma)) {\n    for (j in 1:ncol(gamma)) {\n      # Compute numerical derivative\n      old = as.scalar(gamma[i,j])\n      gamma[i,j] = old - h\n      outmh = scale_shift1d::forward(X, gamma, beta)\n      lossmh = l2_loss::forward(outmh, y)\n      gamma[i,j] = old + h\n      outph = scale_shift1d::forward(X, gamma, beta)\n      lossph = l2_loss::forward(outph, y)\n      gamma[i,j] = old  # reset\n      dgamma_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dgamma[i,j]), dgamma_num,\n                                                  lossph, lossmh)\n    }\n  }\n\n  print(\" - Grad checking beta.\")\n  for (i in 1:nrow(beta)) {\n    for (j in 1:ncol(beta)) {\n      # Compute numerical derivative\n      old = as.scalar(beta[i,j])\n      beta[i,j] = old - h\n      outmh = scale_shift1d::forward(X, gamma, beta)\n      lossmh = l2_loss::forward(outmh, y)\n      beta[i,j] = old + h\n      outph = scale_shift1d::forward(X, gamma, beta)\n      lossph = l2_loss::forward(outph, y)\n      beta[i,j] = old  # reset\n      dbeta_num = (lossph-lossmh) / (2*h)  # numerical derivative\n\n      # Check error\n      rel_error = test_util::check_rel_grad_error(as.scalar(dbeta[i,j]), dbeta_num,\n                                                  lossph, lossmh)\n    }\n  }\n}\n";
        return string;
    }
}

