/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.AppendM;
import org.apache.sysml.lops.BinaryM;
import org.apache.sysml.lops.CombineBinary;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.FunctionCallCP;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.MapMult;
import org.apache.sysml.lops.OutputParameters;
import org.apache.sysml.lops.PMMJ;
import org.apache.sysml.lops.PickByCount;
import org.apache.sysml.lops.SortKeys;
import org.apache.sysml.lops.Unary;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.lops.compile.LopComparator;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.SPInstructionParser;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.sort.PickFromCompactInputFormat;

public class Dag<N extends Lop> {
    private static final Log LOG = LogFactory.getLog((String)Dag.class.getName());
    private static final int CHILD_BREAKS_ALIGNMENT = 2;
    private static final int CHILD_DOES_NOT_BREAK_ALIGNMENT = 1;
    private static final int MRCHILD_NOT_FOUND = 0;
    private static final int MR_CHILD_FOUND_BREAKS_ALIGNMENT = 4;
    private static final int MR_CHILD_FOUND_DOES_NOT_BREAK_ALIGNMENT = 5;
    private static IDSequence job_id = null;
    private static IDSequence var_index = null;
    private int total_reducers = -1;
    private String scratch = "";
    private String scratchFilePath = null;
    private ArrayList<Lop> nodes = new ArrayList();
    private HashMap<Long, Integer> IDMap = new HashMap();
    private double gmrMapperFootprint = 0.0;

    public Dag() {
        this.total_reducers = ConfigurationManager.getNumReducers();
    }

    private String getFilePath() {
        if (this.scratchFilePath == null) {
            this.scratchFilePath = this.scratch + "/" + "_p" + DMLScript.getUUID() + "/" + "/" + "_t0" + "/";
        }
        return this.scratchFilePath;
    }

    public static String getNextUniqueFilenameSuffix() {
        return "temp" + job_id.getNextID();
    }

    public String getNextUniqueFilename() {
        return this.getFilePath() + Dag.getNextUniqueFilenameSuffix();
    }

    public static String getNextUniqueVarname(Expression.DataType dt) {
        return (dt.isMatrix() ? "_mVar" : (dt.isFrame() ? "_fVar" : "_Var")) + var_index.getNextID();
    }

    public boolean addNode(Lop node) {
        if (this.nodes.contains(node)) {
            return false;
        }
        this.nodes.add(node);
        return true;
    }

    public ArrayList<Instruction> getJobs(StatementBlock sb, DMLConfig config) {
        if (config != null) {
            this.total_reducers = config.getIntValue("sysml.numreducers");
            this.scratch = config.getTextValue("sysml.scratch") + "/";
        }
        List<Lop> node_v = OptimizerUtils.isHadoopExecutionMode() ? this.doTopologicalSortStrictOrder(this.nodes) : this.doTopologicalSortTwoLevelOrder(this.nodes);
        ArrayList<Instruction> inst = OptimizerUtils.isHadoopExecutionMode() ? this.doGreedyGrouping(sb, node_v) : this.doPlainInstructionGen(sb, node_v);
        return Dag.cleanupInstructions(inst);
    }

    private List<Lop> doTopologicalSortStrictOrder(List<Lop> v) {
        Lop[] nodearray = v.toArray(new Lop[0]);
        Arrays.sort(nodearray, new LopComparator());
        return this.createIDMapping(nodearray);
    }

    private List<Lop> doTopologicalSortTwoLevelOrder(List<Lop> v) {
        List<Lop> nodes = Stream.concat(v.stream().filter(l -> !l.getOutputs().isEmpty()).sorted(Comparator.comparing(l -> l.getID())), v.stream().filter(l -> l.getOutputs().isEmpty())).collect(Collectors.toList());
        return nodes;
    }

    private List<Lop> createIDMapping(Lop[] nodearray) {
        int i;
        ArrayList<Lop> ret = new ArrayList<Lop>();
        this.IDMap.clear();
        for (i = 0; i < nodearray.length; ++i) {
            ret.add(nodearray[i]);
            this.IDMap.put(nodearray[i].getID(), i);
        }
        for (i = 0; i < nodearray.length; ++i) {
            this.dagDFS(nodearray[i], nodearray[i].createReachable(nodearray.length));
        }
        if (LOG.isTraceEnabled()) {
            for (Lop vnode : ret) {
                StringBuilder sb = new StringBuilder();
                sb.append(vnode.getID());
                sb.append("(");
                sb.append(vnode.getLevel());
                sb.append(") ");
                sb.append((Object)vnode.getType());
                sb.append("(");
                for (Lop vin : vnode.getInputs()) {
                    sb.append(vin.getID());
                    sb.append(",");
                }
                sb.append("), ");
                LOG.trace((Object)sb.toString());
            }
            LOG.trace((Object)"topological sort -- done");
        }
        return ret;
    }

    private ArrayList<Instruction> doGreedyGrouping(StatementBlock sb, List<Lop> node_v) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Grouping DAG ============");
        }
        ArrayList<Lop> execNodes = new ArrayList<Lop>();
        ArrayList<Lop> finishedNodes = new ArrayList<Lop>();
        ArrayList<Lop> queuedNodes = new ArrayList<Lop>();
        List<List<Lop>> jobNodes = Dag.createNodeVectors(JobType.getNumJobTypes());
        ArrayList<Instruction> deleteInst = new ArrayList<Instruction>();
        List<Instruction> writeInst = Dag.deleteUpdatedTransientReadVariables(sb, node_v);
        List<Instruction> endOfBlockInst = Dag.generateRemoveInstructions(sb);
        ArrayList<Instruction> inst = Dag.generateInstructionsForInputVariables(node_v);
        boolean done = false;
        String indent = "    ";
        while (!done) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Grouping nodes in DAG");
            }
            execNodes.clear();
            queuedNodes.clear();
            Dag.clearNodeVectors(jobNodes);
            this.gmrMapperFootprint = 0.0;
            for (Lop node : node_v) {
                if (finishedNodes.contains(node)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing node (" + node.getID() + ") " + node.toString() + " exec nodes size is " + execNodes.size()));
                }
                if (node.definesMRJob() && !this.compatibleWithChildrenInExecNodes(execNodes, node)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Queueing node " + node.toString() + " (code 1)"));
                    }
                    queuedNodes.add(node);
                    this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                    continue;
                }
                if (this.hasChildNode(node, queuedNodes)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Queueing node " + node.toString() + " (code 2)"));
                    }
                    queuedNodes.add(node);
                    this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                    continue;
                }
                if (node.getInputs().size() >= 2) {
                    int jobid = Integer.MIN_VALUE;
                    boolean queueit = false;
                    for (int idx = 0; idx < node.getInputs().size(); ++idx) {
                        int input_jobid = Dag.jobType(node.getInputs().get(idx), jobNodes);
                        if (input_jobid == -1) continue;
                        if (jobid == Integer.MIN_VALUE) {
                            jobid = input_jobid;
                            continue;
                        }
                        if (jobid == input_jobid) continue;
                        queueit = true;
                        break;
                    }
                    if (queueit) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)(indent + "Queueing node " + node.toString() + " (code 3)"));
                        }
                        queuedNodes.add(node);
                        this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                        continue;
                    }
                }
                boolean eliminate = false;
                eliminate = Dag.canEliminateLop(node, execNodes);
                if (eliminate) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Adding -" + node.toString()));
                    }
                    execNodes.add(node);
                    finishedNodes.add(node);
                    this.addNodeByJobType(node, jobNodes, execNodes, eliminate);
                    continue;
                }
                if (node.definesMRJob() && this.hasMRJobChildNode(node, execNodes) && (node.getType() != Lop.Type.Grouping || !this.checkDataGenAsChildNode(node, execNodes))) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Queueing node " + node.toString() + " (code 4)"));
                    }
                    queuedNodes.add(node);
                    this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                    continue;
                }
                if (node.getInputs().size() > 1 && this.hasChildNode(node, execNodes, LopProperties.ExecLocation.RecordReader)) {
                    Lop rr_node = this.getChildNode(node, execNodes, LopProperties.ExecLocation.RecordReader);
                    boolean queue_it = false;
                    for (Lop lop : node.getInputs()) {
                        if (lop.equals(rr_node) || Dag.isChild(rr_node, lop, this.IDMap)) continue;
                        queue_it = true;
                        break;
                    }
                    if (queue_it) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)(indent + "Queueing -" + node.toString() + " (code 5)"));
                        }
                        queuedNodes.add(node);
                        this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                        continue;
                    }
                }
                if (node.getExecLocation() == LopProperties.ExecLocation.Data) {
                    Data dnode = (Data)node;
                    boolean dnode_queued = false;
                    if (dnode.getOperationType() == Data.OperationTypes.READ) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)(indent + "Adding Data -" + node.toString()));
                        }
                        if (node.getDataType() == Expression.DataType.SCALAR && node.getOutputParameters().getFile_name() != null) {
                            execNodes.add(node);
                        }
                    } else if (dnode.getOperationType() == Data.OperationTypes.WRITE) {
                        Lop input = dnode.getInputs().get(0);
                        if (!this.isTransientWriteRead(dnode)) {
                            if (execNodes.contains(input) && !Dag.isCompatible(node, input) && Dag.sendWriteLopToMR(node)) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)(indent + "Queueing -" + node.toString()));
                                }
                                queuedNodes.add(node);
                                dnode_queued = true;
                            } else {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)(indent + "Adding Data -" + node.toString()));
                                }
                                execNodes.add(node);
                                if (Dag.sendWriteLopToMR(node)) {
                                    this.addNodeByJobType(node, jobNodes, execNodes, false);
                                }
                            }
                        }
                    }
                    if (dnode_queued) continue;
                    finishedNodes.add(node);
                    continue;
                }
                if (node.getExecLocation() == LopProperties.ExecLocation.MapOrReduce) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Adding -" + node.toString()));
                    }
                    execNodes.add(node);
                    finishedNodes.add(node);
                    this.addNodeByJobType(node, jobNodes, execNodes, false);
                    continue;
                }
                if (node.getExecLocation() == LopProperties.ExecLocation.RecordReader) {
                    if (!this.hasChildNode(node, execNodes, LopProperties.ExecLocation.Map) && !this.hasChildNode(node, execNodes, LopProperties.ExecLocation.MapAndReduce)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)(indent + "Adding -" + node.toString()));
                        }
                        execNodes.add(node);
                        finishedNodes.add(node);
                        this.addNodeByJobType(node, jobNodes, execNodes, false);
                        continue;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Queueing -" + node.toString() + " (code 6)"));
                    }
                    queuedNodes.add(node);
                    this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                    continue;
                }
                if (node.getExecLocation() == LopProperties.ExecLocation.Map) {
                    boolean queueThisNode = false;
                    int subcode = -1;
                    if (node.usesDistributedCache()) {
                        int[] dcInputIndexes;
                        for (int dcInputIndex : dcInputIndexes = node.distributedCacheInputIndex()) {
                            Lop dcInput = node.getInputs().get(dcInputIndex - 1);
                            if (dcInput.getType() == Lop.Type.Data || dcInput.getExecType() != LopProperties.ExecType.MR || !execNodes.contains(dcInput)) continue;
                            queueThisNode = true;
                            subcode = 1;
                        }
                        double d = Dag.computeFootprintInMapper(node);
                        if (this.gmrMapperFootprint > 0.0 && !Dag.checkMemoryLimits(node, this.gmrMapperFootprint + d)) {
                            queueThisNode = true;
                            subcode = 2;
                        }
                        if (!queueThisNode) {
                            this.gmrMapperFootprint += d;
                        }
                    }
                    if (!(queueThisNode || this.hasChildNode(node, execNodes, LopProperties.ExecLocation.MapAndReduce) || this.hasMRJobChildNode(node, execNodes))) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)(indent + "Adding -" + node.toString()));
                        }
                        execNodes.add(node);
                        finishedNodes.add(node);
                        this.addNodeByJobType(node, jobNodes, execNodes, false);
                        continue;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Queueing -" + node.toString() + " (code 7 - subcode " + subcode + ")"));
                    }
                    queuedNodes.add(node);
                    this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                    continue;
                }
                if (node.getExecLocation() == LopProperties.ExecLocation.MapAndReduce) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Adding -" + node.toString()));
                    }
                    execNodes.add(node);
                    finishedNodes.add(node);
                    this.addNodeByJobType(node, jobNodes, execNodes, eliminate);
                    continue;
                }
                if (node.getExecLocation() == LopProperties.ExecLocation.Reduce) {
                    if (this.compatibleWithChildrenInExecNodes(execNodes, node) && (this.hasChildNode(node, execNodes, LopProperties.ExecLocation.MapAndReduce) || this.hasChildNode(node, execNodes, LopProperties.ExecLocation.Map))) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)(indent + "Adding -" + node.toString()));
                        }
                        execNodes.add(node);
                        finishedNodes.add(node);
                        this.addNodeByJobType(node, jobNodes, execNodes, false);
                        continue;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Queueing -" + node.toString() + " (code 8)"));
                    }
                    queuedNodes.add(node);
                    this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                    continue;
                }
                if (node.getExecLocation() != LopProperties.ExecLocation.ControlProgram) continue;
                for (Lop lop : node.getInputs()) {
                    if (!execNodes.contains(lop) || lop.getExecLocation() == LopProperties.ExecLocation.Data || lop.getExecLocation() == LopProperties.ExecLocation.ControlProgram) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(indent + "Queueing -" + node.toString() + " (code 9)"));
                    }
                    queuedNodes.add(node);
                    this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
                    break;
                }
                if (queuedNodes.contains(node)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(indent + "Adding - scalar" + node.toString()));
                }
                execNodes.add(node);
                this.addNodeByJobType(node, jobNodes, execNodes, false);
                finishedNodes.add(node);
            }
            if (execNodes.isEmpty()) {
                if (!queuedNodes.isEmpty()) {
                    throw new LopsException("Queued nodes should not be 0 at this point \n");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("All done! queuedNodes = " + queuedNodes.size()));
                }
                done = true;
                continue;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Generating jobs for group -- Node count=" + execNodes.size()));
            }
            this.generateControlProgramJobs(execNodes, inst, writeInst, deleteInst);
            for (int i = 0; i < execNodes.size(); ++i) {
                Lop node;
                node = (Lop)execNodes.get(i);
                if (Dag.jobType(node, jobNodes) != -1) continue;
                if (Dag.isCompatible(node, JobType.GMR)) {
                    if (node.hasNonBlockedInputs()) {
                        jobNodes.get(JobType.GMRCELL.getId()).add(node);
                        Dag.addChildren(node, jobNodes.get(JobType.GMRCELL.getId()), execNodes);
                        continue;
                    }
                    jobNodes.get(JobType.GMR.getId()).add(node);
                    Dag.addChildren(node, jobNodes.get(JobType.GMR.getId()), execNodes);
                    continue;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(indent + "Queueing -" + node.toString() + " (code 10)"));
                }
                execNodes.remove(i);
                finishedNodes.remove(node);
                queuedNodes.add(node);
                this.removeNodesForNextIteration(node, finishedNodes, execNodes, queuedNodes, jobNodes);
            }
            if (!execNodes.isEmpty()) {
                this.generateMRJobs(execNodes, inst, writeInst, deleteInst, jobNodes);
            }
            this.handleSingleOutputJobs(execNodes, jobNodes, finishedNodes);
        }
        inst.addAll(writeInst);
        inst.addAll(deleteInst);
        inst.addAll(endOfBlockInst);
        return inst;
    }

    private ArrayList<Instruction> doPlainInstructionGen(StatementBlock sb, List<Lop> nodes) {
        ArrayList<Instruction> deleteInst = new ArrayList<Instruction>();
        List<Instruction> writeInst = Dag.deleteUpdatedTransientReadVariables(sb, nodes);
        List<Instruction> endOfBlockInst = Dag.generateRemoveInstructions(sb);
        ArrayList<Instruction> inst = Dag.generateInstructionsForInputVariables(nodes);
        List<Lop> execNodes = nodes.stream().filter(l -> l.getExecLocation() != LopProperties.ExecLocation.Data || ((Data)l).getOperationType() == Data.OperationTypes.WRITE && !this.isTransientWriteRead((Data)l) || ((Data)l).isPersistentRead() && l.getDataType().isScalar()).collect(Collectors.toList());
        this.generateControlProgramJobs(execNodes, inst, writeInst, deleteInst);
        inst.addAll(writeInst);
        inst.addAll(deleteInst);
        inst.addAll(endOfBlockInst);
        return inst;
    }

    private boolean isTransientWriteRead(Data dnode) {
        Lop input = dnode.getInputs().get(0);
        return dnode.isTransient() && input.getExecLocation() == LopProperties.ExecLocation.Data && ((Data)input).isTransient() && dnode.getOutputParameters().getLabel().equals(input.getOutputParameters().getLabel());
    }

    private static List<Instruction> deleteUpdatedTransientReadVariables(StatementBlock sb, List<Lop> nodeV) {
        ArrayList<Instruction> insts = new ArrayList<Instruction>();
        if (sb == null) {
            return insts;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"In delete updated variables");
        }
        HashMap<String, Lop> labelNodeMapping = new HashMap<String, Lop>();
        HashSet<String> updatedLabels = new HashSet<String>();
        HashMap<String, Lop> updatedLabelsLineNum = new HashMap<String, Lop>();
        for (Lop node : nodeV) {
            if (node.getExecLocation() != LopProperties.ExecLocation.Data || !((Data)node).isTransient() || ((Data)node).getOperationType() != Data.OperationTypes.READ || ((Data)node).getDataType() != Expression.DataType.MATRIX) continue;
            boolean hasWriteParent = false;
            for (Lop p : node.getOutputs()) {
                if (p.getExecLocation() != LopProperties.ExecLocation.Data) continue;
                hasWriteParent = true;
                break;
            }
            if (hasWriteParent) continue;
            labelNodeMapping.put(node.getOutputParameters().getLabel(), node);
        }
        for (Lop node : nodeV) {
            if (node.getExecLocation() != LopProperties.ExecLocation.Data || !((Data)node).isTransient() || ((Data)node).getOperationType() != Data.OperationTypes.WRITE || ((Data)node).getDataType() != Expression.DataType.MATRIX || !labelNodeMapping.containsKey(node.getOutputParameters().getLabel()) || labelNodeMapping.containsValue(node.getInputs().get(0))) continue;
            updatedLabels.add(node.getOutputParameters().getLabel());
            updatedLabelsLineNum.put(node.getOutputParameters().getLabel(), node);
        }
        Instruction rm_inst = null;
        for (String label : updatedLabels) {
            rm_inst = VariableCPInstruction.prepareRemoveInstruction(label);
            rm_inst.setLocation((Lop)updatedLabelsLineNum.get(label));
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)rm_inst.toString());
            }
            insts.add(rm_inst);
        }
        return insts;
    }

    private static List<Instruction> generateRemoveInstructions(StatementBlock sb) {
        if (sb == null) {
            return Collections.emptyList();
        }
        ArrayList<Instruction> insts = new ArrayList<Instruction>();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"In generateRemoveInstructions()");
        }
        for (String varName : sb.liveIn().getVariableNames()) {
            if (sb.liveOut().containsVariable(varName)) continue;
            Instruction inst = VariableCPInstruction.prepareRemoveInstruction(varName);
            inst.setLocation(sb.getFilename(), sb.getEndLine(), sb.getEndLine(), -1, -1);
            insts.add(inst);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("  Adding " + inst.toString()));
        }
        return insts;
    }

    private static List<List<Lop>> createNodeVectors(int size) {
        return IntStream.range(0, size).mapToObj(i -> new ArrayList()).collect(Collectors.toList());
    }

    private static void clearNodeVectors(List<List<Lop>> arr) {
        arr.stream().forEach(t -> t.clear());
    }

    private static boolean isCompatible(List<Lop> nodes, JobType jt, int from, int to) {
        return nodes.stream().allMatch(n -> (n.getCompatibleJobs() & jt.getBase()) != 0);
    }

    private static boolean isCompatible(Lop node1, Lop node2) {
        return (node1.getCompatibleJobs() & node2.getCompatibleJobs()) > 0;
    }

    private static boolean isCompatible(Lop node, JobType jt) {
        if (jt == JobType.GMRCELL) {
            jt = JobType.GMR;
        }
        return (node.getCompatibleJobs() & jt.getBase()) > 0;
    }

    private void addNodeByJobType(Lop node, List<List<Lop>> arr, List<Lop> execNodes, boolean eliminate) {
        if (!eliminate && node.definesMRJob()) {
            JobType jt = JobType.findJobTypeFromLop(node);
            if (jt == null) {
                throw new LopsException(node.printErrorLocation() + "No matching JobType is found for a the lop type: " + (Object)((Object)node.getType()) + " \n");
            }
            if (jt == JobType.GMR) {
                if (node.hasNonBlockedInputs()) {
                    int gmrcell_index = JobType.GMRCELL.getId();
                    arr.get(gmrcell_index).add(node);
                    int from = arr.get(gmrcell_index).size();
                    Dag.addChildren(node, arr.get(gmrcell_index), execNodes);
                    int to = arr.get(gmrcell_index).size();
                    if (!Dag.isCompatible(arr.get(gmrcell_index), JobType.GMR, from, to)) {
                        throw new LopsException(node.printErrorLocation() + "Error during compatibility check \n");
                    }
                } else if (this.hasChildNode(node, arr.get(JobType.DATAGEN.getId()))) {
                    arr.get(JobType.DATAGEN.getId()).add(node);
                } else {
                    int gmr_index = JobType.GMR.getId();
                    arr.get(gmr_index).add(node);
                    int from = arr.get(gmr_index).size();
                    Dag.addChildren(node, arr.get(gmr_index), execNodes);
                    int to = arr.get(gmr_index).size();
                    if (!Dag.isCompatible(arr.get(gmr_index), JobType.GMR, from, to)) {
                        throw new LopsException(node.printErrorLocation() + "Error during compatibility check \n");
                    }
                }
            } else {
                int index = jt.getId();
                arr.get(index).add(node);
                int from = arr.get(index).size();
                Dag.addChildren(node, arr.get(index), execNodes);
                int to = arr.get(index).size();
                if (!Dag.isCompatible(arr.get(index), jt, from, to)) {
                    throw new LopsException("Unexpected error in addNodeByType.");
                }
            }
            return;
        }
        if (eliminate) {
            if (node.hasNonBlockedInputs()) {
                arr.get(JobType.GMRCELL.getId()).add(node);
            } else {
                arr.get(JobType.GMR.getId()).add(node);
            }
            return;
        }
        int numAdded = 0;
        for (JobType j : JobType.values()) {
            if (j.getId() <= 0 || !Dag.hasDirectChildNode(node, arr.get(j.getId())) || !Dag.isCompatible(node, j)) continue;
            arr.get(j.getId()).add(node);
            ++numAdded;
        }
        if (numAdded > 1) {
            throw new LopsException("Unexpected error in addNodeByJobType(): A given lop can ONLY be added to a single job vector (numAdded = " + numAdded + ").");
        }
    }

    private static void removeNodeByJobType(Lop node, List<List<Lop>> arr) {
        for (JobType jt : JobType.values()) {
            if (jt.getId() <= 0) continue;
            arr.get(jt.getId()).remove(node);
        }
    }

    private void handleSingleOutputJobs(List<Lop> execNodes, List<List<Lop>> jobNodes, List<Lop> finishedNodes) {
        ArrayList<Lop> nodesWithUnfinishedOutputs = new ArrayList<Lop>();
        int[] jobIndices = new int[]{JobType.MMCJ.getId()};
        Lop.Type[] lopTypes = new Lop.Type[]{Lop.Type.MMCJ};
        for (int jobi = 0; jobi < jobIndices.length; ++jobi) {
            int jindex = jobIndices[jobi];
            if (jobNodes.get(jindex).isEmpty()) continue;
            List<Lop> vec = jobNodes.get(jindex);
            for (int i = 0; i < vec.size(); ++i) {
                int numParents;
                Lop MRparent;
                Lop node = vec.get(i);
                if (node.getExecLocation() != LopProperties.ExecLocation.MapOrReduce && node.getExecLocation() != LopProperties.ExecLocation.Map || (MRparent = this.getParentNode(node, execNodes, LopProperties.ExecLocation.MapAndReduce)) == null || MRparent.getType() != lopTypes[jobi] || (numParents = node.getOutputs().size()) <= 1) continue;
                for (int j = 0; j < numParents; ++j) {
                    if (finishedNodes.contains(node.getOutputs().get(j))) continue;
                    nodesWithUnfinishedOutputs.add(node);
                }
            }
            for (Lop node : vec) {
                if (node.getExecLocation() != LopProperties.ExecLocation.MapOrReduce && node.getExecLocation() != LopProperties.ExecLocation.Map) continue;
                if (nodesWithUnfinishedOutputs.contains(node)) {
                    finishedNodes.remove(node);
                }
                if (!this.hasParentNode(node, nodesWithUnfinishedOutputs)) continue;
                finishedNodes.remove(node);
            }
        }
    }

    private static boolean canEliminateLop(Lop node, List<Lop> execNodes) {
        if (!node.isAligner()) {
            return false;
        }
        int ret = Dag.getChildAlignment(node, execNodes, LopProperties.ExecLocation.MapAndReduce);
        if (ret == 2) {
            return false;
        }
        if (ret == 1) {
            return true;
        }
        if (ret == 0) {
            return false;
        }
        if (ret == 4) {
            return false;
        }
        if (ret == 5) {
            return true;
        }
        throw new RuntimeException("Should not happen. \n");
    }

    private static ArrayList<Instruction> generateInstructionsForInputVariables(List<Lop> nodes_v) {
        ArrayList<Instruction> insts = new ArrayList<Instruction>();
        for (Lop n : nodes_v) {
            if (n.getExecLocation() != LopProperties.ExecLocation.Data || ((Data)n).isTransient() || ((Data)n).getOperationType() != Data.OperationTypes.READ || n.getDataType() != Expression.DataType.MATRIX && n.getDataType() != Expression.DataType.FRAME || ((Data)n).isLiteral()) continue;
            try {
                String inst_string = n.getInstructions();
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(inst_string);
                currInstr.setLocation(n);
                insts.add(currInstr);
            }
            catch (DMLRuntimeException e) {
                throw new LopsException(n.printErrorLocation() + "error generating instructions from input variables in Dag -- \n", e);
            }
        }
        return insts;
    }

    private static boolean sendWriteLopToMR(Lop node) {
        if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE) {
            return false;
        }
        Lop in = node.getInputs().get(0);
        OutputParameters.Format nodeFormat = node.getOutputParameters().getFormat();
        return node.getExecType() == LopProperties.ExecType.MR || in.getExecType() == LopProperties.ExecType.MR && nodeFormat != OutputParameters.Format.CSV;
    }

    private static double computeFootprintInMapper(Lop node) {
        if (!node.usesDistributedCache()) {
            return 0.0;
        }
        OutputParameters in1dims = node.getInputs().get(0).getOutputParameters();
        OutputParameters in2dims = node.getInputs().get(1).getOutputParameters();
        double footprint = 0.0;
        if (node instanceof MapMult) {
            int dcInputIndex = node.distributedCacheInputIndex()[0];
            footprint = AggBinaryOp.getMapmmMemEstimate(in1dims.getNumRows(), in1dims.getNumCols(), in1dims.getRowsInBlock(), in1dims.getColsInBlock(), in1dims.getNnz(), in2dims.getNumRows(), in2dims.getNumCols(), in2dims.getRowsInBlock(), in2dims.getColsInBlock(), in2dims.getNnz(), dcInputIndex, false);
        } else if (node instanceof PMMJ) {
            int dcInputIndex = node.distributedCacheInputIndex()[0];
            footprint = AggBinaryOp.getMapmmMemEstimate(in1dims.getNumRows(), 1L, in1dims.getRowsInBlock(), in1dims.getColsInBlock(), in1dims.getNnz(), in2dims.getNumRows(), in2dims.getNumCols(), in2dims.getRowsInBlock(), in2dims.getColsInBlock(), in2dims.getNnz(), dcInputIndex, true);
        } else if (node instanceof AppendM) {
            footprint = BinaryOp.footprintInMapper(in1dims.getNumRows(), in1dims.getNumCols(), in2dims.getNumRows(), in2dims.getNumCols(), in1dims.getRowsInBlock(), in1dims.getColsInBlock());
        } else if (node instanceof BinaryM) {
            footprint = BinaryOp.footprintInMapper(in1dims.getNumRows(), in1dims.getNumCols(), in2dims.getNumRows(), in2dims.getNumCols(), in1dims.getRowsInBlock(), in1dims.getColsInBlock());
        } else {
            return 0.0;
        }
        return footprint;
    }

    private static boolean checkMemoryLimits(Lop node, double footprintInMapper) {
        boolean addNode = true;
        if (!node.usesDistributedCache()) {
            return addNode;
        }
        double memBudget = Math.min(1.0, 1.0) * OptimizerUtils.getRemoteMemBudgetMap(true);
        if (footprintInMapper <= memBudget) {
            return addNode;
        }
        return !addNode;
    }

    private boolean compatibleWithChildrenInExecNodes(List<Lop> execNodes, Lop node) {
        for (Lop tmpNode : execNodes) {
            if (!Dag.isChild(tmpNode, node, this.IDMap) || tmpNode.getExecLocation() == LopProperties.ExecLocation.ControlProgram || (tmpNode.getCompatibleJobs() & node.getCompatibleJobs()) != 0) continue;
            return false;
        }
        return true;
    }

    private static void excludeRemoveInstruction(String varName, List<Instruction> deleteInst) {
        for (int i = 0; i < deleteInst.size(); ++i) {
            Instruction inst = deleteInst.get(i);
            if (inst.getType() != Instruction.IType.CONTROL_PROGRAM && inst.getType() != Instruction.IType.SPARK || ((CPInstruction)inst).getCPInstructionType() != CPInstruction.CPType.Variable || !((VariableCPInstruction)inst).isRemoveVariable(varName)) continue;
            deleteInst.remove(i);
        }
    }

    private static void processConsumersForInputs(Lop node, List<Instruction> inst, List<Instruction> delteInst) {
        for (Lop in : node.getInputs()) {
            if (DMLScript.ENABLE_DEBUG_MODE) {
                Dag.processConsumers(in, inst, delteInst, node);
                continue;
            }
            Dag.processConsumers(in, inst, delteInst, null);
        }
    }

    private static void processConsumers(Lop node, List<Instruction> inst, List<Instruction> deleteInst, Lop locationInfo) {
        if (node.removeConsumer() == 0) {
            if (node.getExecLocation() == LopProperties.ExecLocation.Data && ((Data)node).isLiteral()) {
                return;
            }
            String label = node.getOutputParameters().getLabel();
            Instruction currInstr = VariableCPInstruction.prepareRemoveInstruction(label);
            if (locationInfo != null) {
                currInstr.setLocation(locationInfo);
            } else {
                currInstr.setLocation(node);
            }
            inst.add(currInstr);
            Dag.excludeRemoveInstruction(label, deleteInst);
        }
    }

    private void generateControlProgramJobs(List<Lop> execNodes, List<Instruction> inst, List<Instruction> writeInst, List<Instruction> deleteInst) {
        ArrayList<Lop> markedNodes = new ArrayList<Lop>();
        ArrayList<String> var_deletions = new ArrayList<String>();
        HashMap<String, Lop> var_deletionsLineNum = new HashMap<String, Lop>();
        boolean doRmVar = false;
        for (int i = 0; i < execNodes.size(); ++i) {
            Lop node = execNodes.get(i);
            doRmVar = false;
            if (node.getExecLocation() == LopProperties.ExecLocation.Data && ((Data)node).getOperationType() == Data.OperationTypes.READ && ((Data)node).getDataType() == Expression.DataType.SCALAR && node.getOutputParameters().getFile_name() == null) {
                markedNodes.add(node);
                continue;
            }
            if (node.getExecLocation() == LopProperties.ExecLocation.ControlProgram) {
                NodeOutput out;
                if (node.getDataType() == Expression.DataType.SCALAR) {
                    out = this.setupNodeOutputs(node, LopProperties.ExecType.CP, false, false);
                    inst.addAll(out.getPreInstructions());
                    deleteInst.addAll(out.getLastInstructions());
                } else {
                    out = this.setupNodeOutputs(node, LopProperties.ExecType.CP, false, false);
                    inst.addAll(out.getPreInstructions());
                    boolean hasTransientWriteParent = false;
                    for (Lop parent : node.getOutputs()) {
                        if (parent.getExecLocation() != LopProperties.ExecLocation.Data || ((Data)parent).getOperationType() != Data.OperationTypes.WRITE || !((Data)parent).isTransient()) continue;
                        hasTransientWriteParent = true;
                        break;
                    }
                    if (!hasTransientWriteParent) {
                        deleteInst.addAll(out.getLastInstructions());
                    } else {
                        var_deletions.add(node.getOutputParameters().getLabel());
                        var_deletionsLineNum.put(node.getOutputParameters().getLabel(), node);
                    }
                }
                String inst_string = "";
                if (node.getType() == Lop.Type.ParameterizedBuiltin || node.getType() == Lop.Type.GroupedAgg || node.getType() == Lop.Type.DataGen) {
                    inst_string = node.getInstructions(node.getOutputParameters().getLabel());
                } else if (node.getType() == Lop.Type.FunctionCallCP) {
                    String[] inputs = new String[node.getInputs().size()];
                    String[] outputs = new String[node.getOutputs().size()];
                    int count = 0;
                    for (Lop in : node.getInputs()) {
                        inputs[count++] = in.getOutputParameters().getLabel();
                    }
                    count = 0;
                    for (Lop out2 : node.getOutputs()) {
                        outputs[count++] = out2.getOutputParameters().getLabel();
                    }
                    inst_string = node.getInstructions(inputs, outputs);
                } else if (node.getType() == Lop.Type.Nary) {
                    String[] inputs = new String[node.getInputs().size()];
                    int count = 0;
                    for (Lop in : node.getInputs()) {
                        inputs[count++] = in.getOutputParameters().getLabel();
                    }
                    inst_string = node.getInstructions(inputs, node.getOutputParameters().getLabel());
                } else if (node.getInputs().isEmpty()) {
                    inst_string = node.getInstructions(node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 1) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 2) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 3 || node.getType() == Lop.Type.Ctable) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 4) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getInputs().get(3).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 5) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getInputs().get(3).getOutputParameters().getLabel(), node.getInputs().get(4).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 6) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getInputs().get(3).getOutputParameters().getLabel(), node.getInputs().get(4).getOutputParameters().getLabel(), node.getInputs().get(5).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else if (node.getInputs().size() == 7) {
                    inst_string = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), node.getInputs().get(1).getOutputParameters().getLabel(), node.getInputs().get(2).getOutputParameters().getLabel(), node.getInputs().get(3).getOutputParameters().getLabel(), node.getInputs().get(4).getOutputParameters().getLabel(), node.getInputs().get(5).getOutputParameters().getLabel(), node.getInputs().get(6).getOutputParameters().getLabel(), node.getOutputParameters().getLabel());
                } else {
                    String[] inputs = new String[node.getInputs().size()];
                    for (int j = 0; j < node.getInputs().size(); ++j) {
                        inputs[j] = node.getInputs().get(j).getOutputParameters().getLabel();
                    }
                    inst_string = node.getInstructions(inputs, node.getOutputParameters().getLabel());
                }
                try {
                    Instruction currInstr;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Generating instruction - " + inst_string));
                    }
                    if ((currInstr = InstructionParser.parseSingleInstruction(inst_string)) == null) {
                        throw new LopsException("Error parsing the instruction:" + inst_string);
                    }
                    if (node._beginLine != 0) {
                        currInstr.setLocation(node);
                    } else if (!node.getOutputs().isEmpty()) {
                        currInstr.setLocation(node.getOutputs().get(0));
                    } else if (!node.getInputs().isEmpty()) {
                        currInstr.setLocation(node.getInputs().get(0));
                    }
                    inst.add(currInstr);
                }
                catch (Exception e) {
                    throw new LopsException(node.printErrorLocation() + "Problem generating simple inst - " + inst_string, e);
                }
                markedNodes.add(node);
                doRmVar = true;
            } else if (node.getExecLocation() == LopProperties.ExecLocation.Data) {
                Data dnode = (Data)node;
                Data.OperationTypes op = dnode.getOperationType();
                if (op == Data.OperationTypes.WRITE) {
                    NodeOutput out = null;
                    if (Dag.sendWriteLopToMR(node)) {
                        doRmVar = false;
                    } else {
                        out = this.setupNodeOutputs(node, LopProperties.ExecType.CP, false, false);
                        if (dnode.getDataType() == Expression.DataType.SCALAR) {
                            writeInst.addAll(out.getLastInstructions());
                            doRmVar = false;
                        } else if (dnode.isTransient()) {
                            deleteInst.addAll(out.getLastInstructions());
                            doRmVar = false;
                        } else {
                            inst.addAll(out.getLastInstructions());
                            doRmVar = true;
                        }
                        markedNodes.add(node);
                    }
                } else {
                    if (node.getDataType() != Expression.DataType.SCALAR) {
                        throw new LopsException("Matrix READs are not handled in CP yet!");
                    }
                    node.getOutputParameters().setLabel("_Var" + var_index.getNextID());
                    String io_inst = node.getInstructions(node.getOutputParameters().getLabel(), node.getOutputParameters().getFile_name());
                    CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(io_inst);
                    currInstr.setLocation(node);
                    inst.add(currInstr);
                    Instruction tempInstr = VariableCPInstruction.prepareRemoveInstruction(node.getOutputParameters().getLabel());
                    tempInstr.setLocation(node);
                    deleteInst.add(tempInstr);
                    markedNodes.add(node);
                    doRmVar = true;
                }
            }
            if (doRmVar) {
                Dag.processConsumersForInputs(node, inst, deleteInst);
            }
            doRmVar = false;
        }
        for (String var : var_deletions) {
            Instruction rmInst = VariableCPInstruction.prepareRemoveInstruction(var);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  Adding var_deletions: " + rmInst.toString()));
            }
            rmInst.setLocation((Lop)var_deletionsLineNum.get(var));
            deleteInst.add(rmInst);
        }
        for (Lop node : markedNodes) {
            execNodes.remove(node);
        }
    }

    private void removeNodesForNextIteration(Lop node, List<Lop> finishedNodes, List<Lop> execNodes, List<Lop> queuedNodes, List<List<Lop>> jobvec) {
        boolean bl;
        if (node.getInputs().size() == 1) {
            return;
        }
        boolean allQueued = true;
        for (Lop input : node.getInputs()) {
            if (queuedNodes.contains(input)) continue;
            allQueued = false;
            break;
        }
        if (allQueued) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("  Before remove nodes for next iteration -- size of execNodes " + execNodes.size()));
        }
        int jobid = Integer.MIN_VALUE;
        boolean inputs_in_same_job = true;
        for (Lop lop : node.getInputs()) {
            int input_jobid = Dag.jobType(lop, jobvec);
            if (jobid == Integer.MIN_VALUE) {
                jobid = input_jobid;
                continue;
            }
            if (jobid == input_jobid) continue;
            inputs_in_same_job = false;
            break;
        }
        boolean unassigned_inputs = false;
        for (Lop input : node.getInputs()) {
            if (input.getExecType() != LopProperties.ExecType.MR || execNodes.contains(input)) continue;
            unassigned_inputs = true;
            break;
        }
        boolean bl2 = false;
        for (Lop input : node.getInputs()) {
            if (!queuedNodes.contains(input)) continue;
            bl = true;
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"  Property Flags:");
            LOG.trace((Object)("    Inputs in same job: " + inputs_in_same_job));
            LOG.trace((Object)("    Unassigned inputs: " + unassigned_inputs));
            LOG.trace((Object)("    Child queued: " + bl));
        }
        ArrayList<Lop> markedNodes = new ArrayList<Lop>();
        for (Lop tmpNode : execNodes) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  Checking for removal (" + tmpNode.getID() + ") " + tmpNode.toString()));
            }
            if (!Dag.isChild(tmpNode, node, this.IDMap)) continue;
            if (node.getInputs().contains(tmpNode) && tmpNode.isAligner()) {
                markedNodes.add(tmpNode);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("    Removing for next iteration (code 1): (" + tmpNode.getID() + ") " + tmpNode.toString()));
                }
            }
            if (!this.hasOtherQueuedParentNode(tmpNode, queuedNodes, node) && this.branchHasNoOtherUnExecutedParents(tmpNode, node, execNodes, finishedNodes)) {
                boolean queueit = false;
                int code = -1;
                switch (node.getExecLocation()) {
                    case Map: {
                        if (this.branchCanBePiggyBackedMap(tmpNode, node, execNodes, queuedNodes, markedNodes)) {
                            queueit = true;
                        }
                        code = 2;
                        break;
                    }
                    case MapAndReduce: {
                        if (this.branchCanBePiggyBackedMapAndReduce(tmpNode, node, execNodes, queuedNodes) && !tmpNode.definesMRJob()) {
                            queueit = true;
                        }
                        code = 3;
                        break;
                    }
                    case Reduce: {
                        if (this.branchCanBePiggyBackedReduce(tmpNode, node, execNodes, queuedNodes)) {
                            queueit = true;
                        }
                        code = 4;
                        break;
                    }
                }
                if (queueit) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("    Removing for next iteration (code " + code + "): (" + tmpNode.getID() + ") " + tmpNode.toString()));
                    }
                    markedNodes.add(tmpNode);
                }
            }
            if (!inputs_in_same_job && !unassigned_inputs || node.getExecLocation() != LopProperties.ExecLocation.MapAndReduce || this.hasOtherMapAndReduceParentNode(tmpNode, execNodes, node) || !this.branchCanBePiggyBackedMapAndReduce(tmpNode, node, execNodes, queuedNodes) || tmpNode.definesMRJob()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("    Removing for next iteration (code 5): (" + tmpNode.getID() + ") " + tmpNode.toString()));
            }
            markedNodes.add(tmpNode);
        }
        for (Lop enode : execNodes) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("  Checking for removal - (" + enode.getID() + ") " + enode.toString()));
            }
            if (!this.hasChildNode(enode, markedNodes) || markedNodes.contains(enode)) continue;
            markedNodes.add(enode);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("    Removing for next iteration (code 6) (" + enode.getID() + ") " + enode.toString()));
        }
        if (execNodes.size() != markedNodes.size()) {
            for (Lop n : markedNodes) {
                if (n.usesDistributedCache()) {
                    this.gmrMapperFootprint -= Dag.computeFootprintInMapper(n);
                }
                finishedNodes.remove(n);
                execNodes.remove(n);
                Dag.removeNodeByJobType(n, jobvec);
                queuedNodes.add(n);
            }
        }
    }

    private boolean branchCanBePiggyBackedReduce(Lop tmpNode, Lop node, List<Lop> execNodes, List<Lop> queuedNodes) {
        if (node.getExecLocation() != LopProperties.ExecLocation.Reduce) {
            return false;
        }
        for (Lop ni : node.getInputs()) {
            if (!queuedNodes.contains(ni) || !Dag.isChild(tmpNode, ni, this.IDMap)) continue;
            return false;
        }
        for (Lop n : execNodes) {
            if (n.equals(node)) continue;
            if (n.equals(tmpNode) && n.getExecLocation() != LopProperties.ExecLocation.Map && n.getExecLocation() != LopProperties.ExecLocation.MapOrReduce) {
                return false;
            }
            if (!Dag.isChild(n, node, this.IDMap) || !Dag.isChild(tmpNode, n, this.IDMap) || node.getInputs().contains(tmpNode) || n.getExecLocation() == LopProperties.ExecLocation.Map || n.getExecLocation() == LopProperties.ExecLocation.MapOrReduce) continue;
            return false;
        }
        return true;
    }

    private boolean branchCanBePiggyBackedMap(Lop tmpNode, Lop node, List<Lop> execNodes, List<Lop> queuedNodes, List<Lop> markedNodes) {
        if (node.getExecLocation() != LopProperties.ExecLocation.Map) {
            return false;
        }
        for (Lop ni : node.getInputs()) {
            if (queuedNodes == null || !queuedNodes.contains(ni) || !Dag.isChild(tmpNode, ni, this.IDMap)) continue;
            return false;
        }
        if (tmpNode.definesMRJob() || tmpNode.getExecLocation() != LopProperties.ExecLocation.Map && tmpNode.getExecLocation() != LopProperties.ExecLocation.MapOrReduce) {
            return false;
        }
        if (node.usesDistributedCache()) {
            for (Object dcInputIndex : (Object)node.distributedCacheInputIndex()) {
                Lop dcInput = node.getInputs().get((int)(dcInputIndex - true));
                if (!Dag.isChild(tmpNode, dcInput, this.IDMap)) continue;
                return false;
            }
        }
        if (tmpNode.usesDistributedCache()) {
            double memsize = Dag.computeFootprintInMapper(tmpNode);
            if (node.usesDistributedCache()) {
                memsize += Dag.computeFootprintInMapper(node);
            }
            if (markedNodes != null) {
                for (Lop n : markedNodes) {
                    if (!n.usesDistributedCache()) continue;
                    memsize += Dag.computeFootprintInMapper(n);
                }
            }
            if (!Dag.checkMemoryLimits(node, memsize)) {
                return false;
            }
        }
        return (tmpNode.getCompatibleJobs() & node.getCompatibleJobs()) > 0;
    }

    private boolean branchCanBePiggyBackedMapAndReduce(Lop tmpNode, Lop node, List<Lop> execNodes, List<Lop> queuedNodes) {
        if (node.getExecLocation() != LopProperties.ExecLocation.MapAndReduce) {
            return false;
        }
        JobType jt = JobType.findJobTypeFromLop(node);
        for (Lop n : execNodes) {
            if (n.equals(node) || !n.equals(tmpNode) && (!Dag.isChild(n, node, this.IDMap) || !Dag.isChild(tmpNode, n, this.IDMap))) continue;
            if (this.hasOtherMapAndReduceParentNode(tmpNode, queuedNodes, node)) {
                return false;
            }
            LopProperties.ExecLocation el = n.getExecLocation();
            if (el != LopProperties.ExecLocation.Map && el != LopProperties.ExecLocation.MapOrReduce) {
                return false;
            }
            if (Dag.isCompatible(n, jt)) continue;
            return false;
        }
        return true;
    }

    private boolean branchHasNoOtherUnExecutedParents(Lop tmpNode, Lop node, List<Lop> execNodes, List<Lop> finishedNodes) {
        if (tmpNode.getOutputs().size() > 1) {
            int cnt = 0;
            for (Lop output : tmpNode.getOutputs()) {
                if (finishedNodes.contains(output)) continue;
                ++cnt;
            }
            if (cnt != 1) {
                return false;
            }
        }
        for (Lop n : execNodes) {
            if (n.equals(node) || n.equals(tmpNode) || !Dag.isChild(n, node, this.IDMap) || !Dag.isChild(tmpNode, n, this.IDMap)) continue;
            int cnt = 0;
            for (Lop output : n.getOutputs()) {
                if (finishedNodes.contains(output)) continue;
                ++cnt;
            }
            if (cnt == true) continue;
            return false;
        }
        return true;
    }

    private static int jobType(Lop lops, List<List<Lop>> jobvec) {
        for (JobType jt : JobType.values()) {
            int i = jt.getId();
            if (i <= 0 || jobvec.get(i) == null || !jobvec.get(i).contains(lops)) continue;
            return i;
        }
        return -1;
    }

    private boolean hasOtherMapAndReduceParentNode(Lop tmpNode, List<Lop> nodeList, Lop node) {
        if (tmpNode.getExecLocation() == LopProperties.ExecLocation.MapAndReduce) {
            return true;
        }
        for (Lop n : tmpNode.getOutputs()) {
            if (!nodeList.contains(n) || !Dag.isChild(n, node, this.IDMap)) continue;
            if (!n.equals(node) && n.getExecLocation() == LopProperties.ExecLocation.MapAndReduce) {
                return true;
            }
            return this.hasOtherMapAndReduceParentNode(n, nodeList, node);
        }
        return false;
    }

    private boolean hasOtherQueuedParentNode(Lop tmpNode, List<Lop> queuedNodes, Lop node) {
        if (queuedNodes.isEmpty()) {
            return false;
        }
        boolean[] nodeMarked = node.getReachable();
        boolean[] tmpMarked = tmpNode.getReachable();
        long nodeid = this.IDMap.get(node.getID()).intValue();
        long tmpid = this.IDMap.get(tmpNode.getID()).intValue();
        for (Lop qnode : queuedNodes) {
            int id = this.IDMap.get(qnode.getID());
            if ((long)id == nodeid || !nodeMarked[id] || (long)id == tmpid || !tmpMarked[id]) continue;
            return true;
        }
        return false;
    }

    private static void printJobNodes(List<List<Lop>> jobNodes) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        for (JobType jt : JobType.values()) {
            int i = jt.getId();
            if (i <= 0 || jobNodes.get(i) == null || jobNodes.get(i).isEmpty()) continue;
            LOG.trace((Object)(jt.getName() + " Job Nodes:"));
            for (int j = 0; j < jobNodes.get(i).size(); ++j) {
                LOG.trace((Object)("    " + jobNodes.get(i).get(j).getID() + ") " + jobNodes.get(i).get(j).toString()));
            }
        }
    }

    private static boolean hasANode(List<Lop> nodes, LopProperties.ExecLocation loc) {
        for (Lop n : nodes) {
            if (n.getExecLocation() != LopProperties.ExecLocation.RecordReader) continue;
            return true;
        }
        return false;
    }

    private List<List<Lop>> splitGMRNodesByRecordReader(List<Lop> gmrnodes) {
        ArrayList<Lop> rrnodes = new ArrayList<Lop>();
        for (Lop gmrnode : gmrnodes) {
            if (gmrnode.getExecLocation() != LopProperties.ExecLocation.RecordReader) continue;
            rrnodes.add(gmrnode);
        }
        List<List<Lop>> splitGMR = Dag.createNodeVectors(rrnodes.size() + 1);
        boolean[] flags = new boolean[gmrnodes.size()];
        Arrays.fill(flags, false);
        for (int rrid = 0; rrid < rrnodes.size(); ++rrid) {
            splitGMR.get(rrid).add((Lop)rrnodes.get(rrid));
            for (int j = 0; j < gmrnodes.size(); ++j) {
                if (((Lop)rrnodes.get(rrid)).equals(gmrnodes.get(j))) {
                    flags[j] = true;
                    continue;
                }
                if (!Dag.isChild((Lop)rrnodes.get(rrid), gmrnodes.get(j), this.IDMap)) continue;
                splitGMR.get(rrid).add(gmrnodes.get(j));
                flags[j] = true;
            }
        }
        int jobindex = rrnodes.size();
        for (int i = 0; i < gmrnodes.size(); ++i) {
            if (flags[i]) continue;
            splitGMR.get(jobindex).add(gmrnodes.get(i));
            flags[i] = true;
        }
        return splitGMR;
    }

    private void generateMRJobs(List<Lop> execNodes, List<Instruction> inst, List<Instruction> writeinst, List<Instruction> deleteinst, List<List<Lop>> jobNodes) {
        Dag.printJobNodes(jobNodes);
        ArrayList<Instruction> rmvarinst = new ArrayList<Instruction>();
        for (JobType jt : JobType.values()) {
            int index;
            List<Lop> currNodes;
            if (jt == JobType.INVALID || jt == JobType.ANY || (currNodes = jobNodes.get(index = jt.getId())) == null || currNodes.isEmpty()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Generating " + jt.getName() + " job"));
            }
            if (jt.allowsRecordReaderInstructions() && Dag.hasANode(jobNodes.get(index), LopProperties.ExecLocation.RecordReader)) {
                List<List<Lop>> rrlist = this.splitGMRNodesByRecordReader(jobNodes.get(index));
                for (int i = 0; i < rrlist.size(); ++i) {
                    this.generateMapReduceInstructions(rrlist.get(i), inst, writeinst, deleteinst, rmvarinst, jt);
                }
                continue;
            }
            if (jt.allowsSingleShuffleInstruction()) {
                Lop.Type splittingLopType = jt.getShuffleLopType();
                ArrayList<Lop> nodesForASingleJob = new ArrayList<Lop>();
                for (int i = 0; i < jobNodes.get(index).size(); ++i) {
                    if (jobNodes.get(index).get(i).getType() != splittingLopType) continue;
                    nodesForASingleJob.clear();
                    nodesForASingleJob.add(jobNodes.get(index).get(i));
                    Dag.addChildren(jobNodes.get(index).get(i), nodesForASingleJob, jobNodes.get(index));
                    if (jt.isCompatibleWithParentNodes()) {
                        this.addParents(jobNodes.get(index).get(i), nodesForASingleJob, jobNodes.get(index));
                    }
                    this.generateMapReduceInstructions(nodesForASingleJob, inst, writeinst, deleteinst, rmvarinst, jt);
                }
                continue;
            }
            this.generateMapReduceInstructions(jobNodes.get(index), inst, writeinst, deleteinst, rmvarinst, jt);
        }
        inst.addAll(rmvarinst);
    }

    private void addParents(Lop node, List<Lop> node_v, List<Lop> exec_n) {
        for (Lop enode : exec_n) {
            if (!Dag.isChild(node, enode, this.IDMap) || node_v.contains(enode)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Adding parent - " + enode.toString()));
            }
            node_v.add(enode);
        }
    }

    private static void addChildren(Lop node, List<Lop> node_v, List<Lop> exec_n) {
        if (exec_n.contains(node) && node.getExecLocation() != LopProperties.ExecLocation.ControlProgram && !node_v.contains(node)) {
            node_v.add(node);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("      Added child " + node.toString()));
            }
        }
        if (!exec_n.contains(node)) {
            return;
        }
        for (Lop n : node.getInputs()) {
            Dag.addChildren(n, node_v, exec_n);
        }
    }

    private static OutputInfo getOutputInfo(Lop node, boolean cellModeOverride) {
        if (node.getDataType() == Expression.DataType.SCALAR && node.getExecType() == LopProperties.ExecType.CP || node instanceof FunctionCallCP) {
            return null;
        }
        OutputInfo oinfo = null;
        OutputParameters oparams = node.getOutputParameters();
        if (oparams.isBlocked()) {
            if (!cellModeOverride) {
                oinfo = OutputInfo.BinaryBlockOutputInfo;
            } else {
                oinfo = OutputInfo.BinaryCellOutputInfo;
                try {
                    oparams.setDimensions(oparams.getNumRows(), oparams.getNumCols(), -1L, -1L, oparams.getNnz(), oparams.getUpdateType());
                }
                catch (HopsException e) {
                    throw new LopsException(node.printErrorLocation() + "error in getOutputInfo in Dag ", e);
                }
            }
        } else {
            oinfo = oparams.getFormat() == OutputParameters.Format.TEXT || oparams.getFormat() == OutputParameters.Format.MM ? OutputInfo.TextCellOutputInfo : (oparams.getFormat() == OutputParameters.Format.CSV ? OutputInfo.CSVOutputInfo : OutputInfo.BinaryCellOutputInfo);
        }
        if (node.getType() == Lop.Type.SortKeys && node.getExecType() == LopProperties.ExecType.MR) {
            oinfo = ((SortKeys)node).getOpType() == SortKeys.OperationTypes.Indexes ? OutputInfo.BinaryBlockOutputInfo : OutputInfo.OutputInfoForSortOutput;
        } else if (node.getType() == Lop.Type.CombineBinary) {
            CombineBinary combine = (CombineBinary)node;
            if (combine.getOperation() == CombineBinary.OperationTypes.PreSort) {
                oinfo = OutputInfo.OutputInfoForSortInput;
            } else if (combine.getOperation() == CombineBinary.OperationTypes.PreCentralMoment || combine.getOperation() == CombineBinary.OperationTypes.PreCovUnweighted || combine.getOperation() == CombineBinary.OperationTypes.PreGroupedAggUnweighted) {
                oinfo = OutputInfo.WeightedPairOutputInfo;
            }
        } else if (node.getType() == Lop.Type.CombineTernary) {
            oinfo = OutputInfo.WeightedPairOutputInfo;
        } else if (node.getType() == Lop.Type.CentralMoment || node.getType() == Lop.Type.CoVariance) {
            oinfo = OutputInfo.BinaryCellOutputInfo;
        }
        return oinfo;
    }

    private static String prepareAssignVarInstruction(Lop input, Lop node) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)LopProperties.ExecType.CP);
        sb.append("\u00b0");
        sb.append("assignvar");
        sb.append("\u00b0");
        sb.append(input.prepScalarInputOperand(LopProperties.ExecType.CP));
        sb.append("\u00b0");
        sb.append(node.prepOutputOperand());
        return sb.toString();
    }

    private NodeOutput setupNodeOutputs(Lop node, LopProperties.ExecType et, boolean cellModeOverride, boolean copyTWrite) {
        OutputParameters oparams = node.getOutputParameters();
        NodeOutput out = new NodeOutput();
        node.setConsumerCount(node.getOutputs().size());
        out.setOutInfo(Dag.getOutputInfo(node, cellModeOverride));
        if (node.getExecLocation() != LopProperties.ExecLocation.Data) {
            if (node.getDataType() == Expression.DataType.SCALAR || node.getDataType() == Expression.DataType.LIST) {
                oparams.setLabel("_Var" + var_index.getNextID());
                out.setVarName(oparams.getLabel());
                Instruction currInstr = VariableCPInstruction.prepareRemoveInstruction(oparams.getLabel());
                currInstr.setLocation(node);
                out.addLastInstruction(currInstr);
            } else if (!(node instanceof FunctionCallCP)) {
                oparams.setFile_name(this.getNextUniqueFilename());
                oparams.setLabel(Dag.getNextUniqueVarname(node.getDataType()));
                int rpb = (int)oparams.getRowsInBlock();
                int cpb = (int)oparams.getColsInBlock();
                Instruction createvarInst = VariableCPInstruction.prepareCreateVariableInstruction(oparams.getLabel(), oparams.getFile_name(), true, node.getDataType(), OutputInfo.outputInfoToString(Dag.getOutputInfo(node, false)), new MatrixCharacteristics(oparams.getNumRows(), oparams.getNumCols(), rpb, cpb, oparams.getNnz()), oparams.getUpdateType());
                createvarInst.setLocation(node);
                out.addPreInstruction(createvarInst);
                Instruction currInstr = VariableCPInstruction.prepareRemoveInstruction(oparams.getLabel());
                currInstr.setLocation(node);
                out.addLastInstruction(currInstr);
                out.setFileName(oparams.getFile_name());
                out.setVarName(oparams.getLabel());
            } else {
                FunctionCallCP fcall = (FunctionCallCP)node;
                if (fcall.getFunctionOutputs() != null) {
                    for (Lop fnOut : fcall.getFunctionOutputs()) {
                        OutputParameters fnOutParams = fnOut.getOutputParameters();
                        Instruction createvarInst = VariableCPInstruction.prepareCreateVariableInstruction(fnOutParams.getLabel(), this.getFilePath() + fnOutParams.getLabel(), true, fnOut.getDataType(), OutputInfo.outputInfoToString(Dag.getOutputInfo(fnOut, false)), new MatrixCharacteristics(fnOutParams.getNumRows(), fnOutParams.getNumCols(), (int)fnOutParams.getRowsInBlock(), (int)fnOutParams.getColsInBlock(), fnOutParams.getNnz()), oparams.getUpdateType());
                        if (node._beginLine != 0) {
                            createvarInst.setLocation(node);
                        } else {
                            createvarInst.setLocation(fnOut);
                        }
                        out.addPreInstruction(createvarInst);
                    }
                }
            }
        } else if (node.getDataType() == Expression.DataType.SCALAR) {
            if (!(oparams.getFile_name() != null || node instanceof Data && ((Data)node).isPersistentWrite())) {
                String io_inst = Dag.prepareAssignVarInstruction(node.getInputs().get(0), node);
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(io_inst);
                if (node._beginLine != 0) {
                    currInstr.setLocation(node);
                } else if (!node.getInputs().isEmpty()) {
                    currInstr.setLocation(node.getInputs().get(0));
                }
                out.addLastInstruction(currInstr);
            } else {
                Lop fname = ((Data)node).getNamedInputLop("iofilename");
                String io_inst = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), fname.getOutputParameters().getLabel());
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(io_inst);
                if (node._beginLine != 0) {
                    currInstr.setLocation(node);
                } else if (!node.getInputs().isEmpty()) {
                    currInstr.setLocation(node.getInputs().get(0));
                }
                out.addLastInstruction(currInstr);
            }
        } else if (((Data)node).isTransient()) {
            if (et == LopProperties.ExecType.CP) {
                String inputFileName = node.getInputs().get(0).getOutputParameters().getFile_name();
                String inputVarName = node.getInputs().get(0).getOutputParameters().getLabel();
                String constVarName = oparams.getLabel();
                String constFileName = inputFileName + constVarName;
                Instruction currInstr = VariableCPInstruction.prepareCopyInstruction(inputVarName, constVarName);
                currInstr.setLocation(node);
                out.addLastInstruction(currInstr);
                out.setFileName(constFileName);
            } else {
                if (copyTWrite) {
                    Instruction currInstr = VariableCPInstruction.prepareCopyInstruction(node.getInputs().get(0).getOutputParameters().getLabel(), oparams.getLabel());
                    currInstr.setLocation(node);
                    out.addLastInstruction(currInstr);
                    return out;
                }
                String tempVarName = oparams.getLabel() + "temp";
                String tempFileName = this.getNextUniqueFilename();
                int rpb = (int)oparams.getRowsInBlock();
                int cpb = (int)oparams.getColsInBlock();
                Instruction createvarInst = VariableCPInstruction.prepareCreateVariableInstruction(tempVarName, tempFileName, true, node.getDataType(), OutputInfo.outputInfoToString(out.getOutInfo()), new MatrixCharacteristics(oparams.getNumRows(), oparams.getNumCols(), rpb, cpb, oparams.getNnz()), oparams.getUpdateType());
                createvarInst.setLocation(node);
                out.addPreInstruction(createvarInst);
                String constVarName = oparams.getLabel();
                String constFileName = tempFileName + constVarName;
                oparams.setFile_name(this.getFilePath() + constFileName);
                Instruction currInstr = VariableCPInstruction.prepareMoveInstruction(tempVarName, constVarName);
                currInstr.setLocation(node);
                out.addLastInstruction(currInstr);
                out.setFileName(tempFileName);
                out.setVarName(tempVarName);
            }
        } else if (et == LopProperties.ExecType.MR) {
            Instruction createvarInst;
            String fnameStr;
            oparams.setLabel("pVar" + var_index.getNextID());
            int rpb = (int)oparams.getRowsInBlock();
            int cpb = (int)oparams.getColsInBlock();
            Lop fnameLop = ((Data)node).getNamedInputLop("iofilename");
            String string = fnameStr = fnameLop instanceof Data && ((Data)fnameLop).isLiteral() ? fnameLop.getOutputParameters().getLabel() : "\u00b6" + fnameLop.getOutputParameters().getLabel() + "\u00b6";
            if (oparams.getFormat() == OutputParameters.Format.CSV) {
                String tempFileName = this.getNextUniqueFilename();
                String createInst = node.getInstructions(tempFileName);
                createvarInst = CPInstructionParser.parseSingleInstruction(createInst);
                String writeInst = node.getInstructions(oparams.getLabel(), fnameLop.getOutputParameters().getLabel());
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(writeInst);
                currInstr.setLocation(node);
                out.addPostInstruction(currInstr);
                CPInstruction tempInstr = CPInstructionParser.parseSingleInstruction("CP\u00b0rmfilevar\u00b0" + oparams.getLabel() + "\u00b7" + (Object)((Object)Expression.ValueType.UNKNOWN) + "\u00b0" + "true" + "\u00b7" + "BOOLEAN");
                tempInstr.setLocation(node);
                out.addLastInstruction(tempInstr);
            } else if (oparams.getFormat() == OutputParameters.Format.MM) {
                createvarInst = VariableCPInstruction.prepareCreateVariableInstruction(oparams.getLabel(), this.getNextUniqueFilename(), false, node.getDataType(), OutputInfo.outputInfoToString(Dag.getOutputInfo(node, false)), new MatrixCharacteristics(oparams.getNumRows(), oparams.getNumCols(), rpb, cpb, oparams.getNnz()), oparams.getUpdateType());
                String writeInst = node.getInstructions(oparams.getLabel(), fnameLop.getOutputParameters().getLabel());
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction(writeInst);
                currInstr.setLocation(node);
                out.addPostInstruction(currInstr);
                CPInstruction tempInstr = CPInstructionParser.parseSingleInstruction("CP\u00b0rmfilevar\u00b0" + oparams.getLabel() + "\u00b7" + (Object)((Object)Expression.ValueType.UNKNOWN) + "\u00b0" + "true" + "\u00b7" + "BOOLEAN");
                tempInstr.setLocation(node);
                out.addLastInstruction(tempInstr);
            } else {
                createvarInst = VariableCPInstruction.prepareCreateVariableInstruction(oparams.getLabel(), fnameStr, false, node.getDataType(), OutputInfo.outputInfoToString(Dag.getOutputInfo(node, false)), new MatrixCharacteristics(oparams.getNumRows(), oparams.getNumCols(), rpb, cpb, oparams.getNnz()), oparams.getUpdateType());
                CPInstruction currInstr = CPInstructionParser.parseSingleInstruction("CP\u00b0rmfilevar\u00b0" + oparams.getLabel() + "\u00b7" + (Object)((Object)Expression.ValueType.UNKNOWN) + "\u00b0" + "false" + "\u00b7" + "BOOLEAN");
                currInstr.setLocation(node);
                out.addLastInstruction(currInstr);
            }
            createvarInst.setLocation(node);
            out.addPreInstruction(createvarInst);
            out.setFileName(oparams.getFile_name());
            out.setVarName(oparams.getLabel());
        } else {
            Lop fname = ((Data)node).getNamedInputLop("iofilename");
            String io_inst = node.getInstructions(node.getInputs().get(0).getOutputParameters().getLabel(), fname.getOutputParameters().getLabel());
            Instruction currInstr = node.getExecType() == LopProperties.ExecType.SPARK ? SPInstructionParser.parseSingleInstruction(io_inst) : CPInstructionParser.parseSingleInstruction(io_inst);
            currInstr.setLocation(!node.getInputs().isEmpty() && node.getInputs().get((int)0)._beginLine != 0 ? node.getInputs().get(0) : node);
            out.addLastInstruction(currInstr);
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    private void generateMapReduceInstructions(List<Lop> execNodes, List<Instruction> inst, List<Instruction> writeinst, List<Instruction> deleteinst, List<Instruction> rmvarinst, JobType jt) {
        void var32_40;
        ArrayList<Byte> resultIndices = new ArrayList<Byte>();
        ArrayList<String> inputs = new ArrayList<String>();
        ArrayList<String> outputs = new ArrayList<String>();
        ArrayList<InputInfo> inputInfos = new ArrayList<InputInfo>();
        ArrayList<OutputInfo> outputInfos = new ArrayList<OutputInfo>();
        ArrayList<Long> numRows = new ArrayList<Long>();
        ArrayList<Long> numCols = new ArrayList<Long>();
        ArrayList<Long> numRowsPerBlock = new ArrayList<Long>();
        ArrayList<Long> numColsPerBlock = new ArrayList<Long>();
        ArrayList<String> mapperInstructions = new ArrayList<String>();
        ArrayList<String> randInstructions = new ArrayList<String>();
        ArrayList<String> recordReaderInstructions = new ArrayList<String>();
        int numReducers = 0;
        int replication = 1;
        ArrayList<String> inputLabels = new ArrayList<String>();
        ArrayList<String> outputLabels = new ArrayList<String>();
        ArrayList<Instruction> renameInstructions = new ArrayList<Instruction>();
        ArrayList<Instruction> variableInstructions = new ArrayList<Instruction>();
        ArrayList<Instruction> postInstructions = new ArrayList<Instruction>();
        ArrayList<Integer> MRJobLineNumbers = null;
        if (DMLScript.ENABLE_DEBUG_MODE) {
            MRJobLineNumbers = new ArrayList<Integer>();
        }
        ArrayList<Lop> inputLops = new ArrayList<Lop>();
        boolean cellModeOverride = false;
        ArrayList<Lop> rootNodes = new ArrayList<Lop>();
        Dag.getOutputNodes(execNodes, rootNodes, jt);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("# of root nodes = " + rootNodes.size()));
        }
        if (jt == JobType.GMR || jt == JobType.GMRCELL) {
            ArrayList<Lop> markedNodes = new ArrayList<Lop>();
            for (Lop lop : rootNodes) {
                if (lop.getExecLocation() != LopProperties.ExecLocation.Data || !((Data)lop).isTransient() || ((Data)lop).getOperationType() != Data.OperationTypes.WRITE || ((Data)lop).getDataType() != Expression.DataType.MATRIX || lop.getInputs().get(0).getExecLocation() != LopProperties.ExecLocation.Data || !((Data)lop.getInputs().get(0)).isTransient() || !lop.getOutputParameters().getLabel().equals(lop.getInputs().get(0).getOutputParameters().getLabel())) continue;
                markedNodes.add(lop);
            }
            rootNodes.removeAll(markedNodes);
            markedNodes.clear();
            if (rootNodes.isEmpty()) {
                return;
            }
        }
        HashMap<Lop, Integer> nodeIndexMapping = new HashMap<Lop, Integer>();
        for (Lop lop : rootNodes) {
            Dag.getInputPathsAndParameters(lop, execNodes, inputs, inputInfos, numRows, numCols, numRowsPerBlock, numColsPerBlock, nodeIndexMapping, inputLabels, inputLops, MRJobLineNumbers);
        }
        if (jt == JobType.DATAGEN) {
            randInstructions = inputs;
        }
        int[] start_index = new int[]{inputs.size()};
        if (jt == JobType.GMR || jt == JobType.GMRCELL) {
            for (Lop rnode : rootNodes) {
                Dag.getRecordReaderInstructions(rnode, execNodes, inputs, recordReaderInstructions, nodeIndexMapping, start_index, inputLabels, inputLops, MRJobLineNumbers);
                if (recordReaderInstructions.size() <= 1) continue;
                throw new LopsException("MapReduce job can only have a single recordreader instruction: " + recordReaderInstructions.toString());
            }
        }
        if (jt != JobType.REBLOCK && jt != JobType.CSV_REBLOCK && jt != JobType.DATAGEN) {
            void var32_38;
            boolean bl = false;
            while (var32_38 < inputInfos.size()) {
                if (inputInfos.get((int)var32_38) == InputInfo.BinaryCellInputInfo || inputInfos.get((int)var32_38) == InputInfo.TextCellInputInfo) {
                    cellModeOverride = true;
                }
                ++var32_38;
            }
        }
        if (!recordReaderInstructions.isEmpty() || jt == JobType.GROUPED_AGG) {
            cellModeOverride = true;
        }
        boolean bl = false;
        while (var32_40 < rootNodes.size()) {
            this.getMapperInstructions(rootNodes.get((int)var32_40), execNodes, inputs, mapperInstructions, nodeIndexMapping, start_index, inputLabels, inputLops, MRJobLineNumbers);
            ++var32_40;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("    Input strings: " + inputs.toString()));
            if (jt == JobType.DATAGEN) {
                LOG.trace((Object)("    Rand instructions: " + Dag.getCSVString(randInstructions)));
            }
            if (jt == JobType.GMR) {
                LOG.trace((Object)("    RecordReader instructions: " + Dag.getCSVString(recordReaderInstructions)));
            }
            LOG.trace((Object)("    Mapper instructions: " + Dag.getCSVString(mapperInstructions)));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> aggInstructionsReducer = new ArrayList<String>();
        ArrayList<String> otherInstructionsReducer = new ArrayList<String>();
        for (Lop rn : rootNodes) {
            NodeOutput out;
            int resultIndex = this.getAggAndOtherInstructions(rn, execNodes, arrayList, aggInstructionsReducer, otherInstructionsReducer, nodeIndexMapping, start_index, inputLabels, inputLops, MRJobLineNumbers);
            if (resultIndex == -1) {
                throw new LopsException("Unexpected error in piggybacking!");
            }
            if (rn.getExecLocation() == LopProperties.ExecLocation.Data && ((Data)rn).getOperationType() == Data.OperationTypes.WRITE && ((Data)rn).isTransient() && rootNodes.contains(rn.getInputs().get(0))) {
                out = this.setupNodeOutputs(rn, LopProperties.ExecType.MR, cellModeOverride, true);
                writeinst.addAll(out.getLastInstructions());
                continue;
            }
            resultIndices.add((byte)resultIndex);
            out = this.setupNodeOutputs(rn, LopProperties.ExecType.MR, cellModeOverride, false);
            outputLabels.add(out.getVarName());
            outputs.add(out.getFileName());
            outputInfos.add(out.getOutInfo());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("    Output Info: " + out.getFileName() + ";" + OutputInfo.outputInfoToString(out.getOutInfo()) + ";" + out.getVarName()));
            }
            renameInstructions.addAll(out.getLastInstructions());
            variableInstructions.addAll(out.getPreInstructions());
            postInstructions.addAll(out.getPostInstructions());
        }
        byte[] resultIndicesByte = new byte[resultIndices.size()];
        for (int i = 0; i < resultIndicesByte.length; ++i) {
            resultIndicesByte[i] = (Byte)resultIndices.get(i);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("    Shuffle Instructions: " + Dag.getCSVString(arrayList)));
            LOG.trace((Object)("    Aggregate Instructions: " + Dag.getCSVString(aggInstructionsReducer)));
            LOG.trace((Object)("    Other instructions =" + Dag.getCSVString(otherInstructionsReducer)));
            LOG.trace((Object)("    Output strings: " + outputs.toString()));
            LOG.trace((Object)("    ResultIndices = " + resultIndices.toString()));
        }
        MRJobInstruction mr = new MRJobInstruction(jt);
        if (!(arrayList.isEmpty() && aggInstructionsReducer.isEmpty() && otherInstructionsReducer.isEmpty())) {
            numReducers = this.total_reducers;
        }
        mr.setInputOutputLabels(inputLabels.toArray(new String[0]), outputLabels.toArray(new String[0]));
        mr.setOutputs(resultIndicesByte);
        mr.setDimsUnknownFilePrefix(this.getFilePath());
        mr.setNumberOfReducers(numReducers);
        mr.setReplication(replication);
        mr.setRecordReaderInstructions(Dag.getCSVString(recordReaderInstructions));
        mr.setMapperInstructions(Dag.getCSVString(mapperInstructions));
        if (jt == JobType.GMR) {
            double mem = 0.0;
            for (Lop n : execNodes) {
                mem += Dag.computeFootprintInMapper(n);
            }
            mr.setMemoryRequirements(mem);
        }
        if (jt == JobType.DATAGEN) {
            mr.setRandInstructions(Dag.getCSVString(randInstructions));
        }
        mr.setShuffleInstructions(Dag.getCSVString(arrayList));
        mr.setAggregateInstructionsInReducer(Dag.getCSVString(aggInstructionsReducer));
        mr.setOtherInstructionsInReducer(Dag.getCSVString(otherInstructionsReducer));
        if (DMLScript.ENABLE_DEBUG_MODE) {
            mr.setMRJobInstructionsLineNumbers(MRJobLineNumbers);
        }
        inst.addAll(variableInstructions);
        inst.add(mr);
        inst.addAll(postInstructions);
        deleteinst.addAll(renameInstructions);
        for (Lop l : inputLops) {
            if (DMLScript.ENABLE_DEBUG_MODE) {
                Dag.processConsumers(l, rmvarinst, deleteinst, l);
                continue;
            }
            Dag.processConsumers(l, rmvarinst, deleteinst, null);
        }
    }

    private static String getCSVString(List<String> inputStrings) {
        StringBuilder sb = new StringBuilder();
        for (String str : inputStrings) {
            if (str == null) continue;
            if (sb.length() > 0) {
                sb.append("\u2021");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    private int getAggAndOtherInstructions(Lop node, List<Lop> execNodes, List<String> shuffleInstructions, List<String> aggInstructionsReducer, List<String> otherInstructionsReducer, Map<Lop, Integer> nodeIndexMapping, int[] start_index, List<String> inputLabels, List<Lop> inputLops, List<Integer> MRJobLineNumbers) {
        int ret_val = -1;
        if (nodeIndexMapping.containsKey(node)) {
            return nodeIndexMapping.get(node);
        }
        if (!execNodes.contains(node)) {
            return ret_val;
        }
        ArrayList<Integer> inputIndices = new ArrayList<Integer>();
        if (node.getType() == Lop.Type.Data && ((Data)node).getOperationType() == Data.OperationTypes.WRITE) {
            ret_val = this.getAggAndOtherInstructions(node.getInputs().get(0), execNodes, shuffleInstructions, aggInstructionsReducer, otherInstructionsReducer, nodeIndexMapping, start_index, inputLabels, inputLops, MRJobLineNumbers);
            inputIndices.add(ret_val);
        } else {
            for (Lop cnode : node.getInputs()) {
                ret_val = this.getAggAndOtherInstructions(cnode, execNodes, shuffleInstructions, aggInstructionsReducer, otherInstructionsReducer, nodeIndexMapping, start_index, inputLabels, inputLops, MRJobLineNumbers);
                inputIndices.add(ret_val);
            }
        }
        if (node.getExecLocation() == LopProperties.ExecLocation.Data) {
            if (((Data)node).getFileFormatType() == Hop.FileFormatTypes.CSV) {
                int output_index = start_index[0];
                shuffleInstructions.add(node.getInstructions((Integer)inputIndices.get(0), output_index));
                if (DMLScript.ENABLE_DEBUG_MODE) {
                    MRJobLineNumbers.add(node._beginLine);
                }
                nodeIndexMapping.put(node, output_index);
                start_index[0] = start_index[0] + 1;
                return output_index;
            }
            return ret_val;
        }
        if (node.getExecLocation() == LopProperties.ExecLocation.MapAndReduce) {
            boolean instGenerated = true;
            int output_index = start_index[0];
            switch (node.getType()) {
                case ReBlock: 
                case CSVReBlock: 
                case SortKeys: 
                case CentralMoment: 
                case CoVariance: 
                case GroupedAgg: 
                case DataPartition: {
                    shuffleInstructions.add(node.getInstructions((Integer)inputIndices.get(0), output_index));
                    if (!DMLScript.ENABLE_DEBUG_MODE) break;
                    MRJobLineNumbers.add(node._beginLine);
                    break;
                }
                case ParameterizedBuiltin: {
                    break;
                }
                case MMCJ: 
                case MMRJ: 
                case CombineBinary: {
                    shuffleInstructions.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), output_index));
                    if (!DMLScript.ENABLE_DEBUG_MODE) break;
                    MRJobLineNumbers.add(node._beginLine);
                    break;
                }
                case CombineTernary: {
                    shuffleInstructions.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), output_index));
                    if (!DMLScript.ENABLE_DEBUG_MODE) break;
                    MRJobLineNumbers.add(node._beginLine);
                    break;
                }
                default: {
                    instGenerated = false;
                }
            }
            if (instGenerated) {
                nodeIndexMapping.put(node, output_index);
                start_index[0] = start_index[0] + 1;
                return output_index;
            }
            return (Integer)inputIndices.get(0);
        }
        if (node.getExecLocation() == LopProperties.ExecLocation.Reduce || node.getExecLocation() == LopProperties.ExecLocation.MapOrReduce || this.hasChildNode(node, execNodes, LopProperties.ExecLocation.MapAndReduce)) {
            if (inputIndices.size() == 1) {
                int output_index = start_index[0];
                start_index[0] = start_index[0] + 1;
                if (node.getType() == Lop.Type.Aggregate) {
                    aggInstructionsReducer.add(node.getInstructions((Integer)inputIndices.get(0), output_index));
                    if (DMLScript.ENABLE_DEBUG_MODE) {
                        MRJobLineNumbers.add(node._beginLine);
                    }
                } else {
                    otherInstructionsReducer.add(node.getInstructions((Integer)inputIndices.get(0), output_index));
                }
                if (DMLScript.ENABLE_DEBUG_MODE) {
                    MRJobLineNumbers.add(node._beginLine);
                }
                nodeIndexMapping.put(node, output_index);
                return output_index;
            }
            if (inputIndices.size() == 2) {
                int output_index = start_index[0];
                start_index[0] = start_index[0] + 1;
                otherInstructionsReducer.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), output_index));
                if (DMLScript.ENABLE_DEBUG_MODE) {
                    MRJobLineNumbers.add(node._beginLine);
                }
                nodeIndexMapping.put(node, output_index);
                if (node instanceof Unary && node.getInputs().size() > 1) {
                    int index = 0;
                    for (int i = 0; i < node.getInputs().size(); ++i) {
                        if (node.getInputs().get(i).getDataType() != Expression.DataType.SCALAR) continue;
                        index = i;
                        break;
                    }
                    if (node.getInputs().get(index).getExecLocation() == LopProperties.ExecLocation.Data && !((Data)node.getInputs().get(index)).isLiteral()) {
                        inputLabels.add(node.getInputs().get(index).getOutputParameters().getLabel());
                        inputLops.add(node.getInputs().get(index));
                    }
                    if (node.getInputs().get(index).getExecLocation() != LopProperties.ExecLocation.Data) {
                        inputLabels.add(node.getInputs().get(index).getOutputParameters().getLabel());
                        inputLops.add(node.getInputs().get(index));
                    }
                }
                return output_index;
            }
            if (inputIndices.size() == 3 || node.getType() == Lop.Type.Ctable) {
                int output_index = start_index[0];
                start_index[0] = start_index[0] + 1;
                if (node.getType() == Lop.Type.Ctable) {
                    otherInstructionsReducer.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), output_index));
                    if (DMLScript.ENABLE_DEBUG_MODE) {
                        MRJobLineNumbers.add(node._beginLine);
                    }
                    nodeIndexMapping.put(node, output_index);
                } else if (node.getType() == Lop.Type.ParameterizedBuiltin) {
                    otherInstructionsReducer.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), output_index));
                    if (DMLScript.ENABLE_DEBUG_MODE) {
                        MRJobLineNumbers.add(node._beginLine);
                    }
                    nodeIndexMapping.put(node, output_index);
                } else {
                    otherInstructionsReducer.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), output_index));
                    if (DMLScript.ENABLE_DEBUG_MODE) {
                        MRJobLineNumbers.add(node._beginLine);
                    }
                    nodeIndexMapping.put(node, output_index);
                }
                return output_index;
            }
            if (inputIndices.size() == 4 || inputIndices.size() == 5) {
                int output_index = start_index[0];
                start_index[0] = start_index[0] + 1;
                if (inputIndices.size() == 4) {
                    otherInstructionsReducer.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), (Integer)inputIndices.get(3), output_index));
                } else {
                    otherInstructionsReducer.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), (Integer)inputIndices.get(3), (Integer)inputIndices.get(4), output_index));
                }
                if (DMLScript.ENABLE_DEBUG_MODE) {
                    MRJobLineNumbers.add(node._beginLine);
                }
                nodeIndexMapping.put(node, output_index);
                return output_index;
            }
            throw new LopsException("Invalid number of inputs to a lop: " + inputIndices.size());
        }
        return -1;
    }

    private static int getRecordReaderInstructions(Lop node, List<Lop> execNodes, List<String> inputStrings, List<String> recordReaderInstructions, Map<Lop, Integer> nodeIndexMapping, int[] start_index, List<String> inputLabels, List<Lop> inputLops, List<Integer> MRJobLineNumbers) {
        if (nodeIndexMapping.containsKey(node)) {
            return nodeIndexMapping.get(node);
        }
        if (!execNodes.contains(node)) {
            return -1;
        }
        ArrayList<Integer> inputIndices = new ArrayList<Integer>();
        int max_input_index = -1;
        for (int i = 0; i < node.getInputs().size(); ++i) {
            Lop childNode = node.getInputs().get(i);
            int ret_val = Dag.getRecordReaderInstructions(childNode, execNodes, inputStrings, recordReaderInstructions, nodeIndexMapping, start_index, inputLabels, inputLops, MRJobLineNumbers);
            inputIndices.add(ret_val);
            if (ret_val <= max_input_index) continue;
            max_input_index = ret_val;
        }
        if (node.getExecLocation() == LopProperties.ExecLocation.RecordReader) {
            PickByCount pbc;
            int output_index = max_input_index;
            output_index = start_index[0];
            start_index[0] = start_index[0] + 1;
            nodeIndexMapping.put(node, output_index);
            if (node.getType() == Lop.Type.PickValues && (pbc = (PickByCount)node).getOperationType() == PickByCount.OperationTypes.RANGEPICK) {
                int scalarIndex = 1;
                if (node.getInputs().get(scalarIndex).getExecLocation() == LopProperties.ExecLocation.Data && !((Data)node.getInputs().get(scalarIndex)).isLiteral()) {
                    inputLabels.add(node.getInputs().get(scalarIndex).getOutputParameters().getLabel());
                    inputLops.add(node.getInputs().get(scalarIndex));
                }
                if (node.getInputs().get(scalarIndex).getExecLocation() != LopProperties.ExecLocation.Data) {
                    inputLabels.add(node.getInputs().get(scalarIndex).getOutputParameters().getLabel());
                    inputLops.add(node.getInputs().get(scalarIndex));
                }
            }
            if (node.getInputs().size() == 2) {
                recordReaderInstructions.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), output_index));
                if (DMLScript.ENABLE_DEBUG_MODE) {
                    MRJobLineNumbers.add(node._beginLine);
                }
            } else {
                throw new LopsException("Unexpected number of inputs while generating a RecordReader Instruction");
            }
            return output_index;
        }
        return -1;
    }

    private int getMapperInstructions(Lop node, List<Lop> execNodes, List<String> inputStrings, List<String> instructionsInMapper, Map<Lop, Integer> nodeIndexMapping, int[] start_index, List<String> inputLabels, List<Lop> inputLops, List<Integer> MRJobLineNumbers) {
        if (nodeIndexMapping.containsKey(node)) {
            return nodeIndexMapping.get(node);
        }
        if (!execNodes.contains(node)) {
            return -1;
        }
        ArrayList<Integer> inputIndices = new ArrayList<Integer>();
        int max_input_index = -1;
        for (Lop childNode : node.getInputs()) {
            int ret_val = this.getMapperInstructions(childNode, execNodes, inputStrings, instructionsInMapper, nodeIndexMapping, start_index, inputLabels, inputLops, MRJobLineNumbers);
            inputIndices.add(ret_val);
            if (ret_val <= max_input_index) continue;
            max_input_index = ret_val;
        }
        if (!(node.getExecLocation() != LopProperties.ExecLocation.Map && node.getExecLocation() != LopProperties.ExecLocation.MapOrReduce || this.hasChildNode(node, execNodes, LopProperties.ExecLocation.MapAndReduce) || this.hasChildNode(node, execNodes, LopProperties.ExecLocation.Reduce))) {
            int output_index = max_input_index;
            output_index = start_index[0];
            start_index[0] = start_index[0] + 1;
            nodeIndexMapping.put(node, output_index);
            if (node instanceof Unary && node.getInputs().size() > 1) {
                int index = 0;
                for (int i1 = 0; i1 < node.getInputs().size(); ++i1) {
                    if (node.getInputs().get(i1).getDataType() != Expression.DataType.SCALAR) continue;
                    index = i1;
                    break;
                }
                if (node.getInputs().get(index).getExecLocation() == LopProperties.ExecLocation.Data && !((Data)node.getInputs().get(index)).isLiteral()) {
                    inputLabels.add(node.getInputs().get(index).getOutputParameters().getLabel());
                    inputLops.add(node.getInputs().get(index));
                }
                if (node.getInputs().get(index).getExecLocation() != LopProperties.ExecLocation.Data) {
                    inputLabels.add(node.getInputs().get(index).getOutputParameters().getLabel());
                    inputLops.add(node.getInputs().get(index));
                }
            }
            if (node.getInputs().size() == 1) {
                instructionsInMapper.add(node.getInstructions((Integer)inputIndices.get(0), output_index));
            } else if (node.getInputs().size() == 2) {
                instructionsInMapper.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), output_index));
            } else if (node.getInputs().size() == 3) {
                instructionsInMapper.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), output_index));
            } else if (node.getInputs().size() == 4) {
                instructionsInMapper.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), (Integer)inputIndices.get(3), output_index));
            } else if (node.getInputs().size() == 5) {
                instructionsInMapper.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), (Integer)inputIndices.get(3), (Integer)inputIndices.get(4), output_index));
            } else if (node.getInputs().size() == 7) {
                instructionsInMapper.add(node.getInstructions((Integer)inputIndices.get(0), (Integer)inputIndices.get(1), (Integer)inputIndices.get(2), (Integer)inputIndices.get(3), (Integer)inputIndices.get(4), (Integer)inputIndices.get(5), (Integer)inputIndices.get(6), output_index));
            } else {
                throw new LopsException("Node with " + node.getInputs().size() + " inputs is not supported in dag.java.");
            }
            if (DMLScript.ENABLE_DEBUG_MODE) {
                MRJobLineNumbers.add(node._beginLine);
            }
            return output_index;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void getInputPathsAndParameters(Lop node, List<Lop> execNodes, List<String> inputStrings, List<InputInfo> inputInfos, List<Long> numRows, List<Long> numCols, List<Long> numRowsPerBlock, List<Long> numColsPerBlock, Map<Lop, Integer> nodeIndexMapping, List<String> inputLabels, List<Lop> inputLops, List<Integer> MRJobLineNumbers) {
        if (node.getType() == Lop.Type.DataGen && execNodes.contains(node) && !nodeIndexMapping.containsKey(node)) {
            numRows.add(node.getOutputParameters().getNumRows());
            numCols.add(node.getOutputParameters().getNumCols());
            numRowsPerBlock.add(node.getOutputParameters().getRowsInBlock());
            numColsPerBlock.add(node.getOutputParameters().getColsInBlock());
            inputStrings.add(node.getInstructions(inputStrings.size(), inputStrings.size()));
            if (DMLScript.ENABLE_DEBUG_MODE) {
                MRJobLineNumbers.add(node._beginLine);
            }
            inputInfos.add(InputInfo.TextCellInputInfo);
            nodeIndexMapping.put(node, inputStrings.size() - 1);
            return;
        }
        if (!execNodes.contains(node) && !nodeIndexMapping.containsKey(node) && node.getExecLocation() != LopProperties.ExecLocation.Data && (node.getExecLocation() != LopProperties.ExecLocation.ControlProgram || node.getDataType() != Expression.DataType.SCALAR) || !execNodes.contains(node) && node.getExecLocation() == LopProperties.ExecLocation.Data && ((Data)node).getOperationType() == Data.OperationTypes.READ && ((Data)node).getDataType() != Expression.DataType.SCALAR && !nodeIndexMapping.containsKey(node)) {
            if (node.getOutputParameters().getFile_name() != null) {
                inputStrings.add(node.getOutputParameters().getFile_name());
            } else {
                inputStrings.add("\u00b6" + node.getOutputParameters().getLabel() + "\u00b6");
            }
            inputLabels.add(node.getOutputParameters().getLabel());
            inputLops.add(node);
            numRows.add(node.getOutputParameters().getNumRows());
            numCols.add(node.getOutputParameters().getNumCols());
            numRowsPerBlock.add(node.getOutputParameters().getRowsInBlock());
            numColsPerBlock.add(node.getOutputParameters().getColsInBlock());
            InputInfo nodeInputInfo = null;
            if (node.getOutputParameters().isBlocked()) {
                if (node.getOutputParameters().getFormat() != OutputParameters.Format.BINARY) throw new LopsException("Invalid format (" + (Object)((Object)node.getOutputParameters().getFormat()) + ") encountered for a node/lop (ID=" + node.getID() + ") with blocked output.");
                nodeInputInfo = InputInfo.BinaryBlockInputInfo;
            } else {
                nodeInputInfo = node.getOutputParameters().getFormat() == OutputParameters.Format.TEXT ? InputInfo.TextCellInputInfo : InputInfo.BinaryCellInputInfo;
            }
            if (node.getType() == Lop.Type.SortKeys) {
                nodeInputInfo = new InputInfo(PickFromCompactInputFormat.class, DoubleWritable.class, IntWritable.class);
            } else if (node.getType() == Lop.Type.CombineBinary) {
                CombineBinary combine = (CombineBinary)node;
                if (combine.getOperation() == CombineBinary.OperationTypes.PreSort) {
                    nodeInputInfo = new InputInfo(SequenceFileInputFormat.class, DoubleWritable.class, IntWritable.class);
                } else if (combine.getOperation() == CombineBinary.OperationTypes.PreCentralMoment || combine.getOperation() == CombineBinary.OperationTypes.PreCovUnweighted || combine.getOperation() == CombineBinary.OperationTypes.PreGroupedAggUnweighted) {
                    nodeInputInfo = InputInfo.WeightedPairInputInfo;
                }
            } else if (node.getType() == Lop.Type.CombineTernary) {
                nodeInputInfo = InputInfo.WeightedPairInputInfo;
            }
            inputInfos.add(nodeInputInfo);
            nodeIndexMapping.put(node, inputStrings.size() - 1);
            return;
        }
        if (!execNodes.contains(node)) {
            return;
        }
        for (Lop lop : node.getInputs()) {
            Dag.getInputPathsAndParameters(lop, execNodes, inputStrings, inputInfos, numRows, numCols, numRowsPerBlock, numColsPerBlock, nodeIndexMapping, inputLabels, inputLops, MRJobLineNumbers);
        }
    }

    private static void getOutputNodes(List<Lop> execNodes, List<Lop> rootNodes, JobType jt) {
        for (Lop node : execNodes) {
            if (node.getOutputs().isEmpty() && !rootNodes.contains(node)) {
                rootNodes.add(node);
                continue;
            }
            int cnt = 0;
            for (Lop lop : node.getOutputs()) {
                cnt += !execNodes.contains(lop) ? 1 : 0;
            }
            if (cnt <= 0 || rootNodes.contains(node) || node.getExecLocation() == LopProperties.ExecLocation.Data && ((Data)node).getOperationType() == Data.OperationTypes.READ && ((Data)node).getDataType() == Expression.DataType.MATRIX || jt.allowsSingleShuffleInstruction() && node.getExecLocation() != LopProperties.ExecLocation.MapAndReduce) continue;
            if (cnt < node.getOutputs().size()) {
                if (node.getProducesIntermediateOutput()) continue;
                rootNodes.add(node);
                continue;
            }
            rootNodes.add(node);
        }
    }

    private static boolean isChild(Lop a, Lop b, Map<Long, Integer> IDMap) {
        int bID = IDMap.get(b.getID());
        return a.getReachable()[bID];
    }

    private void dagDFS(Lop root, boolean[] marked) {
        if (!this.IDMap.containsKey(root.getID())) {
            return;
        }
        int mapID = this.IDMap.get(root.getID());
        if (marked[mapID]) {
            return;
        }
        marked[mapID] = true;
        for (Lop lop : root.getOutputs()) {
            this.dagDFS(lop, marked);
        }
    }

    private static boolean hasDirectChildNode(Lop node, List<Lop> childNodes) {
        if (childNodes.isEmpty()) {
            return false;
        }
        for (Lop cnode : childNodes) {
            if (!cnode.getOutputs().contains(node)) continue;
            return true;
        }
        return false;
    }

    private boolean hasChildNode(Lop node, List<Lop> nodes) {
        return this.hasChildNode(node, nodes, LopProperties.ExecLocation.INVALID);
    }

    private boolean hasChildNode(Lop node, List<Lop> childNodes, LopProperties.ExecLocation type) {
        if (childNodes.isEmpty()) {
            return false;
        }
        int index = this.IDMap.get(node.getID());
        for (Lop cnode : childNodes) {
            if (type != LopProperties.ExecLocation.INVALID && cnode.getExecLocation() != type || !cnode.getReachable()[index]) continue;
            return true;
        }
        return false;
    }

    private Lop getChildNode(Lop node, List<Lop> childNodes, LopProperties.ExecLocation type) {
        if (childNodes.isEmpty()) {
            return null;
        }
        int index = this.IDMap.get(node.getID());
        for (Lop cnode : childNodes) {
            if (cnode.getExecLocation() != type || !cnode.getReachable()[index]) continue;
            return cnode;
        }
        return null;
    }

    private Lop getParentNode(Lop node, List<Lop> parentNodes, LopProperties.ExecLocation type) {
        if (parentNodes.isEmpty()) {
            return null;
        }
        for (Lop pn : parentNodes) {
            int index = this.IDMap.get(pn.getID());
            if (pn.getExecLocation() != type || !node.getReachable()[index]) continue;
            return pn;
        }
        return null;
    }

    private boolean hasMRJobChildNode(Lop node, List<Lop> nodesVec) {
        if (nodesVec.isEmpty()) {
            return false;
        }
        int index = this.IDMap.get(node.getID());
        for (Lop n : nodesVec) {
            if (!n.definesMRJob() || !n.getReachable()[index]) continue;
            return true;
        }
        return false;
    }

    private boolean checkDataGenAsChildNode(Lop node, List<Lop> nodesVec) {
        if (nodesVec.isEmpty()) {
            return true;
        }
        int index = this.IDMap.get(node.getID());
        boolean onlyDatagen = true;
        for (Lop n : nodesVec) {
            if (!n.definesMRJob() || !n.getReachable()[index] || JobType.findJobTypeFromLop(n) == JobType.DATAGEN) continue;
            onlyDatagen = false;
        }
        return onlyDatagen;
    }

    private static int getChildAlignment(Lop node, List<Lop> execNodes, LopProperties.ExecLocation type) {
        for (Lop n : node.getInputs()) {
            if (!execNodes.contains(n)) continue;
            if (execNodes.contains(n) && n.getExecLocation() == type) {
                if (n.getBreaksAlignment()) {
                    return 4;
                }
                return 5;
            }
            int ret = Dag.getChildAlignment(n, execNodes, type);
            if (ret == 5 || ret == 1) {
                if (n.getBreaksAlignment()) {
                    return 2;
                }
                return 1;
            }
            if (ret == 0 || ret == 2 || ret == 4) {
                return ret;
            }
            throw new RuntimeException("Something wrong in getChildAlignment().");
        }
        return 0;
    }

    private boolean hasParentNode(Lop node, List<Lop> parentNodes) {
        if (parentNodes.isEmpty()) {
            return false;
        }
        for (Lop pnode : parentNodes) {
            int index = this.IDMap.get(pnode.getID());
            if (!node.getReachable()[index]) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<Instruction> cleanupInstructions(List<Instruction> insts) {
        List<Instruction> tmp1 = Dag.collapseAssignvarAndRmvarInstructions(insts);
        ArrayList<Instruction> tmp2 = Dag.createPackedRmvarInstructions(tmp1);
        return tmp2;
    }

    private static List<Instruction> collapseAssignvarAndRmvarInstructions(List<Instruction> insts) {
        ArrayList<Instruction> ret = new ArrayList<Instruction>();
        Iterator<Instruction> iter = insts.iterator();
        while (iter.hasNext()) {
            Instruction inst = iter.next();
            if (iter.hasNext() && inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).isAssignVariable()) {
                VariableCPInstruction inst1 = (VariableCPInstruction)inst;
                Instruction inst2 = iter.next();
                if (inst2 instanceof VariableCPInstruction && ((VariableCPInstruction)inst2).isRemoveVariableNoFile() && inst1.getInput1().getName().equals(((VariableCPInstruction)inst2).getInput1().getName())) {
                    ret.add(VariableCPInstruction.prepareMoveInstruction(inst1.getInput1().getName(), inst1.getInput2().getName()));
                    continue;
                }
                ret.add(inst1);
                ret.add(inst2);
                continue;
            }
            ret.add(inst);
        }
        return ret;
    }

    private static ArrayList<Instruction> createPackedRmvarInstructions(List<Instruction> insts) {
        ArrayList<Instruction> ret = new ArrayList<Instruction>();
        ArrayList<String> currRmVar = new ArrayList<String>();
        for (Instruction inst : insts) {
            if (inst instanceof VariableCPInstruction && ((VariableCPInstruction)inst).isRemoveVariableNoFile()) {
                currRmVar.add(((VariableCPInstruction)inst).getInput1().getName());
                continue;
            }
            if (!currRmVar.isEmpty()) {
                ret.add(VariableCPInstruction.prepareRemoveInstruction(currRmVar.toArray(new String[0])));
                currRmVar.clear();
            }
            ret.add(inst);
        }
        if (!currRmVar.isEmpty()) {
            ret.add(VariableCPInstruction.prepareRemoveInstruction(currRmVar.toArray(new String[0])));
        }
        return ret;
    }

    static {
        job_id = new IDSequence();
        var_index = new IDSequence();
    }

    private static class NodeOutput {
        String fileName = null;
        String varName = null;
        OutputInfo outInfo = null;
        ArrayList<Instruction> preInstructions = new ArrayList();
        ArrayList<Instruction> postInstructions = new ArrayList();
        ArrayList<Instruction> lastInstructions = new ArrayList();

        NodeOutput() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }

        public OutputInfo getOutInfo() {
            return this.outInfo;
        }

        public void setOutInfo(OutputInfo outInfo) {
            this.outInfo = outInfo;
        }

        public ArrayList<Instruction> getPreInstructions() {
            return this.preInstructions;
        }

        public void addPreInstruction(Instruction inst) {
            this.preInstructions.add(inst);
        }

        public ArrayList<Instruction> getPostInstructions() {
            return this.postInstructions;
        }

        public void addPostInstruction(Instruction inst) {
            this.postInstructions.add(inst);
        }

        public ArrayList<Instruction> getLastInstructions() {
            return this.lastInstructions;
        }

        public void addLastInstruction(Instruction inst) {
            this.lastInstructions.add(inst);
        }
    }
}

