/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.parser;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.AdhocSubProcess;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Transaction;

public class SubProcessParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, List<SubProcess> activeSubProcessList, Process activeProcess) {
        Object subProcess = null;
        if ("transaction".equalsIgnoreCase(xtr.getLocalName())) {
            subProcess = new Transaction();
        } else if ("adHocSubProcess".equalsIgnoreCase(xtr.getLocalName())) {
            AdhocSubProcess adhocSubProcess = new AdhocSubProcess();
            String orderingAttributeValue = xtr.getAttributeValue(null, "ordering");
            if (StringUtils.isNotEmpty((CharSequence)orderingAttributeValue)) {
                adhocSubProcess.setOrdering(orderingAttributeValue);
            }
            if ("false".equalsIgnoreCase(xtr.getAttributeValue(null, "cancelRemainingInstances"))) {
                adhocSubProcess.setCancelRemainingInstances(false);
            }
            subProcess = adhocSubProcess;
        } else {
            subProcess = "true".equalsIgnoreCase(xtr.getAttributeValue(null, "triggeredByEvent")) ? new EventSubProcess() : new SubProcess();
        }
        BpmnXMLUtil.addXMLLocation((BaseElement)subProcess, xtr);
        activeSubProcessList.add((SubProcess)subProcess);
        subProcess.setId(xtr.getAttributeValue(null, "id"));
        subProcess.setName(xtr.getAttributeValue(null, "name"));
        boolean async = false;
        String asyncString = BpmnXMLUtil.getAttributeValue("async", xtr);
        if ("true".equalsIgnoreCase(asyncString)) {
            async = true;
        }
        boolean notExclusive = false;
        String exclusiveString = BpmnXMLUtil.getAttributeValue("exclusive", xtr);
        if ("false".equalsIgnoreCase(exclusiveString)) {
            notExclusive = true;
        }
        boolean asyncLeave = false;
        String asyncLeaveString = BpmnXMLUtil.getAttributeValue("asyncLeave", xtr);
        if ("true".equalsIgnoreCase(asyncLeaveString)) {
            asyncLeave = true;
        }
        boolean asyncLeaveNotExclusive = false;
        String asyncLeaveExclusiveString = BpmnXMLUtil.getAttributeValue("asyncLeaveExclusive", xtr);
        if ("false".equalsIgnoreCase(asyncLeaveExclusiveString)) {
            asyncLeaveNotExclusive = true;
        }
        boolean forCompensation = false;
        String compensationString = xtr.getAttributeValue(null, "isForCompensation");
        if ("true".equalsIgnoreCase(compensationString)) {
            forCompensation = true;
        }
        subProcess.setAsynchronous(async);
        subProcess.setNotExclusive(notExclusive);
        subProcess.setAsynchronousLeave(asyncLeave);
        subProcess.setAsynchronousLeaveNotExclusive(asyncLeaveNotExclusive);
        subProcess.setForCompensation(forCompensation);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "default"))) {
            subProcess.setDefaultFlow(xtr.getAttributeValue(null, "default"));
        }
        if (activeSubProcessList.size() > 1) {
            SubProcess parentSubProcess = activeSubProcessList.get(activeSubProcessList.size() - 2);
            parentSubProcess.addFlowElement((FlowElement)subProcess);
        } else {
            activeProcess.addFlowElement((FlowElement)subProcess);
        }
    }
}

