/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.SRARouteWizardBuilder;
import org.apache.syncope.client.console.rest.SRARouteRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class SRARouteDirectoryPanel
extends DirectoryPanel<SRARouteTO, SRARouteTO, SRARouteProvider, SRARouteRestClient> {
    private static final long serialVersionUID = -2334397933375604015L;

    public SRARouteDirectoryPanel(String id, SRARouteRestClient restClient, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef);
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Large);
        this.modal.addSubmitButton();
        this.setWindowClosedReloadCallback(this.modal, true);
        this.addNewItemPanelBuilder((ModalPanelBuilder)new SRARouteWizardBuilder(new SRARouteTO(), restClient, pageRef), true);
        this.initResultTable();
    }

    protected List<IColumn<SRARouteTO, String>> getColumns() {
        ArrayList<IColumn<SRARouteTO, String>> columns = new ArrayList<IColumn<SRARouteTO, String>>();
        columns.add((IColumn<SRARouteTO, String>)new KeyPropertyColumn((IModel)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<SRARouteTO, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<SRARouteTO, String>)new PropertyColumn((IModel)new StringResourceModel("target", (Component)this), (Object)"target", "target"));
        columns.add((IColumn<SRARouteTO, String>)new PropertyColumn((IModel)new StringResourceModel("type", (Component)this), (Object)"type", "type"));
        columns.add((IColumn<SRARouteTO, String>)new BooleanPropertyColumn((IModel)new StringResourceModel("logout", (Component)this), "logout", "logout"));
        columns.add((IColumn<SRARouteTO, String>)new BooleanPropertyColumn((IModel)new StringResourceModel("csrf", (Component)this), "csrf", "csrf"));
        columns.add((IColumn<SRARouteTO, String>)new PropertyColumn((IModel)new StringResourceModel("order", (Component)this), (Object)"order", "order"));
        return columns;
    }

    protected ActionsPanel<SRARouteTO> getActions(final IModel<SRARouteTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<SRARouteTO>(){
            private static final long serialVersionUID = -4608353559809323466L;

            public void onClick(AjaxRequestTarget target, SRARouteTO ignore) {
                SRARouteDirectoryPanel.this.send((IEventSink)SRARouteDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((SRARouteRestClient)SRARouteDirectoryPanel.this.restClient).read(((SRARouteTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "SRA_ROUTE_UPDATE");
        panel.add((ActionLink)new ActionLink<SRARouteTO>(){
            private static final long serialVersionUID = -4608353559809323466L;

            public void onClick(AjaxRequestTarget target, SRARouteTO ignore) {
                SRARouteTO clone = (SRARouteTO)SerializationUtils.clone((Serializable)((SRARouteTO)model.getObject()));
                clone.setKey(null);
                SRARouteDirectoryPanel.this.send((IEventSink)SRARouteDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)clone, target));
            }
        }, ActionLink.ActionType.CLONE, "SRA_ROUTE_CREATE");
        panel.add((ActionLink)new ActionLink<SRARouteTO>(){
            private static final long serialVersionUID = -4608353559809323466L;

            public void onClick(AjaxRequestTarget target, SRARouteTO ignore) {
                SRARouteTO route = (SRARouteTO)model.getObject();
                try {
                    ((SRARouteRestClient)SRARouteDirectoryPanel.this.restClient).delete(route.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)SRARouteDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{SRARouteDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)route.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)SRARouteDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "SRA_ROUTE_DELETE", true);
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected SRARouteProvider dataProvider() {
        return new SRARouteProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "gatewayroute.paginator.rows";
    }

    protected final class SRARouteProvider
    extends DirectoryDataProvider<SRARouteTO> {
        private static final long serialVersionUID = 5282134321828253058L;
        private final SortableDataProviderComparator<SRARouteTO> comparator;

        public SRARouteProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<? extends SRARouteTO> iterator(long first, long count) {
            List<SRARouteTO> list = ((SRARouteRestClient)SRARouteDirectoryPanel.this.restClient).list();
            list.sort((Comparator<SRARouteTO>)this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((SRARouteRestClient)SRARouteDirectoryPanel.this.restClient).list().size();
        }

        public IModel<SRARouteTO> model(SRARouteTO route) {
            return new CompoundPropertyModel((Object)route);
        }
    }
}

