/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.table.sort;

import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByLink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.border.Border;

public abstract class BootstrapOrderByBorder<S>
extends Border {
    private static final long serialVersionUID = 1L;

    public BootstrapOrderByBorder(String id, S property, ISortStateLocator<S> stateLocator) {
        super(id);
        OrderByLink<S> link = this.newOrderByLink("orderByLink", property, stateLocator);
        link.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"show"))});
        this.addToBorder(new Component[]{link});
        WebMarkupContainer iconSort = new WebMarkupContainer("iconSort");
        iconSort.setVisible(false);
        link.add(new Component[]{iconSort});
        SortOrder sortOrder = stateLocator.getSortState().getPropertySortOrder(property);
        if (SortOrder.ASCENDING == sortOrder && this.ascendingIconType() != null) {
            iconSort.setVisible(true);
            iconSort.add(new Behavior[]{new IconBehavior(this.ascendingIconType())});
        } else if (SortOrder.DESCENDING == sortOrder && this.descendingIconType() != null) {
            iconSort.setVisible(true);
            iconSort.add(new Behavior[]{new IconBehavior(this.descendingIconType())});
        } else if (this.unsortedIconType() != null) {
            iconSort.setVisible(true);
            iconSort.add(new Behavior[]{new IconBehavior(this.unsortedIconType())});
        }
    }

    protected OrderByLink<S> newOrderByLink(String id, S property, ISortStateLocator<S> stateLocator) {
        return new OrderByLink<S>(id, property, stateLocator){
            private static final long serialVersionUID = 1L;

            protected void onSortChanged() {
                BootstrapOrderByBorder.this.onSortChanged();
            }
        };
    }

    protected void onSortChanged() {
    }

    protected abstract IconType ascendingIconType();

    protected abstract IconType descendingIconType();

    protected abstract IconType unsortedIconType();
}

