/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.util.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.sling.distribution.util.impl.ByteBufferBackedInputStream;

public class FileBackedMemoryOutputStream
extends OutputStream {
    private int memorySize = -1;
    private final ByteBuffer memory;
    private final File tempDirectory;
    private final String fileName;
    private final String fileExtension;
    private FileOutputStream out;
    private File file;

    public FileBackedMemoryOutputStream(int fileThreshold, MemoryUnit memoryUnit, boolean useOffHeapMemory, File tempDirectory, String fileName, String fileExtension) {
        if (fileThreshold < 0) {
            throw new IllegalArgumentException("Negative fileThreshold size has no semantic in this version.");
        }
        int threshold = fileThreshold * memoryUnit.memoryFactor;
        this.memory = useOffHeapMemory ? ByteBuffer.allocateDirect(threshold) : ByteBuffer.allocate(threshold);
        this.tempDirectory = tempDirectory;
        this.fileName = fileName;
        this.fileExtension = fileExtension;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.memory.hasRemaining()) {
            this.memory.put((byte)(b & 0xFF));
        } else {
            if (this.out == null) {
                this.file = File.createTempFile(this.fileName, this.fileExtension, this.tempDirectory);
                this.out = new FileOutputStream(this.file);
            }
            this.out.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out == null) {
            int memLen = Math.min(this.memory.remaining(), len);
            this.memory.put(b, off, memLen);
            if (len > memLen) {
                this.file = File.createTempFile(this.fileName, this.fileExtension, this.tempDirectory);
                this.out = new FileOutputStream(this.file);
                this.out.write(b, off + memLen, len - memLen);
            }
        } else {
            this.out.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    File getFile() {
        return this.file;
    }

    public long size() {
        long size;
        long l = size = this.memorySize > 0 ? (long)this.memorySize : (long)this.memory.position();
        if (this.file != null) {
            size += this.file.length();
        }
        return size;
    }

    public void clean() {
        this.memory.clear();
        this.memory.rewind();
        if (this.file != null) {
            this.file.delete();
        }
    }

    public InputStream openWrittenDataInputStream() throws IOException {
        this.memorySize = this.memory.position();
        this.memory.flip();
        return new ByteBufferBackedInputStream(this.memory, this.file);
    }

    public static enum MemoryUnit {
        BYTES(1),
        KILO_BYTES(1000),
        MEGA_BYTES((int)Math.pow(10.0, 6.0)),
        GIGA_BYTES((int)Math.pow(10.0, 9.0));

        private final int memoryFactor;

        private MemoryUnit(int memoryFactor) {
            this.memoryFactor = memoryFactor;
        }
    }
}

