/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CredentialsSupport;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.PrincipalNameResolver;
import org.apache.sling.auth.oauth_client.spi.OidcAuthCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OidcIdentityProvider
implements ExternalIdentityProvider,
PrincipalNameResolver,
CredentialsSupport {
    private final String name;

    OidcIdentityProvider(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public Set<Class> getCredentialClasses() {
        return Collections.singleton(OidcAuthCredentials.class);
    }

    @Nullable
    public String getUserId(@NotNull Credentials credentials) {
        if (this.validCredentials(credentials)) {
            return ((OidcAuthCredentials)credentials).getUserId();
        }
        return null;
    }

    @NotNull
    public Map<String, ?> getAttributes(@NotNull Credentials credentials) {
        if (this.validCredentials(credentials)) {
            return Collections.singletonMap(".token", "");
        }
        return Collections.emptyMap();
    }

    public boolean setAttributes(@NotNull Credentials credentials, @NotNull Map<String, ?> map) {
        if (this.validCredentials(credentials)) {
            OidcAuthCredentials oidcAuthCredentials = (OidcAuthCredentials)credentials;
            map.keySet().forEach(key -> oidcAuthCredentials.setAttribute((String)key, (String)map.get(key)));
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public ExternalIdentity getIdentity(@NotNull ExternalIdentityRef externalIdentityRef) {
        if (this.isSameIdp(externalIdentityRef) && externalIdentityRef instanceof OidcGroupRef) {
            return new OidcGroup(externalIdentityRef);
        }
        return null;
    }

    @Nullable
    public ExternalUser getUser(@NotNull String s) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ExternalUser authenticate(@NotNull Credentials credentials) {
        if (this.validCredentials(credentials)) {
            return new OidcUser((OidcAuthCredentials)credentials);
        }
        return null;
    }

    @Nullable
    public ExternalGroup getGroup(@NotNull String s) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Iterator<ExternalUser> listUsers() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Iterator<ExternalGroup> listGroups() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String fromExternalIdentityRef(@NotNull ExternalIdentityRef externalIdentityRef) throws ExternalIdentityException {
        if (!this.isSameIdp(externalIdentityRef)) {
            throw new ExternalIdentityException("Foreign IDP " + externalIdentityRef.getString());
        }
        return externalIdentityRef.getId();
    }

    private boolean validCredentials(@NotNull Credentials credentials) {
        if (credentials instanceof OidcAuthCredentials) {
            OidcAuthCredentials oidcAuthCredentials = (OidcAuthCredentials)credentials;
            return this.isSameIdp(oidcAuthCredentials);
        }
        return false;
    }

    private boolean isSameIdp(@NotNull OidcAuthCredentials credentials) {
        return this.name.equals(credentials.getIdp());
    }

    private boolean isSameIdp(@NotNull ExternalIdentityRef ref) {
        return this.name.equals(ref.getProviderName());
    }

    static class OidcGroupRef
    extends ExternalIdentityRef {
        private OidcGroupRef(@NotNull String id, @NotNull String idp) {
            super(id, idp);
        }
    }

    private final class OidcGroup
    extends OidcIdentity
    implements ExternalGroup {
        OidcGroup(ExternalIdentityRef ref) {
            super(ref);
        }

        @NotNull
        public Iterable<ExternalIdentityRef> getDeclaredGroups() {
            return Collections.emptyList();
        }

        @NotNull
        public Map<String, ?> getProperties() {
            return Collections.emptyMap();
        }

        @NotNull
        public Iterable<ExternalIdentityRef> getDeclaredMembers() {
            return Collections.emptyList();
        }
    }

    private final class OidcUser
    extends OidcIdentity
    implements ExternalUser {
        private final OidcAuthCredentials creds;
        private final Iterable<String> groups;

        private OidcUser(OidcAuthCredentials creds) {
            super(new ExternalIdentityRef(creds.getUserId(), creds.getIdp()));
            this.creds = creds;
            this.groups = creds.getGroups();
        }

        @NotNull
        public Iterable<ExternalIdentityRef> getDeclaredGroups() {
            ArrayList<ExternalIdentityRef> externalGroups = new ArrayList<ExternalIdentityRef>();
            this.groups.forEach(group -> externalGroups.add(new OidcGroupRef((String)group, this.creds.getIdp())));
            return externalGroups;
        }

        @NotNull
        public Map<String, ?> getProperties() {
            return this.creds.getAttributes();
        }

        @Override
        @NotNull
        public ExternalIdentityRef getExternalId() {
            return new ExternalIdentityRef(this.creds.getUserId(), this.creds.getIdp());
        }
    }

    private static abstract class OidcIdentity
    implements ExternalIdentity {
        private final ExternalIdentityRef ref;

        private OidcIdentity(@NotNull ExternalIdentityRef ref) {
            this.ref = ref;
        }

        @NotNull
        public ExternalIdentityRef getExternalId() {
            return this.ref;
        }

        @NotNull
        public String getId() {
            return this.ref.getId();
        }

        @NotNull
        public String getPrincipalName() {
            return this.getId();
        }

        @Nullable
        public String getIntermediatePath() {
            return "";
        }
    }
}

