/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.util.Arrays;
import java.util.EventListener;
import java.util.logging.Logger;
import org.apache.sis.util.ArraysExt;

public abstract class SystemListener
implements EventListener {
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.system");
    private static SystemListener[] listeners;
    private final String module;

    protected SystemListener(String module) {
        this.module = module;
    }

    public static synchronized void add(SystemListener listener) {
        assert (listener != null && !ArraysExt.contains(listeners, listener));
        SystemListener[] list = listeners;
        list = list == null ? new SystemListener[1] : Arrays.copyOf(list, list.length + 1);
        list[list.length - 1] = listener;
        listeners = list;
    }

    public static synchronized void remove(SystemListener listener) {
        SystemListener[] list = listeners;
        if (list != null) {
            int i = list.length;
            while (--i >= 0) {
                if (list[i] != listener) continue;
                list = ArraysExt.remove(list, i, 1);
            }
            listeners = list;
        }
    }

    public static synchronized void removeModule(String name) {
        SystemListener[] list;
        if (name != null && (list = listeners) != null) {
            int count = 0;
            SystemListener[] modified = new SystemListener[list.length];
            for (SystemListener listener : list) {
                if (name.equals(listener.module)) continue;
                modified[count++] = listener;
            }
            if (count != list.length) {
                listeners = Arrays.copyOf(modified, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireClasspathChanged() {
        Class<SystemListener> clazz = SystemListener.class;
        synchronized (SystemListener.class) {
            SystemListener[] list = listeners;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    list[i].classpathChanged();
                }
            }
            return;
        }
    }

    protected abstract void classpathChanged();

    protected void databaseChanged() {
    }
}

