/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.io.Serializable;
import org.apache.sis.util.ObjectConverter;

class ClassPair<S, T>
implements Serializable {
    private static final long serialVersionUID = -5214470401299470687L;
    final Class<S> sourceClass;
    final Class<T> targetClass;

    ClassPair(Class<S> sourceClass, Class<T> targetClass) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    final ClassPair<? super S, T> parentSource() {
        Class<Object> source;
        if (this.sourceClass.isInterface()) {
            Class<?>[] interfaces = this.sourceClass.getInterfaces();
            if (interfaces.length == 0) {
                return null;
            }
            source = interfaces[0];
        } else {
            source = this.sourceClass.getSuperclass();
            if (source == null) {
                return null;
            }
        }
        return new ClassPair<S, T>(source, this.targetClass);
    }

    final ObjectConverter<? super S, ? extends T> cast(ObjectConverter<?, ?> converter) {
        if (converter != null) {
            assert (converter.getSourceClass().isAssignableFrom(this.sourceClass)) : this.sourceClass;
            assert (this.targetClass.isAssignableFrom(converter.getTargetClass())) : this.targetClass;
        }
        return converter;
    }

    public boolean equals(Object other) {
        if (other instanceof ClassPair) {
            ClassPair that = (ClassPair)other;
            return this.sourceClass == that.sourceClass && this.targetClass == that.targetClass;
        }
        return false;
    }

    public final int hashCode() {
        return this.sourceClass.hashCode() + 31 * this.targetClass.hashCode();
    }

    public String toString() {
        return this.targetClass.getSimpleName() + "\u00a0\u2190\u00a0" + this.sourceClass.getSimpleName();
    }
}

