/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.css.ICSSNamespaceDefinition;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSNodeBase;
import org.apache.royale.compiler.internal.css.CSSStringPropertyValue;
import org.apache.royale.compiler.problems.CSSNamespaceEmptyURIProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class CSSNamespaceDefinition
extends CSSNodeBase
implements ICSSNamespaceDefinition {
    private final String prefix;
    private final String uri;
    private final List<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();

    protected CSSNamespaceDefinition(String prefix, String uri, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.NAMESPACE_DEFINITION);
        assert (uri != null) : "@namespace URI can't be null.";
        if (!uri.equals("<missing STRING>")) assert (CSSStringPropertyValue.isQuoted(uri)) : "Do not strip namespace quotes in parser.";
        this.prefix = prefix;
        this.uri = uri == null ? "" : CSSStringPropertyValue.stripQuotes(uri);
        if (this.uri.length() == 0) {
            SourceLocation sourceLocation = new SourceLocation(tokenStream.getSourceName(), -1, -1, tree.getLine(), tree.getCharPositionInLine());
            this.problems.add(new CSSNamespaceEmptyURIProblem(sourceLocation));
        }
    }

    public List<ICompilerProblem> getProblems() {
        return this.problems;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String toString() {
        return Joiner.on((String)" ").skipNulls().join((Object)"@namespace", (Object)this.prefix, new Object[]{"\"" + this.uri + "\"", ";"});
    }
}

