/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.localization.LocalizationManager;
import java.util.HashMap;

public class FaultActions {
    HashMap<String, Integer> m_faults = new HashMap();
    HashMap<String, String> m_description = new HashMap();
    HashMap<String, Integer> m_actions = new HashMap();
    int m_nextBitForAction = 1;

    private FaultActions() {
    }

    Integer get(String string) {
        return this.m_faults.get(string);
    }

    Integer getAction(String string) {
        return this.m_actions.get(string);
    }

    void put(String string, Integer n) {
        this.m_faults.put(string, n);
    }

    public void clear() {
        this.m_faults.clear();
    }

    public int size() {
        return this.m_faults.size();
    }

    public Object[] names() {
        return this.m_faults.keySet().toArray();
    }

    public Object[] actions() {
        return this.m_actions.keySet().toArray();
    }

    public boolean exists(String string) {
        return this.get(string) != null;
    }

    public void putDescription(String string, String string2) {
        this.m_description.put(string, string2);
    }

    public String getDescription(String string) {
        return this.m_description.get(string) == null ? "" : this.m_description.get(string);
    }

    public void add(String string) {
        this.put(string, 0);
    }

    public void addAction(String string) {
        Integer n = this.m_nextBitForAction++;
        this.m_actions.put(string, n);
    }

    public boolean is(String string, String string2) {
        int n = this.getAction(string2);
        int n2 = this.get(string);
        boolean bl = (n2 & n) == n;
        return bl;
    }

    public int action(String string, String string2) {
        Integer n;
        Integer n2 = this.get(string);
        if (n2 == null) {
            throw new IllegalArgumentException(string);
        }
        boolean bl = string2.startsWith("no");
        if (bl) {
            string2 = string2.substring(2);
        }
        if ((n = this.getAction(string2)) == null) {
            throw new IllegalArgumentException(string2);
        }
        int n3 = n2;
        int n4 = n;
        int n5 = n3 & ~n4;
        n5 = bl ? n5 : n5 | n4;
        this.put(string, n5);
        return n5;
    }

    public static class FaultActionsBuilder {
        private final LocalizationManager localizationManager;

        public FaultActionsBuilder(LocalizationManager localizationManager) {
            this.localizationManager = localizationManager;
        }

        public FaultActions build() {
            FaultActions faultActions = new FaultActions();
            this.populateFaultTable(faultActions);
            return faultActions;
        }

        private void populateFaultTable(FaultActions faultActions) {
            faultActions.addAction("stop");
            faultActions.addAction("print");
            faultActions.add("invalid_target");
            faultActions.add("recursion_limit");
            faultActions.add("invalid_with");
            faultActions.add("proto_limit");
            faultActions.add("invalid_url");
            faultActions.add("exception");
            faultActions.add("stack_underflow");
            faultActions.add("zero_divide");
            faultActions.add("script_timeout");
            faultActions.putDescription("invalid_target", this.getLocalizationManager().getLocalizedTextString("invalidTargetFault"));
            faultActions.putDescription("recursion_limit", this.getLocalizationManager().getLocalizedTextString("recursionLimitFault"));
            faultActions.putDescription("invalid_with", this.getLocalizationManager().getLocalizedTextString("invalidWithFault"));
            faultActions.putDescription("proto_limit", this.getLocalizationManager().getLocalizedTextString("protoLimitFault"));
            faultActions.putDescription("invalid_url", this.getLocalizationManager().getLocalizedTextString("invalidUrlFault"));
            faultActions.putDescription("exception", this.getLocalizationManager().getLocalizedTextString("exceptionFault"));
            faultActions.putDescription("stack_underflow", this.getLocalizationManager().getLocalizedTextString("stackUnderflowFault"));
            faultActions.putDescription("zero_divide", this.getLocalizationManager().getLocalizedTextString("divideByZeroFault"));
            faultActions.putDescription("script_timeout", this.getLocalizationManager().getLocalizedTextString("scriptTimeoutFault"));
            faultActions.action("invalid_target", "stop");
            faultActions.action("invalid_target", "print");
            faultActions.action("recursion_limit", "stop");
            faultActions.action("recursion_limit", "print");
            faultActions.action("invalid_with", "stop");
            faultActions.action("invalid_with", "print");
            faultActions.action("proto_limit", "stop");
            faultActions.action("proto_limit", "print");
            faultActions.action("invalid_url", "stop");
            faultActions.action("invalid_url", "print");
            faultActions.action("exception", "stop");
            faultActions.action("exception", "print");
            faultActions.action("stack_underflow", "stop");
            faultActions.action("stack_underflow", "print");
            faultActions.action("zero_divide", "stop");
            faultActions.action("zero_divide", "print");
            faultActions.action("script_timeout", "stop");
            faultActions.action("script_timeout", "print");
        }

        private LocalizationManager getLocalizationManager() {
            return this.localizationManager;
        }
    }
}

