/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLModelRootNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLData;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLDualContentProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelRootNode;

class MXMLModelNode
extends MXMLInstanceNode
implements IMXMLModelNode {
    private MXMLModelRootNode rootNode;

    MXMLModelNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLModelID;
    }

    @Override
    public String getName() {
        return "Model";
    }

    @Override
    public int getChildCount() {
        return this.rootNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.rootNode : null;
    }

    @Override
    public IMXMLModelRootNode getRootNode() {
        return this.rootNode;
    }

    @Override
    protected void initializeFromTag(MXMLTreeBuilder builder, IMXMLTagData tag) {
        RoyaleProject project = builder.getProject();
        String qname = project.getModelClass();
        this.setClassReference(project, qname);
        super.initializeFromTag(builder, tag);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            IMXMLData mxmlData;
            String sourcePath = MXMLModelNode.resolveSourceAttributePath(builder, attribute, info);
            if (sourcePath != null && (mxmlData = builder.getExternalMXMLData(attribute, sourcePath)) != null) {
                IMXMLTagData rootTag = mxmlData.getRootTag();
                this.rootNode = new MXMLModelRootNode(this);
                this.rootNode.initializeFromTag(builder, rootTag);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        info.hasDualContent = true;
        if (this.rootNode == null) {
            this.rootNode = new MXMLModelRootNode(this);
            this.rootNode.initializeFromTag(builder, childTag);
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (info.hasSourceAttribute && info.hasDualContent) {
            MXMLDualContentProblem problem = new MXMLDualContentProblem(tag, tag.getShortName());
            builder.addProblem(problem);
        }
    }
}

