/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DValue
implements Value {
    private int m_type;
    private String m_typeName;
    private String m_className;
    private int m_attribs;
    private Map<String, DVariable> m_members;
    long m_nonProtoId;
    private Object m_value;
    private String[] m_classHierarchy;
    private int m_levelsWithMembers;
    private Session m_session;
    private Map<String, List<DVariable>> m_inheritedPrivates;
    private int m_isolateId;

    public DValue(long l, int n) {
        this.init(8, null, null, 0, new Long(l));
        this.setIsolateId(n);
    }

    public DValue(int n, String string, String string2, int n2, Object object, int n3) {
        this.init(n, string, string2, n2, object);
        this.setIsolateId(n3);
    }

    public static DValue forPrimitive(Object object, int n) {
        if (object == null) {
            return new DValue(6, "null", "", 0, object, n);
        }
        if (object == Value.UNDEFINED) {
            return new DValue(7, "undefined", "", 0, object, n);
        }
        if (object instanceof Boolean) {
            return new DValue(1, "Boolean", "", 0, object, n);
        }
        if (object instanceof Double) {
            return new DValue(0, "Number", "", 0, object, n);
        }
        if (object instanceof String) {
            return new DValue(2, "String", "", 0, object, n);
        }
        assert (false);
        return null;
    }

    private void init(int n, String string, String string2, int n2, Object object) {
        if (object == null && n == 7) {
            object = Value.UNDEFINED;
        }
        this.m_type = n;
        this.m_typeName = string;
        this.m_className = string2;
        this.m_attribs = n2;
        this.m_value = object;
        this.m_members = null;
        this.m_inheritedPrivates = null;
        this.m_nonProtoId = this.getId();
        this.m_isolateId = 1;
    }

    @Override
    public int getIsolateId() {
        return this.m_isolateId;
    }

    public void setIsolateId(int n) {
        this.m_isolateId = n;
    }

    @Override
    public int getAttributes() {
        return this.m_attribs;
    }

    @Override
    public String getClassName() {
        return this.m_className;
    }

    @Override
    public long getId() {
        if (this.m_value instanceof Long) {
            return (Long)this.m_value;
        }
        return -1L;
    }

    @Override
    public int getMemberCount(Session session) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(session);
        return this.m_members == null ? 0 : this.m_members.size();
    }

    @Override
    public Variable getMemberNamed(Session session, String string) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(session);
        return this.findMember(string);
    }

    @Override
    public String[] getClassHierarchy(boolean bl) {
        String[] stringArray;
        if (bl) {
            return this.m_classHierarchy;
        }
        if (this.m_classHierarchy != null) {
            stringArray = new String[this.m_levelsWithMembers];
            System.arraycopy(this.m_classHierarchy, 0, stringArray, 0, this.m_levelsWithMembers);
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public DVariable findMember(String string) {
        if (this.m_members == null) {
            return null;
        }
        return this.m_members.get(string);
    }

    @Override
    public Variable[] getMembers(Session session) throws NotSuspendedException, NoResponseException, NotConnectedException {
        this.obtainMembers(session);
        int n = this.getMemberCount(session);
        Object[] objectArray = new DVariable[n];
        if (n > 0) {
            n = 0;
            for (DVariable dVariable : this.m_members.values()) {
                objectArray[n++] = dVariable;
            }
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    private void obtainMembers(Session session) throws NotSuspendedException, NoResponseException, NotConnectedException {
        long l;
        if (session == null) {
            session = this.m_session;
        } else {
            this.m_session = session;
        }
        if (this.m_members == null && session != null && (l = this.getId()) != -1L) {
            if (((PlayerSession)session).getRawValue(l, this.m_isolateId) == this) {
                ((PlayerSession)session).obtainMembers(l, this.m_isolateId);
            }
            if (this.m_members != null) {
                for (DVariable dVariable : this.m_members.values()) {
                    if (!(dVariable instanceof DVariable)) continue;
                    dVariable.setSession(session);
                }
            }
        }
    }

    public boolean membersObtained() {
        return this.getId() == -1L || this.m_members != null;
    }

    public void setMembersObtained(boolean bl) {
        if (bl) {
            if (this.m_members == null) {
                this.m_members = Collections.emptyMap();
            }
            if (this.m_inheritedPrivates == null) {
                this.m_inheritedPrivates = Collections.emptyMap();
            }
        } else {
            this.m_members = null;
            this.m_inheritedPrivates = null;
        }
    }

    public void addMember(DVariable dVariable) {
        if (this.m_members == null) {
            this.m_members = new HashMap<String, DVariable>();
        }
        String string = dVariable.getName();
        DValue dValue = (DValue)dVariable.getValue();
        dValue.m_nonProtoId = string != null && string.equals("__proto__") ? this.m_nonProtoId : dValue.getId();
        dVariable.m_nonProtoParentId = this.m_nonProtoId;
        this.m_members.put(string, dVariable);
    }

    public void addInheritedPrivateMember(DVariable dVariable) {
        if (this.m_inheritedPrivates == null) {
            this.m_inheritedPrivates = new HashMap<String, List<DVariable>>();
        }
        String string = dVariable.getName();
        DValue dValue = (DValue)dVariable.getValue();
        dValue.m_nonProtoId = string != null && string.equals("__proto__") ? this.m_nonProtoId : dValue.getId();
        dVariable.m_nonProtoParentId = this.m_nonProtoId;
        List<DVariable> list = this.m_inheritedPrivates.get(string);
        if (list == null) {
            list = new ArrayList<DVariable>();
            list.add(dVariable);
            this.m_inheritedPrivates.put(string, list);
        } else {
            list.add(dVariable);
        }
    }

    public void removeAllMembers() {
        this.m_members = null;
        this.m_inheritedPrivates = null;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public String getTypeName() {
        return this.m_typeName;
    }

    @Override
    public Object getValueAsObject() {
        return this.m_value;
    }

    @Override
    public String getValueAsString() {
        return DValue.getValueAsString(this.m_value);
    }

    public static String getValueAsString(Object object) {
        long l;
        double d;
        if (object == null) {
            return "null";
        }
        if (object instanceof Double && (d = ((Double)object).doubleValue()) == (double)(l = (long)d)) {
            return Long.toString(l);
        }
        return object.toString();
    }

    @Override
    public boolean isAttributeSet(int n) {
        return (this.m_attribs & n) != 0;
    }

    public void setTypeName(String string) {
        this.m_typeName = string;
    }

    public void setClassName(String string) {
        this.m_className = string;
    }

    public void setType(int n) {
        this.m_type = n;
    }

    public void setValue(Object object) {
        this.m_value = object;
    }

    public void setAttributes(int n) {
        this.m_attribs = n;
    }

    public void setClassHierarchy(String[] stringArray, int n) {
        this.m_classHierarchy = stringArray;
        this.m_levelsWithMembers = n;
    }

    public String membersToString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_members == null) {
            stringBuilder.append(PlayerSessionManager.getLocalizationManager().getLocalizedTextString("empty"));
        } else {
            for (DVariable dVariable : this.m_members.values()) {
                stringBuilder.append(dVariable);
                stringBuilder.append(",\n");
            }
        }
        return stringBuilder.toString();
    }

    public void setSession(Session session) {
        this.m_session = session;
    }

    public String toString() {
        return this.getValueAsString();
    }

    @Override
    public Variable[] getPrivateInheritedMembers() {
        if (this.m_inheritedPrivates == null) {
            return new DVariable[0];
        }
        ArrayList<DVariable> arrayList = new ArrayList<DVariable>();
        for (List<DVariable> objectArray2 : this.m_inheritedPrivates.values()) {
            arrayList.addAll(objectArray2);
        }
        Object[] objectArray = arrayList.toArray(new DVariable[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Override
    public Variable[] getPrivateInheritedMemberNamed(String string) {
        if (this.m_inheritedPrivates == null) {
            return new DVariable[0];
        }
        List<DVariable> list = this.m_inheritedPrivates.get(string);
        if (list != null) {
            return list.toArray(new Variable[0]);
        }
        return new DVariable[0];
    }
}

