/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.generic.util;

import com.alipay.hessian.generic.exception.ConvertException;
import com.alipay.hessian.generic.model.GenericArray;
import com.alipay.hessian.generic.model.GenericClass;
import com.alipay.hessian.generic.model.GenericCollection;
import com.alipay.hessian.generic.model.GenericMap;
import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.hessian.generic.util.ClassFilter;
import com.alipay.hessian.generic.util.CustomConverter;
import com.caucho.hessian.io.CalendarHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class GenericUtils {
    private static final Logger log = Logger.getLogger(GenericUtils.class.getName());
    private static Unsafe unsafe;
    private static final CopyOnWriteArrayList<CustomConverter> HANDLERS;

    public static void addCustomConverter(CustomConverter customConverter) {
        HANDLERS.add(customConverter);
    }

    public static void removeCustomConverter(CustomConverter customConverter) {
        HANDLERS.remove(customConverter);
    }

    public static <T> T convertToObject(Object genericObject) {
        try {
            return (T)GenericUtils.innerToConvertObject(genericObject, new IdentityHashMap<Object, Object>());
        }
        catch (Throwable t) {
            throw new ConvertException(t);
        }
    }

    private static Object innerToConvertObject(Object value, Map<Object, Object> map) throws Exception {
        if (value == null) {
            return null;
        }
        if (value.getClass() == GenericObject.class) {
            GenericObject genericObject = (GenericObject)value;
            return GenericUtils.doConvertToObject(genericObject, map);
        }
        if (value.getClass() == GenericCollection.class) {
            GenericCollection collection = (GenericCollection)value;
            return GenericUtils.doConvertToCollection(collection, map);
        }
        if (value.getClass() == GenericMap.class) {
            GenericMap genericMap = (GenericMap)value;
            return GenericUtils.doConvertToMap(genericMap, map);
        }
        if (value.getClass() == GenericArray.class) {
            GenericArray genericArray = (GenericArray)value;
            return GenericUtils.doConvertToArray(genericArray, map);
        }
        if (value.getClass() == GenericClass.class) {
            GenericClass genericClass = (GenericClass)value;
            return GenericUtils.doConvertToClass(genericClass, map);
        }
        Object obj = GenericUtils.handleCollectionOrMapToObject(value, map);
        return obj;
    }

    private static Object doConvertToObject(GenericObject genericObject, Map<Object, Object> map) throws Exception {
        Object object = map.get(genericObject);
        if (object != null) {
            return object;
        }
        if (CalendarHandle.class.getName().equals(genericObject.getType())) {
            return GenericUtils.handleCalendarHandle(genericObject, map);
        }
        Class clazz = GenericUtils.loadClassFromTCCL(genericObject.getType());
        if (Enum.class.isAssignableFrom(clazz)) {
            Method valueOfMethod = clazz.getMethod("valueOf", Class.class, String.class);
            return valueOfMethod.invoke(null, clazz, genericObject.getField("name"));
        }
        for (CustomConverter converter : HANDLERS) {
            if (!converter.interestClass().isAssignableFrom(clazz)) continue;
            return converter.convertToObject(clazz, genericObject);
        }
        object = GenericUtils.instantiate(clazz);
        map.put(genericObject, object);
        List<Field> fieldsList = GenericUtils.getClassFields(clazz);
        for (Field field : fieldsList) {
            Object value = genericObject.getField(field.getName());
            if (value == null) {
                if (!genericObject.hasField(field.getName())) continue;
                GenericUtils.setFieldValue(object, field, null);
                continue;
            }
            Object result = GenericUtils.innerToConvertObject(value, map);
            GenericUtils.setFieldValue(object, field, result);
        }
        return object;
    }

    private static void setFieldValue(Object object, Field field, Object value) throws IllegalAccessException {
        if ((field.getType() == Byte.TYPE || field.getType() == Byte.class) && value.getClass() == Integer.class) {
            field.set(object, ((Integer)value).byteValue());
            return;
        }
        if ((field.getType() == Short.TYPE || field.getType() == Short.class) && value.getClass() == Integer.class) {
            field.set(object, ((Integer)value).shortValue());
            return;
        }
        if ((field.getType() == Float.TYPE || field.getType() == Float.class) && value.getClass() == Double.class) {
            field.set(object, Float.valueOf(((Double)value).floatValue()));
            return;
        }
        field.set(object, value);
    }

    private static Object handleCalendarHandle(GenericObject genericObject, Map<Object, Object> map) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Calendar cal;
        Object type = genericObject.getField("type");
        Date date = (Date)genericObject.getField("date");
        if (type == null) {
            cal = new GregorianCalendar();
        } else if (type.getClass() == Class.class) {
            Class clazz = (Class)type;
            cal = (Calendar)clazz.newInstance();
        } else if (type.getClass() == GenericClass.class) {
            GenericClass gc = (GenericClass)type;
            Class clazz = (Class)GenericUtils.doConvertToClass(gc, map);
            cal = (Calendar)clazz.newInstance();
        } else {
            throw new IllegalArgumentException("type\u9700\u8981\u662fClass\u6216\u8005GenericClass\u7c7b\u578b");
        }
        map.put(genericObject, cal);
        cal.setTimeInMillis(date.getTime());
        return cal;
    }

    private static Object doConvertToCollection(GenericCollection genericCollection, Map<Object, Object> map) throws Exception {
        Object object = map.get(genericCollection);
        if (object != null) {
            return object;
        }
        Class clazz = GenericUtils.loadClassFromTCCL(genericCollection.getType());
        if (!Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("GenericCollection\u5b9e\u4f8b\u672a\u5c01\u88c5Collection\u5b9e\u4f8b.");
        }
        Collection result = (Collection)GenericUtils.instantiate(clazz);
        map.put(genericCollection, result);
        Collection values = genericCollection.getCollection();
        for (Object value : values) {
            result.add(GenericUtils.innerToConvertObject(value, map));
        }
        return result;
    }

    private static Object doConvertToMap(GenericMap genericMap, Map<Object, Object> map) throws Exception {
        Object object = map.get(genericMap);
        if (object != null) {
            return object;
        }
        Class clazz = GenericUtils.loadClassFromTCCL(genericMap.getType());
        if (!Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("GenericMap\u5b9e\u4f8b\u672a\u5c01\u88c5Map\u5b9e\u4f8b.");
        }
        Map result = (Map)GenericUtils.instantiate(clazz);
        map.put(genericMap, result);
        for (Map.Entry entry : genericMap.getMap().entrySet()) {
            result.put(GenericUtils.innerToConvertObject(entry.getKey(), map), GenericUtils.innerToConvertObject(entry.getValue(), map));
        }
        return result;
    }

    private static Object doConvertToArray(GenericArray genericArray, Map<Object, Object> map) throws Exception {
        Object object = map.get(genericArray);
        if (object != null) {
            return object;
        }
        Class clazz = GenericUtils.loadClassFromTCCL(genericArray.getComponentType());
        Object[] objects = genericArray.getObjects();
        Object result = Array.newInstance(clazz, objects.length);
        map.put(genericArray, result);
        for (int i = 0; i < objects.length; ++i) {
            Array.set(result, i, GenericUtils.innerToConvertObject(objects[i], map));
        }
        return result;
    }

    private static Object doConvertToClass(GenericClass genericClass, Map<Object, Object> map) throws ClassNotFoundException {
        Object object = map.get(genericClass);
        if (object != null) {
            return object;
        }
        Class obj = GenericUtils.loadClassFromTCCL(genericClass.getClazzName());
        map.put(genericClass, obj);
        return obj;
    }

    public static <T> T convertToGenericObject(Object object) {
        try {
            return (T)GenericUtils.innerConvertToGenericObject(object, new IdentityHashMap<Object, Object>());
        }
        catch (Throwable t) {
            throw new ConvertException(t);
        }
    }

    private static Object innerConvertToGenericObject(Object value, Map<Object, Object> map) throws Exception {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        for (CustomConverter converter : HANDLERS) {
            GenericObject genericObject;
            if (!converter.interestClass().isAssignableFrom(clazz) || (genericObject = converter.convertToGenericObject(clazz, value)) == null) continue;
            map.put(value, genericObject);
            return genericObject;
        }
        if (ClassFilter.filterExcludeClass(clazz.getName())) {
            Object result = GenericUtils.handleCollectionOrMapToGenericObjec(value, map);
            return result;
        }
        if (clazz.isArray() && ClassFilter.arrayFilter(clazz)) {
            return value;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)value;
            return GenericUtils.doConvertToGenericCollection(collection, map);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Map m = (Map)value;
            return GenericUtils.doConvertToGenericMap(m, map);
        }
        if (clazz.isArray()) {
            if (ClassFilter.arrayFilter(clazz)) {
                return value;
            }
            return GenericUtils.doConvertToGenericArray(value, map);
        }
        if (clazz == Class.class) {
            Class clazzValue = (Class)value;
            if (ClassFilter.filter(clazzValue.getName())) {
                return value;
            }
            return GenericUtils.doConvertToGenericClass(clazzValue, map);
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            ArrayList list = new ArrayList();
            Enumeration iter = (Enumeration)value;
            while (iter.hasMoreElements()) {
                list.add(iter.nextElement());
            }
            return list;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar = (Calendar)value;
            return GenericUtils.convertCalendarToGenericObject(calendar, map);
        }
        return GenericUtils.doConvertToGenericObjec(value, map);
    }

    private static Object doConvertToGenericObjec(Object object, Map<Object, Object> map) throws Exception {
        Object cachedObject = map.get(object);
        if (cachedObject != null) {
            return cachedObject;
        }
        Class<?> clazz = object.getClass();
        GenericObject genericObject = new GenericObject(clazz.getName());
        map.put(object, genericObject);
        boolean isEnum = false;
        if (Enum.class.isAssignableFrom(clazz)) {
            isEnum = true;
        }
        List<Field> fieldsList = GenericUtils.getClassFields(clazz);
        for (Field field : fieldsList) {
            Object obj = field.get(object);
            if (isEnum && !field.getName().equals("name")) continue;
            genericObject.putField(field.getName(), GenericUtils.innerConvertToGenericObject(obj, map));
        }
        return genericObject;
    }

    private static Object doConvertToGenericCollection(Collection collection, Map<Object, Object> map) throws Exception {
        Object cachedObject = map.get(collection);
        if (cachedObject != null) {
            return cachedObject;
        }
        GenericCollection genericCollection = new GenericCollection(collection.getClass().getName());
        map.put(collection, genericCollection);
        ArrayList<Object> defaultCollection = new ArrayList<Object>();
        for (Object obj : collection) {
            defaultCollection.add(GenericUtils.innerConvertToGenericObject(obj, map));
        }
        genericCollection.setCollection(defaultCollection);
        return genericCollection;
    }

    private static Object doConvertToGenericMap(Map valueMap, Map<Object, Object> map) throws Exception {
        Object cachedObject = map.get(valueMap);
        if (cachedObject != null) {
            return cachedObject;
        }
        GenericMap genericMap = new GenericMap(valueMap.getClass().getName());
        map.put(valueMap, genericMap);
        HashMap<Object, Object> defaultMap = new HashMap<Object, Object>();
        for (Map.Entry entry : valueMap.entrySet()) {
            defaultMap.put(GenericUtils.innerConvertToGenericObject(entry.getKey(), map), GenericUtils.innerConvertToGenericObject(entry.getValue(), map));
        }
        genericMap.setMap(defaultMap);
        return genericMap;
    }

    private static Object doConvertToGenericArray(Object array, Map<Object, Object> map) throws Exception {
        Class<?> clazz = array.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u8981\u662f\u4e00\u4e2a\u6570\u7ec4\u7c7b\u578b");
        }
        Object cachedObject = map.get(array);
        if (cachedObject != null) {
            return cachedObject;
        }
        GenericArray genericArray = new GenericArray(GenericUtils.convertHessianFormat(clazz.getComponentType().getName()));
        map.put(array, genericArray);
        int length = Array.getLength(array);
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            Array.set(objects, i, GenericUtils.innerConvertToGenericObject(Array.get(array, i), map));
        }
        genericArray.setObjects(objects);
        return genericArray;
    }

    private static Object doConvertToGenericClass(Class clazzValue, Map<Object, Object> map) {
        Object cachedObject = map.get(clazzValue);
        if (cachedObject != null) {
            return cachedObject;
        }
        GenericClass genericClass = new GenericClass(clazzValue.getName());
        map.put(clazzValue, genericClass);
        return genericClass;
    }

    private static Object convertCalendarToGenericObject(Calendar calendar, Map<Object, Object> map) {
        Object cachedObject = map.get(calendar);
        if (cachedObject != null) {
            return cachedObject;
        }
        GenericObject go = new GenericObject(CalendarHandle.class.getName());
        map.put(calendar, go);
        go.putField("type", GenericUtils.doConvertToGenericClass(calendar.getClass(), map));
        go.putField("date", new Date(calendar.getTimeInMillis()));
        return go;
    }

    private static List<Field> getClassFields(Class clazz) {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                fieldsList.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return fieldsList;
    }

    private static Object instantiate(Class clazz) throws Exception {
        try {
            Class type = clazz;
            Constructor<?> constructor = null;
            Object[] constructorArgs = null;
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            long bestCost = Long.MAX_VALUE;
            for (int i = 0; i < constructors.length; ++i) {
                Class<?>[] param = constructors[i].getParameterTypes();
                long cost = 0L;
                for (int j = 0; j < param.length; ++j) {
                    cost = 4L * cost;
                    if (Object.class.equals(param[j])) {
                        ++cost;
                        continue;
                    }
                    if (String.class.equals(param[j])) {
                        cost += 2L;
                        continue;
                    }
                    if (Integer.TYPE.equals(param[j])) {
                        cost += 3L;
                        continue;
                    }
                    if (Long.TYPE.equals(param[j])) {
                        cost += 4L;
                        continue;
                    }
                    if (param[j].isPrimitive()) {
                        cost += 5L;
                        continue;
                    }
                    cost += 6L;
                }
                if (cost < 0L || cost > 65536L) {
                    cost = 65536L;
                }
                if ((cost += (long)(param.length << 48)) >= bestCost) continue;
                constructor = constructors[i];
                bestCost = cost;
            }
            if (constructor != null) {
                constructor.setAccessible(true);
                Class<?>[] params = constructor.getParameterTypes();
                constructorArgs = new Object[params.length];
                for (int i = 0; i < params.length; ++i) {
                    constructorArgs[i] = GenericUtils.getParamArg(params[i]);
                }
            }
            if (constructor != null) {
                return constructor.newInstance(constructorArgs);
            }
            return type.newInstance();
        }
        catch (Exception e) {
            return unsafe.allocateInstance(clazz);
        }
    }

    private static Object getParamArg(Class cl) {
        if (!cl.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(cl)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(cl)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(cl)) {
            return new Short(0);
        }
        if (Character.TYPE.equals(cl)) {
            return new Character('\u0000');
        }
        if (Integer.TYPE.equals(cl)) {
            return 0;
        }
        if (Long.TYPE.equals(cl)) {
            return 0L;
        }
        if (Float.TYPE.equals(cl)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(cl)) {
            return 0.0;
        }
        throw new UnsupportedOperationException();
    }

    private static Object handleCollectionOrMapToObject(Object value, Map<Object, Object> map) throws Exception {
        if (value == null) {
            return null;
        }
        if (map.get(value) != null) {
            return map.get(value);
        }
        if (Collection.class.isAssignableFrom(value.getClass())) {
            Collection values = (Collection)value;
            Collection result = (Collection)GenericUtils.instantiate(value.getClass());
            map.put(value, result);
            for (Object obj : values) {
                result.add(GenericUtils.innerToConvertObject(obj, map));
            }
            return result;
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            Map valueMap = (Map)value;
            Map result = (Map)GenericUtils.instantiate(value.getClass());
            map.put(value, result);
            for (Map.Entry entry : valueMap.entrySet()) {
                result.put(GenericUtils.innerToConvertObject(entry.getKey(), map), GenericUtils.innerToConvertObject(entry.getValue(), map));
            }
            return result;
        }
        return value;
    }

    private static Object handleCollectionOrMapToGenericObjec(Object value, Map<Object, Object> map) throws Exception {
        if (value == null) {
            return null;
        }
        if (map.get(value) != null) {
            return map.get(value);
        }
        if (Collection.class.isAssignableFrom(value.getClass())) {
            Collection values = (Collection)value;
            Collection result = (Collection)GenericUtils.instantiate(value.getClass());
            map.put(value, result);
            for (Object obj : values) {
                result.add(GenericUtils.innerConvertToGenericObject(obj, map));
            }
            return result;
        }
        if (value != null && Map.class.isAssignableFrom(value.getClass())) {
            Map valueMap = (Map)value;
            Map result = (Map)GenericUtils.instantiate(value.getClass());
            map.put(value, result);
            for (Map.Entry entry : valueMap.entrySet()) {
                result.put(GenericUtils.innerConvertToGenericObject(entry.getKey(), map), GenericUtils.innerConvertToGenericObject(entry.getValue(), map));
            }
            return result;
        }
        return value;
    }

    private static String convertHessianFormat(String componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3anull.");
        }
        int lastIndex = componentType.lastIndexOf(91);
        if (lastIndex != -1) {
            if (componentType.charAt(componentType.length() - 1) != ';' && componentType.charAt(lastIndex + 1) != 'L') {
                throw new IllegalArgumentException("\u975e\u6cd5\u6570\u7ec4\u683c\u5f0f");
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < lastIndex + 1; ++i) {
                sb.append('[');
            }
            sb.append(componentType.substring(lastIndex + 2, componentType.length() - 1));
            return sb.toString();
        }
        return componentType;
    }

    private static Class loadClassFromTCCL(String clazzName) throws ClassNotFoundException {
        return Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
    }

    static {
        HANDLERS = new CopyOnWriteArrayList();
        try {
            Class<?> unsafe = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = null;
            for (Field field : unsafe.getDeclaredFields()) {
                if (!field.getName().equals("theUnsafe")) continue;
                theUnsafe = field;
            }
            if (theUnsafe != null) {
                theUnsafe.setAccessible(true);
                GenericUtils.unsafe = (Unsafe)theUnsafe.get(null);
            }
        }
        catch (Throwable e) {
            log.warning(e.toString());
        }
    }
}

