/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.timer.rocksdb;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.rocksdb.MessageRocksDBStorage;
import org.apache.rocketmq.store.timer.TimerMessageStore;
import org.apache.rocketmq.store.timer.TimerMetrics;
import org.apache.rocketmq.store.timer.rocksdb.TimerMessageRocksDBStore;
import org.apache.rocketmq.store.timer.rocksdb.TimerRocksDBRecord;

public class Timeline {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final String DELETE_KEY_SPLIT = "+";
    private static final int ORIGIN_CAPACITY = 100000;
    private static final int BATCH_SIZE = 1000;
    private static final int MAX_BATCH_SIZE_FROM_ROCKSDB = 8000;
    private static final int INITIAL = 0;
    private static final int RUNNING = 1;
    private static final int SHUTDOWN = 2;
    private volatile int state = 0;
    private final AtomicLong commitOffset = new AtomicLong(0L);
    private final MessageStore messageStore;
    private final MessageStoreConfig storeConfig;
    private final TimerMessageStore timerMessageStore;
    private final MessageRocksDBStorage messageRocksDBStorage;
    private final TimerMessageRocksDBStore timerMessageRocksDBStore;
    private final long precisionMs;
    private final TimerMetrics timerMetrics;
    private TimelineIndexBuildService timelineIndexBuildService;
    private TimelineForwardService timelineForwardService;
    private TimelineRollService timelineRollService;
    private TimelineDeleteService timelineDeleteService;
    private BlockingQueue<TimerRocksDBRecord> originTimerMsgQueue;

    public Timeline(MessageStore messageStore, MessageRocksDBStorage messageRocksDBStorage, TimerMessageRocksDBStore timerMessageRocksDBStore, TimerMetrics timerMetrics) {
        this.messageStore = messageStore;
        this.storeConfig = messageStore.getMessageStoreConfig();
        this.timerMessageStore = messageStore.getTimerMessageStore();
        this.messageRocksDBStorage = messageRocksDBStorage;
        this.timerMessageRocksDBStore = timerMessageRocksDBStore;
        this.precisionMs = timerMessageRocksDBStore.precisionMs;
        this.timerMetrics = timerMetrics;
        this.initService();
    }

    private void initService() {
        this.timelineIndexBuildService = new TimelineIndexBuildService();
        this.timelineForwardService = new TimelineForwardService();
        this.originTimerMsgQueue = this.storeConfig.isTimerEnableDisruptor() ? new DisruptorBlockingQueue(100000) : new LinkedBlockingDeque<TimerRocksDBRecord>(100000);
        this.timelineRollService = new TimelineRollService();
        this.timelineDeleteService = new TimelineDeleteService();
    }

    public void start() {
        if (this.state == 1) {
            return;
        }
        this.commitOffset.set(this.timerMessageRocksDBStore.getReadOffset().get());
        this.timelineIndexBuildService.start();
        this.timelineForwardService.start();
        this.timelineRollService.start();
        this.timelineDeleteService.start();
        this.state = 1;
        log.info("Timeline start success, start commitOffset: {}", (Object)this.commitOffset.get());
    }

    public void shutDown() {
        if (this.state != 1 || this.state == 2) {
            return;
        }
        if (null != this.timelineIndexBuildService) {
            this.timelineIndexBuildService.shutdown();
        }
        if (null != this.timelineForwardService) {
            this.timelineForwardService.shutdown();
        }
        if (null != this.timelineRollService) {
            this.timelineRollService.shutdown();
        }
        if (null != this.timelineDeleteService) {
            this.timelineDeleteService.shutdown();
        }
        this.state = 2;
        log.info("Timeline shutdown success");
    }

    public void putRecord(TimerRocksDBRecord timerRecord) throws InterruptedException {
        if (null == timerRecord) {
            return;
        }
        while (!this.originTimerMsgQueue.offer(timerRecord, 3L, TimeUnit.SECONDS)) {
            if (null != timerRecord.getMessageExt()) {
                logError.error("Timeline originTimerMsgQueue put record failed, topic: {}, uniqKey: {}", (Object)timerRecord.getMessageExt().getTopic(), (Object)timerRecord.getUniqKey());
                continue;
            }
            logError.error("Timeline originTimerMsgQueue put record failed, uniqKey: {}", (Object)timerRecord.getUniqKey());
        }
    }

    public void putDeleteRecord(long delayTime, String uniqKey, long offsetPy, int sizePy, long queueOffset, MessageExt messageExt) throws InterruptedException {
        if (delayTime <= 0L || StringUtils.isEmpty((CharSequence)uniqKey) || offsetPy < 0L || sizePy < 0 || queueOffset < 0L || null == messageExt) {
            log.info("Timeline putDeleteRecord param error, delayTime: {}, uniqKey: {}, offsetPy: {}, sizePy: {}, queueOffset: {}, messageExt: {}", new Object[]{delayTime, uniqKey, offsetPy, sizePy, queueOffset, messageExt});
            return;
        }
        while (!this.originTimerMsgQueue.offer(new TimerRocksDBRecord(delayTime, uniqKey, offsetPy, sizePy, queueOffset, messageExt), 3L, TimeUnit.SECONDS)) {
            log.error("Timeline putDeleteRecord originTimerMsgQueue put delete record failed, uniqKey: {}", (Object)uniqKey);
        }
    }

    public void addMetric(MessageExt msg, int value) {
        if (null == msg || null == msg.getProperty("REAL_TOPIC")) {
            return;
        }
        if (null != msg.getProperty("TIMER_ENQUEUE_MS") && NumberUtils.toLong((String)msg.getProperty("TIMER_ENQUEUE_MS")) == Long.MAX_VALUE) {
            return;
        }
        this.timerMetrics.addAndGet(msg, value);
    }

    private String getServiceThreadName() {
        DefaultMessageStore messageStore;
        String brokerIdentifier = "";
        if (this.messageStore instanceof DefaultMessageStore && (messageStore = (DefaultMessageStore)this.messageStore).getBrokerConfig().isInBrokerContainer()) {
            brokerIdentifier = messageStore.getBrokerConfig().getIdentifier();
        }
        return brokerIdentifier;
    }

    private void recallToTimeWheel(TimerRocksDBRecord tr) {
        if (!this.messageStore.getMessageStoreConfig().isTimerRecallToTimeWheelEnable()) {
            return;
        }
        if (null == tr || null == tr.getMessageExt()) {
            return;
        }
        try {
            this.timerMessageStore.doEnqueue(tr.getOffsetPy(), tr.getSizePy(), tr.getDelayTime(), tr.getMessageExt(), true);
        }
        catch (Exception e) {
            log.error("Timeline recallToTimeWheel error: {}", (Object)e.getMessage());
        }
    }

    private boolean scanRecordsToQueue(long checkpoint, long checkRange, BlockingQueue<List<TimerRocksDBRecord>> queue) {
        if (checkpoint <= 0L || checkRange <= 0L || null == queue) {
            logError.error("Timeline scanRecordsToQueue param error, checkpoint: {}, checkRange: {}, queue: {}", new Object[]{checkpoint, checkRange, queue});
            return false;
        }
        if (this.storeConfig.isTimerStopDequeue()) {
            logError.info("Timeline scanRecordsToQueue storeConfig isTimerStopDequeue is true, stop to scan records to queue");
            return false;
        }
        long count = 0L;
        byte[] lastKey = null;
        try {
            List<TimerRocksDBRecord> trs;
            while (null != (trs = this.messageRocksDBStorage.scanRecordsForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, checkpoint, checkpoint + checkRange, 8000, lastKey)) && !CollectionUtils.isEmpty(trs)) {
                count += (long)trs.size();
                boolean hasMoreData = trs.size() >= 8000;
                byte[] byArray = lastKey = hasMoreData ? trs.get(trs.size() - 1).getKeyBytes() : null;
                if (null == lastKey) {
                    trs.get(trs.size() - 1).setCheckPoint(checkpoint + checkRange);
                }
                while (!queue.offer(trs, 3L, TimeUnit.SECONDS)) {
                    log.debug("Timeline scanRecordsToQueue offer to queue error, queue size: {}, records size: {}", (Object)queue.size(), (Object)trs.size());
                }
                if (hasMoreData) continue;
                break;
            }
        }
        catch (Exception e) {
            logError.error("Timeline scanRecordsToQueue error: {}", (Object)e.getMessage());
            return false;
        }
        log.info("Timeline scan records from rocksdb, checkpoint: {}, records size: {}", (Object)checkpoint, (Object)count);
        return true;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    private class TimelineDeleteService
    extends ServiceThread {
        private final Logger log = Timeline.access$300();
        private long lastDeleteCheckPoint = 0L;

        private TimelineDeleteService() {
        }

        public String getServiceName() {
            return Timeline.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            this.log.info(this.getServiceName() + " service start");
            while (!this.isStopped()) {
                try {
                    this.waitForRunning(TimeUnit.MINUTES.toMillis(30L));
                    if (this.stopped) {
                        this.log.info(this.getServiceName() + " service end");
                        return;
                    }
                }
                catch (Exception e) {
                    logError.error("Timeline TimelineDeleteService wait error: {}", (Object)e.getMessage());
                }
                try {
                    long checkpoint = Timeline.this.messageRocksDBStorage.getCheckpointForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, MessageRocksDBStorage.TIMELINE_CHECK_POINT);
                    if (this.lastDeleteCheckPoint == checkpoint) continue;
                    Timeline.this.messageRocksDBStorage.deleteRecordsForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, checkpoint - TimeUnit.HOURS.toMillis(168L), checkpoint - TimeUnit.MINUTES.toMillis(30L));
                    this.lastDeleteCheckPoint = checkpoint;
                }
                catch (Exception e) {
                    logError.error("Timeline TimelineDeleteService delete failed, lastDeleteCheckPoint: {} error: {}", (Object)this.lastDeleteCheckPoint, (Object)e.getMessage());
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }
    }

    private class TimelineRollService
    extends ServiceThread {
        private final Logger log = Timeline.access$300();

        private TimelineRollService() {
        }

        public String getServiceName() {
            return Timeline.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            this.log.info(this.getServiceName() + " service start");
            while (!this.isStopped()) {
                int rollIntervalHour = 1;
                int rollRangeHour = 2;
                try {
                    if (Timeline.this.storeConfig.getTimerRocksDBRollIntervalHours() > 0) {
                        rollIntervalHour = Timeline.this.storeConfig.getTimerRocksDBRollIntervalHours();
                    }
                    if (Timeline.this.storeConfig.getTimerRocksDBRollRangeHours() > 0) {
                        rollRangeHour = Timeline.this.storeConfig.getTimerRocksDBRollRangeHours();
                    }
                    this.waitForRunning(TimeUnit.HOURS.toMillis(rollIntervalHour));
                    if (this.stopped) {
                        this.log.info(this.getServiceName() + " service end");
                        return;
                    }
                }
                catch (Exception e) {
                    logError.error("Timeline TimelineRollService wait error: {}", (Object)e.getMessage());
                }
                long rollCheckpoint = System.currentTimeMillis();
                try {
                    this.log.info("Timeline TimelineRollService start roll rollCheckpoint: {}", (Object)rollCheckpoint);
                    while (!Timeline.this.scanRecordsToQueue(rollCheckpoint + TimeUnit.HOURS.toMillis(rollRangeHour), TimeUnit.SECONDS.toMillis(Timeline.this.storeConfig.getTimerMaxDelaySec()), Timeline.this.timerMessageRocksDBStore.getRollMessageQueue())) {
                        logError.error("Timeline TimelineRollService scanRecordsToQueue error.");
                        Thread.sleep(200L);
                    }
                    this.log.info("Timeline TimelineRollService roll records success, lastRollTime: {}, rollCheckpoint: {}, cost: {}", new Object[]{rollCheckpoint, rollCheckpoint, System.currentTimeMillis() - rollCheckpoint});
                }
                catch (Exception e) {
                    logError.error("Timeline TimelineRollService failed error: {}", (Object)e.getMessage());
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }
    }

    private class TimelineForwardService
    extends ServiceThread {
        private final Logger log = Timeline.access$300();

        private TimelineForwardService() {
        }

        public String getServiceName() {
            return Timeline.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            long checkpoint = Timeline.this.messageRocksDBStorage.getCheckpointForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, MessageRocksDBStorage.TIMELINE_CHECK_POINT);
            this.log.info(this.getServiceName() + " service start, checkpoint: {}", (Object)checkpoint);
            while (!this.isStopped()) {
                try {
                    if (!this.timelineForward(checkpoint, Timeline.this.precisionMs)) {
                        this.waitForRunning(100L);
                        continue;
                    }
                    checkpoint += Timeline.this.precisionMs;
                }
                catch (Exception e) {
                    logError.error("Timeline error occurred in " + this.getServiceName(), (Throwable)e);
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }

        private boolean timelineForward(long checkpoint, long checkRange) {
            if (checkpoint > System.currentTimeMillis()) {
                return false;
            }
            try {
                long begin = System.currentTimeMillis();
                boolean result = Timeline.this.scanRecordsToQueue(checkpoint, checkRange, Timeline.this.timerMessageRocksDBStore.getExpiredMessageQueue());
                this.log.info("Timeline TimelineForwardService timelineForward scanRecordsToQueue end, result: {}, checkpoint: {}, checkRange: {}, checkDelay: {}, cost: {}", new Object[]{result, checkpoint, checkRange, System.currentTimeMillis() - checkpoint, System.currentTimeMillis() - begin});
                return result;
            }
            catch (Exception e) {
                logError.error("Timeline TimelineForwardService timelineForward error: {}", (Object)e.getMessage());
                return false;
            }
        }
    }

    public class TimelineIndexBuildService
    extends ServiceThread {
        private final Logger log = Timeline.access$300();
        private List<TimerRocksDBRecord> trs;

        public String getServiceName() {
            return Timeline.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            this.log.info(this.getServiceName() + " service start");
            this.trs = new ArrayList<TimerRocksDBRecord>(1000);
            while (!this.isStopped() || !Timeline.this.originTimerMsgQueue.isEmpty()) {
                try {
                    this.buildTimelineIndex();
                }
                catch (Exception e) {
                    logError.error("Timeline error occurred in: {}, error: {}", (Object)this.getServiceName(), (Object)e.getMessage());
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }

        private void buildTimelineIndex() throws InterruptedException {
            this.pollTimerMessageRecords();
            if (CollectionUtils.isEmpty(this.trs)) {
                return;
            }
            ArrayList<TimerRocksDBRecord> cudlist = new ArrayList<TimerRocksDBRecord>();
            for (TimerRocksDBRecord tr : this.trs) {
                try {
                    MessageExt messageExt = tr.getMessageExt();
                    if (null == messageExt) {
                        logError.error("Timeline TimelineIndexBuildService buildTimelineIndex error, messageExt is null");
                        continue;
                    }
                    String timerDelUniqKey = messageExt.getProperty("TIMER_DEL_UNIQKEY");
                    if (!StringUtils.isEmpty((CharSequence)timerDelUniqKey)) {
                        tr.setUniqKey(this.extractUniqKey(timerDelUniqKey));
                        tr.setActionFlag((byte)1);
                        cudlist.add(tr);
                        Timeline.this.addMetric(messageExt, -1);
                        Timeline.this.recallToTimeWheel(tr);
                        continue;
                    }
                    if (TimerMessageRocksDBStore.isExpired(tr.getDelayTime())) {
                        Timeline.this.timerMessageRocksDBStore.putRealTopicMessage(tr.getMessageExt());
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)messageExt.getProperty("TIMER_ROLL_LABEL"))) {
                        tr.setActionFlag((byte)2);
                        cudlist.add(tr);
                        continue;
                    }
                    tr.setActionFlag((byte)0);
                    cudlist.add(tr);
                    Timeline.this.addMetric(messageExt, 1);
                }
                catch (Exception e) {
                    logError.error("Timeline TimelineIndexBuildService buildTimelineIndex deal trs error", (Throwable)e);
                }
            }
            if (!CollectionUtils.isEmpty(cudlist)) {
                Timeline.this.messageRocksDBStorage.writeRecordsForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, cudlist);
            }
            this.synCommitOffset(this.trs);
            this.trs.clear();
        }

        private String extractUniqKey(String deleteKey) throws IllegalArgumentException {
            if (StringUtils.isEmpty((CharSequence)deleteKey)) {
                throw new IllegalArgumentException("deleteKey is empty");
            }
            int separatorIndex = deleteKey.indexOf(Timeline.DELETE_KEY_SPLIT);
            if (separatorIndex == -1) {
                return deleteKey;
            }
            return deleteKey.substring(separatorIndex + 1);
        }

        private void pollTimerMessageRecords() throws InterruptedException {
            TimerRocksDBRecord firstReq = (TimerRocksDBRecord)Timeline.this.originTimerMsgQueue.poll(100L, TimeUnit.MILLISECONDS);
            if (null != firstReq) {
                TimerRocksDBRecord tmpReq;
                this.trs.add(firstReq);
                while (null != (tmpReq = (TimerRocksDBRecord)Timeline.this.originTimerMsgQueue.poll(100L, TimeUnit.MILLISECONDS))) {
                    this.trs.add(tmpReq);
                    if (this.trs.size() < 1000) continue;
                    break;
                }
            }
        }

        private void synCommitOffset(List<TimerRocksDBRecord> trs) {
            if (CollectionUtils.isEmpty(trs)) {
                return;
            }
            long lastQueueOffset = Timeline.this.messageRocksDBStorage.getCheckpointForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, MessageRocksDBStorage.SYS_TOPIC_SCAN_OFFSET_CHECK_POINT);
            long queueOffset = trs.get(trs.size() - 1).getQueueOffset() + 1L;
            if (queueOffset > lastQueueOffset) {
                Timeline.this.commitOffset.set(queueOffset);
                Timeline.this.messageRocksDBStorage.writeCheckPointForTimer(MessageRocksDBStorage.TIMER_COLUMN_FAMILY, MessageRocksDBStorage.SYS_TOPIC_SCAN_OFFSET_CHECK_POINT, Timeline.this.commitOffset.get());
            }
        }
    }
}

