/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.descriptors.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PlutoWebXmlRewriter {
    private static final String NAMESPACE_PREFIX = "xp";
    private static final String[] ELEMENTS_BEFORE_SERVLET_23 = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet"};
    private static final String[] ELEMENTS_BEFORE_SERVLET_MAPPING_23 = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping"};
    private static final String[] ELEMENTS_BEFORE_SERVLET = new String[]{"description", "display-name", "icon", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet"};
    private static final String[] ELEMENTS_BEFORE_SERVLET_MAPPING = new String[]{"description", "display-name", "icon", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping"};
    private Document descriptor;
    private String namespace;
    private String prefix;
    private Element root;
    private XPath xpath;
    private boolean descriptor23;

    public PlutoWebXmlRewriter(Document descriptor) {
        this.descriptor = descriptor;
        this.root = descriptor.getDocumentElement();
        this.namespace = this.root.getNamespaceURI();
        String version = this.root.getAttribute("version");
        if (version.equals("")) {
            version = "2.3";
        }
        try {
            Double.parseDouble(version);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Unable to create Determine wew.xml version: " + version, e);
        }
        this.descriptor23 = version.equals("2.3");
        if (!this.descriptor23 && version.compareTo("2.3") < 0) {
            throw new RuntimeException("Unsupported (too old?) web.xml version: " + version);
        }
        this.xpath = XPathFactory.newInstance().newXPath();
        if (this.namespace != null && this.namespace.length() > 0) {
            this.prefix = "xp:";
            this.xpath.setNamespaceContext(new XPathNamespaceContext(NAMESPACE_PREFIX, this.namespace));
        } else {
            this.prefix = "";
            this.xpath.setNamespaceContext(new XPathNamespaceContext(""));
        }
    }

    public PlutoWebXmlRewriter(InputStream source) throws Exception {
        this(PlutoWebXmlRewriter.parseXml(source));
    }

    protected static Document parseXml(InputStream source) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                    return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
                }
                return null;
            }
        });
        Document document = builder.parse(source);
        return document;
    }

    protected static void insertElementCorrectly(Element root, Element toInsert, String[] elementsBefore) {
        NodeList allChildren = root.getChildNodes();
        List<String> elementsBeforeList = Arrays.asList(elementsBefore);
        Node insertBefore = null;
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node node = allChildren.item(i);
            if (insertBefore == null) {
                insertBefore = node;
            }
            if (node.getNodeType() != 1) continue;
            if (!elementsBeforeList.contains(node.getNodeName())) break;
            insertBefore = null;
        }
        if (insertBefore == null) {
            root.appendChild(toInsert);
        } else {
            root.insertBefore(toInsert, insertBefore);
        }
    }

    public boolean is23Descriptor() {
        return this.descriptor23;
    }

    public boolean hasServlets() {
        Object result = null;
        try {
            result = this.xpath.evaluate("/" + this.prefix + "web-app/" + this.prefix + "servlet", this.descriptor, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result != null ? ((NodeList)result).getLength() > 0 : false;
    }

    public boolean hasServletMappings() {
        Object result = null;
        try {
            result = this.xpath.evaluate("/" + this.prefix + "web-app/" + this.prefix + "servlet-mapping", this.descriptor, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result != null ? ((NodeList)result).getLength() > 0 : false;
    }

    public String getServletClass(String servletName) {
        Object result = null;
        try {
            result = this.xpath.evaluate("/" + this.prefix + "web-app/" + this.prefix + "servlet[" + this.prefix + "servlet-name='" + servletName + "']/" + this.prefix + "servlet-class/text()", this.descriptor, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return result != null ? (String)result : null;
    }

    public void injectPortletServlet(String className, String name) {
        Element servlet = this.descriptor.createElementNS(this.namespace, "servlet");
        Element servletName = this.descriptor.createElementNS(this.namespace, "servlet-name");
        servletName.setTextContent(name);
        Element servletClass = this.descriptor.createElementNS(this.namespace, "servlet-class");
        servletClass.setTextContent(className);
        servlet.appendChild(servletName);
        servlet.appendChild(servletClass);
        Element init2Param = this.descriptor.createElementNS(this.namespace, "init-param");
        Element param2Name = this.descriptor.createElementNS(this.namespace, "param-name");
        param2Name.setTextContent("portlet-name");
        Element param2Value = this.descriptor.createElementNS(this.namespace, "param-value");
        param2Value.setTextContent(name);
        init2Param.appendChild(param2Name);
        init2Param.appendChild(param2Value);
        servlet.appendChild(init2Param);
        Element loadOnStartup = this.descriptor.createElementNS(this.namespace, "load-on-startup");
        loadOnStartup.setTextContent("1");
        servlet.appendChild(loadOnStartup);
        PlutoWebXmlRewriter.insertElementCorrectly(this.root, servlet, this.descriptor23 ? ELEMENTS_BEFORE_SERVLET_23 : ELEMENTS_BEFORE_SERVLET);
        Element servletMappingElement = this.descriptor.createElementNS(this.namespace, "servlet-mapping");
        Element servletMapName = this.descriptor.createElementNS(this.namespace, "servlet-name");
        servletMapName.setTextContent(name);
        Element servletUrlPattern = this.descriptor.createElementNS(this.namespace, "url-pattern");
        servletUrlPattern.setTextContent("/PlutoInvoker/" + name);
        servletMappingElement.appendChild(servletMapName);
        servletMappingElement.appendChild(servletUrlPattern);
        PlutoWebXmlRewriter.insertElementCorrectly(this.root, servletMappingElement, this.descriptor23 ? ELEMENTS_BEFORE_SERVLET_MAPPING_23 : ELEMENTS_BEFORE_SERVLET_MAPPING);
    }

    public void write(OutputStream dest) throws IOException {
        try {
            DOMSource domSource = new DOMSource(this.descriptor);
            StreamResult streamResult = new StreamResult(dest);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            if (this.descriptor.getDoctype() != null) {
                transformer.setOutputProperty("doctype-public", this.descriptor.getDoctype().getPublicId());
                transformer.setOutputProperty("doctype-system", this.descriptor.getDoctype().getSystemId());
            }
            transformer.setOutputProperty("media-type", "text/xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static class XPathNamespaceContext
    implements NamespaceContext {
        private String namespaceURI;
        private String prefix;

        public XPathNamespaceContext(String prefix) {
            this(prefix, "http://www.w3.org/XML/1998/namespace");
        }

        public XPathNamespaceContext(String prefix, String namespaceURI) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Null prefix");
            }
            if (this.prefix.equals(prefix)) {
                return this.namespaceURI;
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }
}

