/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import org.apache.pdfbox.util.PDFMergerUtility;

public class PDFMerger {
    private PDFMerger() {
    }

    public static void main(String[] args) throws Exception {
        PDFMerger merge = new PDFMerger();
        merge.merge(args);
    }

    private void merge(String[] args) throws Exception {
        String destinationFileName = "";
        boolean nonSeq = false;
        int firstFileArgPos = 0;
        if (args.length > 0 && args[0].equals("-nonSeq")) {
            nonSeq = true;
            firstFileArgPos = 1;
        }
        if (args.length - firstFileArgPos < 3) {
            PDFMerger.usage();
        }
        PDFMergerUtility merger = new PDFMergerUtility();
        for (int i = firstFileArgPos; i < args.length - 1; ++i) {
            String sourceFileName = args[i];
            merger.addSource(sourceFileName);
        }
        destinationFileName = args[args.length - 1];
        merger.setDestinationFileName(destinationFileName);
        if (nonSeq) {
            merger.mergeDocumentsNonSeq(null);
        } else {
            merger.mergeDocuments();
        }
    }

    private static void usage() {
        System.err.println("Usage: java -jar pdfbox-app-x.y.z.jar PDFMerger [-nonSeq] <Source PDF File 2..n> <Destination PDF File>\n  -nonSeq                      use the non-sequential parser\n  <Source PDF File 2..n>       2 or more source PDF documents to merge\n  <Destination PDF File>       The PDF document to save the merged documents to\n");
        System.exit(1);
    }
}

