/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.myfaces = exports.jsf = void 0;
/**
 * jsf.js init layer which provides as per spec the proper
 * window namespace if it does not exist already
 * if this file is included then the code falls back with its namespaces
 * on jsf2.3 or earlier level, for 4.0+ please include faces.js
 */
if (!(window === null || window === void 0 ? void 0 : window.jsf)) {
    const faces = require("./_api").faces;
    window['jsf'] = (_a = window === null || window === void 0 ? void 0 : window.jsf) !== null && _a !== void 0 ? _a : faces;
    window.jsf.specversion = 230000;
    delete window.jsf.contextpath;
    let faces4Init = faces.push.init;
    /*
     * we shim back the breaking api change from 3.0 to 4.0
     * onerror is gone
     */
    faces.push.init = (socketClientId, url, channel, onopen, onmessage, 
    // no on error api change for 4.0
    //onerror: Function,
    onclose, behaviors, autoConnect) => {
        faces4Init(socketClientId, url, channel, onopen, onmessage, null, onclose, behaviors, autoConnect);
    };
}
if (!((_b = window === null || window === void 0 ? void 0 : window.myfaces) === null || _b === void 0 ? void 0 : _b.ab)) {
    const myfaces = require("./_api").myfaces;
    //namespace might be extended is not exclusively reserved so we merge
    window["myfaces"] = (_c = window === null || window === void 0 ? void 0 : window.myfaces) !== null && _c !== void 0 ? _c : {};
    if (!((_d = window === null || window === void 0 ? void 0 : window.myfaces) === null || _d === void 0 ? void 0 : _d.ab)) {
        const myfaces = require("./_api").myfaces;
        //namespace might be extended is not exclusively reserved so we merge
        window["myfaces"] = (_e = window === null || window === void 0 ? void 0 : window.myfaces) !== null && _e !== void 0 ? _e : {};
        Object.keys(myfaces).forEach(key => { var _a, _b; return window.myfaces[key] = (_b = (_a = window.myfaces) === null || _a === void 0 ? void 0 : _a[key]) !== null && _b !== void 0 ? _b : myfaces[key]; });
    }
}
exports.jsf = window.jsf;
exports.myfaces = window.myfaces;
//# sourceMappingURL=jsf.js.map