/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import javax.faces.view.Location;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class HtmlStylesheetRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static final Logger log = Logger.getLogger(HtmlStylesheetRenderer.class.getName());
    private static final String IS_BUILDING_INITIAL_STATE = "javax.faces.IS_BUILDING_INITIAL_STATE";

    @Override
    public void processEvent(ComponentSystemEvent event) {
        if (event instanceof PostAddToViewEvent) {
            UIComponent ccParent;
            UIComponent component = event.getComponent();
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Location location = (Location)component.getAttributes().get("org.apache.myfaces.compositecomponent.location");
            if (location != null && (ccParent = CompositeComponentELUtils.getCompositeComponentBasedOnLocation(facesContext, location)) != null) {
                component.getAttributes().put("oam.CC_FIND_COMPONENT_EXPRESSION", ComponentSupport.getFindComponentExpression(facesContext, ccParent));
            }
            if (!ExternalContextUtils.isPortlet(facesContext.getExternalContext()) && facesContext.getPartialViewContext().isAjaxRequest()) {
                boolean isPostAddToViewEventAfterBuildInitialState;
                boolean isBuildingInitialState = facesContext.getAttributes().containsKey(IS_BUILDING_INITIAL_STATE);
                boolean bl = isPostAddToViewEventAfterBuildInitialState = !isBuildingInitialState || isBuildingInitialState && FaceletViewDeclarationLanguage.isRefreshingTransientBuild(facesContext);
                if (isPostAddToViewEventAfterBuildInitialState && MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isStrictJsf2RefreshTargetAjax()) {
                    RequestViewContext requestViewContext = RequestViewContext.getCurrentInstance(facesContext);
                    requestViewContext.setRenderTarget("head", true);
                }
            }
            facesContext.getViewRoot().addComponentResource(facesContext, component, "head");
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        boolean hasChildren;
        if (facesContext == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        Map<String, Object> componentAttributesMap = component.getAttributes();
        String resourceName = (String)componentAttributesMap.get("name");
        boolean bl = hasChildren = component.getChildCount() > 0;
        if (resourceName != null && !"".equals(resourceName)) {
            if (hasChildren) {
                log.info("Component with resourceName " + resourceName + " and child components found. Child components will be ignored.");
            }
        } else if (hasChildren) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("style", component);
            writer.writeAttribute("type", "text/css", null);
            RendererUtils.renderChildren(facesContext, component);
            writer.endElement("style");
        } else if (!facesContext.isProjectStage(ProjectStage.Production)) {
            facesContext.addMessage(component.getClientId(facesContext), new FacesMessage("Component with no name and no body content, so nothing rendered."));
        }
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Resource resource;
        super.encodeEnd(facesContext, component);
        Map<String, Object> componentAttributesMap = component.getAttributes();
        String resourceName = (String)componentAttributesMap.get("name");
        String libraryName = (String)componentAttributesMap.get("library");
        if (resourceName == null) {
            return;
        }
        if ("".equals(resourceName)) {
            return;
        }
        String additionalQueryParams = null;
        int index = resourceName.indexOf(63);
        if (index >= 0) {
            additionalQueryParams = resourceName.substring(index + 1);
            resourceName = resourceName.substring(0, index);
        }
        if (libraryName == null) {
            if (ResourceUtils.isRenderedStylesheet(facesContext, libraryName, resourceName)) {
                return;
            }
            resource = facesContext.getApplication().getResourceHandler().createResource(resourceName);
        } else {
            if (ResourceUtils.isRenderedStylesheet(facesContext, libraryName, resourceName)) {
                return;
            }
            resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName);
        }
        if (resource == null) {
            log.warning("Resource referenced by resourceName " + resourceName + (libraryName == null ? "" : " and libraryName " + libraryName) + " not found in call to ResourceHandler.createResource. It will be silenty ignored.");
            return;
        }
        if (ResourceUtils.isRenderedStylesheet(facesContext, resource.getLibraryName(), resource.getResourceName())) {
            return;
        }
        ResourceUtils.markStylesheetAsRendered(facesContext, libraryName, resourceName);
        ResourceUtils.markStylesheetAsRendered(facesContext, resource.getLibraryName(), resource.getResourceName());
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("link", component);
        writer.writeAttribute("rel", "stylesheet", null);
        String media = (String)component.getAttributes().get("media");
        if (media != null) {
            writer.writeAttribute("media", media, null);
        }
        writer.writeAttribute("type", resource.getContentType() == null ? "text/css" : resource.getContentType(), null);
        String path = resource.getRequestPath();
        if (additionalQueryParams != null) {
            path = path + (path.indexOf(63) >= 0 ? "&amp;" : "?") + additionalQueryParams;
        }
        writer.writeURIAttribute("href", facesContext.getExternalContext().encodeResourceURL(path), null);
        writer.endElement("link");
    }
}

