/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagDecorator;
import javax.faces.view.facelets.TagException;
import org.apache.myfaces.view.facelets.compiler.CompilationUnit;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.compiler.CompositeComponentUnit;
import org.apache.myfaces.view.facelets.compiler.FaceletsProcessingInstructions;
import org.apache.myfaces.view.facelets.compiler.NamespaceManager;
import org.apache.myfaces.view.facelets.compiler.NamespaceUnit;
import org.apache.myfaces.view.facelets.compiler.RemoveUnit;
import org.apache.myfaces.view.facelets.compiler.TagUnit;
import org.apache.myfaces.view.facelets.compiler.TextUnit;
import org.apache.myfaces.view.facelets.compiler.TrimmedTagUnit;
import org.apache.myfaces.view.facelets.tag.TagAttributesImpl;
import org.apache.myfaces.view.facelets.tag.TagLibrary;

final class CompilationManager {
    private static final Logger log = Logger.getLogger(CompilationManager.class.getName());
    private final Compiler compiler;
    private final TagLibrary tagLibrary;
    private final TagDecorator tagDecorator;
    private final NamespaceManager namespaceManager;
    private final Stack<CompilationUnit> units;
    private int tagId;
    private boolean finished;
    private final String alias;
    private CompilationUnit interfaceCompilationUnit;
    private final FaceletsProcessingInstructions faceletsProcessingInstructions;

    public CompilationManager(String alias, Compiler compiler, FaceletsProcessingInstructions instructions) {
        this.alias = alias;
        this.compiler = compiler;
        this.tagDecorator = compiler.createTagDecorator();
        this.tagLibrary = compiler.createTagLibrary();
        this.namespaceManager = new NamespaceManager();
        this.tagId = 0;
        this.finished = false;
        this.units = new Stack();
        this.units.push(new CompilationUnit());
        this.interfaceCompilationUnit = null;
        this.faceletsProcessingInstructions = instructions;
    }

    public void writeInstruction(String value) {
        TextUnit unit;
        if (this.finished) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            unit = (TextUnit)this.currentUnit();
        } else {
            unit = new TextUnit(this.alias, this.nextTagId(), this.faceletsProcessingInstructions.isEscapeInlineText(), this.faceletsProcessingInstructions.isCompressSpaces());
            this.startUnit(unit);
        }
        unit.writeInstruction(value);
    }

    public void writeText(String value) {
        TextUnit unit;
        if (this.finished) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            unit = (TextUnit)this.currentUnit();
        } else {
            unit = new TextUnit(this.alias, this.nextTagId(), this.faceletsProcessingInstructions.isEscapeInlineText(), this.faceletsProcessingInstructions.isCompressSpaces());
            this.startUnit(unit);
        }
        unit.write(value);
    }

    public void writeComment(String text) {
        TextUnit unit;
        if (this.compiler.isTrimmingComments()) {
            return;
        }
        if (this.finished) {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        if (this.currentUnit() instanceof TextUnit) {
            unit = (TextUnit)this.currentUnit();
        } else {
            unit = new TextUnit(this.alias, this.nextTagId(), this.faceletsProcessingInstructions.isEscapeInlineText(), this.faceletsProcessingInstructions.isCompressSpaces());
            this.startUnit(unit);
        }
        unit.writeComment(text);
    }

    public void writeWhitespace(String text) {
        if (!this.compiler.isTrimmingWhitespace()) {
            this.writeText(text);
        }
    }

    private String nextTagId() {
        return Integer.toHexString(Math.abs(this.alias.hashCode() ^ 13 * this.tagId++));
    }

    public void pushTag(Tag orig) {
        if (this.finished) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Tag Pushed: " + orig);
        }
        Tag t = this.tagDecorator.decorate(orig);
        String[] qname = this.determineQName(t);
        t = this.trimAttributes(t);
        if (CompilationManager.isTrimmed(qname[0], qname[1])) {
            log.fine("Composition Found, Popping Parent Tags");
            this.units.clear();
            NamespaceUnit nsUnit = this.namespaceManager.toNamespaceUnit(this.tagLibrary);
            this.units.push(nsUnit);
            this.startUnit(new TrimmedTagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId()));
            log.fine("New Namespace and [Trimmed] TagUnit pushed");
        } else if (CompilationManager.isRemove(qname[0], qname[1])) {
            this.units.push(new RemoveUnit());
        } else if (CompilationManager.isCompositeComponentInterface(qname[0], qname[1])) {
            log.fine("Composite Component Interface Found, saving unit");
            CompositeComponentUnit compositeRootCompilationUnit = new CompositeComponentUnit();
            this.startUnit(compositeRootCompilationUnit);
            this.interfaceCompilationUnit = new TagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId());
            this.startUnit(this.interfaceCompilationUnit);
        } else if (CompilationManager.isCompositeComponentImplementation(qname[0], qname[1])) {
            log.fine("Composite component Found, Popping Parent Tags");
            this.units.clear();
            NamespaceUnit nsUnit = this.namespaceManager.toNamespaceUnit(this.tagLibrary);
            this.units.push(nsUnit);
            CompositeComponentUnit compositeRootCompilationUnit = new CompositeComponentUnit();
            this.startUnit(compositeRootCompilationUnit);
            if (this.interfaceCompilationUnit != null) {
                this.currentUnit().addChild(this.interfaceCompilationUnit);
                this.interfaceCompilationUnit = null;
            }
            this.startUnit(new TrimmedTagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId()));
            log.fine("New Namespace and TagUnit pushed");
        } else if (this.tagLibrary.containsTagHandler(qname[0], qname[1])) {
            this.startUnit(new TagUnit(this.tagLibrary, qname[0], qname[1], t, this.nextTagId()));
        } else {
            TextUnit unit;
            if (this.tagLibrary.containsNamespace(qname[0])) {
                throw new TagException(orig, "Tag Library supports namespace: " + qname[0] + ", but no tag was defined for name: " + qname[1]);
            }
            if (this.currentUnit() instanceof TextUnit) {
                unit = (TextUnit)this.currentUnit();
            } else {
                unit = new TextUnit(this.alias, this.nextTagId(), this.faceletsProcessingInstructions.isEscapeInlineText(), this.faceletsProcessingInstructions.isCompressSpaces());
                this.startUnit(unit);
            }
            if (this.compiler.isDevelopmentProjectStage()) {
                String qName = null;
                boolean isPrefixed = false;
                TagAttribute jsfc = t.getAttributes().get("jsfc");
                if (jsfc != null) {
                    qName = jsfc.getValue();
                    if (jsfc.getValue().indexOf(58) > 0) {
                        isPrefixed = true;
                    }
                } else if (t.getQName().indexOf(58) > 0) {
                    qName = t.getQName();
                    isPrefixed = true;
                }
                if (isPrefixed) {
                    unit.addMessage(FacesMessage.SEVERITY_WARN, "Warning: The page " + this.alias + " declares namespace " + qname[0] + " and uses the tag " + qName + " , but no TagLibrary associated to namespace.", "Warning: The page " + this.alias + " declares namespace " + qname[0] + " and uses the tag " + qName + " , but no TagLibrary associated to namespace. " + "Please check the namespace name and if it is correct, it is probably that your " + "library .taglib.xml cannot be found on the current classpath, or if you are " + "referencing a composite component library check your library folder match with the " + "namespace and can be located by the installed ResourceHandler.");
                }
            }
            unit.startTag(t);
        }
    }

    public void popTag() {
        CompilationUnit t;
        if (this.finished) {
            return;
        }
        CompilationUnit unit = this.currentUnit();
        if (unit instanceof TextUnit) {
            t = (TextUnit)unit;
            if (t.isClosed()) {
                this.finishUnit();
            } else {
                t.endTag();
                return;
            }
        }
        if ((unit = this.currentUnit()) instanceof TagUnit) {
            t = (TagUnit)unit;
            if (t instanceof TrimmedTagUnit) {
                this.finished = true;
                return;
            }
        } else if (unit instanceof CompositeComponentUnit) {
            this.finished = true;
            return;
        }
        this.finishUnit();
    }

    public void popNamespace(String ns) {
        this.namespaceManager.popNamespace(ns);
        if (this.currentUnit() instanceof NamespaceUnit) {
            this.finishUnit();
        }
    }

    public void pushNamespace(String prefix, String uri) {
        NamespaceUnit unit;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Namespace Pushed " + prefix + ": " + uri);
        }
        this.namespaceManager.pushNamespace(prefix, uri);
        if (this.currentUnit() instanceof NamespaceUnit) {
            unit = (NamespaceUnit)this.currentUnit();
        } else {
            unit = new NamespaceUnit(this.tagLibrary);
            this.startUnit(unit);
        }
        unit.setNamespace(prefix, uri);
    }

    public FaceletHandler createFaceletHandler() {
        return ((CompilationUnit)this.units.get(0)).createFaceletHandler();
    }

    private CompilationUnit currentUnit() {
        if (!this.units.isEmpty()) {
            return this.units.peek();
        }
        return null;
    }

    private void finishUnit() {
        CompilationUnit obj = this.units.pop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Finished Unit: " + obj);
        }
    }

    private void startUnit(CompilationUnit unit) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting Unit: " + unit + " and adding it to parent: " + this.currentUnit());
        }
        this.currentUnit().addChild(unit);
        this.units.push(unit);
    }

    private Tag trimAttributes(Tag tag) {
        Tag t = this.trimJSFCAttribute(tag);
        t = this.trimNSAttributes(t);
        return t;
    }

    protected static boolean isRemove(String ns, String name) {
        return "http://java.sun.com/jsf/facelets".equals(ns) && "remove".equals(name);
    }

    protected static boolean isTrimmed(String ns, String name) {
        return "http://java.sun.com/jsf/facelets".equals(ns) && ("composition".equals(name) || "component".equals(name));
    }

    protected static boolean isCompositeComponentInterface(String ns, String name) {
        return "http://java.sun.com/jsf/composite".equals(ns) && "interface".equals(name);
    }

    protected static boolean isCompositeComponentImplementation(String ns, String name) {
        return "http://java.sun.com/jsf/composite".equals(ns) && "implementation".equals(name);
    }

    private String[] determineQName(Tag tag) {
        TagAttribute attr = tag.getAttributes().get("jsfc");
        if (attr != null) {
            String localName;
            String namespace;
            String value;
            int c;
            if (log.isLoggable(Level.FINE)) {
                log.fine(attr + " JSF Facelet Compile Directive Found");
            }
            if ((c = (value = attr.getValue()).indexOf(58)) == -1) {
                namespace = this.namespaceManager.getNamespace("");
                localName = value;
            } else {
                String prefix = value.substring(0, c);
                namespace = this.namespaceManager.getNamespace(prefix);
                if (namespace == null) {
                    throw new TagAttributeException(tag, attr, "No Namespace matched for: " + prefix);
                }
                localName = value.substring(c + 1);
            }
            return new String[]{namespace, localName};
        }
        return new String[]{tag.getNamespace(), tag.getLocalName()};
    }

    private Tag trimJSFCAttribute(Tag tag) {
        TagAttribute attr = tag.getAttributes().get("jsfc");
        if (attr != null) {
            TagAttribute[] oa = tag.getAttributes().getAll();
            TagAttribute[] na = new TagAttribute[oa.length - 1];
            int p = 0;
            for (int i = 0; i < oa.length; ++i) {
                if ("jsfc".equals(oa[i].getLocalName())) continue;
                na[p++] = oa[i];
            }
            return new Tag(tag, (TagAttributes)new TagAttributesImpl(na));
        }
        return tag;
    }

    private Tag trimNSAttributes(Tag tag) {
        TagAttribute[] attr = tag.getAttributes().getAll();
        int remove = 0;
        for (int i = 0; i < attr.length; ++i) {
            if (!attr[i].getQName().startsWith("xmlns") || !this.tagLibrary.containsNamespace(attr[i].getValue())) continue;
            remove |= 1 << i;
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(attr[i] + " Namespace Bound to TagLibrary");
        }
        if (remove == 0) {
            return tag;
        }
        ArrayList<TagAttribute> attrList = new ArrayList<TagAttribute>(attr.length);
        int p = 0;
        for (int i = 0; i < attr.length; ++i) {
            p = 1 << i;
            if ((p & remove) == p) continue;
            attrList.add(attr[i]);
        }
        attr = attrList.toArray(new TagAttribute[attrList.size()]);
        return new Tag(tag.getLocation(), tag.getNamespace(), tag.getLocalName(), tag.getQName(), (TagAttributes)new TagAttributesImpl(attr));
    }

    public FaceletsProcessingInstructions getFaceletsProcessingInstructions() {
        return this.faceletsProcessingInstructions;
    }
}

