/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.putty;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSASupport;
import org.apache.sshd.putty.AbstractPuttyKeyDecoder;
import org.apache.sshd.putty.PuttyKeyReader;

public class EdDSAPuttyKeyDecoder<PUB extends PublicKey, PRIV extends PrivateKey>
extends AbstractPuttyKeyDecoder<PUB, PRIV> {
    public static final EdDSAPuttyKeyDecoder INSTANCE = new EdDSAPuttyKeyDecoder();

    public EdDSAPuttyKeyDecoder() {
        super(((EdDSASupport)SecurityUtils.getEdDSASupport().get()).getEDDSAPublicKeyType(), ((EdDSASupport)SecurityUtils.getEdDSASupport().get()).getEDDSAPrivateKeyType(), Collections.singletonList("ssh-ed25519"));
    }

    @Override
    public Collection<KeyPair> loadKeyPairs(NamedResource resourceKey, int formatVersion, PuttyKeyReader pubReader, PuttyKeyReader prvReader, Map<String, String> headers) throws IOException, GeneralSecurityException {
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported for " + resourceKey);
        }
        String keyType = pubReader.readString();
        if (!"ssh-ed25519".equals(keyType)) {
            throw new InvalidKeySpecException("Not an EdDSA key: " + keyType);
        }
        byte[] seed = pubReader.read(Short.MAX_VALUE);
        PublicKey pubKey = ((EdDSASupport)SecurityUtils.getEdDSASupport().get()).generateEDDSAPublicKey(seed);
        seed = prvReader.read(Short.MAX_VALUE);
        PrivateKey prvKey = ((EdDSASupport)SecurityUtils.getEdDSASupport().get()).generateEDDSAPrivateKey(seed);
        return Collections.singletonList(new KeyPair(pubKey, prvKey));
    }
}

