/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.assertj.core.internal.BinaryDiffResult;
import org.assertj.core.util.VisibleForTesting;

@VisibleForTesting
public class BinaryDiff {
    @VisibleForTesting
    public BinaryDiffResult diff(File actual, byte[] expected) throws IOException {
        return this.diff(actual.toPath(), expected);
    }

    @VisibleForTesting
    public BinaryDiffResult diff(Path actual, byte[] expected) throws IOException {
        try (InputStream actualStream = Files.newInputStream(actual, new OpenOption[0]);){
            BinaryDiffResult binaryDiffResult = this.diff(actualStream, expected);
            return binaryDiffResult;
        }
    }

    @VisibleForTesting
    public BinaryDiffResult diff(InputStream actualStream, byte[] expected) throws IOException {
        try (ByteArrayInputStream expectedStream = new ByteArrayInputStream(expected);){
            BinaryDiffResult binaryDiffResult = this.diff(actualStream, expectedStream);
            return binaryDiffResult;
        }
    }

    @VisibleForTesting
    public BinaryDiffResult diff(InputStream actualStream, InputStream expectedStream) throws IOException {
        int index = 0;
        while (true) {
            int actual = actualStream.read();
            int expected = expectedStream.read();
            if (actual == -1 && expected == -1) {
                return BinaryDiffResult.noDiff();
            }
            if (actual != expected) {
                return new BinaryDiffResult(index, expected, actual);
            }
            ++index;
        }
    }
}

