/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.Ring;

public class FileMetadata {
    public static final String DEFAULT_NAME = "";
    public static final Format DEFAULT_FORMAT = Format.BINARY;
    private String name;
    private Format format;
    private long length;
    private long lastModified;
    private final List<Signature> signatures = new ArrayList<Signature>();
    private final Ring verified = new Ring();

    public FileMetadata() {
        this(DEFAULT_NAME);
    }

    public FileMetadata(PGPLiteralData data) {
        this(data.getFileName(), Format.byCode((char)data.getFormat()));
        Date modificationTime = data.getModificationTime();
        if (modificationTime != null) {
            this.setLastModified(modificationTime.getTime());
        }
    }

    public FileMetadata(File file) {
        this(file == null ? null : file.toPath());
    }

    public FileMetadata(Path file) {
        this(DEFAULT_NAME, DEFAULT_FORMAT);
        this.setFile(file);
    }

    public FileMetadata(String name) {
        this(name, DEFAULT_FORMAT);
    }

    public FileMetadata(String name, Format format) {
        this(name, format, 0L, 0L);
    }

    public FileMetadata(String name, Format format, long length, long lastModified) {
        this.setName(name);
        this.setFormat(format);
        this.setLength(length);
        this.setLastModified(lastModified);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String x) {
        this.name = x != null ? x : DEFAULT_NAME;
    }

    public FileMetadata withName(String x) {
        this.setName(x);
        return this;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long x) {
        this.length = x;
    }

    public FileMetadata withLength(long x) {
        this.setLength(x);
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long x) {
        this.lastModified = x;
    }

    public FileMetadata withLastModified(long x) {
        this.setLastModified(x);
        return this;
    }

    public Date getLastModifiedDate() {
        return new Date(this.getLastModified());
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format x) {
        this.format = x != null ? x : Format.BINARY;
    }

    public FileMetadata withFormat(Format x) {
        this.setFormat(x);
        return this;
    }

    public Ring getVerified() {
        return this.verified;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public void setFile(File file) {
        this.setFile(file == null ? null : file.toPath());
    }

    public void setFile(Path file) {
        if (file == null) {
            return;
        }
        this.setName(Objects.toString(file.getFileName()));
        try {
            BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            this.setLength(attrs == null ? 0L : attrs.size());
            FileTime lastModified = attrs == null ? null : attrs.lastModifiedTime();
            this.setLastModified(lastModified == null ? 0L : lastModified.toMillis());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FileMetadata withFile(File file) {
        return this.withFile(file == null ? null : file.toPath());
    }

    public FileMetadata withFile(Path file) {
        this.setFile(file);
        return this;
    }

    public int getSignatureType() {
        return this.format == Format.TEXT || this.format == Format.UTF8 ? 1 : 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getFormat()}) + 31 * Long.hashCode(this.getLength()) + 37 * Long.hashCode(TimeUnit.MILLISECONDS.toSeconds(this.getLastModified()));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        FileMetadata that = (FileMetadata)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals((Object)this.getFormat(), (Object)that.getFormat()) && this.getLength() == that.getLength() && TimeUnit.MILLISECONDS.toSeconds(this.getLastModified()) == TimeUnit.MILLISECONDS.toSeconds(that.getLastModified());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", length=" + this.getLength() + ", format=" + (Object)((Object)this.getFormat()) + ", lastModified=" + this.getLastModifiedDate() + "]";
    }

    public static class Signature {
        private boolean verified;
        private long keyId;
        private Key key;

        public Signature() {
        }

        public Signature(long keyId) {
            this();
            this.keyId = keyId;
        }

        public Signature(long keyId, Key key) {
            this(keyId);
            this.key = key;
        }

        public boolean isVerified() {
            return this.verified;
        }

        public void setVerified(boolean x) {
            this.verified = x;
        }

        public long getKeyId() {
            return this.keyId;
        }

        public void setKeyId(long x) {
            this.keyId = x;
        }

        public Key getKey() {
            return this.key;
        }

        public void setKey(Key x) {
            this.key = x;
        }

        public Key getVerifiedKey() {
            return this.verified ? this.key : null;
        }

        public void setVerifiedKey(Key x) {
            this.verified = x != null;
            this.key = x;
        }
    }

    public static enum Format {
        BINARY('b'),
        TEXT('t'),
        UTF8('u');

        private final char code;

        private Format(char code) {
            this.code = code;
        }

        public char getCode() {
            return this.code;
        }

        public static Format byCode(char code) {
            switch (code) {
                case 'b': {
                    return BINARY;
                }
                case 't': {
                    return TEXT;
                }
                case 'u': {
                    return UTF8;
                }
            }
            return null;
        }
    }
}

