/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.PropertyCache;

public final class FixedLength
extends LengthProperty {
    public static final String PICA = "pc";
    public static final String POINT = "pt";
    public static final String MM = "mm";
    public static final String CM = "cm";
    public static final String INCH = "in";
    public static final String MPT = "mpt";
    private static final PropertyCache cache = new PropertyCache(FixedLength.class);
    public static final FixedLength ZERO_FIXED_LENGTH = new FixedLength(0.0, "mpt", 1.0f);
    private int millipoints;

    private FixedLength(double numUnits, String units, float res) {
        this.millipoints = FixedLength.convert(numUnits, units, res);
    }

    public static FixedLength getInstance(double numUnits, String units, float sourceResolution) {
        if (numUnits == 0.0) {
            return ZERO_FIXED_LENGTH;
        }
        return (FixedLength)cache.fetch(new FixedLength(numUnits, units, sourceResolution));
    }

    public static FixedLength getInstance(double numUnits, String units) {
        return FixedLength.getInstance(numUnits, units, 1.0f);
    }

    public static FixedLength getInstance(double numUnits) {
        return FixedLength.getInstance(numUnits, MPT, 1.0f);
    }

    private static int convert(double dvalue, String unit, float res) {
        if ("px".equals(unit)) {
            dvalue *= (double)(res * 1000.0f);
        } else if (INCH.equals(unit)) {
            dvalue *= 72000.0;
        } else if (CM.equals(unit)) {
            dvalue *= 28346.4567;
        } else if (MM.equals(unit)) {
            dvalue *= 2834.64567;
        } else if (POINT.equals(unit)) {
            dvalue *= 1000.0;
        } else if (PICA.equals(unit)) {
            dvalue *= 12000.0;
        } else if (!MPT.equals(unit)) {
            dvalue = 0.0;
            log.error((Object)("Unknown length unit '" + unit + "'"));
        }
        return (int)dvalue;
    }

    public int getValue() {
        return this.millipoints;
    }

    public int getValue(PercentBaseContext context) {
        return this.millipoints;
    }

    public double getNumericValue() {
        return this.millipoints;
    }

    public double getNumericValue(PercentBaseContext context) {
        return this.millipoints;
    }

    public boolean isAbsolute() {
        return true;
    }

    public String toString() {
        return this.millipoints + MPT;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FixedLength) {
            return ((FixedLength)obj).millipoints == this.millipoints;
        }
        return false;
    }

    public int hashCode() {
        return this.millipoints;
    }
}

