/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class WordTagSampleStreamFactory
extends AbstractSampleStreamFactory<POSSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(POSSample.class, "opennlp", new WordTagSampleStreamFactory(Parameters.class));
    }

    protected <P> WordTagSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<POSSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return new WordTagSampleStream(lineStream);
    }

    public static interface Parameters
    extends BasicFormatParams {
    }
}

