/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

final class Constants {
    static void checkAsmExperimental(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName().replace('.', '/');
        if (!Constants.isWhitelisted(string)) {
            Constants.checkIsPreview(clazz.getClassLoader().getResourceAsStream(string + ".class"));
        }
    }

    static boolean isWhitelisted(String string) {
        if (!string.startsWith("org/objectweb/asm/")) {
            return false;
        }
        String string2 = "(Annotation|Class|Field|Method|Module|RecordComponent|Signature)";
        return string.contains("Test$") || Pattern.matches("org/objectweb/asm/util/Trace" + string2 + "Visitor(\\$.*)?", string) || Pattern.matches("org/objectweb/asm/util/Check" + string2 + "Adapter(\\$.*)?", string);
    }

    static void checkIsPreview(InputStream inputStream) {
        int n;
        if (inputStream == null) {
            throw new IllegalStateException("Bytecode not available, can't check class version");
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            try {
                dataInputStream.readInt();
                n = dataInputStream.readUnsignedShort();
            }
            catch (Throwable throwable) {
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("I/O error, can't check class version", iOException);
        }
        if (n != 65535) {
            throw new IllegalStateException("ASM9_EXPERIMENTAL can only be used by classes compiled with --enable-preview");
        }
    }
}

