/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfHandlerLocal
extends SecurityConfHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Path securityJsonPath;

    public SecurityConfHandlerLocal(CoreContainer coreContainer) {
        super(coreContainer);
        this.securityJsonPath = Paths.get(coreContainer.getSolrHome(), new String[0]).resolve("security.json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SecurityConfHandler.SecurityConfig getSecurityConfig(boolean getFresh) {
        if (!Files.exists(this.securityJsonPath, new LinkOption[0])) return new SecurityConfHandler.SecurityConfig();
        try (InputStream securityJsonIs = Files.newInputStream(this.securityJsonPath, new OpenOption[0]);){
            SecurityConfHandler.SecurityConfig securityConfig = new SecurityConfHandler.SecurityConfig().setData(securityJsonIs);
            return securityConfig;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed opening existing security.json file: " + this.securityJsonPath, (Throwable)e);
        }
    }

    @Override
    protected void getConf(SolrQueryResponse rsp, String key) {
        SecurityConfHandler.SecurityConfig props = this.getSecurityConfig(false);
        Object o = props.getData().get(key);
        if (o == null) {
            rsp.add("errorMessages", Collections.singletonList("No " + key + " configured"));
        } else {
            rsp.add(key + ".enabled", this.getPlugin(key) != null);
            rsp.add(key, o);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean persistConf(SecurityConfHandler.SecurityConfig securityConfig) throws IOException {
        if (securityConfig == null) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed persisting security.json to SOLR_HOME. Object was empty.");
        if (securityConfig.getData().isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed persisting security.json to SOLR_HOME. Object was empty.");
        }
        try (OutputStream securityJsonOs = Files.newOutputStream(this.securityJsonPath, new OpenOption[0]);){
            securityJsonOs.write(Utils.toJSON(securityConfig.getData()));
            log.debug("Persisted security.json to {}", (Object)this.securityJsonPath);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed persisting security.json to " + this.securityJsonPath, (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        return "Edit or read security configuration locally in SOLR_HOME";
    }

    @Override
    protected void securityConfEdited() {
        this.cores.securityNodeChanged();
    }
}

