/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class TestSecurityManager
extends SecurityManager {
    private static final String JUNIT4_TEST_RUNNER_PACKAGE = "com.carrotsearch.ant.tasks.junit4.";
    private static final String ECLIPSE_TEST_RUNNER_PACKAGE = "org.eclipse.jdt.internal.junit.runner.";
    private static final String IDEA_TEST_RUNNER_PACKAGE = "com.intellij.rt.execution.junit.";

    @Override
    public void checkExit(int status) {
        String systemClassName = System.class.getName();
        String runtimeClassName = Runtime.class.getName();
        String exitMethodHit = null;
        for (StackTraceElement se : new Exception().getStackTrace()) {
            String className = se.getClassName();
            String methodName = se.getMethodName();
            if (("exit".equals(methodName) || "halt".equals(methodName)) && (systemClassName.equals(className) || runtimeClassName.equals(className))) {
                exitMethodHit = className + '#' + methodName + '(' + status + ')';
                continue;
            }
            if (exitMethodHit == null) continue;
            if (!className.startsWith(JUNIT4_TEST_RUNNER_PACKAGE) && !className.startsWith(ECLIPSE_TEST_RUNNER_PACKAGE) && !className.startsWith(IDEA_TEST_RUNNER_PACKAGE)) break;
            super.checkExit(status);
            return;
        }
        if (exitMethodHit == null) {
            exitMethodHit = "JVM exit method";
        }
        throw new SecurityException(exitMethodHit + " calls are not allowed because they terminate the test runner's JVM.");
    }
}

