/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.security.Permission;
import org.apache.solr.security.RuleBasedAuthorizationPluginBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedAuthorizationPlugin
extends RuleBasedAuthorizationPluginBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Set<String>> usersVsRoles = new HashMap<String, Set<String>>();

    @Override
    public void init(Map<String, Object> initInfo) {
        super.init(initInfo);
        Map<String, Object> map = SecurityConfHandler.getMapValue(initInfo, "user-role");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> o;
            Map.Entry<String, Object> e = o = iterator.next();
            String roleName = e.getKey();
            this.usersVsRoles.put(roleName, Permission.readValueAsSet(map, roleName));
        }
    }

    @Override
    public Set<String> getUserRoles(Principal principal) {
        return this.usersVsRoles.get(principal.getName());
    }
}

