/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.types;

public enum StringOperator {
    EQUALS('='){

        @Override
        public boolean doTest(char extractedChar, char testChar, boolean lastChar) {
            return extractedChar == testChar;
        }
    }
    ,
    NOT_EQUALS('!'){

        @Override
        public boolean doTest(char extractedChar, char testChar, boolean lastChar) {
            return extractedChar != testChar;
        }
    }
    ,
    GREATER_THAN('>'){

        @Override
        public boolean doTest(char extractedChar, char testChar, boolean lastChar) {
            if (lastChar) {
                return extractedChar > testChar;
            }
            return extractedChar >= testChar;
        }
    }
    ,
    LESS_THAN('<'){

        @Override
        public boolean doTest(char extractedChar, char testChar, boolean lastChar) {
            if (lastChar) {
                return extractedChar < testChar;
            }
            return extractedChar <= testChar;
        }
    };

    public static final StringOperator DEFAULT_OPERATOR;
    private final char prefixChar;

    private StringOperator(char prefixChar) {
        this.prefixChar = prefixChar;
    }

    public abstract boolean doTest(char var1, char var2, boolean var3);

    public static StringOperator fromTest(String testStr) {
        if (testStr.length() == 0) {
            return null;
        }
        char first = testStr.charAt(0);
        for (StringOperator operator : StringOperator.values()) {
            if (operator.prefixChar != first) continue;
            return operator;
        }
        return null;
    }

    static {
        DEFAULT_OPERATOR = EQUALS;
    }
}

