/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.endian.EndianConverter;
import com.j256.simplemagic.entries.MagicFormatter;
import com.j256.simplemagic.entries.MagicMatcher;
import com.j256.simplemagic.logger.Logger;
import com.j256.simplemagic.logger.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public class MagicEntry {
    private static Logger logger = LoggerFactory.getLogger(MagicEntry.class);
    private final String name;
    private final int level;
    private final boolean addOffset;
    private final int offset;
    private final OffsetInfo offsetInfo;
    private final MagicMatcher matcher;
    private final Long andValue;
    private final boolean unsignedType;
    private final Object testValue;
    private final boolean formatSpacePrefix;
    private final boolean clearFormat;
    private final MagicFormatter formatter;
    private List<MagicEntry> children;
    private String mimeType;
    private boolean optional;

    MagicEntry(String name, int level, boolean addOffset, int offset, OffsetInfo offsetInfo, MagicMatcher matcher, Long andValue, boolean unsignedType, Object testValue, boolean formatSpacePrefix, boolean clearFormat, MagicFormatter formatter) {
        this.name = name;
        this.level = level;
        this.addOffset = addOffset;
        this.offset = offset;
        this.offsetInfo = offsetInfo;
        this.matcher = matcher;
        this.andValue = andValue;
        this.unsignedType = unsignedType;
        this.testValue = testValue;
        this.formatSpacePrefix = formatSpacePrefix;
        this.clearFormat = clearFormat;
        this.formatter = formatter;
    }

    ContentInfo matchBytes(byte[] bytes) {
        ContentData data = this.matchBytes(bytes, 0, 0, null);
        if (data == null || data.name == "unknown") {
            return null;
        }
        return new ContentInfo(data.name, data.mimeType, data.sb.toString(), data.partial);
    }

    int getLevel() {
        return this.level;
    }

    byte[] getStartsWithByte() {
        if (this.offset != 0) {
            return null;
        }
        return this.matcher.getStartingBytes(this.testValue);
    }

    boolean isOptional() {
        return this.optional;
    }

    void setOptional(boolean optional) {
        this.optional = optional;
    }

    void addChild(MagicEntry child) {
        if (this.children == null) {
            this.children = new ArrayList<MagicEntry>();
        }
        this.children.add(child);
    }

    void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("level ").append(this.level);
        if (this.name != null) {
            sb.append(",name '").append(this.name).append('\'');
        }
        if (this.mimeType != null) {
            sb.append(",mime '").append(this.mimeType).append('\'');
        }
        if (this.testValue != null) {
            sb.append(",test '").append(this.testValue).append('\'');
        }
        if (this.formatter != null) {
            sb.append(",format '").append(this.formatter).append('\'');
        }
        return sb.toString();
    }

    private ContentData matchBytes(byte[] bytes, int prevOffset, int level, ContentData contentData) {
        boolean required;
        Object val;
        int offset = this.offset;
        if (this.offsetInfo != null) {
            Integer maybeOffset = this.offsetInfo.getOffset(bytes);
            if (maybeOffset == null) {
                return null;
            }
            offset = maybeOffset;
        }
        if (this.addOffset) {
            offset = prevOffset + offset;
        }
        if ((val = this.matcher.extractValueFromBytes(offset, bytes, required = this.testValue == null && this.formatter != null)) == null) {
            return null;
        }
        if (this.testValue != null) {
            MagicMatcher.MutableOffset mutableOffset = new MagicMatcher.MutableOffset(offset);
            if ((val = this.matcher.isMatch(this.testValue, this.andValue, this.unsignedType, val, mutableOffset, bytes)) == null) {
                return null;
            }
            offset = mutableOffset.offset;
        }
        if (contentData == null) {
            contentData = new ContentData(this.name, this.mimeType, level);
            contentData.partial = true;
        }
        if (this.formatter != null) {
            if (this.clearFormat) {
                contentData.sb.setLength(0);
            }
            if (this.formatSpacePrefix && contentData.sb.length() > 0) {
                contentData.sb.append(' ');
            }
            this.matcher.renderValue(contentData.sb, val, this.formatter);
        }
        logger.trace("matched data: {}: {}", this, (Object)contentData);
        if (this.children == null) {
            contentData.partial = false;
        } else {
            boolean allOptional = true;
            for (MagicEntry entry : this.children) {
                if (!entry.isOptional()) {
                    allOptional = false;
                }
                entry.matchBytes(bytes, offset, level + 1, contentData);
            }
            if (allOptional) {
                contentData.partial = false;
            }
        }
        if (this.name != "unknown" && contentData.name == "unknown") {
            contentData.name = this.name;
        }
        if (this.mimeType != null && (contentData.mimeType == null || level > contentData.mimeTypeLevel)) {
            contentData.mimeType = this.mimeType;
            contentData.mimeTypeLevel = level;
        }
        return contentData;
    }

    static class OffsetInfo {
        final int offset;
        final EndianConverter converter;
        final boolean isId3;
        final int size;
        final int add;

        OffsetInfo(int offset, EndianConverter converter, boolean isId3, int size, int add) {
            this.offset = offset;
            this.converter = converter;
            this.isId3 = isId3;
            this.size = size;
            this.add = add;
        }

        public Integer getOffset(byte[] bytes) {
            Long val = this.isId3 ? this.converter.convertId3(this.offset, bytes, this.size) : this.converter.convertNumber(this.offset, bytes, this.size);
            if (val == null) {
                return null;
            }
            return (int)(val + (long)this.add);
        }
    }

    static class ContentData {
        String name;
        boolean partial;
        String mimeType;
        int mimeTypeLevel;
        final StringBuilder sb = new StringBuilder();

        private ContentData(String name, String mimeType, int mimeTypeLevel) {
            this.name = name;
            this.mimeType = mimeType;
            this.mimeTypeLevel = mimeTypeLevel;
        }
    }
}

