/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.EvalContext;
import com.healthmarketscience.jackcess.expr.EvalException;
import com.healthmarketscience.jackcess.expr.NumericConfig;
import com.healthmarketscience.jackcess.expr.TemporalConfig;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.expr.DefaultDateFunctions;
import com.healthmarketscience.jackcess.impl.expr.DefaultFunctions;
import com.healthmarketscience.jackcess.impl.expr.DefaultTextFunctions;
import com.healthmarketscience.jackcess.impl.expr.ExpressionTokenizer;
import com.healthmarketscience.jackcess.impl.expr.NumberFormatter;
import com.healthmarketscience.jackcess.impl.expr.ValueSupport;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class FormatUtil {
    private static final Map<String, Fmt> PREDEF_FMTS = new HashMap<String, Fmt>();
    private static final Fmt NULL_FMT;
    private static final Fmt DUMMY_FMT;
    private static final char QUOTE_CHAR = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final char LEFT_ALIGN_CHAR = '!';
    private static final char START_COLOR_CHAR = '[';
    private static final char END_COLOR_CHAR = ']';
    private static final char CHOICE_SEP_CHAR = ';';
    private static final char FILL_ESCAPE_CHAR = '*';
    private static final char REQ_PLACEHOLDER_CHAR = '@';
    private static final char OPT_PLACEHOLDER_CHAR = '&';
    private static final char TO_UPPER_CHAR = '>';
    private static final char TO_LOWER_CHAR = '<';
    private static final char DT_LIT_COLON_CHAR = ':';
    private static final char DT_LIT_SLASH_CHAR = '/';
    private static final char SINGLE_QUOTE_CHAR = '\'';
    private static final char EXP_E_CHAR = 'E';
    private static final char EXP_e_CHAR = 'e';
    private static final char PLUS_CHAR = '+';
    private static final char MINUS_CHAR = '-';
    private static final char REQ_DIGIT_CHAR = '0';
    private static final int NO_CHAR = -1;
    private static final byte FCT_UNKNOWN = 0;
    private static final byte FCT_LITERAL = 1;
    private static final byte FCT_GENERAL = 2;
    private static final byte FCT_DATE = 3;
    private static final byte FCT_NUMBER = 4;
    private static final byte FCT_TEXT = 5;
    private static final byte[] FORMAT_CODE_TYPES;
    private static final DateFormatBuilder PARTIAL_PREFIX;
    private static final Map<String, DateFormatBuilder> DATE_FMT_BUILDERS;
    private static final int NF_POS_IDX = 0;
    private static final int NF_NEG_IDX = 1;
    private static final int NF_ZERO_IDX = 2;
    private static final int NF_NULL_IDX = 3;
    private static final int NUM_NF_FMTS = 4;
    private static final NumberFormatter.NotationType[] NO_EXP_TYPES;
    private static final boolean[] NO_FMT_TYPES;

    private FormatUtil() {
    }

    public static Value format(EvalContext ctx, Value expr, String fmtStr, int firstDay, int firstWeekType) {
        Args args = new Args(ctx, expr, firstDay, firstWeekType);
        return args.format(FormatUtil.createFormat(args, fmtStr));
    }

    public static StandaloneFormatter createStandaloneFormatter(EvalContext ctx, String fmtStr, int firstDay, int firstWeekType) {
        Args args = new Args(ctx, null, firstDay, firstWeekType);
        Fmt fmt = FormatUtil.createFormat(args, fmtStr);
        return new StandaloneFormatter(fmt, args);
    }

    private static Fmt createFormat(Args args, String fmtStr) {
        Fmt predefFmt = PREDEF_FMTS.get(fmtStr);
        if (predefFmt != null) {
            return predefFmt;
        }
        if (StringUtils.isEmpty((CharSequence)fmtStr)) {
            return DUMMY_FMT;
        }
        return FormatUtil.parseCustomFormat(fmtStr, args);
    }

    private static Fmt parseCustomFormat(String fmtStr, Args args) {
        ExpressionTokenizer.ExprBuf buf = new ExpressionTokenizer.ExprBuf(fmtStr, null);
        byte curFormatType = FormatUtil.determineFormatType(buf);
        buf.reset(0);
        switch (curFormatType) {
            case 2: {
                return FormatUtil.parseCustomGeneralFormat(buf);
            }
            case 3: {
                return FormatUtil.parseCustomDateFormat(buf, args);
            }
            case 4: {
                return FormatUtil.parseCustomNumberFormat(buf, args);
            }
            case 5: {
                return FormatUtil.parseCustomTextFormat(buf);
            }
        }
        throw new EvalException("Invalid format type " + curFormatType);
    }

    private static byte determineFormatType(ExpressionTokenizer.ExprBuf buf) {
        block10: while (buf.hasNext()) {
            char c = buf.next();
            byte fmtType = FormatUtil.getFormatCodeType(c);
            switch (fmtType) {
                case 0: 
                case 1: {
                    continue block10;
                }
                case 2: {
                    switch (c) {
                        case '\"': {
                            FormatUtil.parseQuotedString(buf);
                            continue block10;
                        }
                        case '[': {
                            FormatUtil.parseColorString(buf);
                            continue block10;
                        }
                        case '*': 
                        case '\\': {
                            if (!buf.hasNext()) continue block10;
                            buf.next();
                            continue block10;
                        }
                    }
                    continue block10;
                }
                case 3: 
                case 4: 
                case 5: {
                    return fmtType;
                }
            }
            throw new EvalException("Invalid format type " + fmtType);
        }
        return 2;
    }

    private static Fmt parseCustomGeneralFormat(ExpressionTokenizer.ExprBuf buf) {
        StringBuilder sb = new StringBuilder();
        String[] fmtStrs = new String[4];
        int fmtIdx = 0;
        block11: while (buf.hasNext()) {
            char c = buf.next();
            byte fmtType = FormatUtil.getFormatCodeType(c);
            switch (fmtType) {
                case 2: {
                    switch (c) {
                        case '!': {
                            break;
                        }
                        case '\"': {
                            FormatUtil.parseQuotedString(buf, sb);
                            break;
                        }
                        case '[': {
                            FormatUtil.parseColorString(buf);
                            break;
                        }
                        case '\\': {
                            if (!buf.hasNext()) continue block11;
                            sb.append(buf.next());
                            break;
                        }
                        case '*': {
                            if (!buf.hasNext()) continue block11;
                            buf.next();
                            break;
                        }
                        case ';': {
                            if (fmtIdx == 3) break block11;
                            FormatUtil.addCustomGeneralFormat(fmtStrs, fmtIdx++, sb);
                            break;
                        }
                        default: {
                            sb.append(c);
                            break;
                        }
                    }
                    continue block11;
                }
                default: {
                    sb.append(c);
                    continue block11;
                }
            }
        }
        while (fmtIdx < 4) {
            FormatUtil.addCustomGeneralFormat(fmtStrs, fmtIdx++, sb);
        }
        return new CustomGeneralFmt(ValueSupport.toValue(fmtStrs[0]), ValueSupport.toValue(fmtStrs[1]), ValueSupport.toValue(fmtStrs[2]), ValueSupport.toValue(fmtStrs[3]));
    }

    private static void addCustomGeneralFormat(String[] fmtStrs, int fmtIdx, StringBuilder sb) {
        FormatUtil.addCustomNumberFormat(fmtStrs, NO_EXP_TYPES, NO_FMT_TYPES, NO_FMT_TYPES, fmtIdx, sb);
    }

    private static Fmt parseCustomDateFormat(ExpressionTokenizer.ExprBuf buf, Args args) {
        boolean[] fmtState = new boolean[]{false, false};
        ArrayList<DateFormatBuilder> dfbs = new ArrayList<DateFormatBuilder>();
        block11: while (buf.hasNext()) {
            char c = buf.next();
            byte fmtType = FormatUtil.getFormatCodeType(c);
            switch (fmtType) {
                case 2: {
                    switch (c) {
                        case '\"': {
                            String str = FormatUtil.parseQuotedString(buf);
                            dfbs.add((dtfb, argsParam, hasAmPmParam, dtType) -> dtfb.appendLiteral(str));
                            continue block11;
                        }
                        case '[': {
                            FormatUtil.parseColorString(buf);
                            continue block11;
                        }
                        case '\\': {
                            if (!buf.hasNext()) continue block11;
                            dfbs.add(FormatUtil.buildLiteralCharDFB(buf.next()));
                            continue block11;
                        }
                        case '*': {
                            if (!buf.hasNext()) continue block11;
                            buf.next();
                            continue block11;
                        }
                        case ';': {
                            break block11;
                        }
                    }
                    dfbs.add(FormatUtil.buildLiteralCharDFB(c));
                    continue block11;
                }
                case 3: {
                    FormatUtil.parseCustomDateFormatPattern(c, buf, dfbs, fmtState);
                    continue block11;
                }
                default: {
                    dfbs.add(FormatUtil.buildLiteralCharDFB(c));
                    continue block11;
                }
            }
        }
        boolean hasAmPm = fmtState[0];
        boolean hasGeneralFormat = fmtState[1];
        if (!hasGeneralFormat) {
            DateTimeFormatter dtf = FormatUtil.createDateTimeFormatter(dfbs, args, hasAmPm, null);
            return new CustomFmt(argsParam -> ValueSupport.toValue(dtf.format(argsParam.getAsLocalDateTime())));
        }
        DateTimeFormatter dateFmt = FormatUtil.createDateTimeFormatter(dfbs, args, hasAmPm, Value.Type.DATE);
        DateTimeFormatter timeFmt = FormatUtil.createDateTimeFormatter(dfbs, args, hasAmPm, Value.Type.TIME);
        DateTimeFormatter dtFmt = FormatUtil.createDateTimeFormatter(dfbs, args, hasAmPm, Value.Type.DATE_TIME);
        return new CustomFmt(argsParam -> FormatUtil.formatDateTime(argsParam, dateFmt, timeFmt, dtFmt));
    }

    private static void parseCustomDateFormatPattern(char c, ExpressionTokenizer.ExprBuf buf, List<DateFormatBuilder> dfbs, boolean[] fmtState) {
        if (c == ':' || c == '/') {
            dfbs.add(FormatUtil.buildLiteralCharDFB(c));
            return;
        }
        StringBuilder sb = buf.getScratchBuffer();
        sb.append(c);
        char firstChar = c;
        int firstPos = buf.curPos();
        String bestMatchPat = sb.toString();
        DateFormatBuilder bestMatch = DATE_FMT_BUILDERS.get(bestMatchPat);
        int bestPos = firstPos;
        while (buf.hasNext()) {
            sb.append(buf.next());
            String tmpPat = sb.toString();
            DateFormatBuilder dfb = DATE_FMT_BUILDERS.get(tmpPat);
            if (dfb == null) break;
            if (dfb == PARTIAL_PREFIX) continue;
            bestMatch = dfb;
            bestPos = buf.curPos();
            bestMatchPat = tmpPat;
        }
        if (bestMatch != PARTIAL_PREFIX) {
            buf.reset(bestPos);
            dfbs.add(bestMatch);
            switch (firstChar) {
                case 'A': 
                case 'a': {
                    fmtState[0] = true;
                    break;
                }
                case 'c': {
                    fmtState[1] = true;
                    break;
                }
            }
        } else {
            buf.reset(firstPos);
            dfbs.add(FormatUtil.buildLiteralCharDFB(firstChar));
        }
    }

    private static DateFormatBuilder buildLiteralCharDFB(char c) {
        return (dtfb, args, hasAmPm, dtType) -> dtfb.appendLiteral(c);
    }

    private static DateTimeFormatter createDateTimeFormatter(List<DateFormatBuilder> dfbs, Args args, boolean hasAmPm, Value.Type dtType) {
        DateTimeFormatterBuilder dtfb = new DateTimeFormatterBuilder();
        dfbs.forEach(d -> d.build(dtfb, args, hasAmPm, dtType));
        return dtfb.toFormatter(args._ctx.getTemporalConfig().getLocale());
    }

    private static Value formatDateTime(Args args, DateTimeFormatter dateFmt, DateTimeFormatter timeFmt, DateTimeFormatter dtFmt) {
        LocalDateTime ldt = args.getAsLocalDateTime();
        DateTimeFormatter fmt = null;
        switch (args._expr.getType()) {
            case DATE: {
                fmt = dateFmt;
                break;
            }
            case TIME: {
                fmt = timeFmt;
                break;
            }
            default: {
                fmt = dtFmt;
            }
        }
        return ValueSupport.toValue(fmt.format(ldt));
    }

    private static Fmt parseCustomNumberFormat(ExpressionTokenizer.ExprBuf buf, Args args) {
        StringBuilder sb = new StringBuilder();
        String[] fmtStrs = new String[4];
        int fmtIdx = 0;
        StringBuilder pendingLiteral = new StringBuilder();
        NumberFormatter.NotationType[] expTypes = new NumberFormatter.NotationType[4];
        boolean[] hasFmts = new boolean[4];
        boolean[] hasReqDigit = new boolean[4];
        block17: while (buf.hasNext()) {
            char c = buf.next();
            byte fmtType = FormatUtil.getFormatCodeType(c);
            switch (fmtType) {
                case 2: {
                    switch (c) {
                        case '!': {
                            break;
                        }
                        case '\"': {
                            FormatUtil.parseQuotedString(buf, pendingLiteral);
                            break;
                        }
                        case '[': {
                            FormatUtil.parseColorString(buf);
                            break;
                        }
                        case '\\': {
                            if (!buf.hasNext()) continue block17;
                            pendingLiteral.append(buf.next());
                            break;
                        }
                        case '*': {
                            if (!buf.hasNext()) continue block17;
                            buf.next();
                            break;
                        }
                        case ';': {
                            if (fmtIdx == 3) break block17;
                            FormatUtil.flushPendingNumberLiteral(pendingLiteral, sb);
                            FormatUtil.addCustomNumberFormat(fmtStrs, expTypes, hasFmts, hasReqDigit, fmtIdx++, sb);
                            break;
                        }
                        default: {
                            pendingLiteral.append(c);
                            break;
                        }
                    }
                    continue block17;
                }
                case 4: {
                    hasFmts[fmtIdx] = true;
                    switch (c) {
                        case 'E': {
                            int signChar = buf.peekNext();
                            if (signChar == 43 || signChar == 45) {
                                buf.next();
                                expTypes[fmtIdx] = signChar == 43 ? NumberFormatter.NotationType.EXP_E_PLUS : NumberFormatter.NotationType.EXP_E_MINUS;
                                FormatUtil.flushPendingNumberLiteral(pendingLiteral, sb);
                                sb.append('E');
                                continue block17;
                            }
                            pendingLiteral.append(c);
                            continue block17;
                        }
                        case 'e': {
                            int signChar = buf.peekNext();
                            if (signChar == 43 || signChar == 45) {
                                buf.next();
                                expTypes[fmtIdx] = signChar == 43 ? NumberFormatter.NotationType.EXP_e_PLUS : NumberFormatter.NotationType.EXP_e_MINUS;
                                FormatUtil.flushPendingNumberLiteral(pendingLiteral, sb);
                                sb.append('E');
                                continue block17;
                            }
                            pendingLiteral.append(c);
                            continue block17;
                        }
                        case '0': {
                            hasReqDigit[fmtIdx] = true;
                            FormatUtil.flushPendingNumberLiteral(pendingLiteral, sb);
                            sb.append(c);
                            continue block17;
                        }
                    }
                    FormatUtil.flushPendingNumberLiteral(pendingLiteral, sb);
                    sb.append(c);
                    continue block17;
                }
                default: {
                    pendingLiteral.append(c);
                    continue block17;
                }
            }
        }
        while (fmtIdx < 4) {
            FormatUtil.flushPendingNumberLiteral(pendingLiteral, sb);
            FormatUtil.addCustomNumberFormat(fmtStrs, expTypes, hasFmts, hasReqDigit, fmtIdx++, sb);
        }
        return new CustomNumberFmt(FormatUtil.createCustomNumberFormat(fmtStrs, expTypes, hasFmts, hasReqDigit, 0, false, args, buf), FormatUtil.createCustomNumberFormat(fmtStrs, expTypes, hasFmts, hasReqDigit, 1, false, args, buf), FormatUtil.createCustomNumberFormat(fmtStrs, expTypes, hasFmts, hasReqDigit, 2, true, args, buf), FormatUtil.createCustomNumberFormat(fmtStrs, expTypes, hasFmts, hasReqDigit, 3, true, args, buf));
    }

    private static void addCustomNumberFormat(String[] fmtStrs, NumberFormatter.NotationType[] expTypes, boolean[] hasFmts, boolean[] hasReqDigit, int fmtIdx, StringBuilder sb) {
        if (sb.length() == 0) {
            switch (fmtIdx) {
                case 1: {
                    sb.append('-').append(fmtStrs[0]);
                    expTypes[1] = expTypes[0];
                    hasFmts[1] = hasFmts[0];
                    hasReqDigit[1] = hasReqDigit[0];
                    break;
                }
                case 2: {
                    sb.append(fmtStrs[0]);
                    expTypes[2] = expTypes[0];
                    hasFmts[2] = hasFmts[0];
                    hasReqDigit[2] = hasReqDigit[0];
                    break;
                }
            }
        }
        fmtStrs[fmtIdx] = sb.toString();
        sb.setLength(0);
    }

    private static void flushPendingNumberLiteral(StringBuilder pendingLiteral, StringBuilder sb) {
        if (pendingLiteral.length() == 0) {
            return;
        }
        if (pendingLiteral.length() == 1 && pendingLiteral.charAt(0) == '\'') {
            sb.append('\'').append('\'');
            pendingLiteral.setLength(0);
            return;
        }
        sb.append('\'');
        int startPos = sb.length();
        sb.append((CharSequence)pendingLiteral);
        for (int i = startPos; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != '\'') continue;
            sb.insert(++i, '\'');
        }
        sb.append('\'');
        pendingLiteral.setLength(0);
    }

    private static BDFormat createCustomNumberFormat(String[] fmtStrs, NumberFormatter.NotationType[] expTypes, boolean[] hasFmts, boolean[] hasReqDigit, int fmtIdx, boolean isZeroFmt, Args args, ExpressionTokenizer.ExprBuf buf) {
        String fmtStr = fmtStrs[fmtIdx];
        if (!hasFmts[fmtIdx]) {
            if (fmtStr.length() > 0) {
                StringBuilder sb = buf.getScratchBuffer().append(fmtStr).deleteCharAt(fmtStr.length() - 1).deleteCharAt(0);
                if (sb.length() > 0) {
                    for (int i = 0; i < sb.length(); ++i) {
                        if (sb.charAt(i) != '\'') continue;
                        sb.deleteCharAt(++i);
                    }
                } else {
                    sb.append('\'');
                }
                fmtStr = sb.toString();
            }
            return new LiteralBDFormat(fmtStr);
        }
        NumberFormatter.NotationType expType = expTypes[fmtIdx];
        DecimalFormat df = args._ctx.createDecimalFormat(fmtStr);
        if (df.getMaximumFractionDigits() > 0) {
            df.setDecimalSeparatorAlwaysShown(true);
        }
        if (expType != null) {
            NumberFormatter.ScientificFormat nf = new NumberFormatter.ScientificFormat(df, expType);
            if (isZeroFmt) {
                return new LiteralBDFormat(nf.format(BigDecimal.ZERO));
            }
            return new BaseBDFormat(nf);
        }
        if (!hasReqDigit[fmtIdx]) {
            df.setMinimumIntegerDigits(0);
        }
        if (isZeroFmt) {
            String zeroVal = df.format(BigDecimal.ZERO);
            if (!hasReqDigit[fmtIdx]) {
                int prefLen = df.getPositivePrefix().length();
                int len = zeroVal.length() - df.getPositiveSuffix().length();
                StringBuilder sb = buf.getScratchBuffer().append(zeroVal);
                for (int i = len - 1; i >= prefLen; --i) {
                    if (sb.charAt(i) != '0') continue;
                    sb.deleteCharAt(i);
                }
                zeroVal = sb.toString();
            }
            return new LiteralBDFormat(zeroVal);
        }
        return new DecimalBDFormat(df);
    }

    private static Fmt parseCustomTextFormat(ExpressionTokenizer.ExprBuf buf) {
        CharSourceFmt fmt = null;
        ArrayList<BiConsumer<StringBuilder, CharSource>> subFmts = new ArrayList<BiConsumer<StringBuilder, CharSource>>();
        int numPlaceholders = 0;
        boolean rightAligned = true;
        TextCase textCase = TextCase.NONE;
        StringBuilder pendingLiteral = new StringBuilder();
        boolean hasFmtChars = false;
        block18: while (buf.hasNext()) {
            char c = buf.next();
            hasFmtChars = true;
            byte fmtType = FormatUtil.getFormatCodeType(c);
            switch (fmtType) {
                case 2: {
                    switch (c) {
                        case '!': {
                            rightAligned = false;
                            break;
                        }
                        case '\"': {
                            FormatUtil.parseQuotedString(buf, pendingLiteral);
                            break;
                        }
                        case '[': {
                            FormatUtil.parseColorString(buf);
                            break;
                        }
                        case '\\': {
                            if (!buf.hasNext()) continue block18;
                            pendingLiteral.append(buf.next());
                            break;
                        }
                        case '*': {
                            if (!buf.hasNext()) continue block18;
                            buf.next();
                            break;
                        }
                        case ';': {
                            if (fmt != null) break block18;
                            FormatUtil.flushPendingTextLiteral(pendingLiteral, subFmts);
                            fmt = new CharSourceFmt(subFmts, numPlaceholders, rightAligned, textCase);
                            subFmts = new ArrayList();
                            numPlaceholders = 0;
                            rightAligned = true;
                            textCase = TextCase.NONE;
                            hasFmtChars = false;
                            break;
                        }
                        default: {
                            pendingLiteral.append(c);
                            break;
                        }
                    }
                    continue block18;
                }
                case 5: {
                    switch (c) {
                        case '@': {
                            FormatUtil.flushPendingTextLiteral(pendingLiteral, subFmts);
                            ++numPlaceholders;
                            subFmts.add((sb, cs) -> {
                                int tmp = cs.next();
                                sb.append((char)(tmp != -1 ? (int)tmp : 32));
                            });
                            continue block18;
                        }
                        case '&': {
                            FormatUtil.flushPendingTextLiteral(pendingLiteral, subFmts);
                            ++numPlaceholders;
                            subFmts.add((sb, cs) -> {
                                int tmp = cs.next();
                                if (tmp != -1) {
                                    sb.append((char)tmp);
                                }
                            });
                            continue block18;
                        }
                        case '>': {
                            textCase = textCase == TextCase.LOWER ? TextCase.NONE : TextCase.UPPER;
                            continue block18;
                        }
                        case '<': {
                            textCase = textCase == TextCase.UPPER ? TextCase.NONE : TextCase.LOWER;
                            continue block18;
                        }
                    }
                    pendingLiteral.append(c);
                    continue block18;
                }
                default: {
                    pendingLiteral.append(c);
                    continue block18;
                }
            }
        }
        FormatUtil.flushPendingTextLiteral(pendingLiteral, subFmts);
        Fmt emptyFmt = null;
        if (fmt == null) {
            fmt = new CharSourceFmt(subFmts, numPlaceholders, rightAligned, textCase);
            emptyFmt = NULL_FMT;
        } else {
            emptyFmt = hasFmtChars ? new CharSourceFmt(subFmts, numPlaceholders, rightAligned, textCase) : NULL_FMT;
        }
        return new CustomFmt(fmt, emptyFmt);
    }

    private static void flushPendingTextLiteral(StringBuilder pendingLiteral, List<BiConsumer<StringBuilder, CharSource>> subFmts) {
        if (pendingLiteral.length() == 0) {
            return;
        }
        String literal = pendingLiteral.toString();
        pendingLiteral.setLength(0);
        subFmts.add((sb, cs) -> sb.append(literal));
    }

    public static String createNumberFormatPattern(NumPatternType numPatType, int numDecDigits, boolean incLeadDigit, boolean negParens, int numGroupDigits) {
        StringBuilder fmt = new StringBuilder();
        numPatType.appendPrefix(fmt);
        if (numGroupDigits > 0) {
            fmt.append("#,");
            DefaultTextFunctions.nchars(fmt, numGroupDigits - 1, '#');
        }
        fmt.append(incLeadDigit ? "0" : "#");
        if (numDecDigits > 0) {
            fmt.append(".");
            DefaultTextFunctions.nchars(fmt, numDecDigits, '0');
        }
        numPatType.appendSuffix(fmt);
        if (negParens) {
            String mainPat = fmt.toString();
            fmt.append(";(").append(mainPat).append(")");
        }
        return fmt.toString();
    }

    private static byte getFormatCodeType(char c) {
        if (c >= '\u0000' && c < '\u007f') {
            return FORMAT_CODE_TYPES[c];
        }
        return 0;
    }

    private static void setFormatCodeTypes(String chars, byte type) {
        for (char c : chars.toCharArray()) {
            FormatUtil.FORMAT_CODE_TYPES[c] = type;
        }
    }

    private static String parseQuotedString(ExpressionTokenizer.ExprBuf buf) {
        return ExpressionTokenizer.parseStringUntil(buf, null, '\"', true);
    }

    private static void parseQuotedString(ExpressionTokenizer.ExprBuf buf, StringBuilder sb) {
        ExpressionTokenizer.parseStringUntil(buf, null, '\"', true, sb);
    }

    private static String parseColorString(ExpressionTokenizer.ExprBuf buf) {
        return ExpressionTokenizer.parseStringUntil(buf, Character.valueOf('['), ']', false);
    }

    private static void fillInPartialPrefixes() {
        ArrayList<String> validPrefixes = new ArrayList<String>(DATE_FMT_BUILDERS.keySet());
        for (String validPrefix : validPrefixes) {
            int len = validPrefix.length();
            while (len > 1) {
                validPrefix = validPrefix.substring(0, --len);
                DATE_FMT_BUILDERS.putIfAbsent(validPrefix, PARTIAL_PREFIX);
            }
        }
    }

    private static void putPredefFormat(String key, Fmt fmt) {
        Fmt wrapFmt = args -> args.isNullOrEmptyString() ? ValueSupport.EMPTY_STR_VAL : fmt.format(args);
        PREDEF_FMTS.put(key, wrapFmt);
    }

    static {
        FormatUtil.putPredefFormat("General Date", args -> ValueSupport.toValue(args.coerceToDateTimeValue().getAsString()));
        FormatUtil.putPredefFormat("Long Date", new PredefDateFmt(TemporalConfig.Type.LONG_DATE));
        FormatUtil.putPredefFormat("Medium Date", new PredefDateFmt(TemporalConfig.Type.MEDIUM_DATE));
        FormatUtil.putPredefFormat("Short Date", new PredefDateFmt(TemporalConfig.Type.SHORT_DATE));
        FormatUtil.putPredefFormat("Long Time", new PredefDateFmt(TemporalConfig.Type.LONG_TIME));
        FormatUtil.putPredefFormat("Medium Time", new PredefDateFmt(TemporalConfig.Type.MEDIUM_TIME));
        FormatUtil.putPredefFormat("Short Time", new PredefDateFmt(TemporalConfig.Type.SHORT_TIME));
        FormatUtil.putPredefFormat("General Number", args -> ValueSupport.toValue(args.coerceToNumberValue().getAsString()));
        FormatUtil.putPredefFormat("Currency", new PredefNumberFmt(NumericConfig.Type.CURRENCY));
        FormatUtil.putPredefFormat("Euro", new PredefNumberFmt(NumericConfig.Type.EURO));
        FormatUtil.putPredefFormat("Fixed", new PredefNumberFmt(NumericConfig.Type.FIXED));
        FormatUtil.putPredefFormat("Standard", new PredefNumberFmt(NumericConfig.Type.STANDARD));
        FormatUtil.putPredefFormat("Percent", new PredefNumberFmt(NumericConfig.Type.PERCENT));
        FormatUtil.putPredefFormat("Scientific", new ScientificPredefNumberFmt());
        FormatUtil.putPredefFormat("True/False", new PredefBoolFmt("True", "False"));
        FormatUtil.putPredefFormat("Yes/No", new PredefBoolFmt("Yes", "No"));
        FormatUtil.putPredefFormat("On/Off", new PredefBoolFmt("On", "Off"));
        NULL_FMT = args -> ValueSupport.EMPTY_STR_VAL;
        DUMMY_FMT = args -> args.getNonNullExpr();
        FORMAT_CODE_TYPES = new byte[127];
        FormatUtil.setFormatCodeTypes(" $+-()", (byte)1);
        FormatUtil.setFormatCodeTypes("\"!*\\[];", (byte)2);
        FormatUtil.setFormatCodeTypes(":/cdwmqyhnstampmAMPM", (byte)3);
        FormatUtil.setFormatCodeTypes(".,0#%Ee", (byte)4);
        FormatUtil.setFormatCodeTypes("@&<>", (byte)5);
        PARTIAL_PREFIX = (dtfb, args, hasAmPm, dtType) -> {
            throw new UnsupportedOperationException();
        };
        DATE_FMT_BUILDERS = new HashMap<String, DateFormatBuilder>();
        DATE_FMT_BUILDERS.put("c", (dtfb, args, hasAmPm, dtType) -> dtfb.append(ValueSupport.getDateFormatForType(args._ctx, dtType)));
        DATE_FMT_BUILDERS.put("d", new SimpleDFB("d"));
        DATE_FMT_BUILDERS.put("dd", new SimpleDFB("dd"));
        DATE_FMT_BUILDERS.put("ddd", new SimpleDFB("eee"));
        DATE_FMT_BUILDERS.put("dddd", new SimpleDFB("eeee"));
        DATE_FMT_BUILDERS.put("ddddd", new PredefDFB(TemporalConfig.Type.SHORT_DATE));
        DATE_FMT_BUILDERS.put("dddddd", new PredefDFB(TemporalConfig.Type.LONG_DATE));
        DATE_FMT_BUILDERS.put("w", new WeekBasedDFB(){

            @Override
            protected TemporalField getField(WeekFields weekFields) {
                return weekFields.dayOfWeek();
            }
        });
        DATE_FMT_BUILDERS.put("ww", new WeekBasedDFB(){

            @Override
            protected TemporalField getField(WeekFields weekFields) {
                return weekFields.weekOfWeekBasedYear();
            }
        });
        DATE_FMT_BUILDERS.put("m", new SimpleDFB("L"));
        DATE_FMT_BUILDERS.put("mm", new SimpleDFB("LL"));
        DATE_FMT_BUILDERS.put("mmm", new SimpleDFB("MMM"));
        DATE_FMT_BUILDERS.put("mmmm", new SimpleDFB("MMMM"));
        DATE_FMT_BUILDERS.put("q", new SimpleDFB("Q"));
        DATE_FMT_BUILDERS.put("y", new SimpleDFB("D"));
        DATE_FMT_BUILDERS.put("yy", new SimpleDFB("yy"));
        DATE_FMT_BUILDERS.put("yyyy", new SimpleDFB("yyyy"));
        DATE_FMT_BUILDERS.put("h", new HourlyDFB("h", "H"));
        DATE_FMT_BUILDERS.put("hh", new HourlyDFB("hh", "HH"));
        DATE_FMT_BUILDERS.put("n", new SimpleDFB("m"));
        DATE_FMT_BUILDERS.put("nn", new SimpleDFB("mm"));
        DATE_FMT_BUILDERS.put("s", new SimpleDFB("s"));
        DATE_FMT_BUILDERS.put("ss", new SimpleDFB("ss"));
        DATE_FMT_BUILDERS.put("ttttt", new PredefDFB(TemporalConfig.Type.LONG_TIME));
        DATE_FMT_BUILDERS.put("AM/PM", new AmPmDFB("AM", "PM"));
        DATE_FMT_BUILDERS.put("am/pm", new AmPmDFB("am", "pm"));
        DATE_FMT_BUILDERS.put("A/P", new AmPmDFB("A", "P"));
        DATE_FMT_BUILDERS.put("a/p", new AmPmDFB("a", "p"));
        DATE_FMT_BUILDERS.put("AMPM", (dtfb, args, hasAmPm, dtType) -> {
            String[] amPmStrs = args._ctx.getTemporalConfig().getAmPmStrings();
            new AmPmDFB(amPmStrs[0], amPmStrs[1]).build(dtfb, args, hasAmPm, dtType);
        });
        FormatUtil.fillInPartialPrefixes();
        NO_EXP_TYPES = new NumberFormatter.NotationType[4];
        NO_FMT_TYPES = new boolean[4];
    }

    private static final class DecimalBDFormat
    extends BaseBDFormat {
        private final int _maxDecDigits;

        private DecimalBDFormat(DecimalFormat df) {
            super(df);
            int maxDecDigits = df.getMaximumFractionDigits();
            for (int mult = df.getMultiplier(); mult > 1; mult /= 10) {
                ++maxDecDigits;
            }
            this._maxDecDigits = maxDecDigits;
        }

        @Override
        public int getMaxDecimalDigits() {
            return this._maxDecDigits;
        }
    }

    private static class BaseBDFormat
    extends BDFormat {
        private final NumberFormat _nf;

        private BaseBDFormat(NumberFormat nf) {
            this._nf = nf;
        }

        @Override
        public String format(BigDecimal bd) {
            return this._nf.format(bd);
        }
    }

    private static final class LiteralBDFormat
    extends BDFormat {
        private final String _str;

        private LiteralBDFormat(String str) {
            this._str = str;
        }

        @Override
        public String format(BigDecimal bd) {
            return this._str;
        }
    }

    private static abstract class BDFormat {
        private BDFormat() {
        }

        public int getMaxDecimalDigits() {
            return Integer.MAX_VALUE;
        }

        public abstract String format(BigDecimal var1);
    }

    private static final class CustomNumberFmt
    extends BaseCustomNumberFmt {
        private final BDFormat _posFmt;
        private final BDFormat _negFmt;
        private final BDFormat _zeroFmt;
        private final BDFormat _nullFmt;

        private CustomNumberFmt(BDFormat posFmt, BDFormat negFmt, BDFormat zeroFmt, BDFormat nullFmt) {
            this._posFmt = posFmt;
            this._negFmt = negFmt;
            this._zeroFmt = zeroFmt;
            this._nullFmt = nullFmt;
        }

        private Value formatMaybeZero(BigDecimal bd, BDFormat fmt) {
            int maxDecDigits = fmt.getMaxDecimalDigits();
            if (maxDecDigits < bd.scale() && BigDecimal.ZERO.compareTo(bd = bd.setScale(maxDecDigits, NumberFormatter.ROUND_MODE)) == 0) {
                fmt = this._zeroFmt;
            }
            return ValueSupport.toValue(fmt.format(bd));
        }

        @Override
        protected Value formatNull(Args args) {
            return ValueSupport.toValue(this._nullFmt.format(BigDecimal.ZERO));
        }

        @Override
        protected Value formatPos(BigDecimal bd, Args args) {
            return this.formatMaybeZero(bd, this._posFmt);
        }

        @Override
        protected Value formatNeg(BigDecimal bd, Args args) {
            return this.formatMaybeZero(bd.negate(), this._negFmt);
        }

        @Override
        protected Value formatZero(BigDecimal bd, Args args) {
            return ValueSupport.toValue(this._zeroFmt.format(bd));
        }
    }

    private static final class CustomGeneralFmt
    extends BaseCustomNumberFmt {
        private final Value _posVal;
        private final Value _negVal;
        private final Value _zeroVal;
        private final Value _nullVal;

        private CustomGeneralFmt(Value posVal, Value negVal, Value zeroVal, Value nullVal) {
            this._posVal = posVal;
            this._negVal = negVal;
            this._zeroVal = zeroVal;
            this._nullVal = nullVal;
        }

        @Override
        protected Value formatNull(Args args) {
            return this._nullVal;
        }

        @Override
        protected Value formatPos(BigDecimal bd, Args args) {
            return this._posVal;
        }

        @Override
        protected Value formatNeg(BigDecimal bd, Args args) {
            return this._negVal;
        }

        @Override
        protected Value formatZero(BigDecimal bd, Args args) {
            return this._zeroVal;
        }
    }

    private static abstract class BaseCustomNumberFmt
    implements Fmt {
        private BaseCustomNumberFmt() {
        }

        @Override
        public Value format(Args args) {
            if (args._expr.isNull()) {
                return this.formatNull(args);
            }
            BigDecimal bd = args.getAsBigDecimal();
            int cmp = BigDecimal.ZERO.compareTo(bd);
            return cmp < 0 ? this.formatPos(bd, args) : (cmp > 0 ? this.formatNeg(bd, args) : this.formatZero(bd, args));
        }

        protected abstract Value formatNull(Args var1);

        protected abstract Value formatPos(BigDecimal var1, Args var2);

        protected abstract Value formatNeg(BigDecimal var1, Args var2);

        protected abstract Value formatZero(BigDecimal var1, Args var2);
    }

    private static final class CharSource {
        private int _prefLen;
        private final String _str;
        private int _strPos;
        private final TextCase _textCase;

        private CharSource(String str, int len, boolean rightAligned, TextCase textCase) {
            this._str = str;
            this._textCase = textCase;
            int strLen = str.length();
            if (len > strLen) {
                if (rightAligned) {
                    this._prefLen = len - strLen;
                }
            } else if (len < strLen && !rightAligned) {
                this._strPos = strLen - len;
            }
        }

        public int next() {
            if (this._prefLen > 0) {
                --this._prefLen;
                return -1;
            }
            if (this._strPos < this._str.length()) {
                return this._textCase.apply(this._str.charAt(this._strPos++));
            }
            return -1;
        }

        public void appendRemaining(StringBuilder sb) {
            int strLen = this._str.length();
            while (this._strPos < strLen) {
                sb.append(this._textCase.apply(this._str.charAt(this._strPos++)));
            }
        }
    }

    private static final class CharSourceFmt
    implements Fmt {
        private final List<BiConsumer<StringBuilder, CharSource>> _subFmts;
        private final int _numPlaceholders;
        private final boolean _rightAligned;
        private final TextCase _textCase;

        private CharSourceFmt(List<BiConsumer<StringBuilder, CharSource>> subFmts, int numPlaceholders, boolean rightAligned, TextCase textCase) {
            this._subFmts = subFmts;
            this._numPlaceholders = numPlaceholders;
            this._rightAligned = rightAligned;
            this._textCase = textCase;
        }

        @Override
        public Value format(Args args) {
            CharSource cs = new CharSource(args.getAsString(), this._numPlaceholders, this._rightAligned, this._textCase);
            StringBuilder sb = new StringBuilder();
            this._subFmts.stream().forEach(fmt -> fmt.accept(sb, cs));
            cs.appendRemaining(sb);
            return ValueSupport.toValue(sb.toString());
        }
    }

    private static final class CustomFmt
    implements Fmt {
        private final Fmt _fmt;
        private final Fmt _emptyFmt;

        private CustomFmt(Fmt fmt) {
            this(fmt, NULL_FMT);
        }

        private CustomFmt(Fmt fmt, Fmt emptyFmt) {
            this._fmt = fmt;
            this._emptyFmt = emptyFmt;
        }

        @Override
        public Value format(Args args) {
            Fmt fmt = this._fmt;
            if (args.maybeCoerceToEmptyString()) {
                fmt = this._emptyFmt;
            }
            return fmt.format(args);
        }
    }

    private static final class AmPmDFB
    extends AbstractMap<Long, String>
    implements DateFormatBuilder {
        private static final Long ZERO_KEY = 0L;
        private final String _am;
        private final String _pm;

        private AmPmDFB(String am, String pm) {
            this._am = am;
            this._pm = pm;
        }

        @Override
        public void build(DateTimeFormatterBuilder dtfb, Args args, boolean hasAmPm, Value.Type dtType) {
            dtfb.appendText((TemporalField)ChronoField.AMPM_OF_DAY, this);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public String get(Object key) {
            return ZERO_KEY.equals(key) ? this._am : this._pm;
        }

        @Override
        public Set<Map.Entry<Long, String>> entrySet() {
            return new AbstractSet<Map.Entry<Long, String>>(){

                @Override
                public int size() {
                    return 2;
                }

                @Override
                public Iterator<Map.Entry<Long, String>> iterator() {
                    return Arrays.asList(new AbstractMap.SimpleImmutableEntry<Long, String>(0L, _am), new AbstractMap.SimpleImmutableEntry<Long, String>(1L, _pm)).iterator();
                }
            };
        }
    }

    private static abstract class WeekBasedDFB
    implements DateFormatBuilder {
        private WeekBasedDFB() {
        }

        @Override
        public void build(DateTimeFormatterBuilder dtfb, Args args, boolean hasAmPm, Value.Type dtType) {
            dtfb.appendValue(this.getField(DefaultDateFunctions.weekFields(args._firstDay, args._firstWeekType)));
        }

        protected abstract TemporalField getField(WeekFields var1);
    }

    private static final class PredefDFB
    implements DateFormatBuilder {
        private final TemporalConfig.Type _type;

        private PredefDFB(TemporalConfig.Type type) {
            this._type = type;
        }

        @Override
        public void build(DateTimeFormatterBuilder dtfb, Args args, boolean hasAmPm, Value.Type dtType) {
            dtfb.appendPattern(args._ctx.getTemporalConfig().getDateTimeFormat(this._type));
        }
    }

    private static final class HourlyDFB
    implements DateFormatBuilder {
        private final String _pat12;
        private final String _pat24;

        private HourlyDFB(String pat12, String pat24) {
            this._pat12 = pat12;
            this._pat24 = pat24;
        }

        @Override
        public void build(DateTimeFormatterBuilder dtfb, Args args, boolean hasAmPm, Value.Type dtTypePm) {
            dtfb.appendPattern(hasAmPm ? this._pat12 : this._pat24);
        }
    }

    private static final class SimpleDFB
    implements DateFormatBuilder {
        private final String _pat;

        private SimpleDFB(String pat) {
            this._pat = pat;
        }

        @Override
        public void build(DateTimeFormatterBuilder dtfb, Args args, boolean hasAmPm, Value.Type dtType) {
            dtfb.appendPattern(this._pat);
        }
    }

    private static final class ScientificPredefNumberFmt
    extends BaseNumberFmt {
        private ScientificPredefNumberFmt() {
        }

        @Override
        protected NumberFormat getNumberFormat(Args args) {
            NumberFormat df = args._ctx.createDecimalFormat(args._ctx.getNumericConfig().getNumberFormat(NumericConfig.Type.SCIENTIFIC));
            df = new NumberFormatter.ScientificFormat(df);
            return df;
        }
    }

    private static final class PredefNumberFmt
    extends BaseNumberFmt {
        private final NumericConfig.Type _type;

        private PredefNumberFmt(NumericConfig.Type type) {
            this._type = type;
        }

        @Override
        protected NumberFormat getNumberFormat(Args args) {
            return args._ctx.createDecimalFormat(args._ctx.getNumericConfig().getNumberFormat(this._type));
        }
    }

    private static abstract class BaseNumberFmt
    implements Fmt {
        private BaseNumberFmt() {
        }

        @Override
        public Value format(Args args) {
            NumberFormat df = this.getNumberFormat(args);
            return ValueSupport.toValue(df.format(args.getAsBigDecimal()));
        }

        protected abstract NumberFormat getNumberFormat(Args var1);
    }

    private static final class PredefBoolFmt
    implements Fmt {
        private final Value _trueVal;
        private final Value _falseVal;

        private PredefBoolFmt(String trueStr, String falseStr) {
            this._trueVal = ValueSupport.toValue(trueStr);
            this._falseVal = ValueSupport.toValue(falseStr);
        }

        @Override
        public Value format(Args args) {
            return args.getAsBoolean() ? this._trueVal : this._falseVal;
        }
    }

    private static final class PredefDateFmt
    implements Fmt {
        private final TemporalConfig.Type _type;

        private PredefDateFmt(TemporalConfig.Type type) {
            this._type = type;
        }

        @Override
        public Value format(Args args) {
            DateTimeFormatter dtf = args._ctx.createDateFormatter(args._ctx.getTemporalConfig().getDateTimeFormat(this._type));
            return ValueSupport.toValue(dtf.format(args.getAsLocalDateTime()));
        }
    }

    public static class StandaloneFormatter {
        private final Fmt _fmt;
        private final Args _args;

        private StandaloneFormatter(Fmt fmt, Args args) {
            this._fmt = fmt;
            this._args = args;
        }

        public Value format(Value expr) {
            return this._args.setExpr(expr).format(this._fmt);
        }
    }

    private static final class Args {
        private final EvalContext _ctx;
        private Value _expr;
        private final int _firstDay;
        private final int _firstWeekType;

        private Args(EvalContext ctx, Value expr, int firstDay, int firstWeekType) {
            this._ctx = ctx;
            this._expr = expr;
            this._firstDay = firstDay;
            this._firstWeekType = firstWeekType;
        }

        public Args setExpr(Value expr) {
            this._expr = expr;
            return this;
        }

        public Value getNonNullExpr() {
            return this._expr.isNull() ? ValueSupport.EMPTY_STR_VAL : this._expr;
        }

        public boolean isNullOrEmptyString() {
            return this._expr.isNull() || this._expr.getType().isString() && this.getAsString().isEmpty();
        }

        public boolean maybeCoerceToEmptyString() {
            if (this.isNullOrEmptyString()) {
                this._expr = ValueSupport.EMPTY_STR_VAL;
                return true;
            }
            return false;
        }

        public Args coerceToDateTimeValue() {
            if (!this._expr.getType().isTemporal()) {
                Value boolExpr = null;
                if (this._expr.getType().isString() && (boolExpr = this.maybeGetStringAsBooleanValue()) != null) {
                    this._expr = boolExpr;
                }
                this._expr = this._expr.getAsDateTimeValue(this._ctx);
            }
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Args coerceToNumberValue() {
            if (this._expr.getType().isNumeric()) return this;
            if (this._expr.getType().isString()) {
                Value boolExpr = this.maybeGetStringAsBooleanValue();
                if (boolExpr != null) {
                    this._expr = boolExpr;
                    return this;
                } else {
                    BigDecimal bd = DefaultFunctions.maybeGetAsBigDecimal(this._ctx, this._expr);
                    if (bd != null) {
                        this._expr = ValueSupport.toValue(bd);
                        return this;
                    } else {
                        Value maybe = DefaultFunctions.maybeGetAsDateTimeValue(this._ctx, this._expr);
                        if (maybe == null) throw new EvalException("invalid number value");
                        this._expr = ValueSupport.toValue(maybe.getAsDouble(this._ctx));
                    }
                }
                return this;
            } else {
                this._expr = ValueSupport.toValue(this._expr.getAsDouble(this._ctx));
            }
            return this;
        }

        private Value maybeGetStringAsBooleanValue() {
            String val = this.getAsString();
            if ("true".equalsIgnoreCase(val)) {
                return ValueSupport.TRUE_VAL;
            }
            if ("false".equalsIgnoreCase(val)) {
                return ValueSupport.FALSE_VAL;
            }
            return null;
        }

        public BigDecimal getAsBigDecimal() {
            this.coerceToNumberValue();
            return this._expr.getAsBigDecimal(this._ctx);
        }

        public LocalDateTime getAsLocalDateTime() {
            this.coerceToDateTimeValue();
            return this._expr.getAsLocalDateTime(this._ctx);
        }

        public boolean getAsBoolean() {
            this.coerceToNumberValue();
            return this._expr.getAsBoolean(this._ctx);
        }

        public String getAsString() {
            return this._expr.getAsString(this._ctx);
        }

        public Value format(Fmt fmt) {
            Value origExpr = this._expr;
            try {
                return fmt.format(this);
            }
            catch (EvalException ee) {
                return origExpr;
            }
        }
    }

    @FunctionalInterface
    static interface DateFormatBuilder {
        public void build(DateTimeFormatterBuilder var1, Args var2, boolean var3, Value.Type var4);
    }

    @FunctionalInterface
    static interface Fmt {
        public Value format(Args var1);
    }

    private static enum TextCase {
        NONE,
        UPPER{

            @Override
            public char apply(char c) {
                return Character.toUpperCase(c);
            }
        }
        ,
        LOWER{

            @Override
            public char apply(char c) {
                return Character.toLowerCase(c);
            }
        };


        public char apply(char c) {
            return c;
        }
    }

    public static enum NumPatternType {
        GENERAL,
        CURRENCY{

            @Override
            protected void appendPrefix(StringBuilder fmt) {
                fmt.append('\u00a4');
            }

            @Override
            protected boolean useParensForNegatives(NumericConfig cfg) {
                return cfg.useParensForCurrencyNegatives();
            }
        }
        ,
        EURO{

            @Override
            protected void appendPrefix(StringBuilder fmt) {
                fmt.append('\u20ac');
            }

            @Override
            protected boolean useParensForNegatives(NumericConfig cfg) {
                return cfg.useParensForCurrencyNegatives();
            }
        }
        ,
        PERCENT{

            @Override
            protected void appendSuffix(StringBuilder fmt) {
                fmt.append('%');
            }
        }
        ,
        SCIENTIFIC{

            @Override
            protected void appendSuffix(StringBuilder fmt) {
                fmt.append("E0");
            }
        };


        protected void appendPrefix(StringBuilder fmt) {
        }

        protected void appendSuffix(StringBuilder fmt) {
        }

        protected boolean useParensForNegatives(NumericConfig cfg) {
            return cfg.useParensForNegatives();
        }
    }
}

